/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.awt.Cursor;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.eso.gasgano.datamodel.DataModelEvent;
import org.eso.gasgano.datamodel.ResultsModel;
import org.eso.gasgano.datamodel.gui.ResultsComponent;
import org.eso.gasgano.datamodel.gui.ResultsContainer;
import org.eso.gasgano.gui.AbstractTreeTableModel;
import org.eso.gasgano.gui.TreeTableModel;
import org.eso.gasgano.properties.GasProp;

public class ResultsTreeTableModel
extends AbstractTreeTableModel {
    private Vector treeListeners = null;
    private ResultsModel dm = null;
    private RootNode root = new RootNode();
    private Vector displayCols = null;
    private int groupDataByLevel = 0;
    protected Vector allTheLeaves = new Vector();
    private JTree theTree = null;

    public ResultsTreeTableModel(ResultsModel d2) {
        this.init(d2);
    }

    private void init(ResultsModel d2) {
        this.dm = d2;
        this.treeListeners = new Vector();
        this.setRootLabel(null);
        this.displayCols = GasProp.getProperties().fsDisplayColumns;
    }

    public void setTree(JTree tree) {
        this.theTree = tree;
    }

    public int getGroupDataByLevel() {
        return this.groupDataByLevel;
    }

    public void setGroupDataByLevel(int gbLevel) {
        if (this.groupDataByLevel != gbLevel) {
            this.groupDataByLevel = gbLevel;
            this.setRootLabel(null);
            this.updateTree();
        }
    }

    public void setRootLabel(String name) {
        name = new String("Displaying " + this.dm.getReferenceCount() + " references ");
        this.root.setLabel(name);
    }

    public String getRootLabel() {
        String rc = null;
        if (this.root != null) {
            this.root.getLabel();
        }
        return rc;
    }

    @Override
    public Object getChild(Object parent, int index) {
        Object rc = null;
        if (parent == this.root) {
            if (this.groupDataByLevel == 0) {
                rc = this.dm.getReferenceAt(index);
            }
        } else {
            ResultsContainer tmpContainer;
            int fc;
            rc = parent instanceof ResultsContainer ? (index >= (fc = (tmpContainer = (ResultsContainer)parent).getFramesCount()) ? tmpContainer.getLabelAt(index - fc) : tmpContainer.getFrameAt(index)) : null;
        }
        return rc;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int rc = -1;
        if (parent == this.root) {
            if (this.groupDataByLevel == 0) {
                rc = this.dm.getIndexOfReference((ResultsContainer)child);
            }
        } else if (parent instanceof ResultsContainer) {
            ResultsContainer cont = (ResultsContainer)parent;
            if (child instanceof ResultsComponent) {
                rc = cont.getIndexOfFrame((ResultsComponent)child);
            }
            if (child instanceof ResultsContainer) {
                rc = cont.getIndexOfLabel((ResultsContainer)child) + cont.getLabelsCount();
            }
        } else {
            System.out.println("Child " + child + " was not located");
            rc = -1;
        }
        return rc;
    }

    @Override
    public int getChildCount(Object parent) {
        int rc = 0;
        if (parent == this.root) {
            if (this.groupDataByLevel == 0) {
                rc = this.dm.getReferenceCount();
            }
        } else {
            rc = parent instanceof ResultsContainer ? ((ResultsContainer)parent).getLabelsCount() + ((ResultsContainer)parent).getFramesCount() : 0;
        }
        return rc;
    }

    @Override
    public int getColumnCount() {
        return 1 + this.displayCols.size();
    }

    @Override
    public String getColumnName(int column) {
        String rc = null;
        rc = column == 0 ? "File" : (String)this.displayCols.elementAt(column - 1);
        return rc;
    }

    @Override
    public Object getValueAt(Object node, int column) {
        Object rc = null;
        if (column > 0) {
            if (node instanceof ResultsComponent) {
                String[] colData = null;
                colData = ((ResultsComponent)node).getDisplayData();
                if (colData != null && colData.length >= column) {
                    rc = colData[column - 1];
                }
            }
        } else {
            if (node instanceof ResultsContainer) {
                // empty if block
            }
            rc = node;
        }
        return rc;
    }

    public void toggleColumn() {
    }

    @Override
    public Class getColumnClass(int column) {
        Class rc = null;
        rc = column == 0 ? TreeTableModel.class : ResultsComponent.class;
        return rc;
    }

    @Override
    public Object getRoot() {
        if (this.root == null) {
            this.setRootLabel(null);
        }
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        boolean rc = false;
        if (node instanceof ResultsComponent) {
            rc = true;
        }
        return rc;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public void dataModelChanged(DataModelEvent e2) {
    }

    public void updateTree() {
        this.setRootLabel(null);
        Object[] path = new Object[]{this.root};
        this.fireTreeStructureChanged(this, path, null, null);
        this.theTree.expandPath(new TreePath(this.root));
    }

    protected Enumeration getChildren(Object parent) {
        Object rc = null;
        if (parent == this.root) {
            if (this.groupDataByLevel == 0) {
                rc = this.dm.getReferenceSet();
            }
        } else if (parent instanceof ResultsContainer) {
            rc = ((ResultsContainer)parent).getDescendants().elements();
            if (rc == null) {
                System.err.println("No children");
            }
        } else {
            rc = parent instanceof ResultsComponent ? null : null;
        }
        return (Enumeration)rc;
    }

    public Object[] getPathToRoot(Object child) {
        int i;
        ResultsContainer father;
        Object[] path = null;
        int size = 0;
        if (child instanceof ResultsComponent) {
            Vector<Object> tmpVect = new Vector<Object>();
            ResultsComponent child2 = (ResultsComponent)child;
            tmpVect.addElement(child);
            father = (ResultsContainer)child2.getFather();
            do {
                tmpVect.addElement(father);
            } while ((father = father.getFather()) != null);
            tmpVect.addElement(this.getRoot());
            size = tmpVect.size();
            path = new Object[size];
            for (i = 0; i < size; ++i) {
                path[size - i - 1] = tmpVect.elementAt(i);
            }
        }
        if (child instanceof ResultsContainer) {
            ResultsContainer child2 = (ResultsContainer)child;
            Vector<Object> tmpVect = new Vector<Object>();
            tmpVect.addElement(child);
            father = child2.getFather();
            do {
                tmpVect.addElement(father);
            } while ((father = father.getFather()) != null);
            tmpVect.addElement(this.getRoot());
            size = tmpVect.size();
            path = new Object[size];
            for (i = 0; i < size; ++i) {
                path[size - i - 1] = tmpVect.elementAt(i);
            }
        }
        if (child instanceof RootNode) {
            path = new Object[]{child};
        }
        return path;
    }

    public Vector getAllTheLeaves(Object father) {
        this.allTheLeaves.removeAllElements();
        this.rec_traverse(father);
        return this.allTheLeaves;
    }

    public void rec_traverse(Object father) {
        if (this.isLeaf(father)) {
            this.allTheLeaves.addElement(father);
            return;
        }
        Enumeration e2 = this.getChildren(father);
        while (e2.hasMoreElements()) {
            this.rec_traverse(e2.nextElement());
        }
    }

    public void expandAllTheNodes(int row) {
        final TreePath tp = this.theTree.getPathForRow(row);
        Runnable recExpander = new Runnable(){

            @Override
            public void run() {
                Cursor tmpCursor = ResultsTreeTableModel.this.theTree.getCursor();
                ResultsTreeTableModel.this.recExpand(tp);
                ResultsTreeTableModel.this.theTree.setCursor(tmpCursor);
            }
        };
        new Thread(recExpander).start();
    }

    private void recExpand(TreePath tp) {
        if (tp == null) {
            return;
        }
        Object parent = tp.getLastPathComponent();
        this.theTree.expandPath(tp);
        if (this.isLeaf(parent)) {
            return;
        }
        Enumeration e2 = this.getChildren(parent);
        while (e2.hasMoreElements()) {
            Object tmpObj = e2.nextElement();
            this.recExpand(tp.pathByAddingChild(tmpObj));
        }
    }

    public boolean isPopupSuitable(Object container) {
        return !(container instanceof ResultsContainer);
    }

    class Reloader
    implements Runnable {
        Object[] path = null;

        public Reloader(Object[] path) {
            this.path = path;
        }

        @Override
        public void run() {
            ResultsTreeTableModel.this.fireTreeStructureChanged(ResultsTreeTableModel.this, this.path, null, null);
        }
    }

    class RootNode {
        private String label = null;

        RootNode() {
        }

        public String toString() {
            return this.label;
        }

        void setLabel(String s) {
            this.label = s;
        }

        String getLabel() {
            return this.label;
        }
    }
}

