/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eso.gasgano.gui.FileListModel;

public class FileListPane
extends JTabbedPane
implements ListSelectionListener {
    private Vector selectionListeners = new Vector();
    private Vector fileLists = new Vector();
    private boolean clearSelection = false;
    private Vector[] chosenFew = new Vector[4];

    public FileListPane() {
        for (int i = 0; i < 4; ++i) {
            this.chosenFew[i] = new Vector();
        }
    }

    public void addList(FileListModel m) {
        JList newList = new JList(m);
        newList.addListSelectionListener(this);
        newList.setCellRenderer(new MyCellRenderer(newList.getSelectionBackground()));
        this.fileLists.addElement(newList);
        this.add((Component)new JScrollPane(newList), m.getLabel());
    }

    public void removeList(FileListModel m) {
        for (int i = this.fileLists.size() - 1; i >= 0; --i) {
            if (((JList)this.fileLists.elementAt(i)).getModel() != m) continue;
            this.fileLists.removeElementAt(i);
            this.removeTabAt(i);
        }
    }

    public void emptyLists() {
        Enumeration e2 = this.fileLists.elements();
        while (e2.hasMoreElements()) {
            JList jl = (JList)e2.nextElement();
            ((FileListModel)jl.getModel()).emptyList();
        }
    }

    public FileListModel getListModel(int listIndex) {
        JList jl = (JList)this.fileLists.elementAt(listIndex);
        return (FileListModel)jl.getModel();
    }

    public void setListModel(FileListModel model, int index) {
        JList jl = (JList)this.fileLists.elementAt(index);
        jl.setModel(model);
    }

    public Vector getLists() {
        return this.fileLists;
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (this.clearSelection) {
            return;
        }
        Object src = evt.getSource();
        boolean fileSelected = false;
        Enumeration e2 = this.fileLists.elements();
        this.clearSelection = true;
        while (e2.hasMoreElements()) {
            JList jl = (JList)e2.nextElement();
            if (src != jl) {
                jl.clearSelection();
                continue;
            }
            fileSelected = !((FileListModel)jl.getModel()).isEmpty();
        }
        this.clearSelection = false;
        if (fileSelected) {
            e2 = this.selectionListeners.elements();
            while (e2.hasMoreElements()) {
                ListSelectionListener lsl = (ListSelectionListener)e2.nextElement();
                lsl.valueChanged(evt);
            }
        }
    }

    public void addListSelectionListener(ListSelectionListener l) {
        if (!this.selectionListeners.contains(l)) {
            this.selectionListeners.addElement(l);
        }
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.selectionListeners.removeElement(l);
    }

    public void setActiveElements(Vector[] chosenFew) {
        for (int i = 0; i < 4; ++i) {
            this.chosenFew[i] = chosenFew[i];
        }
    }

    private class MyCellRenderer
    extends JTextField
    implements ListCellRenderer {
        Font font = null;
        Color backColor = null;

        public MyCellRenderer(Color back) {
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.backColor = back;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.toString();
            this.font = this.getFont();
            this.setFont(new Font(this.font.getName(), 0, this.font.getSize()));
            this.setBackground(Color.white);
            if (FileListPane.this.chosenFew[FileListPane.this.fileLists.indexOf(list)].contains(value)) {
                this.setFont(new Font(this.font.getName(), 1, this.font.getSize()));
            }
            if (isSelected) {
                this.setBackground(this.backColor);
            }
            this.setText(s);
            return this;
        }
    }
}

