/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel.gui;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.eso.gasgano.datamodel.DataModelChangeListener;
import org.eso.gasgano.datamodel.DataModelChangeNotifier;
import org.eso.gasgano.datamodel.DataModelEvent;
import org.eso.gasgano.datamodel.FrameInfo;
import org.eso.gasgano.datamodel.filesystem.DFSDataModel;
import org.eso.gasgano.datamodel.gui.FitsFileOBComponent;
import org.eso.gasgano.datamodel.gui.KeywordContainerOBComponent;
import org.eso.gasgano.datamodel.gui.OBComponent;
import org.eso.gasgano.properties.PropertyDB;

public class TFitsFileOBComponent
extends KeywordContainerOBComponent
implements DataModelChangeListener {
    private DataModelChangeNotifier eventSource = null;
    private boolean isSelfLocalizable = false;
    private static JLabel tfitsLabel = new JLabel(new ImageIcon(TFitsFileOBComponent.class.getResource("/org/eso/gasgano/gui/icons/tfits.gif")), 0);

    public TFitsFileOBComponent(String address) {
        super(address);
        long startTime = 0L;
        if (PropertyDB.getInstance().isDebug(5)) {
            startTime = System.currentTimeMillis();
        }
        if (this.getStatus() == 3) {
            this.addToDataModel(defaultKeywordQuery[0].getValue(), defaultKeywordQuery[1].getValue(), this.myFile.getTelescope());
            if (PropertyDB.getInstance().isDebug(5)) {
                initTime += System.currentTimeMillis() - startTime;
                ++initNumber;
            }
        }
    }

    @Override
    public void addToDataModel(String progId, String obId, String telescopeId) {
        DFSDataModel dm = DFSDataModel.getDataModel();
        if (!dm.passFilter(this)) {
            this.myFile.setStatus(4);
            return;
        }
        if (progId == null || obId == null) {
            this.insertInDataModel();
        } else {
            String dir = this.myFile.getPath().getParent();
            dm.addObComponent(progId, obId, dir, telescopeId, this);
            this.isSelfLocalizable = true;
        }
        this.setPipeProduct(true);
    }

    @Override
    public JComponent getTreeCellComponent() {
        JLabel cell = null;
        Color foreGround = null;
        cell = tfitsLabel;
        foreGround = Color.red;
        cell.setText(this.toString());
        cell.setForeground(foreGround);
        cell.setFont(this.getLabelFont());
        return cell;
    }

    @Override
    public String getArcfile() {
        return new String("");
    }

    @Override
    public void classify() {
        this.myFile.classify(DFSDataModel.getDataModel().getClassifier());
        if (TFitsFileOBComponent.getDefaultFileDescription() != null) {
            TFitsFileOBComponent.getDefaultFileDescription().classificationChanged(this);
        }
    }

    @Override
    public void dataModelChanged(DataModelEvent e2) {
        if (e2.getEvent() == 0 || e2.getEvent() == 1 || e2.getEvent() == 2) {
            if (PropertyDB.getInstance().isDebug(6)) {
                System.out.println(this.getId() + " received dataModelChangeEvent.");
            }
            if (!this.isSelfLocalizable && e2.getFile() != this) {
                this.insertInDataModel();
            }
        }
    }

    private void insertInDataModel() {
        DFSDataModel dm = DFSDataModel.getDataModel();
        String progId = null;
        String obId = null;
        String telescopeId = null;
        if (!dm.passFilter(this)) {
            this.myFile.setStatus(4);
            return;
        }
        OBComponent dataSource = this.getIdentifyingComponent();
        DataModelChangeNotifier notifier = null;
        if (dataSource == null) {
            progId = "Unknown Program";
            obId = "Unknown Observation";
            telescopeId = "Unknown Telescope";
            notifier = dm;
        } else {
            FrameInfo frameInfo = new FrameInfo();
            dm.provideFrameInfo((KeywordContainerOBComponent)dataSource, frameInfo);
            telescopeId = frameInfo.telescopeId;
            progId = frameInfo.programId;
            obId = frameInfo.obsId;
            notifier = dataSource;
        }
        if (!(this.storeProgram != null && this.storeProgram.equals(progId) && this.storeObservation != null && this.storeObservation.equals(obId) && this.storeTelescope != null && this.storeTelescope.equals(telescopeId))) {
            if (this.eventSource != null) {
                this.removeFromDataModel();
            }
            if (this.getStatus() == 3) {
                String dir = this.myFile.getPath().getParent();
                dm.addObComponent(progId, obId, dir, telescopeId, this);
                this.storeProgram = this.storeProgram == null ? progId : this.storeProgram;
                this.storeObservation = this.storeObservation == null ? obId : this.storeObservation;
                this.storeTelescope = this.storeTelescope == null ? telescopeId : this.storeTelescope;
                this.registerToNotifier(notifier);
            }
        }
    }

    private OBComponent getIdentifyingComponent() {
        OBComponent rc = null;
        DFSDataModel dm = DFSDataModel.getDataModel();
        Vector dataSourceSet = dm.getObComponentByBaseName(this.myFile.getBaseName());
        if (dataSourceSet != null && !dataSourceSet.isEmpty()) {
            Enumeration e2 = dataSourceSet.elements();
            while (rc == null && e2.hasMoreElements()) {
                rc = (OBComponent)e2.nextElement();
                if (rc instanceof FitsFileOBComponent) continue;
                rc = null;
            }
        }
        return rc;
    }

    private void registerToNotifier(DataModelChangeNotifier n) {
        if (this.eventSource != n) {
            if (this.eventSource != null) {
                this.eventSource.removeDataModelChangeListener(this);
            }
            if (n != null) {
                n.addDataModelChangeListener(this);
            }
            this.eventSource = n;
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.registerToNotifier(null);
    }
}

