/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix;

import cern.colt.PersistentObject;
import cern.colt.matrix.DoubleMatrix3D;
import cern.colt.matrix.impl.DenseDoubleMatrix3D;
import cern.colt.matrix.impl.SparseDoubleMatrix3D;
import cern.jet.math.Functions;

public class DoubleFactory3D
extends PersistentObject {
    public static final DoubleFactory3D dense = new DoubleFactory3D();
    public static final DoubleFactory3D sparse = new DoubleFactory3D();

    protected DoubleFactory3D() {
    }

    public DoubleMatrix3D ascending(int n, int n2, int n3) {
        Functions functions = Functions.functions;
        return this.descending(n, n2, n3).assign(Functions.chain(Functions.neg, Functions.minus(n * n2 * n3)));
    }

    public DoubleMatrix3D descending(int n, int n2, int n3) {
        DoubleMatrix3D doubleMatrix3D = this.make(n, n2, n3);
        int n4 = 0;
        int n5 = n;
        while (--n5 >= 0) {
            int n6 = n2;
            while (--n6 >= 0) {
                int n7 = n3;
                while (--n7 >= 0) {
                    doubleMatrix3D.setQuick(n5, n6, n7, n4++);
                }
            }
        }
        return doubleMatrix3D;
    }

    public DoubleMatrix3D make(double[][][] dArray) {
        if (this == sparse) {
            return new SparseDoubleMatrix3D(dArray);
        }
        return new DenseDoubleMatrix3D(dArray);
    }

    public DoubleMatrix3D make(int n, int n2, int n3) {
        if (this == sparse) {
            return new SparseDoubleMatrix3D(n, n2, n3);
        }
        return new DenseDoubleMatrix3D(n, n2, n3);
    }

    public DoubleMatrix3D make(int n, int n2, int n3, double d2) {
        return this.make(n, n2, n3).assign(d2);
    }

    public DoubleMatrix3D random(int n, int n2, int n3) {
        return this.make(n, n2, n3).assign(Functions.random());
    }
}

