/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.CharComparator;
import cern.colt.function.CharProcedure;
import cern.colt.list.AbstractList;
import cern.colt.list.CharArrayList;
import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public abstract class AbstractCharList
extends AbstractList {
    protected int size;

    protected AbstractCharList() {
    }

    public void add(char c2) {
        this.beforeInsert(this.size, c2);
    }

    public void addAllOfFromTo(AbstractCharList abstractCharList, int n, int n2) {
        this.beforeInsertAllOfFromTo(this.size, abstractCharList, n, n2);
    }

    public void beforeInsert(int n, char c2) {
        this.beforeInsertDummies(n, 1);
        this.set(n, c2);
    }

    public void beforeInsertAllOfFromTo(int n, AbstractCharList abstractCharList, int n2, int n3) {
        int n4 = n3 - n2 + 1;
        this.beforeInsertDummies(n, n4);
        this.replaceFromToWithFrom(n, n + n4 - 1, abstractCharList, n2);
    }

    protected void beforeInsertDummies(int n, int n2) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        if (n2 > 0) {
            this.ensureCapacity(this.size + n2);
            this.setSizeRaw(this.size + n2);
            this.replaceFromToWithFrom(n + n2, this.size - 1, this, n);
        }
    }

    public int binarySearch(char c2) {
        return this.binarySearchFromTo(c2, 0, this.size - 1);
    }

    public int binarySearchFromTo(char c2, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        while (n3 <= n4) {
            int n5 = (n3 + n4) / 2;
            char c3 = this.get(n5);
            if (c3 < c2) {
                n3 = n5 + 1;
                continue;
            }
            if (c3 > c2) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public Object clone() {
        return this.partFromTo(0, this.size - 1);
    }

    public boolean contains(char c2) {
        return this.indexOfFromTo(c2, 0, this.size - 1) >= 0;
    }

    public void delete(char c2) {
        int n = this.indexOfFromTo(c2, 0, this.size - 1);
        if (n >= 0) {
            this.remove(n);
        }
    }

    public char[] elements() {
        char[] cArray = new char[this.size];
        int n = this.size;
        while (--n >= 0) {
            cArray[n] = this.getQuick(n);
        }
        return cArray;
    }

    public AbstractCharList elements(char[] cArray) {
        this.clear();
        this.addAllOfFromTo(new CharArrayList(cArray), 0, cArray.length - 1);
        return this;
    }

    public abstract void ensureCapacity(int var1);

    public boolean equals(Object object) {
        if (!(object instanceof AbstractCharList)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        AbstractCharList abstractCharList = (AbstractCharList)object;
        if (this.size() != abstractCharList.size()) {
            return false;
        }
        int n = this.size();
        while (--n >= 0) {
            if (this.getQuick(n) == abstractCharList.getQuick(n)) continue;
            return false;
        }
        return true;
    }

    public void fillFromToWith(int n, int n2, char c2) {
        AbstractList.checkRangeFromTo(n, n2, this.size);
        int n3 = n;
        while (n3 <= n2) {
            this.setQuick(n3++, c2);
        }
    }

    public boolean forEach(CharProcedure charProcedure) {
        int n = 0;
        while (n < this.size) {
            if (charProcedure.apply(this.get(n++))) continue;
            return false;
        }
        return true;
    }

    public char get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.getQuick(n);
    }

    protected abstract char getQuick(int var1);

    public int indexOf(char c2) {
        return this.indexOfFromTo(c2, 0, this.size - 1);
    }

    public int indexOfFromTo(char c2, int n, int n2) {
        AbstractList.checkRangeFromTo(n, n2, this.size);
        int n3 = n;
        while (n3 <= n2) {
            if (c2 == this.getQuick(n3)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public int lastIndexOf(char c2) {
        return this.lastIndexOfFromTo(c2, 0, this.size - 1);
    }

    public int lastIndexOfFromTo(char c2, int n, int n2) {
        AbstractList.checkRangeFromTo(n, n2, this.size());
        int n3 = n2;
        while (n3 >= n) {
            if (c2 == this.getQuick(n3)) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public void mergeSortFromTo(int n, int n2) {
        int n3 = this.size();
        AbstractList.checkRangeFromTo(n, n2, n3);
        char[] cArray = this.elements();
        Sorting.mergeSort(cArray, n, n2 + 1);
        this.elements(cArray);
        this.setSizeRaw(n3);
    }

    public void mergeSortFromTo(int n, int n2, CharComparator charComparator) {
        int n3 = this.size();
        AbstractList.checkRangeFromTo(n, n2, n3);
        char[] cArray = this.elements();
        Sorting.mergeSort(cArray, n, n2 + 1, charComparator);
        this.elements(cArray);
        this.setSizeRaw(n3);
    }

    public AbstractCharList partFromTo(int n, int n2) {
        AbstractList.checkRangeFromTo(n, n2, this.size);
        int n3 = n2 - n + 1;
        CharArrayList charArrayList = new CharArrayList(n3);
        charArrayList.addAllOfFromTo(this, n, n2);
        return charArrayList;
    }

    public void quickSortFromTo(int n, int n2) {
        int n3 = this.size();
        AbstractList.checkRangeFromTo(n, n2, n3);
        char[] cArray = this.elements();
        java.util.Arrays.sort(cArray, n, n2 + 1);
        this.elements(cArray);
        this.setSizeRaw(n3);
    }

    public void quickSortFromTo(int n, int n2, CharComparator charComparator) {
        int n3 = this.size();
        AbstractList.checkRangeFromTo(n, n2, n3);
        char[] cArray = this.elements();
        Sorting.quickSort(cArray, n, n2 + 1, charComparator);
        this.elements(cArray);
        this.setSizeRaw(n3);
    }

    public boolean removeAll(AbstractCharList abstractCharList) {
        if (abstractCharList.size() == 0) {
            return false;
        }
        int n = abstractCharList.size() - 1;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.size) {
            if (abstractCharList.indexOfFromTo(this.getQuick(n3), 0, n) < 0) {
                this.setQuick(n2++, this.getQuick(n3));
            }
            ++n3;
        }
        boolean bl = n2 != this.size;
        this.setSize(n2);
        return bl;
    }

    public void removeFromTo(int n, int n2) {
        int n3;
        AbstractList.checkRangeFromTo(n, n2, this.size);
        int n4 = this.size - n2 - 1;
        if (n4 > 0) {
            this.replaceFromToWithFrom(n, n - 1 + n4, this, n2 + 1);
        }
        if ((n3 = n2 - n + 1) > 0) {
            this.setSizeRaw(this.size - n3);
        }
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractCharList abstractCharList, int n3) {
        block4: {
            int n4 = n2 - n + 1;
            if (n4 <= 0) break block4;
            AbstractList.checkRangeFromTo(n, n2, this.size());
            AbstractList.checkRangeFromTo(n3, n3 + n4 - 1, abstractCharList.size());
            if (n <= n3) {
                while (--n4 >= 0) {
                    this.setQuick(n++, abstractCharList.getQuick(n3++));
                }
            } else {
                int n5 = n3 + n4 - 1;
                while (--n4 >= 0) {
                    this.setQuick(n2--, abstractCharList.getQuick(n5--));
                }
            }
        }
    }

    public void replaceFromToWithFromTo(int n, int n2, AbstractCharList abstractCharList, int n3, int n4) {
        int n5;
        if (n3 > n4) {
            throw new IndexOutOfBoundsException("otherFrom: " + n3 + ", otherTo: " + n4);
        }
        if (this == abstractCharList && n2 - n != n4 - n3) {
            this.replaceFromToWithFromTo(n, n2, this.partFromTo(n3, n4), 0, n4 - n3);
            return;
        }
        int n6 = n5 = n4 - n3 + 1;
        int n7 = n - 1;
        if (n2 >= n) {
            n6 -= n2 - n + 1;
            n7 = n2;
        }
        if (n6 > 0) {
            this.beforeInsertDummies(n7 + 1, n6);
        } else if (n6 < 0) {
            this.removeFromTo(n7 + n6, n7 - 1);
        }
        if (n5 > 0) {
            this.replaceFromToWithFrom(n, n + n5 - 1, abstractCharList, n3);
        }
    }

    public void replaceFromWith(int n, Collection collection) {
        AbstractList.checkRange(n, this.size());
        Iterator iterator = collection.iterator();
        int n2 = n;
        int n3 = Math.min(this.size() - n, collection.size());
        int n4 = 0;
        while (n4 < n3) {
            this.set(n2++, ((Character)iterator.next()).charValue());
            ++n4;
        }
    }

    public boolean retainAll(AbstractCharList abstractCharList) {
        if (abstractCharList.size() == 0) {
            if (this.size == 0) {
                return false;
            }
            this.setSize(0);
            return true;
        }
        int n = abstractCharList.size() - 1;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.size) {
            if (abstractCharList.indexOfFromTo(this.getQuick(n3), 0, n) >= 0) {
                this.setQuick(n2++, this.getQuick(n3));
            }
            ++n3;
        }
        boolean bl = n2 != this.size;
        this.setSize(n2);
        return bl;
    }

    public void reverse() {
        int n = this.size() / 2;
        int n2 = this.size() - 1;
        int n3 = 0;
        while (n3 < n) {
            char c2 = this.getQuick(n3);
            this.setQuick(n3++, this.getQuick(n2));
            this.setQuick(n2--, c2);
        }
    }

    public void set(int n, char c2) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.setQuick(n, c2);
    }

    protected abstract void setQuick(int var1, char var2);

    protected void setSizeRaw(int n) {
        this.size = n;
    }

    public void shuffleFromTo(int n, int n2) {
        AbstractList.checkRangeFromTo(n, n2, this.size());
        Uniform uniform = new Uniform(new DRand(new Date()));
        int n3 = n;
        while (n3 < n2) {
            int n4 = uniform.nextIntFromTo(n3, n2);
            char c2 = this.getQuick(n4);
            this.setQuick(n4, this.getQuick(n3));
            this.setQuick(n3, c2);
            ++n3;
        }
    }

    public int size() {
        return this.size;
    }

    public AbstractCharList times(int n) {
        CharArrayList charArrayList = new CharArrayList(n * this.size());
        int n2 = n;
        while (--n2 >= 0) {
            charArrayList.addAllOfFromTo(this, 0, this.size() - 1);
        }
        return charArrayList;
    }

    public ArrayList toList() {
        int n = this.size();
        ArrayList<Character> arrayList = new ArrayList<Character>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(new Character(this.get(n2)));
            ++n2;
        }
        return arrayList;
    }

    public String toString() {
        return Arrays.toString(this.partFromTo(0, this.size() - 1).elements());
    }
}

