/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.graph.GraphDataKeys;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.util.ThrowableRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGraphToggleAction
extends ToggleAction {
    @Nullable
    protected Graph2D getGraph(AnActionEvent e) {
        return (Graph2D)e.getData(GraphDataKeys.GRAPH);
    }

    @Nullable
    protected GraphBuilder<?, ?> getBuilder(AnActionEvent e) {
        return (GraphBuilder)((Object)e.getData(GraphDataKeys.GRAPH_BUILDER));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractGraphToggleAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        Graph2D graph = this.getGraph(e);
        Project project = AbstractGraphToggleAction.getEventProject((AnActionEvent)e);
        if (graph != null && project != null) {
            super.update(e);
            String text = this.getText(graph);
            if (text != null) {
                presentation.setText(text);
            }
        }
        presentation.setEnabled(graph != null && project != null && this.isEnabled(graph, project, e));
    }

    protected boolean isEnabled(@NotNull Graph2D graph, @NotNull Project project, @NotNull AnActionEvent event) {
        if (graph == null) {
            AbstractGraphToggleAction.$$$reportNull$$$0(1);
        }
        if (project == null) {
            AbstractGraphToggleAction.$$$reportNull$$$0(2);
        }
        if (event == null) {
            AbstractGraphToggleAction.$$$reportNull$$$0(3);
        }
        return true;
    }

    public final boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractGraphToggleAction.$$$reportNull$$$0(4);
        }
        Project project = AbstractGraphToggleAction.getEventProject((AnActionEvent)e);
        Graph2D graph = this.getGraph(e);
        return graph != null && project != null && this.isSelected(graph, project, e);
    }

    public final void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (e == null) {
            AbstractGraphToggleAction.$$$reportNull$$$0(5);
        }
        Graph2D graph = this.getGraph(e);
        Project project = AbstractGraphToggleAction.getEventProject((AnActionEvent)e);
        GraphBuilder<?, ?> builder2 = this.getBuilder(e);
        if (graph != null && project != null && builder2 != null) {
            builder2.getActionExecutor().suppressRunnableReadLockAssertion((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> this.setSelected(graph, state, project, e)));
        }
    }

    protected abstract boolean isSelected(@NotNull Graph2D var1, @NotNull Project var2, @NotNull AnActionEvent var3);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            AbstractGraphToggleAction.$$$reportNull$$$0(6);
        }
        return actionUpdateThread;
    }

    protected abstract void setSelected(@NotNull Graph2D var1, boolean var2, @NotNull Project var3, @NotNull AnActionEvent var4);

    @Nullable
    @NlsActions.ActionText
    protected String getText(@NotNull Graph2D graph) {
        if (graph == null) {
            AbstractGraphToggleAction.$$$reportNull$$$0(7);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/actions/AbstractGraphToggleAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/actions/AbstractGraphToggleAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

