/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbt.settings;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.dbt.DbtBundle;
import com.intellij.dbt.DbtModuleEntity;
import com.intellij.dbt.DbtModuleEntityKt;
import com.intellij.dbt.settings.DbtConfigurable;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.ui.popup.ActionPopupOptions;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleBridgeUtils;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\"B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000eH\u0016J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0018H\u0016J\b\u0010\u001e\u001a\u00020\u0018H\u0016J\b\u0010\u001f\u001a\u00020\u0018H\u0016J\b\u0010 \u001a\u00020\u0018H\u0002J\b\u0010!\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/dbt/settings/DbtConfigurable;", "Lcom/intellij/openapi/options/Configurable;", "Lcom/intellij/openapi/Disposable;", "myModule", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "dbtPathTextField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "moduleEntity", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "dbtSettings", "Lcom/intellij/dbt/DbtModuleEntity;", "dialogDbtExecutablePath", "", "dialogDbtDataSourceId", "dataSourceCombobox", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/database/model/RawDataSource;", "createComponent", "Ljavax/swing/JComponent;", "isModified", "", "apply", "", "getDisplayName", "validateDbtPath", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "reset", "dispose", "disposeUIResources", "markAsReviewed", "clearFileLevelWarnings", "DbtDatabaseConfigEditorListener", "intellij.dbt"})
@SourceDebugExtension(value={"SMAP\nDbtConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbtConfigurable.kt\ncom/intellij/dbt/settings/DbtConfigurable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,193:1\n1374#2:194\n1460#2,5:195\n37#3:200\n36#3,3:201\n13472#4,2:204\n1310#4,2:206\n*S KotlinDebug\n*F\n+ 1 DbtConfigurable.kt\ncom/intellij/dbt/settings/DbtConfigurable\n*L\n71#1:194\n71#1:195,5\n71#1:200\n71#1:201,3\n73#1:204,2\n75#1:206,2\n*E\n"})
public final class DbtConfigurable
implements Configurable,
Disposable {
    @NotNull
    private final Module myModule;
    @NotNull
    private final TextFieldWithBrowseButton dbtPathTextField;
    @Nullable
    private final ModuleEntity moduleEntity;
    @Nullable
    private final DbtModuleEntity dbtSettings;
    @NotNull
    private String dialogDbtExecutablePath;
    @NotNull
    private String dialogDbtDataSourceId;
    @NotNull
    private final ComboBox<RawDataSource> dataSourceCombobox;

    public DbtConfigurable(@NotNull Module myModule) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)myModule, (String)"myModule");
        this.myModule = myModule;
        this.dbtPathTextField = new TextFieldWithBrowseButton();
        Module module = this.myModule;
        ModuleBridge moduleBridge = module instanceof ModuleBridge ? (ModuleBridge)module : null;
        ModuleEntity moduleEntity = this.moduleEntity = moduleBridge != null ? ModuleBridgeUtils.findModuleEntity((ModuleBridge)moduleBridge, (EntityStorage)((ModuleBridge)this.myModule).getEntityStorage().getCurrent()) : null;
        this.dbtSettings = moduleEntity != null ? DbtModuleEntityKt.getDbtSettings(moduleEntity) : null;
        Object object2 = this.dbtSettings;
        if (object2 == null || (object2 = object2.getDbtExecutablePath()) == null) {
            object2 = this.dialogDbtExecutablePath = "";
        }
        if ((object = this.dbtSettings) == null || (object = object.getDbtDataSourceId()) == null) {
            object = "";
        }
        this.dialogDbtDataSourceId = object;
        this.dataSourceCombobox = new ComboBox();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JComponent createComponent() {
        Object v4;
        ComboBox<RawDataSource> comboBox;
        Project project;
        block4: {
            void $this$firstOrNull$iv;
            RawDataSource it;
            void $this$toTypedArray$iv;
            void $this$flatMapTo$iv$iv;
            if (this.dbtSettings == null) {
                return (JComponent)BuilderKt.panel(DbtConfigurable::createComponent$lambda$1);
            }
            MessageBusConnection messageBusConnection = this.myModule.getProject().getMessageBus().connect((Disposable)this);
            Topic topic = DatabaseConfigEditor.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)new DbtDatabaseConfigEditorListener());
            this.dbtPathTextField.setText(this.dialogDbtExecutablePath);
            FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false).withTitle(DbtBundle.message("settings.choose.dbt.executable.dialog.title.dbt", new Object[0])).withFileFilter(arg_0 -> DbtConfigurable.createComponent$lambda$3(DbtConfigurable::createComponent$lambda$2, arg_0));
            TextFieldWithBrowseButton textFieldWithBrowseButton = this.dbtPathTextField;
            project = this.myModule.getProject();
            TextComponentAccessor textComponentAccessor = TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT;
            ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> listener2 = new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(descriptor, this, textFieldWithBrowseButton, project, (TextComponentAccessor<JTextField>)textComponentAccessor){
                final /* synthetic */ DbtConfigurable this$0;
                {
                    this.this$0 = $receiver;
                    super((ComponentWithBrowseButton)$super_call_param$1, $super_call_param$2, $descriptor, $super_call_param$3);
                }

                protected VirtualFile getInitialFile() {
                    return ProjectUtil.guessModuleDir((Module)DbtConfigurable.access$getMyModule$p(this.this$0));
                }
            };
            this.dbtPathTextField.addActionListener((ActionListener)listener2);
            List list = DataSourceManager.getManagers((Project)this.myModule.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getManagers(...)");
            Iterable $this$flatMap$iv = list;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                DataSourceManager it2 = (DataSourceManager)element$iv$iv;
                boolean bl = false;
                List list2 = it2.getDataSources();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDataSources(...)");
                Iterable list$iv$iv = list2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv2 = $this$toTypedArray$iv;
            RawDataSource[] dataSources = thisCollection$iv2.toArray(new RawDataSource[0]);
            this.dataSourceCombobox.addItem(null);
            RawDataSource[] $this$forEach$iv = dataSources;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int thisCollection$iv2 = 0; thisCollection$iv2 < n; ++thisCollection$iv2) {
                RawDataSource element$iv;
                it = element$iv = $this$forEach$iv[thisCollection$iv2];
                boolean bl = false;
                this.dataSourceCombobox.addItem((Object)it);
            }
            this.dataSourceCombobox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)DbtBundle.message("settings.no.data.source", new Object[0]), arg_0 -> DbtConfigurable.createComponent$lambda$6(createComponent.3.INSTANCE, arg_0)));
            $this$forEach$iv = dataSources;
            comboBox = this.dataSourceCombobox;
            boolean $i$f$firstOrNull = false;
            for (void element$iv : $this$firstOrNull$iv) {
                it = element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUniqueId(), (Object)this.dialogDbtDataSourceId)) continue;
                v4 = element$iv;
                break block4;
            }
            v4 = null;
        }
        comboBox.setSelectedItem(v4);
        Project it = project = BuilderKt.panel(arg_0 -> DbtConfigurable.createComponent$lambda$12(this, arg_0));
        boolean bl = false;
        it.registerValidators((Disposable)this);
        return (JComponent)project;
    }

    public boolean isModified() {
        if (this.dbtSettings == null) {
            return false;
        }
        Object object = this.dataSourceCombobox.getSelectedItem();
        Object object2 = object instanceof RawDataSource ? (RawDataSource)object : null;
        if (object2 == null || (object2 = object2.getUniqueId()) == null) {
            object2 = "";
        }
        Object dataSourceUniqueId = object2;
        return !Intrinsics.areEqual((Object)this.dialogDbtExecutablePath, (Object)this.dbtPathTextField.getText()) || !Intrinsics.areEqual((Object)this.dialogDbtDataSourceId, (Object)dataSourceUniqueId);
    }

    public void apply() {
        String string = this.dbtPathTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.dialogDbtExecutablePath = string;
        Object object = this.dataSourceCombobox.getSelectedItem();
        Object object2 = object instanceof RawDataSource ? (RawDataSource)object : null;
        if (object2 == null || (object2 = object2.getUniqueId()) == null) {
            object2 = "";
        }
        this.dialogDbtDataSourceId = object2;
        ApplicationManager.getApplication().invokeLater(() -> DbtConfigurable.apply$lambda$17(this));
    }

    @NotNull
    public String getDisplayName() {
        return DbtBundle.message("dbt.display.name", new Object[0]);
    }

    private final ValidationInfo validateDbtPath(ValidationInfoBuilder $this$validateDbtPath) {
        String string = this.dbtPathTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String value = string;
        if (((CharSequence)value).length() == 0) {
            return $this$validateDbtPath.error(DbtBundle.message("settings.dbt.path.error.empty", new Object[0]));
        }
        File file = new File(value);
        if (!file.exists()) {
            return $this$validateDbtPath.error(DbtBundle.message("settings.dbt.path.error.do.not.exist", new Object[0]));
        }
        if (!file.canExecute()) {
            return $this$validateDbtPath.error(DbtBundle.message("settings.dbt.path.error.message.file.not.executable", new Object[0]));
        }
        return null;
    }

    public void reset() {
    }

    public void dispose() {
        if (this.dbtSettings != null && !this.dbtSettings.getReviewed()) {
            this.markAsReviewed();
        }
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        Disposer.dispose((Disposable)this);
    }

    private final void markAsReviewed() {
        ApplicationManager.getApplication().invokeLater(() -> DbtConfigurable.markAsReviewed$lambda$21(this));
    }

    private final void clearFileLevelWarnings() {
        DaemonCodeAnalyzerEx daemonCodeAnalyzerEx = DaemonCodeAnalyzerEx.getInstanceEx((Project)this.myModule.getProject());
        Intrinsics.checkNotNull((Object)daemonCodeAnalyzerEx, (String)"null cannot be cast to non-null type com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl");
        ((DaemonCodeAnalyzerImpl)daemonCodeAnalyzerEx).restart();
    }

    private static final Unit createComponent$lambda$1$lambda$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(DbtBundle.message("settings.dbt.project.not.found", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$1(Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, DbtConfigurable::createComponent$lambda$1$lambda$0, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final boolean createComponent$lambda$2(VirtualFile it) {
        return new File(it.getPath()).canExecute();
    }

    private static final boolean createComponent$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String createComponent$lambda$6(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final ValidationInfo createComponent$lambda$12$lambda$9$lambda$8(DbtConfigurable this$0, ValidationInfoBuilder $this$validationInfo, TextFieldWithBrowseButton it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationInfo, (String)"$this$validationInfo");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.validateDbtPath($this$validationInfo);
    }

    private static final Unit createComponent$lambda$12$lambda$9(DbtConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.dbtPathTextField).align((Align)AlignX.FILL.INSTANCE).validationInfo((arg_0, arg_1) -> DbtConfigurable.createComponent$lambda$12$lambda$9$lambda$8(this$0, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$12$lambda$11$lambda$10(ActionEvent ae) {
        Intrinsics.checkNotNullParameter((Object)ae, (String)"ae");
        Object object = ae.getSource();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.Component");
        Component component = (Component)object;
        DataContext dataContext = DataManager.getInstance().getDataContext(component);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"dbt database configuration", null, (DataContext)dataContext2);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
        AnActionEvent anActionEvent2 = anActionEvent;
        AnAction anAction = ActionManager.getInstance().getAction("DatabaseView.AddDataSourceGroup");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup actionGroup = (ActionGroup)anAction;
        PopupFactoryImpl.ActionGroupPopup popup = new PopupFactoryImpl.ActionGroupPopup(null, null, actionGroup, dataContext2, ActionPlaces.getActionGroupPopupPlace((String)anActionEvent2.getPlace()), (PresentationFactory)new MenuItemPresentationFactory(), ActionPopupOptions.Companion.showDisabled(), null);
        popup.showUnderneathOf(component);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$12$lambda$11(DbtConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.dataSourceCombobox).align((Align)AlignX.FILL.INSTANCE);
        $this$row.link(DbtBundle.message("settings.add.data.source.label", new Object[0]), DbtConfigurable::createComponent$lambda$12$lambda$11$lambda$10);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$12(DbtConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.row(DbtBundle.message("settings.path.to.dbt.executable", new Object[0]), arg_0 -> DbtConfigurable.createComponent$lambda$12$lambda$9(this$0, arg_0));
        $this$panel.row(DbtBundle.message("settings.data.source", new Object[0]), arg_0 -> DbtConfigurable.createComponent$lambda$12$lambda$11(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit apply$lambda$17$lambda$16$lambda$15$lambda$14(DbtConfigurable this$0, DbtModuleEntity.Builder $this$modifyDbtModuleEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyDbtModuleEntity, (String)"$this$modifyDbtModuleEntity");
        $this$modifyDbtModuleEntity.setDbtExecutablePath(this$0.dialogDbtExecutablePath);
        $this$modifyDbtModuleEntity.setDbtDataSourceId(this$0.dialogDbtDataSourceId);
        return Unit.INSTANCE;
    }

    private static final Unit apply$lambda$17$lambda$16$lambda$15(DbtConfigurable this$0, MutableEntityStorage builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        DbtModuleEntity dbtModuleEntity = this$0.dbtSettings;
        Intrinsics.checkNotNull((Object)dbtModuleEntity);
        DbtModuleEntityKt.modifyDbtModuleEntity(builder, dbtModuleEntity, (Function1<? super DbtModuleEntity.Builder, Unit>)((Function1)arg_0 -> DbtConfigurable.apply$lambda$17$lambda$16$lambda$15$lambda$14(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final void apply$lambda$17$lambda$16(DbtConfigurable this$0) {
        Project project = this$0.myModule.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        WorkspaceModel.Companion.getInstance(project).updateProjectModel("Update dbt settings", arg_0 -> DbtConfigurable.apply$lambda$17$lambda$16$lambda$15(this$0, arg_0));
    }

    private static final void apply$lambda$17(DbtConfigurable this$0) {
        ApplicationManager.getApplication().runWriteAction(() -> DbtConfigurable.apply$lambda$17$lambda$16(this$0));
    }

    private static final Unit markAsReviewed$lambda$21$lambda$20$lambda$19$lambda$18(DbtModuleEntity.Builder $this$modifyDbtModuleEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyDbtModuleEntity, (String)"$this$modifyDbtModuleEntity");
        $this$modifyDbtModuleEntity.setReviewed(true);
        return Unit.INSTANCE;
    }

    private static final Unit markAsReviewed$lambda$21$lambda$20$lambda$19(DbtConfigurable this$0, MutableEntityStorage builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        DbtModuleEntity dbtModuleEntity = this$0.dbtSettings;
        Intrinsics.checkNotNull((Object)dbtModuleEntity);
        DbtModuleEntityKt.modifyDbtModuleEntity(builder, dbtModuleEntity, (Function1<? super DbtModuleEntity.Builder, Unit>)((Function1)DbtConfigurable::markAsReviewed$lambda$21$lambda$20$lambda$19$lambda$18));
        return Unit.INSTANCE;
    }

    private static final void markAsReviewed$lambda$21$lambda$20(DbtConfigurable this$0) {
        Project project = this$0.myModule.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        WorkspaceModel.Companion.getInstance(project).updateProjectModel("Update dbt settings", arg_0 -> DbtConfigurable.markAsReviewed$lambda$21$lambda$20$lambda$19(this$0, arg_0));
    }

    private static final void markAsReviewed$lambda$21(DbtConfigurable this$0) {
        ApplicationManager.getApplication().runWriteAction(() -> DbtConfigurable.markAsReviewed$lambda$21$lambda$20(this$0));
        this$0.clearFileLevelWarnings();
    }

    public static final /* synthetic */ Module access$getMyModule$p(DbtConfigurable $this) {
        return $this.myModule;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/dbt/settings/DbtConfigurable$DbtDatabaseConfigEditorListener;", "Lcom/intellij/database/view/ui/DatabaseConfigEditor$Listener;", "<init>", "(Lcom/intellij/dbt/settings/DbtConfigurable;)V", "applied", "", "target", "", "isNew", "", "intellij.dbt"})
    public final class DbtDatabaseConfigEditorListener
    implements DatabaseConfigEditor.Listener {
        public void applied(@NotNull Object target, boolean isNew) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            if (target instanceof DbDataSource) {
                RawDataSource rawDataSource = ((DbDataSource)target).getDelegateDataSource();
                Intrinsics.checkNotNullExpressionValue((Object)rawDataSource, (String)"getDelegateDataSource(...)");
                RawDataSource dataSource = rawDataSource;
                DbtConfigurable.this.dataSourceCombobox.addItem((Object)dataSource);
                DbtConfigurable.this.dataSourceCombobox.setSelectedItem((Object)dataSource);
            }
        }
    }
}

