/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties.references;

import com.intellij.database.model.DasNamed;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.NameValueGetter;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaReferenceDesc;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Pair;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class BasicParentReference
implements BasicReference {
    public final String parentName;
    public final BasicReference childRef;

    public BasicParentReference(@NotNull String parentName, @NotNull BasicReference childRef) {
        if (parentName == null) {
            BasicParentReference.$$$reportNull$$$0(0);
        }
        if (childRef == null) {
            BasicParentReference.$$$reportNull$$$0(1);
        }
        this.parentName = parentName;
        this.childRef = childRef;
        if (!(childRef instanceof BasicNameReference) && !(childRef instanceof BasicParentReference)) {
            throw new AssertionError((Object)"Unsupported");
        }
    }

    @Nullable
    public static BasicReference create(@Nullable String parentName, @Nullable BasicReference childRef) {
        return BasicNameReference.isDefault(parentName) || childRef == null ? childRef : new BasicParentReference(parentName, childRef);
    }

    private int getDepth() {
        if (this.childRef instanceof BasicParentReference) {
            int depth = ((BasicParentReference)this.childRef).getDepth();
            return depth + 1;
        }
        return 1;
    }

    @Override
    @NotNull
    public <S extends BasicElement> BasicReference simplify(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, ?> meta, @NotNull BasicResolveAssistant assistant) {
        BasicElement base;
        DasNamed root;
        if (source == null) {
            BasicParentReference.$$$reportNull$$$0(2);
        }
        if (meta == null) {
            BasicParentReference.$$$reportNull$$$0(3);
        }
        if (assistant == null) {
            BasicParentReference.$$$reportNull$$$0(4);
        }
        DasNamed dasNamed = root = (base = BasicMetaUtils.getResolveBase(source, meta, assistant)) == null ? null : assistant.getRestrictedRoot(base, this.getDepth(), this.filteredTargets(meta.targets));
        if (root == null || !root.getName().equals(this.parentName)) {
            BasicParentReference basicParentReference = this;
            if (basicParentReference == null) {
                BasicParentReference.$$$reportNull$$$0(5);
            }
            return basicParentReference;
        }
        BasicReference basicReference = this.childRef.simplify(source, meta, assistant);
        if (basicReference == null) {
            BasicParentReference.$$$reportNull$$$0(6);
        }
        return basicReference;
    }

    protected <T extends BasicElement> BasicMetaObject<? extends T>[] filteredTargets(BasicMetaObject<? extends T>[] targets) {
        if (this.childRef instanceof BasicParentReference) {
            return ((BasicParentReference)this.childRef).filteredTargets(targets);
        }
        if (this.childRef instanceof BasicNameReference) {
            return ((BasicNameReference)this.childRef).filteredTargets(targets);
        }
        return targets;
    }

    @Override
    public <S extends BasicElement, T extends BasicElement> boolean matches(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, @NotNull T target2) {
        if (source == null) {
            BasicParentReference.$$$reportNull$$$0(7);
        }
        if (meta == null) {
            BasicParentReference.$$$reportNull$$$0(8);
        }
        if (target2 == null) {
            BasicParentReference.$$$reportNull$$$0(9);
        }
        return this.matchesImpl(source, meta, target2) != null;
    }

    @Nullable
    private <S extends BasicElement, T extends BasicElement> BasicElement matchesImpl(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, @NotNull T target2) {
        if (source == null) {
            BasicParentReference.$$$reportNull$$$0(10);
        }
        if (meta == null) {
            BasicParentReference.$$$reportNull$$$0(11);
        }
        if (target2 == null) {
            BasicParentReference.$$$reportNull$$$0(12);
        }
        Object child = this.childRef instanceof BasicParentReference ? ((BasicParentReference)this.childRef).matchesImpl(source, meta, target2) : (this.childRef.matches(source, meta, target2) ? target2 : null);
        BasicElement current = child == null ? null : child.getParent();
        return current != null && this.parentName.equals(current.getName()) ? current : null;
    }

    @Override
    @NotNull
    public <S extends BasicElement, T extends BasicElement> JBIterable<T> multiResolve(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, @NotNull BasicResolveAssistant assistant) {
        if (source == null) {
            BasicParentReference.$$$reportNull$$$0(13);
        }
        if (meta == null) {
            BasicParentReference.$$$reportNull$$$0(14);
        }
        if (assistant == null) {
            BasicParentReference.$$$reportNull$$$0(15);
        }
        JBIterable<T> candidates = this.childRef instanceof BasicNameReference ? ((BasicNameReference)this.childRef).multiResolve(source, meta, true, assistant) : this.childRef.multiResolve(source, meta, assistant);
        int depth = this.getDepth();
        JBIterable jBIterable = candidates.filter(o -> this.parentName.equals(BasicParentReference.getParentName(o, depth)));
        if (jBIterable == null) {
            BasicParentReference.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    @NotNull
    private static String getParentName(BasicElement o, int depth) {
        for (int i2 = 0; o != null && i2 < depth; o = o.getParent(), ++i2) {
        }
        String string = DasUtil.getName(o);
        if (string == null) {
            BasicParentReference.$$$reportNull$$$0(17);
        }
        return string;
    }

    public int hashCode() {
        return Objects.hash(this.parentName, this.childRef);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicParentReference)) {
            return false;
        }
        BasicParentReference reference = (BasicParentReference)o;
        return this.parentName.equals(reference.parentName) && this.childRef.equals(reference.childRef);
    }

    @Override
    @Nullable
    public String getName() {
        return this.childRef.getName();
    }

    @Override
    public long getObjectId() {
        return Long.MIN_VALUE;
    }

    @Override
    @Nullable
    public String getParentName(int i2) {
        int depth = this.getDepth();
        if (i2 > depth) {
            return null;
        }
        if (i2 == depth) {
            return this.parentName;
        }
        BasicReference r = this;
        for (int k = depth - i2; k > 0 && r != null; --k) {
            BasicParentReference pRef = (BasicParentReference)ObjectUtils.tryCast((Object)r, BasicParentReference.class);
            r = pRef == null ? null : pRef.childRef;
        }
        if (r instanceof BasicParentReference) {
            return r.parentName;
        }
        return r == null ? null : r.getName();
    }

    @Override
    @Nullable
    public BasicReference subReference() {
        return this.childRef;
    }

    @Override
    public boolean isPlain() {
        return this.childRef.isPlain();
    }

    @Override
    public boolean isCrossPortable() {
        return true;
    }

    @Override
    @Nullable
    public String getName(@Nullable BasicElement e) {
        return this.childRef.getName(e);
    }

    @Override
    public void exportProperties(@NotNull NameValueConsumer<? super String> consumer) {
        if (consumer == null) {
            BasicParentReference.$$$reportNull$$$0(18);
        }
        this.childRef.exportProperties(consumer);
        BasicNameReference.exportName(this.parentName, BasicParentReference.parentNameProp(this.getDepth()), consumer);
    }

    @Override
    public boolean isEquivalent(BasicReference ref) {
        BasicParentReference pRef = (BasicParentReference)ObjectUtils.tryCast((Object)ref, BasicParentReference.class);
        return pRef != null ? pRef.parentName.equals(this.parentName) && this.childRef.isEquivalent(pRef.childRef) : this.childRef.isEquivalent(ref);
    }

    @NotNull
    private static String parentNameProp(int depth) {
        Object object = depth == 1 ? "ParentName" : "Parent" + depth + "Name";
        if (object == null) {
            BasicParentReference.$$$reportNull$$$0(19);
        }
        return object;
    }

    @Nullable
    public static BasicReference importProperties(@NotNull NameValueGetter<String> properties2) {
        if (properties2 == null) {
            BasicParentReference.$$$reportNull$$$0(20);
        }
        BasicReference childRef = BasicNameReference.importProperties(properties2);
        int depth = 1;
        String parentName;
        while (!BasicNameReference.isDefault(parentName = BasicNameReference.importName(BasicParentReference.parentNameProp(depth), properties2))) {
            childRef = BasicParentReference.create(parentName, childRef);
            ++depth;
        }
        return childRef;
    }

    public String toString() {
        return "parentName=" + this.parentName + ", name=[" + String.valueOf(this.childRef) + "]";
    }

    @Nullable
    public static BasicReference parseRef(@NotNull String name2, @NotNull NamingService ns, @NotNull Lexer lexer) {
        if (name2 == null) {
            BasicParentReference.$$$reportNull$$$0(21);
        }
        if (ns == null) {
            BasicParentReference.$$$reportNull$$$0(22);
        }
        if (lexer == null) {
            BasicParentReference.$$$reportNull$$$0(23);
        }
        if (name2.contains(".")) {
            lexer.start((CharSequence)name2);
            ObjectPath res = BasicParentReference.extractPath(ns, lexer, false);
            if (res != null) {
                return BasicParentReference.asRef(res);
            }
        }
        return BasicParentReference.parseToken(name2, ns);
    }

    @Nullable
    private static ObjectPath extractPath(@NotNull NamingService ns, @NotNull Lexer lexer, boolean stopOnComma) {
        if (ns == null) {
            BasicParentReference.$$$reportNull$$$0(24);
        }
        if (lexer == null) {
            BasicParentReference.$$$reportNull$$$0(25);
        }
        ObjectPath res2 = null;
        while (!(lexer.getTokenType() == null || stopOnComma && lexer.getTokenType() == SqlCommonTokens.SQL_COMMA)) {
            res2 = BasicParentReference.processToken(lexer.getTokenText(), ns, res2);
            while (lexer.getTokenType() != SqlCommonTokens.SQL_PERIOD && lexer.getTokenType() != null) {
                lexer.advance();
            }
            lexer.advance();
        }
        return res2;
    }

    @NotNull
    public static @Unmodifiable List<BasicReference> parseRefs(@NotNull String name2, @NotNull NamingService ns, @NotNull Lexer lexer) {
        if (name2 == null) {
            BasicParentReference.$$$reportNull$$$0(26);
        }
        if (ns == null) {
            BasicParentReference.$$$reportNull$$$0(27);
        }
        if (lexer == null) {
            BasicParentReference.$$$reportNull$$$0(28);
        }
        if (name2.contains(".") || name2.contains(",")) {
            ArrayList<BasicReference> res = new ArrayList<BasicReference>();
            lexer.start((CharSequence)name2);
            while (lexer.getTokenType() != null) {
                ObjectPath path = BasicParentReference.extractPath(ns, lexer, true);
                lexer.advance();
                ContainerUtil.addIfNotNull(res, (Object)BasicParentReference.asRef(path));
            }
            if (!res.isEmpty()) {
                ArrayList<BasicReference> arrayList = res;
                if (arrayList == null) {
                    BasicParentReference.$$$reportNull$$$0(29);
                }
                return arrayList;
            }
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)BasicParentReference.parseToken(name2, ns));
        if (list == null) {
            BasicParentReference.$$$reportNull$$$0(30);
        }
        return list;
    }

    @Nullable
    public static BasicReference asRef(@Nullable ObjectPath path) {
        if (path == null) {
            return null;
        }
        BasicReference res = BasicNameReference.create(path.name, !path.isQuoted());
        ObjectPath tmp = path.parent;
        while (tmp != null) {
            res = BasicParentReference.create(tmp.name, res);
            tmp = tmp.parent;
        }
        return res;
    }

    @Nullable
    private static BasicNameReference parseToken(@NotNull String name2, @NotNull NamingService ns) {
        boolean quoted;
        if (name2 == null) {
            BasicParentReference.$$$reportNull$$$0(31);
        }
        if (ns == null) {
            BasicParentReference.$$$reportNull$$$0(32);
        }
        return BasicNameReference.create((quoted = ns.isQuoted(name2)) ? ns.unquoteIdentifier(name2) : name2, !quoted);
    }

    @Nullable
    private static ObjectPath processToken(@Nullable String token, @NotNull NamingService ns, @Nullable ObjectPath parent) {
        if (ns == null) {
            BasicParentReference.$$$reportNull$$$0(33);
        }
        if (token == null) {
            return null;
        }
        boolean quoted = ns.isQuoted(token);
        return ObjectPath.create(quoted ? ns.unquoteIdentifier(token) : token, ObjectKind.NONE, !quoted, null, parent);
    }

    @NotNull
    public static @NotNull Pair<@Nullable String, @NotNull String> parseNameRef(@NotNull String name2, @NotNull NamingService ns, @NotNull Lexer lexer) {
        if (name2 == null) {
            BasicParentReference.$$$reportNull$$$0(34);
        }
        if (ns == null) {
            BasicParentReference.$$$reportNull$$$0(35);
        }
        if (lexer == null) {
            BasicParentReference.$$$reportNull$$$0(36);
        }
        if (!name2.contains(".")) {
            Pair pair = Pair.create(null, (Object)ns.unquoteIdentifier(name2));
            if (pair == null) {
                BasicParentReference.$$$reportNull$$$0(37);
            }
            return pair;
        }
        lexer.start((CharSequence)name2);
        String pName = lexer.getTokenText();
        while (lexer.getTokenType() != SqlCommonTokens.SQL_PERIOD && lexer.getTokenType() != null) {
            lexer.advance();
        }
        lexer.advance();
        if (lexer.getTokenType() == null) {
            Pair pair = Pair.create(null, (Object)ns.unquoteIdentifier(pName));
            if (pair == null) {
                BasicParentReference.$$$reportNull$$$0(38);
            }
            return pair;
        }
        String cName = lexer.getTokenText();
        Pair pair = Pair.create((Object)ns.unquoteIdentifier(pName), (Object)ns.unquoteIdentifier(cName));
        if (pair == null) {
            BasicParentReference.$$$reportNull$$$0(39);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 16, 17, 19, 29, 30, 37, 38, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childRef";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assistant";
                break;
            }
            case 5: 
            case 6: 
            case 16: 
            case 17: 
            case 19: 
            case 29: 
            case 30: 
            case 37: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/properties/references/BasicParentReference";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 21: 
            case 26: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 22: 
            case 24: 
            case 27: 
            case 32: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
            case 23: 
            case 25: 
            case 28: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/properties/references/BasicParentReference";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "simplify";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "parentNameProp";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRefs";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "parseNameRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "simplify";
                break;
            }
            case 5: 
            case 6: 
            case 16: 
            case 17: 
            case 19: 
            case 29: 
            case 30: 
            case 37: 
            case 38: 
            case 39: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "matchesImpl";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "parseRef";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "extractPath";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "parseRefs";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "parseToken";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processToken";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "parseNameRef";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 16, 17, 19, 29, 30, 37, 38, 39 -> new IllegalStateException(string);
        };
    }
}

