/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.TextDomain;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryDomain
extends Domain {
    private final Cardinality.ElementsCardinality myCardinality;
    private final long myUpperBound;
    private final TextDomain.Length myLengthCaps;

    public BinaryDomain(@NotNull String name2, @NotNull ConversionPoint descriptor, long upperBound) {
        if (name2 == null) {
            BinaryDomain.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            BinaryDomain.$$$reportNull$$$0(1);
        }
        this(name2, descriptor, upperBound, TextDomain.Length.NONE);
    }

    /*
     * WARNING - void declaration
     */
    public BinaryDomain(@NotNull String name2, @NotNull ConversionPoint descriptor, long upperBound, long defaultValue, boolean bl, boolean bl2) {
        void variable;
        void narrowable;
        if (name2 == null) {
            BinaryDomain.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            BinaryDomain.$$$reportNull$$$0(3);
        }
        this(name2, descriptor, upperBound, narrowable != false ? TextDomain.Length.optional(defaultValue == -1L ? upperBound : defaultValue, (boolean)variable) : TextDomain.Length.fixed(defaultValue, (boolean)variable));
    }

    /*
     * WARNING - void declaration
     */
    public BinaryDomain(@NotNull String name2, @NotNull ConversionPoint descriptor, long upperBound, TextDomain.Length length) {
        void lengthCaps;
        if (name2 == null) {
            BinaryDomain.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            BinaryDomain.$$$reportNull$$$0(5);
        }
        super(descriptor, name2);
        this.myUpperBound = upperBound;
        this.myLengthCaps = lengthCaps;
        this.myCardinality = new Cardinality.ElementsCardinality(this.myUpperBound);
    }

    public long getUpperBound() {
        return this.myUpperBound;
    }

    public long getEffectiveUpperBound() {
        return this.myLengthCaps.getEffectiveLength(this.myUpperBound);
    }

    @Override
    @NotNull
    public Cardinality cardinality() {
        Cardinality.ElementsCardinality elementsCardinality = this.myCardinality;
        if (elementsCardinality == null) {
            BinaryDomain.$$$reportNull$$$0(6);
        }
        return elementsCardinality;
    }

    @Override
    @NotNull
    public Compatibility getCompatibility(@NotNull Domain domain) {
        if (domain == null) {
            BinaryDomain.$$$reportNull$$$0(7);
        }
        Compatibility compatibility = domain instanceof BinaryDomain && BinaryDomain.areTypesCompatible(this.getLogicType(), domain.getLogicType()) ? (((BinaryDomain)domain).getEffectiveUpperBound() <= this.getEffectiveUpperBound() ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.compatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType())) : Compatibility.incompatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType());
        if (compatibility == null) {
            BinaryDomain.$$$reportNull$$$0(8);
        }
        return compatibility;
    }

    private static boolean areTypesCompatible(@NotNull LogicalType type1, @NotNull LogicalType type2) {
        if (type1 == null) {
            BinaryDomain.$$$reportNull$$$0(9);
        }
        if (type2 == null) {
            BinaryDomain.$$$reportNull$$$0(10);
        }
        return type1 == LogicalType.GRAPHIC ? type2 == LogicalType.GRAPHIC : true;
    }

    @Override
    @Nullable
    public Object trim(@NotNull Object o) {
        if (o == null) {
            BinaryDomain.$$$reportNull$$$0(11);
        }
        return o instanceof byte[] && this.getEffectiveUpperBound() > 0L ? (Object)Arrays.copyOf((byte[])o, (int)Math.min(this.getEffectiveUpperBound(), (long)((byte[])o).length)) : o;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull Domain domain) {
        if (domain == null) {
            BinaryDomain.$$$reportNull$$$0(12);
        }
        BinaryDomain binaryDomain = this.myLengthCaps.isNarrowable() && domain instanceof BinaryDomain ? new BinaryDomain(this.simpleName(), this.getPoint(), Math.min(((BinaryDomain)domain).getEffectiveUpperBound(), this.getEffectiveUpperBound()), this.myLengthCaps) : this;
        if (binaryDomain == null) {
            BinaryDomain.$$$reportNull$$$0(13);
        }
        return binaryDomain;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull SizeProvider provider) {
        if (provider == null) {
            BinaryDomain.$$$reportNull$$$0(14);
        }
        BinaryDomain binaryDomain = this.myLengthCaps.isNarrowable() ? new BinaryDomain(this.simpleName(), this.getPoint(), Math.min((long)provider.getSize(), this.getEffectiveUpperBound()), this.myLengthCaps) : this;
        if (binaryDomain == null) {
            BinaryDomain.$$$reportNull$$$0(15);
        }
        return binaryDomain;
    }

    @Override
    @NotNull
    public String name() {
        Object object = this.myLengthCaps.shouldAddLength(this.getUpperBound()) ? this.simpleName() + "(" + this.getEffectiveUpperBound() + ")" : super.name();
        if (object == null) {
            BinaryDomain.$$$reportNull$$$0(16);
        }
        return object;
    }

    protected long getDefaultValue() {
        return this.myLengthCaps.defaultLength;
    }

    protected boolean isNarrowable() {
        return this.myLengthCaps.isNarrowable();
    }

    public boolean isVariable() {
        return this.myLengthCaps.isVariable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 13, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: 
            case 8: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/domain/BinaryDomain";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/domain/BinaryDomain";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "cardinality";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompatibility";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "narrow";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCompatibility";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "areTypesCompatible";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "trim";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "narrow";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 13, 15, 16 -> new IllegalStateException(string);
        };
    }
}

