package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVsUserResourcePackage invokes the vs.DescribeVsUserResourcePackage API synchronously
func (client *Client) DescribeVsUserResourcePackage(request *DescribeVsUserResourcePackageRequest) (response *DescribeVsUserResourcePackageResponse, err error) {
	response = CreateDescribeVsUserResourcePackageResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVsUserResourcePackageWithChan invokes the vs.DescribeVsUserResourcePackage API asynchronously
func (client *Client) DescribeVsUserResourcePackageWithChan(request *DescribeVsUserResourcePackageRequest) (<-chan *DescribeVsUserResourcePackageResponse, <-chan error) {
	responseChan := make(chan *DescribeVsUserResourcePackageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVsUserResourcePackage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVsUserResourcePackageWithCallback invokes the vs.DescribeVsUserResourcePackage API asynchronously
func (client *Client) DescribeVsUserResourcePackageWithCallback(request *DescribeVsUserResourcePackageRequest, callback func(response *DescribeVsUserResourcePackageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVsUserResourcePackageResponse
		var err error
		defer close(result)
		response, err = client.DescribeVsUserResourcePackage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVsUserResourcePackageRequest is the request struct for api DescribeVsUserResourcePackage
type DescribeVsUserResourcePackageRequest struct {
	*requests.RpcRequest
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	ShowLog       string           `position:"Query" name:"ShowLog"`
}

// DescribeVsUserResourcePackageResponse is the response struct for api DescribeVsUserResourcePackage
type DescribeVsUserResourcePackageResponse struct {
	*responses.BaseResponse
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	ResourcePackageInfos ResourcePackageInfos `json:"ResourcePackageInfos" xml:"ResourcePackageInfos"`
}

// CreateDescribeVsUserResourcePackageRequest creates a request to invoke DescribeVsUserResourcePackage API
func CreateDescribeVsUserResourcePackageRequest() (request *DescribeVsUserResourcePackageRequest) {
	request = &DescribeVsUserResourcePackageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeVsUserResourcePackage", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeVsUserResourcePackageResponse creates a response to parse from DescribeVsUserResourcePackage response
func CreateDescribeVsUserResourcePackageResponse() (response *DescribeVsUserResourcePackageResponse) {
	response = &DescribeVsUserResourcePackageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
