package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveDrmUsageData invokes the live.DescribeLiveDrmUsageData API synchronously
func (client *Client) DescribeLiveDrmUsageData(request *DescribeLiveDrmUsageDataRequest) (response *DescribeLiveDrmUsageDataResponse, err error) {
	response = CreateDescribeLiveDrmUsageDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveDrmUsageDataWithChan invokes the live.DescribeLiveDrmUsageData API asynchronously
func (client *Client) DescribeLiveDrmUsageDataWithChan(request *DescribeLiveDrmUsageDataRequest) (<-chan *DescribeLiveDrmUsageDataResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveDrmUsageDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveDrmUsageData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveDrmUsageDataWithCallback invokes the live.DescribeLiveDrmUsageData API asynchronously
func (client *Client) DescribeLiveDrmUsageDataWithCallback(request *DescribeLiveDrmUsageDataRequest, callback func(response *DescribeLiveDrmUsageDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveDrmUsageDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveDrmUsageData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveDrmUsageDataRequest is the request struct for api DescribeLiveDrmUsageData
type DescribeLiveDrmUsageDataRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	SplitBy    string           `position:"Query" name:"SplitBy"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	Interval   string           `position:"Query" name:"Interval"`
}

// DescribeLiveDrmUsageDataResponse is the response struct for api DescribeLiveDrmUsageData
type DescribeLiveDrmUsageDataResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	DrmUsageData DrmUsageData `json:"DrmUsageData" xml:"DrmUsageData"`
}

// CreateDescribeLiveDrmUsageDataRequest creates a request to invoke DescribeLiveDrmUsageData API
func CreateDescribeLiveDrmUsageDataRequest() (request *DescribeLiveDrmUsageDataRequest) {
	request = &DescribeLiveDrmUsageDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveDrmUsageData", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveDrmUsageDataResponse creates a response to parse from DescribeLiveDrmUsageData response
func CreateDescribeLiveDrmUsageDataResponse() (response *DescribeLiveDrmUsageDataResponse) {
	response = &DescribeLiveDrmUsageDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
