package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEpnMeasurementData invokes the ens.DescribeEpnMeasurementData API synchronously
func (client *Client) DescribeEpnMeasurementData(request *DescribeEpnMeasurementDataRequest) (response *DescribeEpnMeasurementDataResponse, err error) {
	response = CreateDescribeEpnMeasurementDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEpnMeasurementDataWithChan invokes the ens.DescribeEpnMeasurementData API asynchronously
func (client *Client) DescribeEpnMeasurementDataWithChan(request *DescribeEpnMeasurementDataRequest) (<-chan *DescribeEpnMeasurementDataResponse, <-chan error) {
	responseChan := make(chan *DescribeEpnMeasurementDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEpnMeasurementData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEpnMeasurementDataWithCallback invokes the ens.DescribeEpnMeasurementData API asynchronously
func (client *Client) DescribeEpnMeasurementDataWithCallback(request *DescribeEpnMeasurementDataRequest, callback func(response *DescribeEpnMeasurementDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEpnMeasurementDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeEpnMeasurementData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEpnMeasurementDataRequest is the request struct for api DescribeEpnMeasurementData
type DescribeEpnMeasurementDataRequest struct {
	*requests.RpcRequest
	StartDate string `position:"Query" name:"StartDate"`
	EndDate   string `position:"Query" name:"EndDate"`
}

// DescribeEpnMeasurementDataResponse is the response struct for api DescribeEpnMeasurementData
type DescribeEpnMeasurementDataResponse struct {
	*responses.BaseResponse
	RequestId        string                                       `json:"RequestId" xml:"RequestId"`
	MeasurementDatas MeasurementDatasInDescribeEpnMeasurementData `json:"MeasurementDatas" xml:"MeasurementDatas"`
}

// CreateDescribeEpnMeasurementDataRequest creates a request to invoke DescribeEpnMeasurementData API
func CreateDescribeEpnMeasurementDataRequest() (request *DescribeEpnMeasurementDataRequest) {
	request = &DescribeEpnMeasurementDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeEpnMeasurementData", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeEpnMeasurementDataResponse creates a response to parse from DescribeEpnMeasurementData response
func CreateDescribeEpnMeasurementDataResponse() (response *DescribeEpnMeasurementDataResponse) {
	response = &DescribeEpnMeasurementDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
