package democenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExpireDemoAccessToken invokes the democenter.ExpireDemoAccessToken API synchronously
// api document: https://help.aliyun.com/api/democenter/expiredemoaccesstoken.html
func (client *Client) ExpireDemoAccessToken(request *ExpireDemoAccessTokenRequest) (response *ExpireDemoAccessTokenResponse, err error) {
	response = CreateExpireDemoAccessTokenResponse()
	err = client.DoAction(request, response)
	return
}

// ExpireDemoAccessTokenWithChan invokes the democenter.ExpireDemoAccessToken API asynchronously
// api document: https://help.aliyun.com/api/democenter/expiredemoaccesstoken.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ExpireDemoAccessTokenWithChan(request *ExpireDemoAccessTokenRequest) (<-chan *ExpireDemoAccessTokenResponse, <-chan error) {
	responseChan := make(chan *ExpireDemoAccessTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExpireDemoAccessToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExpireDemoAccessTokenWithCallback invokes the democenter.ExpireDemoAccessToken API asynchronously
// api document: https://help.aliyun.com/api/democenter/expiredemoaccesstoken.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ExpireDemoAccessTokenWithCallback(request *ExpireDemoAccessTokenRequest, callback func(response *ExpireDemoAccessTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExpireDemoAccessTokenResponse
		var err error
		defer close(result)
		response, err = client.ExpireDemoAccessToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExpireDemoAccessTokenRequest is the request struct for api ExpireDemoAccessToken
type ExpireDemoAccessTokenRequest struct {
	*requests.RpcRequest
	DemoAccessToken string `position:"Body" name:"DemoAccessToken"`
}

// ExpireDemoAccessTokenResponse is the response struct for api ExpireDemoAccessToken
type ExpireDemoAccessTokenResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateExpireDemoAccessTokenRequest creates a request to invoke ExpireDemoAccessToken API
func CreateExpireDemoAccessTokenRequest() (request *ExpireDemoAccessTokenRequest) {
	request = &ExpireDemoAccessTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DemoCenter", "2020-01-21", "ExpireDemoAccessToken", "", "")
	return
}

// CreateExpireDemoAccessTokenResponse creates a response to parse from ExpireDemoAccessToken response
func CreateExpireDemoAccessTokenResponse() (response *ExpireDemoAccessTokenResponse) {
	response = &ExpireDemoAccessTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
