package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVnNluProfile invokes the cloudcallcenter.DescribeVnNluProfile API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/describevnnluprofile.html
func (client *Client) DescribeVnNluProfile(request *DescribeVnNluProfileRequest) (response *DescribeVnNluProfileResponse, err error) {
	response = CreateDescribeVnNluProfileResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVnNluProfileWithChan invokes the cloudcallcenter.DescribeVnNluProfile API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/describevnnluprofile.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVnNluProfileWithChan(request *DescribeVnNluProfileRequest) (<-chan *DescribeVnNluProfileResponse, <-chan error) {
	responseChan := make(chan *DescribeVnNluProfileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVnNluProfile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVnNluProfileWithCallback invokes the cloudcallcenter.DescribeVnNluProfile API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/describevnnluprofile.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVnNluProfileWithCallback(request *DescribeVnNluProfileRequest, callback func(response *DescribeVnNluProfileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVnNluProfileResponse
		var err error
		defer close(result)
		response, err = client.DescribeVnNluProfile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVnNluProfileRequest is the request struct for api DescribeVnNluProfile
type DescribeVnNluProfileRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DescribeVnNluProfileResponse is the response struct for api DescribeVnNluProfile
type DescribeVnNluProfileResponse struct {
	*responses.BaseResponse
	RequestId         string     `json:"RequestId" xml:"RequestId"`
	ChatbotInstanceId string     `json:"ChatbotInstanceId" xml:"ChatbotInstanceId"`
	ChatbotName       string     `json:"ChatbotName" xml:"ChatbotName"`
	NluProfile        NluProfile `json:"NluProfile" xml:"NluProfile"`
}

// CreateDescribeVnNluProfileRequest creates a request to invoke DescribeVnNluProfile API
func CreateDescribeVnNluProfileRequest() (request *DescribeVnNluProfileRequest) {
	request = &DescribeVnNluProfileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "DescribeVnNluProfile", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeVnNluProfileResponse creates a response to parse from DescribeVnNluProfile response
func CreateDescribeVnNluProfileResponse() (response *DescribeVnNluProfileResponse) {
	response = &DescribeVnNluProfileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
