/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mam;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.IQReplyFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.commands.AdHocCommand;
import org.jivesoftware.smackx.commands.AdHocCommandManager;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.forward.packet.Forwarded;
import org.jivesoftware.smackx.mam.element.MamElementFactory;
import org.jivesoftware.smackx.mam.element.MamElements;
import org.jivesoftware.smackx.mam.element.MamFinIQ;
import org.jivesoftware.smackx.mam.element.MamPrefsIQ;
import org.jivesoftware.smackx.mam.element.MamQueryIQ;
import org.jivesoftware.smackx.mam.element.MamVersion;
import org.jivesoftware.smackx.mam.filter.MamResultFilter;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.rsm.packet.RSMSet;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

public final class MamManager
extends Manager {
    private static final String FORM_FIELD_WITH = "with";
    private static final String FORM_FIELD_START = "start";
    private static final String FORM_FIELD_END = "end";
    private static final Map<XMPPConnection, Map<Jid, MamManager>> INSTANCES;
    private static final String ADVANCED_CONFIG_NODE = "urn:xmpp:mam#configure";
    private final Jid archiveAddress;
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final AdHocCommandManager adHocCommandManager;
    private MamVersion mamVersion = null;

    public static MamManager getInstanceFor(XMPPConnection connection) {
        return MamManager.getInstanceFor(connection, null);
    }

    public static MamManager getInstanceFor(MultiUserChat multiUserChat) {
        XMPPConnection connection = multiUserChat.getXmppConnection();
        EntityBareJid archiveAddress = multiUserChat.getRoom();
        return MamManager.getInstanceFor(connection, archiveAddress);
    }

    public static synchronized MamManager getInstanceFor(XMPPConnection connection, Jid archiveAddress) {
        MamManager mamManager;
        Map<Jid, MamManager> managers = INSTANCES.get(connection);
        if (managers == null) {
            managers = new HashMap<Jid, MamManager>();
            INSTANCES.put(connection, managers);
        }
        if ((mamManager = managers.get(archiveAddress)) == null) {
            mamManager = new MamManager(connection, archiveAddress);
            managers.put(archiveAddress, mamManager);
        }
        return mamManager;
    }

    private MamManager(XMPPConnection connection, Jid archiveAddress) {
        super(connection);
        this.archiveAddress = archiveAddress;
        this.serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
        this.adHocCommandManager = AdHocCommandManager.getInstance(connection);
    }

    public Jid getArchiveAddress() {
        if (this.archiveAddress == null) {
            EntityFullJid localJid = this.connection().getUser();
            if (localJid == null) {
                return null;
            }
            return localJid.asBareJid();
        }
        return this.archiveAddress;
    }

    public String getMamNamespace() throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, InterruptedException {
        MamVersion mamVersion = this.getSupportedMamVersionOrNull();
        return mamVersion == null ? null : mamVersion.getNamespace();
    }

    private MamVersion getSupportedMamVersionOrNull() throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, InterruptedException {
        if (this.mamVersion != null) {
            return this.mamVersion;
        }
        DiscoverInfo info = this.serviceDiscoveryManager.discoverInfo(this.getArchiveAddress());
        for (MamVersion v : MamVersion.values()) {
            if (!info.containsFeature(v.getNamespace())) continue;
            this.mamVersion = v;
            break;
        }
        return this.mamVersion;
    }

    private MamVersion getSupportedMamVersionOrThrow() throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, InterruptedException {
        MamVersion mamVersion = this.getSupportedMamVersionOrNull();
        if (mamVersion == null) {
            throw new UnsupportedOperationException("Message Archive Management is not supported by " + String.valueOf(this.getArchiveAddress()));
        }
        return mamVersion;
    }

    private MamElementFactory getElementFactory() throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, InterruptedException {
        return this.getSupportedMamVersionOrThrow().newElementFactory();
    }

    public MamQuery queryArchive(MamQueryArgs mamQueryArgs) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NotLoggedInException, InterruptedException {
        String queryId = StringUtils.secureUniqueRandomString();
        String node = mamQueryArgs.node;
        DataForm dataForm = mamQueryArgs.getDataForm(this.mamVersion);
        MamQueryIQ mamQueryIQ = this.getElementFactory().newQueryIQ(queryId, node, dataForm);
        mamQueryIQ.setType(IQ.Type.set);
        mamQueryIQ.setTo(this.archiveAddress);
        mamQueryArgs.maybeAddRsmSet(mamQueryIQ);
        return this.queryArchive(mamQueryIQ);
    }

    private static FormField getWithFormField(Jid withJid) {
        return ((TextSingleFormField.Builder)FormField.builder(FORM_FIELD_WITH).setValue(withJid.toString())).build();
    }

    public MamQuery queryMostRecentPage(Jid jid, int max) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NotLoggedInException, InterruptedException {
        MamQueryArgs mamQueryArgs = MamQueryArgs.builder().queryLastPage().limitResultsToJid(jid).setResultPageSize(max).build();
        return this.queryArchive(mamQueryArgs);
    }

    public List<FormField> retrieveFormFields() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        return this.retrieveFormFields(null);
    }

    public List<FormField> retrieveFormFields(String node) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        String queryId = StringUtils.secureUniqueRandomString();
        MamQueryIQ mamQueryIq = this.getElementFactory().newQueryIQ(queryId, node, null);
        mamQueryIq.setTo(this.archiveAddress);
        MamQueryIQ mamResponseQueryIq = (MamQueryIQ)this.connection().sendIqRequestAndWaitForResponse(mamQueryIq);
        return mamResponseQueryIq.getDataForm().getFields();
    }

    private MamQuery queryArchive(MamQueryIQ mamQueryIq) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        MamQueryPage mamQueryPage = this.queryArchivePage(mamQueryIq);
        return new MamQuery(mamQueryPage, mamQueryIq.getNode(), DataForm.from(mamQueryIq));
    }

    private MamQueryPage queryArchivePage(MamQueryIQ mamQueryIq) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        StanzaCollector cancelledResultCollector;
        MamFinIQ mamFinIQ;
        XMPPConnection connection = this.getAuthenticatedConnectionOrThrow();
        StanzaCollector mamFinIQCollector = connection.createStanzaCollector(new IQReplyFilter(mamQueryIq, connection));
        StanzaCollector.Configuration resultCollectorConfiguration = StanzaCollector.newConfiguration().setStanzaFilter(new MamResultFilter(mamQueryIq)).setCollectorToReset(mamFinIQCollector);
        try (StanzaCollector resultCollector = connection.createStanzaCollector(resultCollectorConfiguration);){
            connection.sendStanza(mamQueryIq);
            mamFinIQ = (MamFinIQ)mamFinIQCollector.nextResultOrThrow();
            cancelledResultCollector = resultCollector;
        }
        return new MamQueryPage(cancelledResultCollector, mamFinIQ);
    }

    public boolean isSupported() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getSupportedMamVersionOrNull() != null;
    }

    public boolean isAdvancedConfigurationSupported() throws InterruptedException, XMPPException, SmackException {
        DiscoverItems discoverItems = this.adHocCommandManager.discoverCommands(this.archiveAddress);
        for (DiscoverItems.Item item : discoverItems.getItems()) {
            if (!item.getNode().equals(ADVANCED_CONFIG_NODE)) continue;
            return true;
        }
        return false;
    }

    public AdHocCommand getAdvancedConfigurationCommand() throws InterruptedException, XMPPException, SmackException {
        DiscoverItems discoverItems = this.adHocCommandManager.discoverCommands(this.archiveAddress);
        for (DiscoverItems.Item item : discoverItems.getItems()) {
            if (!item.getNode().equals(ADVANCED_CONFIG_NODE)) continue;
            return this.adHocCommandManager.getRemoteCommand(this.archiveAddress, item.getNode());
        }
        throw new SmackException.FeatureNotSupportedException(ADVANCED_CONFIG_NODE, this.archiveAddress);
    }

    private static DataForm.Builder getNewMamForm(MamVersion version) {
        TextSingleFormField field2 = FormField.buildHiddenFormType(version.getNamespace());
        DataForm.Builder form = DataForm.builder();
        form.addField(field2);
        return form;
    }

    public String getMessageUidOfLatestMessage() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NotLoggedInException, InterruptedException {
        MamQueryArgs mamQueryArgs = MamQueryArgs.builder().setResultPageSize(1).queryLastPage().build();
        MamQuery mamQuery = this.queryArchive(mamQueryArgs);
        if (mamQuery.getMessages().isEmpty()) {
            return null;
        }
        return mamQuery.getMamResultExtensions().get(0).getId();
    }

    public MamPrefsResult retrieveArchivingPreferences() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        MamPrefsIQ mamPrefIQ = this.getElementFactory().newPrefsIQ();
        return this.queryMamPrefs(mamPrefIQ);
    }

    public MamPrefsResult updateArchivingPreferences(MamPrefs mamPrefs) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        MamPrefsIQ mamPrefIQ = mamPrefs.constructMamPrefsIq();
        return this.queryMamPrefs(mamPrefIQ);
    }

    public MamPrefsResult enableMamForAllMessages() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NotLoggedInException, InterruptedException {
        return this.setDefaultBehavior(MamPrefsIQ.DefaultBehavior.always);
    }

    public MamPrefsResult enableMamForRosterMessages() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NotLoggedInException, InterruptedException {
        return this.setDefaultBehavior(MamPrefsIQ.DefaultBehavior.roster);
    }

    public MamPrefsResult setDefaultBehavior(MamPrefsIQ.DefaultBehavior desiredDefaultBehavior) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NotLoggedInException, InterruptedException {
        MamPrefsResult mamPrefsResult = this.retrieveArchivingPreferences();
        if (mamPrefsResult.mamPrefs.getDefault() == desiredDefaultBehavior) {
            return mamPrefsResult;
        }
        MamPrefs mamPrefs = mamPrefsResult.asMamPrefs();
        mamPrefs.setDefaultBehavior(desiredDefaultBehavior);
        return this.updateArchivingPreferences(mamPrefs);
    }

    private MamPrefsResult queryMamPrefs(MamPrefsIQ mamPrefsIQ) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        XMPPConnection connection = this.getAuthenticatedConnectionOrThrow();
        MamPrefsIQ mamPrefsResultIQ = (MamPrefsIQ)connection.sendIqRequestAndWaitForResponse(mamPrefsIQ);
        return new MamPrefsResult(mamPrefsResultIQ, DataForm.from(mamPrefsIQ));
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection connection) {
                MamManager.getInstanceFor(connection);
            }
        });
        INSTANCES = new WeakHashMap<XMPPConnection, Map<Jid, MamManager>>();
    }

    public static final class MamQueryArgs {
        private final String node;
        private final Map<String, FormField> formFields;
        private final Integer maxResults;
        private final String afterUid;
        private final String beforeUid;
        private DataForm dataForm;

        private MamQueryArgs(Builder builder) {
            this.node = builder.node;
            this.formFields = builder.formFields;
            this.maxResults = builder.maxResults > 0 ? Integer.valueOf(builder.maxResults) : null;
            this.afterUid = builder.afterUid;
            this.beforeUid = builder.beforeUid;
        }

        DataForm getDataForm(MamVersion version) {
            if (this.dataForm != null) {
                return this.dataForm;
            }
            DataForm.Builder dataFormBuilder = MamManager.getNewMamForm(version);
            dataFormBuilder.addFields(this.formFields.values());
            this.dataForm = dataFormBuilder.build();
            return this.dataForm;
        }

        void maybeAddRsmSet(MamQueryIQ mamQueryIQ) {
            if (this.maxResults == null && this.afterUid == null && this.beforeUid == null) {
                return;
            }
            int max = this.maxResults != null ? this.maxResults : -1;
            RSMSet rsmSet = new RSMSet(this.afterUid, this.beforeUid, -1, -1, null, max, null, -1);
            mamQueryIQ.addExtension(rsmSet);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String node;
            private final Map<String, FormField> formFields = new LinkedHashMap<String, FormField>(8);
            private int maxResults = -1;
            private String afterUid;
            private String beforeUid;

            public Builder queryNode(String node) {
                if (node == null) {
                    return this;
                }
                this.node = node;
                return this;
            }

            public Builder limitResultsToJid(Jid withJid) {
                if (withJid == null) {
                    return this;
                }
                FormField formField = MamManager.getWithFormField(withJid);
                this.formFields.put(formField.getFieldName(), formField);
                return this;
            }

            public Builder limitResultsSince(Date start) {
                if (start == null) {
                    return this;
                }
                TextSingleFormField formField = ((TextSingleFormField.Builder)FormField.builder(MamManager.FORM_FIELD_START).setValue(start)).build();
                this.formFields.put(formField.getFieldName(), formField);
                FormField endFormField = this.formFields.get(MamManager.FORM_FIELD_END);
                if (endFormField != null) {
                    Date end;
                    try {
                        end = endFormField.getFirstValueAsDate();
                    }
                    catch (ParseException e) {
                        throw new IllegalStateException(e);
                    }
                    if (end.getTime() <= start.getTime()) {
                        throw new IllegalArgumentException("Given start date (" + String.valueOf(start) + ") is after the existing end date (" + String.valueOf(end) + ")");
                    }
                }
                return this;
            }

            public Builder limitResultsBefore(Date end) {
                if (end == null) {
                    return this;
                }
                TextSingleFormField formField = ((TextSingleFormField.Builder)FormField.builder(MamManager.FORM_FIELD_END).setValue(end)).build();
                this.formFields.put(formField.getFieldName(), formField);
                FormField startFormField = this.formFields.get(MamManager.FORM_FIELD_START);
                if (startFormField != null) {
                    Date start;
                    try {
                        start = startFormField.getFirstValueAsDate();
                    }
                    catch (ParseException e) {
                        throw new IllegalStateException(e);
                    }
                    if (end.getTime() <= start.getTime()) {
                        throw new IllegalArgumentException("Given end date (" + String.valueOf(end) + ") is before the existing start date (" + String.valueOf(start) + ")");
                    }
                }
                return this;
            }

            public Builder setResultPageSize(Integer max) {
                if (max == null) {
                    this.maxResults = -1;
                    return this;
                }
                return this.setResultPageSizeTo(max);
            }

            public Builder setResultPageSizeTo(int max) {
                if (max < 0) {
                    throw new IllegalArgumentException();
                }
                this.maxResults = max;
                return this;
            }

            public Builder onlyReturnMessageCount() {
                return this.setResultPageSizeTo(0);
            }

            public Builder withAdditionalFormField(FormField formField) {
                this.formFields.put(formField.getFieldName(), formField);
                return this;
            }

            public Builder withAdditionalFormFields(List<FormField> additionalFields) {
                for (FormField formField : additionalFields) {
                    this.withAdditionalFormField(formField);
                }
                return this;
            }

            public Builder afterUid(String afterUid) {
                this.afterUid = StringUtils.requireNullOrNotEmpty(afterUid, "afterUid must not be empty");
                return this;
            }

            public Builder beforeUid(String beforeUid) {
                this.beforeUid = beforeUid;
                return this;
            }

            public Builder queryLastPage() {
                return this.beforeUid("");
            }

            public MamQueryArgs build() {
                return new MamQueryArgs(this);
            }
        }
    }

    public final class MamQuery {
        private final String node;
        private final DataForm form;
        private MamQueryPage mamQueryPage;

        private MamQuery(MamQueryPage mamQueryPage, String node, DataForm form) {
            this.node = node;
            this.form = form;
            this.mamQueryPage = mamQueryPage;
        }

        public boolean isComplete() {
            return this.mamQueryPage.getMamFinIq().isComplete();
        }

        public List<Message> getMessages() {
            return this.mamQueryPage.messages;
        }

        public List<MamElements.MamResultExtension> getMamResultExtensions() {
            return this.mamQueryPage.mamResultExtensions;
        }

        private List<Message> page(RSMSet requestRsmSet) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NotLoggedInException, InterruptedException {
            String queryId = StringUtils.secureUniqueRandomString();
            MamQueryIQ mamQueryIQ = MamManager.this.getElementFactory().newQueryIQ(queryId, this.node, this.form);
            mamQueryIQ.setType(IQ.Type.set);
            mamQueryIQ.setTo(MamManager.this.archiveAddress);
            mamQueryIQ.addExtension(requestRsmSet);
            this.mamQueryPage = MamManager.this.queryArchivePage(mamQueryIQ);
            return this.mamQueryPage.messages;
        }

        private RSMSet getPreviousRsmSet() {
            return this.mamQueryPage.getMamFinIq().getRSMSet();
        }

        public List<Message> pageNext(int count) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NotLoggedInException, InterruptedException {
            RSMSet previousResultRsmSet = this.getPreviousRsmSet();
            RSMSet requestRsmSet = new RSMSet(count, previousResultRsmSet.getLast(), RSMSet.PageDirection.after);
            return this.page(requestRsmSet);
        }

        public List<Message> pagePrevious(int count) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NotLoggedInException, InterruptedException {
            RSMSet previousResultRsmSet = this.getPreviousRsmSet();
            RSMSet requestRsmSet = new RSMSet(count, previousResultRsmSet.getFirst(), RSMSet.PageDirection.before);
            return this.page(requestRsmSet);
        }

        public int getMessageCount() {
            return this.getMessages().size();
        }

        public MamQueryPage getPage() {
            return this.mamQueryPage;
        }
    }

    public static final class MamQueryPage {
        private final MamFinIQ mamFin;
        private final List<Message> mamResultCarrierMessages;
        private final List<MamElements.MamResultExtension> mamResultExtensions;
        private final List<Forwarded<Message>> forwardedMessages;
        private final List<Message> messages;

        private MamQueryPage(StanzaCollector stanzaCollector, MamFinIQ mamFin) {
            this.mamFin = mamFin;
            List<Stanza> mamResultCarrierStanzas = stanzaCollector.getCollectedStanzasAfterCancelled();
            ArrayList<Message> mamResultCarrierMessages = new ArrayList<Message>(mamResultCarrierStanzas.size());
            ArrayList<MamElements.MamResultExtension> mamResultExtensions = new ArrayList<MamElements.MamResultExtension>(mamResultCarrierStanzas.size());
            ArrayList<Forwarded<Message>> forwardedMessages = new ArrayList<Forwarded<Message>>(mamResultCarrierStanzas.size());
            for (Stanza mamResultStanza : mamResultCarrierStanzas) {
                Message resultMessage = (Message)mamResultStanza;
                mamResultCarrierMessages.add(resultMessage);
                MamElements.MamResultExtension mamResultExtension = MamElements.MamResultExtension.from(resultMessage);
                mamResultExtensions.add(mamResultExtension);
                forwardedMessages.add(mamResultExtension.getForwarded());
            }
            this.mamResultCarrierMessages = Collections.unmodifiableList(mamResultCarrierMessages);
            this.mamResultExtensions = Collections.unmodifiableList(mamResultExtensions);
            this.forwardedMessages = Collections.unmodifiableList(forwardedMessages);
            this.messages = Collections.unmodifiableList(Forwarded.extractMessagesFrom(forwardedMessages));
        }

        public List<Message> getMessages() {
            return this.messages;
        }

        public List<Forwarded<Message>> getForwarded() {
            return this.forwardedMessages;
        }

        public List<MamElements.MamResultExtension> getMamResultExtensions() {
            return this.mamResultExtensions;
        }

        public List<Message> getMamResultCarrierMessages() {
            return this.mamResultCarrierMessages;
        }

        public MamFinIQ getMamFinIq() {
            return this.mamFin;
        }
    }

    public static final class MamPrefsResult {
        public final MamPrefsIQ mamPrefs;
        public final DataForm form;

        private MamPrefsResult(MamPrefsIQ mamPrefs, DataForm form) {
            this.mamPrefs = mamPrefs;
            this.form = form;
        }

        public MamPrefs asMamPrefs() {
            return new MamPrefs(this);
        }
    }

    public static final class MamPrefs {
        private final List<Jid> alwaysJids;
        private final List<Jid> neverJids;
        private final MamVersion mamVersion;
        private MamPrefsIQ.DefaultBehavior defaultBehavior;

        private MamPrefs(MamPrefsResult mamPrefsResult) {
            MamPrefsIQ mamPrefsIq = mamPrefsResult.mamPrefs;
            this.alwaysJids = new ArrayList<Jid>(mamPrefsIq.getAlwaysJids());
            this.neverJids = new ArrayList<Jid>(mamPrefsIq.getNeverJids());
            this.defaultBehavior = mamPrefsIq.getDefault();
            this.mamVersion = MamVersion.fromNamespace(mamPrefsIq.getNamespace());
        }

        public void setDefaultBehavior(MamPrefsIQ.DefaultBehavior defaultBehavior) {
            this.defaultBehavior = Objects.requireNonNull(defaultBehavior, "defaultBehavior must not be null");
        }

        public MamPrefsIQ.DefaultBehavior getDefaultBehavior() {
            return this.defaultBehavior;
        }

        public List<Jid> getAlwaysJids() {
            return this.alwaysJids;
        }

        public List<Jid> getNeverJids() {
            return this.neverJids;
        }

        private MamPrefsIQ constructMamPrefsIq() {
            return this.mamVersion.newElementFactory().newPrefsIQ(this.alwaysJids, this.neverJids, this.defaultBehavior);
        }
    }
}

