/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iot;

import java.util.logging.Logger;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.iot.provisioning.IoTProvisioningManager;
import org.jxmpp.jid.Jid;

public abstract class IoTManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(IoTManager.class.getName());
    private final IoTProvisioningManager ioTProvisioningManager;
    private boolean allowNonFriends;
    private static boolean autoEnable;

    public static void setAutoEnableIoTManagers(boolean autoEnable) {
        IoTManager.autoEnable = autoEnable;
    }

    public static boolean isAutoEnableActive() {
        return autoEnable;
    }

    protected IoTManager(XMPPConnection connection) {
        super(connection);
        this.ioTProvisioningManager = IoTProvisioningManager.getInstanceFor(connection);
    }

    public void setAllowNonFriends(boolean allowNonFriends) {
        this.allowNonFriends = allowNonFriends;
    }

    protected boolean isAllowed(Jid jid) {
        if (this.allowNonFriends) {
            return true;
        }
        return this.ioTProvisioningManager.isMyFriend(jid);
    }

    protected abstract class IoTIqRequestHandler
    extends AbstractIqRequestHandler {
        protected IoTIqRequestHandler(String element, String namespace, IQ.Type type, IQRequestHandler.Mode mode) {
            super(element, namespace, type, mode);
        }

        @Override
        public final IQ handleIQRequest(IQ iqRequest) {
            if (!IoTManager.this.isAllowed(iqRequest.getFrom())) {
                LOGGER.warning("Ignoring IQ request " + String.valueOf(iqRequest));
                return null;
            }
            return this.handleIoTIqRequest(iqRequest);
        }

        protected abstract IQ handleIoTIqRequest(IQ var1);
    }
}

