/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.describer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.internal.component.model.AttributeDescriberSelector;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.describer.AmbiguousVariantsFailureDescriber;
import org.gradle.internal.component.resolution.failure.type.AmbiguousVariantsFailure;
import org.gradle.internal.logging.text.TreeFormatter;

public abstract class MissingAttributeAmbiguousVariantsFailureDescriber
extends AmbiguousVariantsFailureDescriber {
    private final IdentityHashMap<AmbiguousVariantsFailure, String> suggestableDistinctAttributes = new IdentityHashMap();

    @Override
    public boolean canDescribeFailure(AmbiguousVariantsFailure failure) {
        HashMap unrequestedAttributesWithValues = new HashMap();
        failure.getCandidates().forEach(candidate -> candidate.getOnlyOnCandidateAttributes().forEach(candidateAttribute -> {
            Attribute attribute = candidateAttribute.getAttribute();
            Set unrequestedValuesForAttribute = unrequestedAttributesWithValues.computeIfAbsent(attribute.getName(), name -> new HashSet());
            unrequestedValuesForAttribute.add(Objects.requireNonNull(candidateAttribute.getProvided()).toString());
        }));
        List attributesDistinctlyIdentifyingCandidates = unrequestedAttributesWithValues.entrySet().stream().filter(entry -> ((Set)entry.getValue()).size() == failure.getCandidates().size()).collect(Collectors.toList());
        if (attributesDistinctlyIdentifyingCandidates.size() == 1) {
            this.suggestableDistinctAttributes.put(failure, (String)((Map.Entry)attributesDistinctlyIdentifyingCandidates.get(0)).getKey());
            return true;
        }
        return false;
    }

    @Override
    protected String buildFailureMsg(AmbiguousVariantsFailure failure, AttributesSchemaInternal schema) {
        String distinguishingAttribute = this.suggestableDistinctAttributes.remove(failure);
        assert (distinguishingAttribute != null);
        AttributeDescriber describer = AttributeDescriberSelector.selectDescriber((AttributeContainerInternal)failure.getRequestedAttributes(), schema);
        TreeFormatter formatter = new TreeFormatter();
        this.summarizeAmbiguousVariants(failure, describer, formatter, false);
        this.buildSpecificAttributeSuggestionMsg(failure, distinguishingAttribute, formatter);
        return formatter.toString();
    }

    @Override
    protected List<String> buildResolutions(String ... resolutions) {
        ArrayList<String> result = new ArrayList<String>(super.buildResolutions(resolutions));
        result.add(this.suggestDependencyInsight());
        return result;
    }

    private void buildSpecificAttributeSuggestionMsg(AmbiguousVariantsFailure failure, String distinguishingAttribute, TreeFormatter formatter) {
        formatter.node("The only attribute distinguishing these variants is '" + distinguishingAttribute + "'. Add this attribute to the consumer's configuration to resolve the ambiguity:");
        formatter.startChildren();
        failure.getCandidates().forEach(candidate -> formatter.node("Value: '" + this.attributeValueForCandidate((ResolutionCandidateAssessor.AssessedCandidate)candidate, distinguishingAttribute) + "' selects variant: '" + candidate.getDisplayName() + "'"));
        formatter.endChildren();
    }

    private String attributeValueForCandidate(ResolutionCandidateAssessor.AssessedCandidate candidate, String distinguishingAttribute) {
        return candidate.getOnlyOnCandidateAttributes().stream().filter(attribute -> Objects.equals(attribute.getAttribute().getName(), distinguishingAttribute)).map(assessedAttribute -> Objects.requireNonNull(assessedAttribute.getProvided()).toString()).findFirst().orElseThrow(IllegalStateException::new);
    }

    private String suggestDependencyInsight() {
        return "Use the dependencyInsight report with the --all-variants option to view all variants of the ambiguous dependency.  This report is described at " + this.getDocumentationRegistry().getDocumentationFor("viewing_debugging_dependencies", "sec:identifying_reason_dependency_selection") + ".";
    }
}

