/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.codeStyle;

import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.Strings;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.MinusculeMatcher;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.NameUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.FList;
import org.jetbrains.kotlin.com.intellij.util.text.NameUtilCore;

class TypoTolerantMatcher
extends MinusculeMatcher {
    private final char[] myPattern;
    private final String myHardSeparators;
    private final NameUtil.MatchingCaseSensitivity myOptions;
    private final boolean myHasHumps;
    private final boolean myHasSeparators;
    private final boolean myHasDots;
    private final boolean[] isLowerCase;
    private final boolean[] isUpperCase;
    private final boolean[] isWordSeparator;
    private final char[] toUpperCase;
    private final char[] toLowerCase;
    private final char[] myMeaningfulCharacters;
    private final int myMinNameLength;
    private static final char[][] keyboard = new char[][]{{'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p'}, {'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l'}, {'z', 'x', 'c', 'v', 'b', 'n', 'm'}};

    TypoTolerantMatcher(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity options, @NotNull String hardSeparators) {
        if (pattern == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(0);
        }
        if (options == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(1);
        }
        if (hardSeparators == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(2);
        }
        this.myOptions = options;
        this.myPattern = Strings.trimEnd(pattern, "* ").toCharArray();
        this.myHardSeparators = hardSeparators;
        this.isLowerCase = new boolean[this.myPattern.length];
        this.isUpperCase = new boolean[this.myPattern.length];
        this.isWordSeparator = new boolean[this.myPattern.length];
        this.toUpperCase = new char[this.myPattern.length];
        this.toLowerCase = new char[this.myPattern.length];
        StringBuilder meaningful = new StringBuilder();
        for (int k = 0; k < this.myPattern.length; ++k) {
            char c = this.myPattern[k];
            this.isLowerCase[k] = Character.isLowerCase(c);
            this.isUpperCase[k] = Character.isUpperCase(c);
            this.isWordSeparator[k] = TypoTolerantMatcher.isWordSeparator(c);
            this.toUpperCase[k] = Strings.toUpperCase(c);
            this.toLowerCase[k] = Strings.toLowerCase(c);
            if (this.isWildcard(k)) continue;
            meaningful.append(this.toLowerCase[k]);
            meaningful.append(this.toUpperCase[k]);
        }
        int i = 0;
        while (this.isWildcard(i)) {
            ++i;
        }
        this.myHasHumps = this.hasFlag(i + 1, this.isUpperCase) && this.hasFlag(i, this.isLowerCase);
        this.myHasSeparators = this.hasFlag(i, this.isWordSeparator);
        this.myHasDots = this.hasDots(i);
        this.myMeaningfulCharacters = meaningful.toString().toCharArray();
        this.myMinNameLength = this.myMeaningfulCharacters.length / 2;
    }

    private static boolean isWordSeparator(char c) {
        return Character.isWhitespace(c) || c == '_' || c == '-' || c == ':' || c == '+' || c == '.';
    }

    private static int nextWord(@NotNull String name2, int start) {
        if (name2 == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(3);
        }
        if (start < name2.length() && Character.isDigit(name2.charAt(start))) {
            return start + 1;
        }
        return NameUtilCore.nextWord(name2, start);
    }

    private boolean hasFlag(int start, boolean[] flags) {
        for (int i = start; i < this.myPattern.length; ++i) {
            if (!flags[i]) continue;
            return true;
        }
        return false;
    }

    private boolean hasDots(int start) {
        for (int i = start; i < this.myPattern.length; ++i) {
            if (this.myPattern[i] != '.') continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static FList<TextRange> prependRange(@NotNull FList<TextRange> ranges2, @NotNull Range range) {
        Range head;
        if (ranges2 == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(4);
        }
        if (range == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(5);
        }
        if ((head = (Range)ranges2.getHead()) != null && head.getStartOffset() == range.getEndOffset()) {
            FList<TextRange> fList = ranges2.getTail().prepend(new Range(range.getStartOffset(), head.getEndOffset(), range.getErrorCount() + head.getErrorCount()));
            if (fList == null) {
                TypoTolerantMatcher.$$$reportNull$$$0(6);
            }
            return fList;
        }
        FList<TextRange> fList = ranges2.prepend(range);
        if (fList == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(7);
        }
        return fList;
    }

    @Override
    public int matchingDegree(@NotNull String name2) {
        if (name2 == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(8);
        }
        return this.matchingDegree(name2, false);
    }

    @Override
    public int matchingDegree(@NotNull String name2, boolean valueStartCaseMatch) {
        if (name2 == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(9);
        }
        return this.matchingDegree(name2, valueStartCaseMatch, this.matchingFragments(name2));
    }

    @Override
    public int matchingDegree(@NotNull String name2, boolean valueStartCaseMatch, @Nullable FList<? extends TextRange> fragments2) {
        if (name2 == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(10);
        }
        if (fragments2 == null) {
            return Integer.MIN_VALUE;
        }
        if (fragments2.isEmpty()) {
            return 0;
        }
        TextRange first = fragments2.getHead();
        boolean startMatch = first.getStartOffset() == 0;
        boolean valuedStartMatch = startMatch && valueStartCaseMatch;
        int errors2 = 0;
        int matchingCase = 0;
        int p = -1;
        int skippedHumps = 0;
        int nextHumpStart = 0;
        boolean humpStartMatchedUpperCase = false;
        for (TextRange textRange : fragments2) {
            for (int i = textRange.getStartOffset(); i < textRange.getEndOffset(); ++i) {
                boolean afterGap = i == textRange.getStartOffset() && first != textRange;
                boolean isHumpStart = false;
                while (nextHumpStart <= i) {
                    if (nextHumpStart == i) {
                        isHumpStart = true;
                    } else if (afterGap) {
                        ++skippedHumps;
                    }
                    nextHumpStart = TypoTolerantMatcher.nextWord(name2, nextHumpStart);
                }
                char c = name2.charAt(i);
                p = Strings.indexOf(this.myPattern, c, p + 1, this.myPattern.length, false);
                if (p < 0) break;
                if (isHumpStart) {
                    humpStartMatchedUpperCase = c == this.myPattern[p] && this.isUpperCase[p];
                }
                matchingCase += this.evaluateCaseMatching(valuedStartMatch, p, humpStartMatchedUpperCase, i, afterGap, isHumpStart, c);
            }
            errors2 = (int)((double)errors2 + 2000.0 * Math.pow(1.0 * (double)((Range)textRange).getErrorCount() / (double)textRange.getLength(), 2.0));
        }
        int startIndex = first.getStartOffset();
        boolean bl = Strings.indexOfAny(name2, this.myHardSeparators, 0, startIndex) >= 0;
        boolean wordStart = startIndex == 0 || NameUtilCore.isWordStart(name2, startIndex) && !NameUtilCore.isWordStart(name2, startIndex - 1);
        boolean finalMatch = fragments2.get(fragments2.size() - 1).getEndOffset() == name2.length();
        return (wordStart ? 1000 : 0) + matchingCase - fragments2.size() + -skippedHumps * 10 - errors2 + (bl ? 0 : 2) + (startMatch ? 1 : 0) + (finalMatch ? 1 : 0);
    }

    private int evaluateCaseMatching(boolean valuedStartMatch, int patternIndex, boolean humpStartMatchedUpperCase, int nameIndex, boolean afterGap, boolean isHumpStart, char nameChar) {
        if (afterGap && isHumpStart && this.isLowerCase[patternIndex]) {
            return -10;
        }
        if (nameChar == this.myPattern[patternIndex]) {
            if (this.isUpperCase[patternIndex]) {
                return 50;
            }
            if (nameIndex == 0 && valuedStartMatch) {
                return 150;
            }
            if (isHumpStart) {
                return 1;
            }
        } else {
            if (isHumpStart) {
                return -1;
            }
            if (this.isLowerCase[patternIndex] && humpStartMatchedUpperCase) {
                return -1;
            }
        }
        return 0;
    }

    @Override
    public boolean isStartMatch(@NotNull String name2) {
        FList<TextRange> fragments2;
        if (name2 == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(11);
        }
        return (fragments2 = this.matchingFragments(name2)) != null && TypoTolerantMatcher.isStartMatch(fragments2);
    }

    public static boolean isStartMatch(@NotNull Iterable<? extends TextRange> fragments2) {
        Iterator<? extends TextRange> iterator2;
        if (fragments2 == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(12);
        }
        return !(iterator2 = fragments2.iterator()).hasNext() || iterator2.next().getStartOffset() == 0;
    }

    @Override
    public boolean matches(@NotNull String name2) {
        if (name2 == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(13);
        }
        return this.matchingFragments(name2) != null;
    }

    @Override
    @NotNull
    public String getPattern() {
        return new String(this.myPattern);
    }

    @Override
    @Nullable
    public FList<TextRange> matchingFragments(@NotNull String name2) {
        FList<TextRange> ranges2;
        if (name2 == null) {
            TypoTolerantMatcher.$$$reportNull$$$0(14);
        }
        if ((ranges2 = new Session(name2, false).matchingFragments()) != null) {
            return ranges2;
        }
        return new Session(name2, true).matchingFragments();
    }

    private boolean isWildcard(int patternIndex) {
        if (patternIndex >= 0 && patternIndex < this.myPattern.length) {
            char pc = this.myPattern[patternIndex];
            return pc == ' ' || pc == '*';
        }
        return false;
    }

    private static char toUpperAscii(char c) {
        if (c >= 'a' && c <= 'z') {
            return (char)(c + -32);
        }
        return c;
    }

    private static char toLowerAscii(char c) {
        if (c >= 'A' && c <= 'Z') {
            return (char)(c - -32);
        }
        return c;
    }

    private static boolean isUpperAscii(char c) {
        return 'A' <= c && c <= 'Z';
    }

    private static boolean isLowerAscii(char c) {
        return 'a' <= c && c <= 'z';
    }

    @NonNls
    public String toString() {
        return "TypoTolerantMatcher{myPattern=" + new String(this.myPattern) + ", myOptions=" + (Object)((Object)this.myOptions) + '}';
    }

    private static char leftMiss(char aChar) {
        boolean isUpperCase = TypoTolerantMatcher.isUpperAscii(aChar);
        char lc = isUpperCase ? TypoTolerantMatcher.toLowerAscii(aChar) : aChar;
        for (char[] line : keyboard) {
            for (int j = 0; j < line.length; ++j) {
                char c = line[j];
                if (c != lc) continue;
                if (j > 0) {
                    return isUpperCase ? TypoTolerantMatcher.toUpperAscii(line[j - 1]) : line[j - 1];
                }
                return '\u0000';
            }
        }
        return '\u0000';
    }

    private static char rightMiss(char aChar) {
        boolean isUpperCase = TypoTolerantMatcher.isUpperAscii(aChar);
        char lc = isUpperCase ? TypoTolerantMatcher.toLowerAscii(aChar) : aChar;
        for (char[] line : keyboard) {
            for (int j = 0; j < line.length; ++j) {
                char c = line[j];
                if (c != lc) continue;
                if (j + 1 < line.length) {
                    return isUpperCase ? TypoTolerantMatcher.toUpperAscii(line[j + 1]) : line[j + 1];
                }
                return '\u0000';
            }
        }
        return '\u0000';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hardSeparators";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/codeStyle/TypoTolerantMatcher";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/codeStyle/TypoTolerantMatcher";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "prependRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "nextWord";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prependRange";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "matchingDegree";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isStartMatch";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "matchingFragments";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Range
    extends TextRange {
        private final int myErrorCount;

        Range(int startOffset, int endOffset, int errorCount) {
            super(startOffset, endOffset);
            this.myErrorCount = errorCount;
        }

        public int getErrorCount() {
            return this.myErrorCount;
        }

        @Override
        @NotNull
        public Range shiftRight(int delta) {
            if (delta == 0) {
                Range range = this;
                if (range == null) {
                    Range.$$$reportNull$$$0(0);
                }
                return range;
            }
            return new Range(this.getStartOffset() + delta, this.getEndOffset() + delta, this.getErrorCount());
        }

        public static Range from(int from2, int length) {
            return new Range(from2, from2 + length, 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/TypoTolerantMatcher$Range", "shiftRight"));
        }
    }

    private static class Fragment {
        private final int myLength;
        private final ErrorState myErrorState;

        Fragment(int length, @NotNull ErrorState errorState) {
            if (errorState == null) {
                Fragment.$$$reportNull$$$0(0);
            }
            this.myLength = length;
            this.myErrorState = errorState;
        }

        int getLength() {
            return this.myLength;
        }

        @NotNull
        ErrorState getErrorState() {
            ErrorState errorState = this.myErrorState;
            if (errorState == null) {
                Fragment.$$$reportNull$$$0(1);
            }
            return errorState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorState";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/codeStyle/TypoTolerantMatcher$Fragment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/codeStyle/TypoTolerantMatcher$Fragment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MissError
    implements Error {
        private final char myMissedChar;

        MissError(char missedChar) {
            this.myMissedChar = missedChar;
        }
    }

    private static class SwapError
    implements Error {
        public static final SwapError instance = new SwapError();

        private SwapError() {
        }
    }

    private static class TypoError
    implements Error {
        private final char myCorrectChar;

        TypoError(char correctChar) {
            this.myCorrectChar = correctChar;
        }
    }

    private static interface Error {
    }

    private static class ErrorState {
        @Nullable
        private final ErrorState myBase;
        private final int myDeriveIndex;
        private List<Pair<Integer, Error>> myErrors;
        private char[] myPattern;

        ErrorState(@Nullable ErrorState base, int deriveIndex) {
            this.myBase = base;
            this.myDeriveIndex = deriveIndex;
        }

        ErrorState() {
            this(null, 0);
        }

        @NotNull
        ErrorState deriveFrom(int index2) {
            return new ErrorState(this, index2);
        }

        void addError(int index2, @NotNull Error error) {
            if (error == null) {
                ErrorState.$$$reportNull$$$0(0);
            }
            if (this.myErrors == null) {
                this.myErrors = new SmartList<Pair<Integer, Error>>();
            }
            Pair<Integer, Error> pair = Pair.create(index2, error);
            this.myErrors.add(pair);
            if (this.myPattern != null) {
                this.myPattern = ErrorState.applyError(this.myPattern, pair);
            }
        }

        int countErrors(int start, int end) {
            int errors2 = 0;
            if (this.myBase != null && start < this.myDeriveIndex) {
                errors2 += this.myBase.countErrors(start, this.myDeriveIndex);
            }
            if (this.myErrors != null) {
                for (Pair<Integer, Error> error : this.myErrors) {
                    if (start > (Integer)error.first || (Integer)error.first >= end) continue;
                    ++errors2;
                }
            }
            return errors2;
        }

        private boolean processErrors(int start, int end, Processor<? super Pair<Integer, Error>> processor2) {
            if (this.myBase != null && start < this.myDeriveIndex && !this.myBase.processErrors(start, this.myDeriveIndex, processor2)) {
                return false;
            }
            if (this.myErrors != null) {
                for (Pair<Integer, Error> error : this.myErrors) {
                    if (start > (Integer)error.first || (Integer)error.first >= end || processor2.process(error)) continue;
                    return false;
                }
            }
            return true;
        }

        public char getChar(char[] pattern, int index2) {
            if (this.myPattern == null) {
                this.myPattern = this.applyErrors((char[])pattern.clone(), Integer.MAX_VALUE);
            }
            return this.myPattern[index2];
        }

        private char[] applyErrors(char[] pattern, int upToIndex) {
            if (this.myBase != null) {
                pattern = this.myBase.applyErrors(pattern, Math.min(this.myDeriveIndex, upToIndex));
            }
            if (this.myErrors != null) {
                for (Pair<Integer, Error> error : this.myErrors) {
                    if ((Integer)error.first >= upToIndex) continue;
                    pattern = ErrorState.applyError(pattern, error);
                }
            }
            return pattern;
        }

        private static char[] applyError(char[] pattern, Pair<Integer, Error> error) {
            if (error.second instanceof TypoError) {
                pattern[((Integer)error.first).intValue()] = ((TypoError)error.second).myCorrectChar;
                return pattern;
            }
            if (error.second instanceof SwapError) {
                char c = pattern[(Integer)error.first];
                pattern[((Integer)error.first).intValue()] = pattern[(Integer)error.first + 1];
                pattern[((Integer)error.first).intValue() + 1] = c;
                return pattern;
            }
            if (error.second instanceof MissError) {
                return ArrayUtil.insert(pattern, (int)((Integer)error.first), ((MissError)error.second).myMissedChar);
            }
            return pattern;
        }

        public boolean affects(int index2) {
            return !this.processErrors(0, index2 + 1, error -> {
                if ((Integer)error.first == index2) {
                    return false;
                }
                if ((Integer)error.first == index2 - 1 && error.second == SwapError.instance) {
                    return false;
                }
                return (Integer)error.first >= index2 || !(error.second instanceof MissError);
            });
        }

        public Error getError(int i) {
            if (this.myErrors != null) {
                for (Pair<Integer, Error> error : this.myErrors) {
                    if ((Integer)error.first != i) continue;
                    return (Error)error.second;
                }
            }
            if (this.myBase != null && this.myDeriveIndex > i) {
                return this.myBase.getError(i);
            }
            return null;
        }

        public int length(char[] pattern) {
            Ref<Integer> ref = new Ref<Integer>(pattern.length);
            this.processErrors(0, Integer.MAX_VALUE, error -> {
                if (error.second instanceof MissError) {
                    ref.set((Integer)ref.get() + 1);
                }
                return true;
            });
            return ref.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/TypoTolerantMatcher$ErrorState", "addError"));
        }
    }

    private class Session {
        @NotNull
        private final String myName;
        private final boolean isAsciiName;
        private final boolean myTypoAware;
        private final boolean myAllowTypos;

        Session(String name2, boolean typoAware) {
            if (name2 == null) {
                Session.$$$reportNull$$$0(0);
            }
            this.myName = name2;
            int length = name2.length();
            boolean isAscii = true;
            for (int i = 0; i < length; ++i) {
                char c = name2.charAt(i);
                if (c < '\u0080') continue;
                isAscii = false;
                break;
            }
            this.isAsciiName = isAscii;
            this.myTypoAware = typoAware;
            this.myAllowTypos = typoAware && isAscii;
        }

        private char charAt(int i, @NotNull ErrorState errorState) {
            if (errorState == null) {
                Session.$$$reportNull$$$0(1);
            }
            return errorState.affects(i) ? errorState.getChar(TypoTolerantMatcher.this.myPattern, i) : TypoTolerantMatcher.this.myPattern[i];
        }

        private char toLowerCase(int i, @NotNull ErrorState errorState) {
            if (errorState == null) {
                Session.$$$reportNull$$$0(2);
            }
            return errorState.affects(i) ? TypoTolerantMatcher.toLowerAscii(errorState.getChar(TypoTolerantMatcher.this.myPattern, i)) : TypoTolerantMatcher.this.toLowerCase[i];
        }

        private char toUpperCase(int i, @NotNull ErrorState errorState) {
            if (errorState == null) {
                Session.$$$reportNull$$$0(3);
            }
            return errorState.affects(i) ? TypoTolerantMatcher.toUpperAscii(errorState.getChar(TypoTolerantMatcher.this.myPattern, i)) : TypoTolerantMatcher.this.toUpperCase[i];
        }

        private boolean isLowerCase(int i, @NotNull ErrorState errorState) {
            if (errorState == null) {
                Session.$$$reportNull$$$0(4);
            }
            return errorState.affects(i) ? TypoTolerantMatcher.isLowerAscii(errorState.getChar(TypoTolerantMatcher.this.myPattern, i)) : TypoTolerantMatcher.this.isLowerCase[i];
        }

        private boolean isUpperCase(int i, @NotNull ErrorState errorState) {
            if (errorState == null) {
                Session.$$$reportNull$$$0(5);
            }
            return errorState.affects(i) ? TypoTolerantMatcher.isUpperAscii(errorState.getChar(TypoTolerantMatcher.this.myPattern, i)) : TypoTolerantMatcher.this.isUpperCase[i];
        }

        private boolean isWordSeparator(int i, @NotNull ErrorState errorState) {
            if (errorState == null) {
                Session.$$$reportNull$$$0(6);
            }
            return errorState.affects(i) ? TypoTolerantMatcher.isWordSeparator(errorState.getChar(TypoTolerantMatcher.this.myPattern, i)) : TypoTolerantMatcher.this.isWordSeparator[i];
        }

        private int patternLength(@NotNull ErrorState errorState) {
            if (errorState == null) {
                Session.$$$reportNull$$$0(7);
            }
            return errorState.length(TypoTolerantMatcher.this.myPattern);
        }

        @Nullable
        public FList<TextRange> matchingFragments() {
            if (this.myName.length() < TypoTolerantMatcher.this.myMinNameLength) {
                return null;
            }
            if (this.myTypoAware && !this.isAsciiName) {
                return null;
            }
            if (!this.myTypoAware) {
                int length = this.myName.length();
                int patternIndex = 0;
                for (int i = 0; i < length; ++i) {
                    char c = this.myName.charAt(i);
                    if (patternIndex >= TypoTolerantMatcher.this.myMeaningfulCharacters.length || c != TypoTolerantMatcher.this.myMeaningfulCharacters[patternIndex] && c != TypoTolerantMatcher.this.myMeaningfulCharacters[patternIndex + 1]) continue;
                    patternIndex += 2;
                }
                if (patternIndex < TypoTolerantMatcher.this.myMinNameLength * 2) {
                    return null;
                }
            }
            return this.matchWildcards(0, 0, new ErrorState());
        }

        @Nullable
        private FList<TextRange> matchWildcards(int patternIndex, int nameIndex, @NotNull ErrorState errorState) {
            if (errorState == null) {
                Session.$$$reportNull$$$0(8);
            }
            if (nameIndex < 0) {
                return null;
            }
            if (!TypoTolerantMatcher.this.isWildcard(patternIndex)) {
                if (patternIndex == this.patternLength(errorState)) {
                    return FList.emptyList();
                }
                return this.matchFragment(patternIndex, nameIndex, errorState);
            }
            while (TypoTolerantMatcher.this.isWildcard(++patternIndex)) {
            }
            if (patternIndex == this.patternLength(errorState)) {
                if (this.isTrailingSpacePattern(errorState) && nameIndex != this.myName.length() && (patternIndex < 2 || !this.isUpperCaseOrDigit(this.charAt(patternIndex - 2, errorState)))) {
                    int spaceIndex = this.myName.indexOf(32, nameIndex);
                    if (spaceIndex >= 0) {
                        return FList.emptyList().prepend(new Range(spaceIndex, spaceIndex + 1, 0));
                    }
                    return null;
                }
                return FList.emptyList();
            }
            FList<TextRange> ranges2 = this.matchFragment(patternIndex, nameIndex, errorState);
            if (ranges2 != null) {
                return ranges2;
            }
            return this.matchSkippingWords(patternIndex, nameIndex, true, errorState);
        }

        private boolean isTrailingSpacePattern(@NotNull ErrorState errorState) {
            if (errorState == null) {
                Session.$$$reportNull$$$0(9);
            }
            return this.isPatternChar(this.patternLength(errorState) - 1, ' ', errorState);
        }

        private boolean isUpperCaseOrDigit(char p) {
            return Character.isUpperCase(p) || Character.isDigit(p);
        }

        @Nullable
        private FList<TextRange> matchSkippingWords(int patternIndex, int nameIndex, boolean allowSpecialChars, @NotNull ErrorState errorState) {
            FList<TextRange> ranges2;
            if (errorState == null) {
                Session.$$$reportNull$$$0(10);
            }
            boolean wordStartsOnly = !this.isPatternChar(patternIndex - 1, '*', errorState) && !this.isWordSeparator(patternIndex, errorState);
            int maxFoundLength = 0;
            while (true) {
                int fragmentLength;
                if ((nameIndex = this.findNextPatternCharOccurrence(nameIndex, patternIndex, allowSpecialChars, wordStartsOnly, errorState)) < 0) {
                    return null;
                }
                Fragment fragment = this.seemsLikeFragmentStart(patternIndex, nameIndex, errorState) ? this.maxMatchingFragment(patternIndex, nameIndex, errorState) : null;
                if (fragment == null || (fragmentLength = fragment.getLength()) <= maxFoundLength && (nameIndex + fragmentLength != this.myName.length() || !this.isTrailingSpacePattern(errorState))) continue;
                if (!this.isMiddleMatch(patternIndex, nameIndex, errorState)) {
                    maxFoundLength = fragmentLength;
                }
                if ((ranges2 = this.matchInsideFragment(patternIndex, nameIndex, fragment)) != null) break;
            }
            return ranges2;
        }

        private int findNextPatternCharOccurrence(int startAt, int patternIndex, boolean allowSpecialChars, boolean wordStartsOnly, @NotNull ErrorState errorState) {
            int next;
            if (errorState == null) {
                Session.$$$reportNull$$$0(11);
            }
            int n = next = wordStartsOnly ? this.indexOfWordStart(patternIndex, startAt, errorState) : this.indexOfIgnoreCase(startAt + 1, patternIndex, errorState);
            if (!allowSpecialChars && !TypoTolerantMatcher.this.myHasSeparators && !TypoTolerantMatcher.this.myHasHumps && Strings.containsAnyChar(this.myName, TypoTolerantMatcher.this.myHardSeparators, startAt, next)) {
                return -1;
            }
            if (!allowSpecialChars && TypoTolerantMatcher.this.myHasDots && !this.isPatternChar(patternIndex - 1, '.', errorState) && Strings.contains(this.myName, startAt, next, '.')) {
                return -1;
            }
            return next;
        }

        private boolean seemsLikeFragmentStart(int patternIndex, int nextOccurrence, @NotNull ErrorState errorState) {
            if (errorState == null) {
                Session.$$$reportNull$$$0(12);
            }
            return !this.isUpperCase(patternIndex, errorState) || Character.isUpperCase(this.myName.charAt(nextOccurrence)) || NameUtilCore.isWordStart(this.myName, nextOccurrence) || !TypoTolerantMatcher.this.myHasHumps && TypoTolerantMatcher.this.myOptions != NameUtil.MatchingCaseSensitivity.ALL;
        }

        private boolean charEquals(int patternIndex, int nameIndex, boolean isIgnoreCase, boolean allowTypos, @NotNull ErrorState errorState) {
            char nextNameChar;
            char nameChar;
            char patternChar;
            if (errorState == null) {
                Session.$$$reportNull$$$0(13);
            }
            if ((patternChar = this.charAt(patternIndex, errorState)) == (nameChar = this.myName.charAt(nameIndex)) || isIgnoreCase && (this.toLowerCase(patternIndex, errorState) == nameChar || this.toUpperCase(patternIndex, errorState) == nameChar)) {
                return true;
            }
            if (!this.myAllowTypos || !allowTypos) {
                return false;
            }
            if (errorState.countErrors(0, patternIndex) > 0) {
                return false;
            }
            Error prevError = errorState.getError(patternIndex - 1);
            if (prevError == SwapError.instance) {
                return false;
            }
            char leftMiss = TypoTolerantMatcher.leftMiss(patternChar);
            if (leftMiss != '\u0000' && (leftMiss == nameChar || isIgnoreCase && (TypoTolerantMatcher.toLowerAscii(leftMiss) == nameChar || TypoTolerantMatcher.toUpperAscii(leftMiss) == nameChar))) {
                errorState.addError(patternIndex, new TypoError(leftMiss));
                return true;
            }
            char rightMiss = TypoTolerantMatcher.rightMiss(patternChar);
            if (rightMiss != '\u0000' && (rightMiss == nameChar || isIgnoreCase && (TypoTolerantMatcher.toLowerAscii(rightMiss) == nameChar || TypoTolerantMatcher.toUpperAscii(rightMiss) == nameChar))) {
                errorState.addError(patternIndex, new TypoError(rightMiss));
                return true;
            }
            if (this.patternLength(errorState) > patternIndex + 1 && this.myName.length() > nameIndex + 1) {
                nextNameChar = this.myName.charAt(nameIndex + 1);
                char nextPatternChar = this.charAt(patternIndex + 1, errorState);
                if ((patternChar == nextNameChar || isIgnoreCase && (this.toLowerCase(patternIndex, errorState) == nextNameChar || this.toUpperCase(patternIndex, errorState) == nextNameChar)) && (nextPatternChar == nameChar || isIgnoreCase && (this.toLowerCase(patternIndex + 1, errorState) == nameChar || this.toUpperCase(patternIndex + 1, errorState) == nameChar))) {
                    errorState.addError(patternIndex, SwapError.instance);
                    return true;
                }
            }
            if (this.myName.length() > nameIndex + 1 && (patternChar == (nextNameChar = this.myName.charAt(nameIndex + 1)) || isIgnoreCase && (this.toLowerCase(patternIndex, errorState) == nextNameChar || this.toUpperCase(patternIndex, errorState) == nextNameChar))) {
                errorState.addError(patternIndex, new MissError(nameChar));
                return true;
            }
            return false;
        }

        @Nullable
        private FList<TextRange> matchFragment(int patternIndex, int nameIndex, @NotNull ErrorState errorState) {
            Fragment fragment;
            if (errorState == null) {
                Session.$$$reportNull$$$0(14);
            }
            return (fragment = this.maxMatchingFragment(patternIndex, nameIndex, errorState)) == null ? null : this.matchInsideFragment(patternIndex, nameIndex, fragment);
        }

        @Nullable
        private Fragment maxMatchingFragment(int patternIndex, int nameIndex, @NotNull ErrorState baseErrorState) {
            boolean ignoreCase;
            ErrorState errorState;
            if (baseErrorState == null) {
                Session.$$$reportNull$$$0(15);
            }
            if (!this.isFirstCharMatching(nameIndex, patternIndex, errorState = baseErrorState.deriveFrom(patternIndex))) {
                return null;
            }
            int i = 1;
            boolean bl = ignoreCase = TypoTolerantMatcher.this.myOptions != NameUtil.MatchingCaseSensitivity.ALL;
            while (nameIndex + i < this.myName.length() && patternIndex + i < this.patternLength(errorState)) {
                if (!this.charEquals(patternIndex + i, nameIndex + i, ignoreCase, true, errorState)) {
                    if (!Character.isDigit(this.charAt(patternIndex + i, errorState)) || !Character.isDigit(this.charAt(patternIndex + i - 1, errorState))) break;
                    return null;
                }
                ++i;
            }
            return new Fragment(i, errorState);
        }

        @Nullable
        private FList<TextRange> matchInsideFragment(int patternIndex, int nameIndex, @NotNull Fragment fragment) {
            if (fragment == null) {
                Session.$$$reportNull$$$0(16);
            }
            int minFragment = this.isMiddleMatch(patternIndex, nameIndex, fragment.getErrorState()) ? 3 : 1;
            FList<TextRange> camelHumpRanges = this.improveCamelHumps(patternIndex, nameIndex, fragment.getLength(), minFragment, fragment.getErrorState());
            if (camelHumpRanges != null) {
                return camelHumpRanges;
            }
            return this.findLongestMatchingPrefix(patternIndex, nameIndex, fragment.getLength(), minFragment, fragment.getErrorState());
        }

        private boolean isMiddleMatch(int patternIndex, int nameIndex, @NotNull ErrorState errorState) {
            if (errorState == null) {
                Session.$$$reportNull$$$0(17);
            }
            return this.isPatternChar(patternIndex - 1, '*', errorState) && !TypoTolerantMatcher.this.isWildcard(patternIndex + 1) && Character.isLetterOrDigit(this.myName.charAt(nameIndex)) && !NameUtilCore.isWordStart(this.myName, nameIndex);
        }

        @Nullable
        private FList<TextRange> findLongestMatchingPrefix(int patternIndex, int nameIndex, int fragmentLength, int minFragment, @NotNull ErrorState errorState) {
            if (errorState == null) {
                Session.$$$reportNull$$$0(18);
            }
            if (patternIndex + fragmentLength >= this.patternLength(errorState)) {
                int errors2 = errorState.countErrors(patternIndex, patternIndex + fragmentLength);
                if (errors2 == fragmentLength) {
                    return null;
                }
                return FList.emptyList().prepend(new Range(nameIndex, nameIndex + fragmentLength, errors2));
            }
            for (int i = fragmentLength; i >= minFragment || TypoTolerantMatcher.this.isWildcard(patternIndex + i); --i) {
                FList<TextRange> ranges2;
                ErrorState derivedErrorState = errorState.deriveFrom(patternIndex + i);
                FList<TextRange> fList = ranges2 = TypoTolerantMatcher.this.isWildcard(patternIndex + i) ? this.matchWildcards(patternIndex + i, nameIndex + i, derivedErrorState) : this.matchSkippingWords(patternIndex + i, nameIndex + i, false, derivedErrorState);
                if (ranges2 == null) continue;
                int errors3 = errorState.countErrors(patternIndex, patternIndex + i);
                if (errors3 == i) {
                    return null;
                }
                return TypoTolerantMatcher.prependRange(ranges2, new Range(nameIndex, nameIndex + i, errors3));
            }
            return null;
        }

        @Nullable
        private FList<TextRange> improveCamelHumps(int patternIndex, int nameIndex, int maxFragment, int minFragment, @NotNull ErrorState errorState) {
            if (errorState == null) {
                Session.$$$reportNull$$$0(19);
            }
            for (int i = minFragment; i < maxFragment; ++i) {
                FList<TextRange> ranges2;
                if (!this.isUppercasePatternVsLowercaseNameChar(patternIndex + i, nameIndex + i, errorState) || (ranges2 = this.findUppercaseMatchFurther(patternIndex + i, nameIndex + i, errorState.deriveFrom(patternIndex + i))) == null) continue;
                int errors2 = errorState.countErrors(patternIndex, patternIndex + i);
                if (errors2 == i) {
                    return null;
                }
                return TypoTolerantMatcher.prependRange(ranges2, new Range(nameIndex, nameIndex + i, errors2));
            }
            return null;
        }

        private boolean isUppercasePatternVsLowercaseNameChar(int patternIndex, int nameIndex, @NotNull ErrorState errorState) {
            if (errorState == null) {
                Session.$$$reportNull$$$0(20);
            }
            return this.isUpperCase(patternIndex, errorState) && !this.charEquals(patternIndex, nameIndex, false, false, errorState);
        }

        @Nullable
        private FList<TextRange> findUppercaseMatchFurther(int patternIndex, int nameIndex, @NotNull ErrorState errorState) {
            if (errorState == null) {
                Session.$$$reportNull$$$0(21);
            }
            int nextWordStart = this.indexOfWordStart(patternIndex, nameIndex, errorState);
            return this.matchWildcards(patternIndex, nextWordStart, errorState.deriveFrom(patternIndex));
        }

        private boolean isFirstCharMatching(int nameIndex, int patternIndex, @NotNull ErrorState errorState) {
            boolean ignoreCase;
            if (errorState == null) {
                Session.$$$reportNull$$$0(22);
            }
            if (nameIndex >= this.myName.length()) {
                return false;
            }
            boolean bl = ignoreCase = TypoTolerantMatcher.this.myOptions != NameUtil.MatchingCaseSensitivity.ALL;
            if (!this.charEquals(patternIndex, nameIndex, ignoreCase, true, errorState)) {
                return false;
            }
            char patternChar = this.charAt(patternIndex, errorState);
            return TypoTolerantMatcher.this.myOptions != NameUtil.MatchingCaseSensitivity.FIRST_LETTER || patternIndex != 0 && (patternIndex != 1 || !TypoTolerantMatcher.this.isWildcard(0)) || !this.hasCase(patternChar) || Character.isUpperCase(patternChar) == Character.isUpperCase(this.myName.charAt(0));
        }

        private boolean hasCase(char patternChar) {
            return Character.isUpperCase(patternChar) || Character.isLowerCase(patternChar);
        }

        private boolean isPatternChar(int patternIndex, char c, @NotNull ErrorState errorState) {
            if (errorState == null) {
                Session.$$$reportNull$$$0(23);
            }
            return patternIndex >= 0 && patternIndex < this.patternLength(errorState) && this.charAt(patternIndex, errorState) == c;
        }

        private int indexOfWordStart(int patternIndex, int startFrom, @NotNull ErrorState errorState) {
            if (errorState == null) {
                Session.$$$reportNull$$$0(24);
            }
            if (startFrom >= this.myName.length() || TypoTolerantMatcher.this.myHasHumps && this.isLowerCase(patternIndex, errorState) && (patternIndex <= 0 || !this.isWordSeparator(patternIndex - 1, errorState))) {
                return -1;
            }
            int nextWordStart = startFrom;
            do {
                if ((nextWordStart = TypoTolerantMatcher.nextWord(this.myName, nextWordStart)) < this.myName.length()) continue;
                return -1;
            } while (!this.charEquals(patternIndex, nextWordStart, true, true, errorState));
            return nextWordStart;
        }

        private int indexOfIgnoreCase(int fromIndex, int patternIndex, @NotNull ErrorState errorState) {
            if (errorState == null) {
                Session.$$$reportNull$$$0(25);
            }
            char p = this.charAt(patternIndex, errorState);
            if (this.isAsciiName && Strings.isAscii(p)) {
                int i = this.indexIgnoringCaseAscii(fromIndex, patternIndex, p);
                if (i != -1) {
                    return i;
                }
                if (this.myAllowTypos) {
                    int leftMiss = this.indexIgnoringCaseAscii(fromIndex, patternIndex, TypoTolerantMatcher.leftMiss(p));
                    if (leftMiss != -1) {
                        return leftMiss;
                    }
                    int rightMiss = this.indexIgnoringCaseAscii(fromIndex, patternIndex, TypoTolerantMatcher.rightMiss(p));
                    if (rightMiss != -1) {
                        return rightMiss;
                    }
                }
                return -1;
            }
            return Strings.indexOfIgnoreCase(this.myName, p, fromIndex);
        }

        private int indexIgnoringCaseAscii(int fromIndex, int patternIndex, char p) {
            char pUpper = TypoTolerantMatcher.toUpperAscii(p);
            char pLower = TypoTolerantMatcher.toLowerAscii(p);
            for (int i = fromIndex; i < this.myName.length(); ++i) {
                char c = this.myName.charAt(i);
                if (c != p && TypoTolerantMatcher.toUpperAscii(c) != pUpper && TypoTolerantMatcher.toLowerAscii(c) != pLower) continue;
                return i;
            }
            return -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorState";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseErrorState";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/codeStyle/TypoTolerantMatcher$Session";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "charAt";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toLowerCase";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toUpperCase";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isLowerCase";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isUpperCase";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isWordSeparator";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "patternLength";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matchWildcards";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isTrailingSpacePattern";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matchSkippingWords";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findNextPatternCharOccurrence";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "seemsLikeFragmentStart";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "charEquals";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matchFragment";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "maxMatchingFragment";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matchInsideFragment";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMiddleMatch";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findLongestMatchingPrefix";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[2] = "improveCamelHumps";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isUppercasePatternVsLowercaseNameChar";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findUppercaseMatchFurther";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isFirstCharMatching";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPatternChar";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[2] = "indexOfWordStart";
                    break;
                }
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[2] = "indexOfIgnoreCase";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

