// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct GetBucketWebsiteOutput {
    /// <p>Specifies the redirect behavior of all requests to a website endpoint of an Amazon S3 bucket.</p>
    pub redirect_all_requests_to: ::std::option::Option<crate::types::RedirectAllRequestsTo>,
    /// <p>The name of the index document for the website (for example <code>index.html</code>).</p>
    pub index_document: ::std::option::Option<crate::types::IndexDocument>,
    /// <p>The object key name of the website error document to use for 4XX class errors.</p>
    pub error_document: ::std::option::Option<crate::types::ErrorDocument>,
    /// <p>Rules that define when a redirect is applied and the redirect behavior.</p>
    pub routing_rules: ::std::option::Option<::std::vec::Vec<crate::types::RoutingRule>>,
    _extended_request_id: Option<String>,
    _request_id: Option<String>,
}
impl GetBucketWebsiteOutput {
    /// <p>Specifies the redirect behavior of all requests to a website endpoint of an Amazon S3 bucket.</p>
    pub fn redirect_all_requests_to(&self) -> ::std::option::Option<&crate::types::RedirectAllRequestsTo> {
        self.redirect_all_requests_to.as_ref()
    }
    /// <p>The name of the index document for the website (for example <code>index.html</code>).</p>
    pub fn index_document(&self) -> ::std::option::Option<&crate::types::IndexDocument> {
        self.index_document.as_ref()
    }
    /// <p>The object key name of the website error document to use for 4XX class errors.</p>
    pub fn error_document(&self) -> ::std::option::Option<&crate::types::ErrorDocument> {
        self.error_document.as_ref()
    }
    /// <p>Rules that define when a redirect is applied and the redirect behavior.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.routing_rules.is_none()`.
    pub fn routing_rules(&self) -> &[crate::types::RoutingRule] {
        self.routing_rules.as_deref().unwrap_or_default()
    }
}
impl crate::s3_request_id::RequestIdExt for GetBucketWebsiteOutput {
    fn extended_request_id(&self) -> Option<&str> {
        self._extended_request_id.as_deref()
    }
}
impl ::aws_types::request_id::RequestId for GetBucketWebsiteOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl GetBucketWebsiteOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketWebsiteOutput`](crate::operation::get_bucket_website::GetBucketWebsiteOutput).
    pub fn builder() -> crate::operation::get_bucket_website::builders::GetBucketWebsiteOutputBuilder {
        crate::operation::get_bucket_website::builders::GetBucketWebsiteOutputBuilder::default()
    }
}

/// A builder for [`GetBucketWebsiteOutput`](crate::operation::get_bucket_website::GetBucketWebsiteOutput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct GetBucketWebsiteOutputBuilder {
    pub(crate) redirect_all_requests_to: ::std::option::Option<crate::types::RedirectAllRequestsTo>,
    pub(crate) index_document: ::std::option::Option<crate::types::IndexDocument>,
    pub(crate) error_document: ::std::option::Option<crate::types::ErrorDocument>,
    pub(crate) routing_rules: ::std::option::Option<::std::vec::Vec<crate::types::RoutingRule>>,
    _extended_request_id: Option<String>,
    _request_id: Option<String>,
}
impl GetBucketWebsiteOutputBuilder {
    /// <p>Specifies the redirect behavior of all requests to a website endpoint of an Amazon S3 bucket.</p>
    pub fn redirect_all_requests_to(mut self, input: crate::types::RedirectAllRequestsTo) -> Self {
        self.redirect_all_requests_to = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies the redirect behavior of all requests to a website endpoint of an Amazon S3 bucket.</p>
    pub fn set_redirect_all_requests_to(mut self, input: ::std::option::Option<crate::types::RedirectAllRequestsTo>) -> Self {
        self.redirect_all_requests_to = input;
        self
    }
    /// <p>Specifies the redirect behavior of all requests to a website endpoint of an Amazon S3 bucket.</p>
    pub fn get_redirect_all_requests_to(&self) -> &::std::option::Option<crate::types::RedirectAllRequestsTo> {
        &self.redirect_all_requests_to
    }
    /// <p>The name of the index document for the website (for example <code>index.html</code>).</p>
    pub fn index_document(mut self, input: crate::types::IndexDocument) -> Self {
        self.index_document = ::std::option::Option::Some(input);
        self
    }
    /// <p>The name of the index document for the website (for example <code>index.html</code>).</p>
    pub fn set_index_document(mut self, input: ::std::option::Option<crate::types::IndexDocument>) -> Self {
        self.index_document = input;
        self
    }
    /// <p>The name of the index document for the website (for example <code>index.html</code>).</p>
    pub fn get_index_document(&self) -> &::std::option::Option<crate::types::IndexDocument> {
        &self.index_document
    }
    /// <p>The object key name of the website error document to use for 4XX class errors.</p>
    pub fn error_document(mut self, input: crate::types::ErrorDocument) -> Self {
        self.error_document = ::std::option::Option::Some(input);
        self
    }
    /// <p>The object key name of the website error document to use for 4XX class errors.</p>
    pub fn set_error_document(mut self, input: ::std::option::Option<crate::types::ErrorDocument>) -> Self {
        self.error_document = input;
        self
    }
    /// <p>The object key name of the website error document to use for 4XX class errors.</p>
    pub fn get_error_document(&self) -> &::std::option::Option<crate::types::ErrorDocument> {
        &self.error_document
    }
    /// Appends an item to `routing_rules`.
    ///
    /// To override the contents of this collection use [`set_routing_rules`](Self::set_routing_rules).
    ///
    /// <p>Rules that define when a redirect is applied and the redirect behavior.</p>
    pub fn routing_rules(mut self, input: crate::types::RoutingRule) -> Self {
        let mut v = self.routing_rules.unwrap_or_default();
        v.push(input);
        self.routing_rules = ::std::option::Option::Some(v);
        self
    }
    /// <p>Rules that define when a redirect is applied and the redirect behavior.</p>
    pub fn set_routing_rules(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::RoutingRule>>) -> Self {
        self.routing_rules = input;
        self
    }
    /// <p>Rules that define when a redirect is applied and the redirect behavior.</p>
    pub fn get_routing_rules(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::RoutingRule>> {
        &self.routing_rules
    }
    pub(crate) fn _extended_request_id(mut self, extended_request_id: impl Into<String>) -> Self {
        self._extended_request_id = Some(extended_request_id.into());
        self
    }

    pub(crate) fn _set_extended_request_id(&mut self, extended_request_id: Option<String>) -> &mut Self {
        self._extended_request_id = extended_request_id;
        self
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`GetBucketWebsiteOutput`](crate::operation::get_bucket_website::GetBucketWebsiteOutput).
    pub fn build(self) -> crate::operation::get_bucket_website::GetBucketWebsiteOutput {
        crate::operation::get_bucket_website::GetBucketWebsiteOutput {
            redirect_all_requests_to: self.redirect_all_requests_to,
            index_document: self.index_document,
            error_document: self.error_document,
            routing_rules: self.routing_rules,
            _extended_request_id: self._extended_request_id,
            _request_id: self._request_id,
        }
    }
}
