%% This Source Code Form is subject to the terms of the Mozilla Public
%% License, v. 2.0. If a copy of the MPL was not distributed with this
%% file, You can obtain one at https://mozilla.org/MPL/2.0/.
%%
%% Copyright (c) 2007-2025 Broadcom. All Rights Reserved. The term “Broadcom” refers to Broadcom Inc. and/or its subsidiaries. All rights reserved.
%%

-module(rabbit_prometheus_dispatcher).

-export([build_dispatcher/0]).

-define(DEFAULT_PATH, "/metrics").

build_dispatcher() ->
    {ok, _} = application:ensure_all_started(prometheus),
    CoreCollectors = [
        prometheus_rabbitmq_core_metrics_collector,
        prometheus_rabbitmq_global_metrics_collector,
        prometheus_rabbitmq_message_size_metrics_collector,
        prometheus_rabbitmq_raft_metrics_collector,
        prometheus_rabbitmq_alarm_metrics_collector,
        prometheus_rabbitmq_dynamic_collector,
        prometheus_process_collector],
    PerObjectCollectors = CoreCollectors ++ [
        prometheus_vm_system_info_collector,
        prometheus_vm_dist_collector,
        prometheus_vm_memory_collector,
        prometheus_mnesia_collector,
        prometheus_vm_statistics_collector,
        prometheus_vm_msacc_collector
    ],
    prometheus_registry:register_collectors(
        case application:get_env(rabbitmq_prometheus, return_per_object_metrics, false) of
            false -> CoreCollectors;
            true  -> PerObjectCollectors
        end
    ),
    prometheus_registry:register_collectors('per-object',
        CoreCollectors ++ PerObjectCollectors),
    prometheus_registry:register_collectors('detailed', [
        prometheus_rabbitmq_core_metrics_collector,
        prometheus_rabbitmq_raft_metrics_collector
        ]),
    prometheus_registry:register_collectors('memory-breakdown', [
        prometheus_rabbitmq_core_metrics_collector
        ]),
    rabbit_prometheus_handler:setup(),
    cowboy_router:compile([{'_', dispatcher()}]).

dispatcher() ->
    [{path() ++ "/[:registry]", rabbit_prometheus_handler, []}].

path() ->
    application:get_env(rabbitmq_prometheus, path, ?DEFAULT_PATH).
