/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.thinClientLink;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.remoteDev.downloader.FrontendInstallation;
import com.intellij.remoteDev.downloader.JetBrainsClientDownloaderConfigurationProvider;
import com.intellij.remoteDev.util.ClientVersionUtil;
import com.intellij.util.ApplicationKt;
import com.intellij.util.UriUtilKt;
import com.jetbrains.gateway.thinClientLink.ClientLifetimeTracker;
import com.jetbrains.gateway.thinClientLink.ClientVersionContext;
import com.jetbrains.gateway.thinClientLink.SingleClientLifetimeTracker;
import com.jetbrains.gateway.thinClientLink.ThinClientHandle;
import com.jetbrains.gateway.thinClientLink.ThinClientProjectInfo;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0010J4\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0007J?\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\u0019\u0010\u001d\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b\u001eJ\u0016\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\tJ\u0010\u0010\"\u001a\u0004\u0018\u00010\u00072\u0006\u0010#\u001a\u00020\u0006J\u0010\u0010$\u001a\u0004\u0018\u00010\u00072\u0006\u0010!\u001a\u00020\tJ\u000e\u0010%\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\tR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/jetbrains/gateway/thinClientLink/LinkedClientManager;", "", "<init>", "()V", "knownClients", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/jetbrains/gateway/thinClientLink/ThinClientHandle;", "projectInfoByUUID", "Lcom/jetbrains/gateway/thinClientLink/ThinClientProjectInfo;", "perVersionContexts", "Lcom/intellij/openapi/util/BuildNumber;", "Lcom/jetbrains/gateway/thinClientLink/ClientVersionContext;", "isKnownClientUid", "", "uid", "isKnownClientUid$intellij_gateway_core", "startNewClient", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "initialLink", "Ljava/net/URI;", "remoteIdentity", "onStarted", "Lkotlin/Function0;", "", "frontendInstallation", "Lcom/intellij/remoteDev/downloader/FrontendInstallation;", "startNewClient$intellij_gateway_core", "getState", "getState$intellij_gateway_core", "addProjectInfo", "uuid", "info", "findByFingerprint", "fingerprint", "findByProjectInfo", "closeClient", "Companion", "intellij.gateway.core"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nLinkedClientManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinkedClientManager.kt\ncom/jetbrains/gateway/thinClientLink/LinkedClientManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n*L\n1#1,173:1\n1#2:174\n1#2:194\n61#3,5:175\n61#3,5:182\n61#3,5:187\n14#3:195\n295#4,2:180\n72#5,2:192\n*S KotlinDebug\n*F\n+ 1 LinkedClientManager.kt\ncom/jetbrains/gateway/thinClientLink/LinkedClientManager\n*L\n91#1:194\n70#1:175,5\n79#1:182,5\n86#1:187,5\n169#1:195\n140#1:180,2\n91#1:192,2\n*E\n"})
public final class LinkedClientManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, ThinClientHandle> knownClients = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<String, ThinClientProjectInfo> projectInfoByUUID = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<BuildNumber, ClientVersionContext> perVersionContexts = new ConcurrentHashMap();
    @NotNull
    private static final Logger logger;

    public final boolean isKnownClientUid$intellij_gateway_core(@NotNull String uid) {
        Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
        return this.knownClients.containsKey(uid);
    }

    @JvmOverloads
    @NotNull
    public final ThinClientHandle startNewClient(@NotNull Lifetime lifetime, @NotNull URI initialLink, @Nullable String remoteIdentity, @NotNull Function0<Unit> onStarted) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)initialLink, (String)"initialLink");
        Intrinsics.checkNotNullParameter(onStarted, (String)"onStarted");
        return this.startNewClient$intellij_gateway_core(lifetime, initialLink, remoteIdentity, onStarted, null);
    }

    public static /* synthetic */ ThinClientHandle startNewClient$default(LinkedClientManager linkedClientManager, Lifetime lifetime, URI uRI, String string, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            function0 = LinkedClientManager::startNewClient$lambda$0;
        }
        return linkedClientManager.startNewClient(lifetime, uRI, string, (Function0<Unit>)function0);
    }

    @NotNull
    public final ThinClientHandle startNewClient$intellij_gateway_core(@NotNull Lifetime lifetime, @NotNull URI initialLink, @Nullable String remoteIdentity, @NotNull Function0<Unit> onStarted, @Nullable FrontendInstallation frontendInstallation) {
        FrontendInstallation frontendInstallation2;
        Object object;
        Map initialFragmentParameters;
        String newClientId;
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                Intrinsics.checkNotNullParameter((Object)initialLink, (String)"initialLink");
                Intrinsics.checkNotNullParameter(onStarted, (String)"onStarted");
                String string = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                newClientId = string;
                initialFragmentParameters = UriUtilKt.getFragmentParameters((URI)initialLink);
                object = remoteIdentity;
                if (object == null) break block10;
                String remoteId = object;
                boolean bl = false;
                Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"remoteId", (Object)remoteId));
                object = map;
                if (map != null) break block11;
            }
            object = MapsKt.emptyMap();
        }
        Object remoteIdParameter = object;
        Map gatewayBuildParameter = MapsKt.mapOf((Pair)TuplesKt.to((Object)"gtw_build", (Object)ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode()));
        URI initialUriWithRemoteId = UriUtilKt.newURIWithFragmentParameters((URI)initialLink, (Map)MapsKt.plus((Map)initialFragmentParameters, (Map)remoteIdParameter));
        URI uRI = URI.create("gwws://127.0.0.1:" + BuiltInServerManager.Companion.getInstance().getPort());
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
        URI gatewayConnectionUri = UriUtilKt.newURIWithFragmentParameters((URI)UriUtilKt.withQuery((URI)UriUtilKt.withPath((URI)uRI, (String)"/gateway/clientLink"), (String)("uid=" + newClientId)), (Map)MapsKt.plus((Map)MapsKt.plus((Map)initialFragmentParameters, (Map)gatewayBuildParameter), (Map)remoteIdParameter));
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Starting new linked client uid=" + newClientId + " initialLinkWithRemoteId=" + initialUriWithRemoteId + " replacedUri=" + gatewayConnectionUri, e$iv);
        }
        if ((frontendInstallation2 = frontendInstallation) == null || (frontendInstallation2 = frontendInstallation2.getBuildNumber()) == null) {
            BuildNumber buildNumber;
            String string = (String)UriUtilKt.getFragmentParameters((URI)initialUriWithRemoteId).get("cb");
            if (string != null) {
                String it = string;
                boolean bl = false;
                buildNumber = BuildNumber.fromStringOrNull((String)it);
            } else {
                buildNumber = frontendInstallation2 = null;
            }
            if (buildNumber == null) {
                BuildNumber buildNumber2 = ApplicationInfo.getInstance().getBuild().withoutProductCode();
                frontendInstallation2 = buildNumber2;
                Intrinsics.checkNotNullExpressionValue((Object)buildNumber2, (String)"withoutProductCode(...)");
            }
        }
        FrontendInstallation clientBuildNumber = frontendInstallation2;
        ThinClientHandle thinClientHandle = (ThinClientHandle)lifetime.executeIfAlive(() -> LinkedClientManager.startNewClient$lambda$9((BuildNumber)clientBuildNumber, lifetime, this, newClientId, gatewayConnectionUri));
        if (thinClientHandle == null) {
            throw new CancellationException();
        }
        ThinClientHandle newClientState = thinClientHandle;
        newClientState.updateJoinLink(initialUriWithRemoteId, false);
        if (!ApplicationKt.getApplication().isUnitTestMode() && !JetBrainsClientDownloaderConfigurationProvider.Companion.getCustomPropertiesAreSet() && !Registry.Companion.is("rdct.always.use.embedded.client") && clientBuildNumber.isSnapshot() && ApplicationKt.getApplication().isInternal()) {
            logger.info("Not launching SNAPSHOT client for link " + gatewayConnectionUri);
            newClientState.startPingingClient$intellij_gateway_core();
            return newClientState;
        }
        newClientState.onClientLaunch$intellij_gateway_core(onStarted);
        return newClientState;
    }

    @Nullable
    public final ThinClientHandle getState$intellij_gateway_core(@Nullable String uid) {
        String string = uid;
        if (string == null) {
            return null;
        }
        return this.knownClients.get(string);
    }

    public final void addProjectInfo(@NotNull String uuid, @NotNull ThinClientProjectInfo info) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        ((Map)this.projectInfoByUUID).put(uuid, info);
    }

    @Nullable
    public final ThinClientHandle findByFingerprint(@NotNull String fingerprint) {
        Object v2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
            Collection<ThinClientHandle> collection = this.knownClients.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ThinClientHandle it = (ThinClientHandle)element$iv;
                boolean bl = false;
                Object object = it.getLastSeenLink$intellij_gateway_core();
                if (!Intrinsics.areEqual(object != null && (object = UriUtilKt.getFragmentParameters((URI)object)) != null ? (String)object.get("fp") : null, (Object)fingerprint)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    @Nullable
    public final ThinClientHandle findByProjectInfo(@NotNull ThinClientProjectInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        for (Map.Entry entry : ((Map)this.projectInfoByUUID).entrySet()) {
            String uid = (String)entry.getKey();
            ThinClientProjectInfo projectInfo = (ThinClientProjectInfo)entry.getValue();
            if (!Intrinsics.areEqual((Object)projectInfo, (Object)info)) continue;
            ThinClientHandle handle2 = this.getState$intellij_gateway_core(uid);
            if (handle2 == null) {
                logger.warn("Inconsistent state: UID '" + uid + "' was found in project info map, but is missing in knownClients map.");
            }
            return handle2;
        }
        return null;
    }

    public final void closeClient(@NotNull ThinClientProjectInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        ThinClientHandle handle2 = this.findByProjectInfo(info);
        if (handle2 == null) {
            logger.info("No client handle for " + info);
        } else {
            logger.info("Found thin client '" + handle2.getUid() + "', for " + info);
            handle2.close();
        }
    }

    @JvmOverloads
    @NotNull
    public final ThinClientHandle startNewClient(@NotNull Lifetime lifetime, @NotNull URI initialLink, @Nullable String remoteIdentity) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)initialLink, (String)"initialLink");
        return LinkedClientManager.startNewClient$default(this, lifetime, initialLink, remoteIdentity, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final ThinClientHandle startNewClient(@NotNull Lifetime lifetime, @NotNull URI initialLink) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)initialLink, (String)"initialLink");
        return LinkedClientManager.startNewClient$default(this, lifetime, initialLink, null, null, 12, null);
    }

    private static final Unit startNewClient$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit startNewClient$lambda$9$lambda$7$lambda$6(LinkedClientManager this$0, BuildNumber $clientBuildNumber) {
        this$0.perVersionContexts.remove($clientBuildNumber);
        return Unit.INSTANCE;
    }

    private static final Unit startNewClient$lambda$9$lambda$8(String $newClientId, LinkedClientManager this$0) {
        logger.debug("Linked client " + $newClientId + " lifetime terminated, removing");
        this$0.knownClients.remove($newClientId);
        this$0.projectInfoByUUID.remove($newClientId);
        return Unit.INSTANCE;
    }

    private static final ThinClientHandle startNewClient$lambda$9(BuildNumber $clientBuildNumber, Lifetime $lifetime, LinkedClientManager this$0, String $newClientId, URI $gatewayConnectionUri) {
        ClientLifetimeTracker clientLifetimeTracker;
        if (ClientVersionUtil.INSTANCE.isSeparateConfigSupported($clientBuildNumber)) {
            $this$debug_u24default$iv = logger;
            Throwable e$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                var12_10 = $this$debug_u24default$iv;
                boolean bl = false;
                var12_10.debug("Client version " + $clientBuildNumber + " supports process-per-connection functionality. Will use separate client processes even for identical versions.", e$iv);
            }
            clientLifetimeTracker = new SingleClientLifetimeTracker($lifetime, $clientBuildNumber);
        } else {
            $this$debug_u24default$iv = logger;
            Throwable e$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                var12_10 = $this$debug_u24default$iv;
                boolean bl = false;
                var12_10.debug("Client version " + $clientBuildNumber + " does not support process-per-connection functionality. Will use a single client process per version.", e$iv);
            }
            ConcurrentMap $this$getOrPut$iv = this$0.perVersionContexts;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get($clientBuildNumber);
            if (object == null) {
                boolean bl = false;
                ClientVersionContext context = new ClientVersionContext($clientBuildNumber);
                context.getLifetime().onTermination(() -> LinkedClientManager.startNewClient$lambda$9$lambda$7$lambda$6(this$0, $clientBuildNumber));
                ClientVersionContext default$iv = context;
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent($clientBuildNumber, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            clientLifetimeTracker = (ClientLifetimeTracker)object;
        }
        ClientLifetimeTracker clientLifetimeTracker2 = clientLifetimeTracker;
        LifetimeDefinition clientStateLifetimeDef = $lifetime.createNested();
        Intrinsics.checkNotNull((Object)clientLifetimeTracker2);
        ThinClientHandle newClientState = new ThinClientHandle($newClientId, clientStateLifetimeDef, $gatewayConnectionUri, clientLifetimeTracker2, $clientBuildNumber);
        ((Map)this$0.knownClients).put($newClientId, newClientState);
        clientStateLifetimeDef.onTermination(() -> LinkedClientManager.startNewClient$lambda$9$lambda$8($newClientId, this$0));
        return newClientState;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LinkedClientManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LinkedClientManager.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/gateway/thinClientLink/LinkedClientManager$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/gateway/thinClientLink/LinkedClientManager;", "intellij.gateway.core"})
    @SourceDebugExtension(value={"SMAP\nLinkedClientManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinkedClientManager.kt\ncom/jetbrains/gateway/thinClientLink/LinkedClientManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,173:1\n40#2,3:174\n*S KotlinDebug\n*F\n+ 1 LinkedClientManager.kt\ncom/jetbrains/gateway/thinClientLink/LinkedClientManager$Companion\n*L\n171#1:174,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LinkedClientManager getInstance() {
            boolean $i$f$service = false;
            Class<LinkedClientManager> serviceClass$iv = LinkedClientManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (LinkedClientManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

