/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.split.backend;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.actions.CellExecutionListener;
import com.intellij.jupyter.core.jupyter.actions.CellRunMode;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionStatus;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterListeners;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputListener;
import com.intellij.jupyter.core.remote.RemoteCellExecutionUpdater;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.outputs.NotebookOutputDataKeyExtractor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import java.time.ZonedDateTime;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/intellij/jupyter/split/backend/RemoteNotebookSync;", "", "<init>", "()V", "installRemoteBackendListeners", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "installRemoteBackendListeners$intellij_jupyter_split_backend", "intellij.jupyter.split.backend"})
public final class RemoteNotebookSync {
    @NotNull
    public static final RemoteNotebookSync INSTANCE = new RemoteNotebookSync();

    private RemoteNotebookSync() {
    }

    public final void installRemoteBackendListeners$intellij_jupyter_split_backend(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        JupyterListeners listeners = JupyterEditorExtensionsKt.getNotebookFile((Editor)editor).getNotebook().getListeners();
        listeners.getOutputListeners().addListener((EventListener)new JupyterOutputListener(editor){
            final /* synthetic */ Editor $editor;
            {
                this.$editor = $editor;
            }

            /*
             * WARNING - void declaration
             */
            public void outputUpdated(JupyterNotebook notebook, NotebookIntervalPointer pointer) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
                Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
                Iterable iterable = NotebookOutputDataKeyExtractor.EP_NAME.getExtensionList();
                Editor editor = this.$editor;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    NotebookOutputDataKeyExtractor it = (NotebookOutputDataKeyExtractor)element$iv;
                    boolean bl = false;
                    NotebookCellLines.Interval interval = pointer.get();
                    Intrinsics.checkNotNull((Object)interval);
                    it.extract(editor, interval);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void allOutputsUpdated(JupyterNotebook notebook) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
                Document document = this.$editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                NotebookCellLines cellLines = NotebookCellLines.Companion.get(document);
                Iterable iterable = cellLines.getIntervals();
                Editor editor = this.$editor;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    NotebookCellLines.Interval interval = (NotebookCellLines.Interval)element$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = NotebookOutputDataKeyExtractor.EP_NAME.getExtensionList();
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        NotebookOutputDataKeyExtractor it = (NotebookOutputDataKeyExtractor)element$iv2;
                        boolean bl2 = false;
                        it.extract(editor, interval);
                    }
                }
            }
        });
        listeners.getCellExecutionListeners().addListener((EventListener)new CellExecutionListener(editor){
            final /* synthetic */ Editor $editor;
            {
                this.$editor = $editor;
            }

            /*
             * WARNING - void declaration
             */
            public void cellExecuted(JupyterNotebook notebook, NotebookIntervalPointer cell, CellRunMode cellRunMode) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
                Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
                Intrinsics.checkNotNullParameter((Object)cellRunMode, (String)"cellRunMode");
                Iterable iterable = RemoteCellExecutionUpdater.Companion.getEP_NAME().getExtensionList();
                Editor editor = this.$editor;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    RemoteCellExecutionUpdater it = (RemoteCellExecutionUpdater)element$iv;
                    boolean bl = false;
                    NotebookCellLines.Interval interval = cell.get();
                    Intrinsics.checkNotNull((Object)interval);
                    it.cellExecuted(editor, interval.getOrdinal(), cellRunMode);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void executionSubmitted(NotebookIntervalPointer cellPointer, BackedNotebookVirtualFile notebook) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
                Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
                Iterable iterable = RemoteCellExecutionUpdater.Companion.getEP_NAME().getExtensionList();
                Editor editor = this.$editor;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    RemoteCellExecutionUpdater it = (RemoteCellExecutionUpdater)element$iv;
                    boolean bl = false;
                    NotebookCellLines.Interval interval = cellPointer.get();
                    Intrinsics.checkNotNull((Object)interval);
                    it.executionSubmitted(editor, interval.getOrdinal());
                }
            }

            /*
             * WARNING - void declaration
             */
            public void executionStarted(NotebookIntervalPointer cellPointer, BackedNotebookVirtualFile notebook, ZonedDateTime startTime) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
                Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
                Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
                Iterable iterable = RemoteCellExecutionUpdater.Companion.getEP_NAME().getExtensionList();
                Editor editor = this.$editor;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    RemoteCellExecutionUpdater it = (RemoteCellExecutionUpdater)element$iv;
                    boolean bl = false;
                    NotebookCellLines.Interval interval = cellPointer.get();
                    Intrinsics.checkNotNull((Object)interval);
                    it.executionStarted(editor, interval.getOrdinal(), startTime);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void executionStopped(NotebookIntervalPointer cellPointer, BackedNotebookVirtualFile notebook, JupyterExecutionStatus jupyterStatus, ZonedDateTime endTime) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
                Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
                Intrinsics.checkNotNullParameter((Object)jupyterStatus, (String)"jupyterStatus");
                Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
                Iterable iterable = RemoteCellExecutionUpdater.Companion.getEP_NAME().getExtensionList();
                Editor editor = this.$editor;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    RemoteCellExecutionUpdater it = (RemoteCellExecutionUpdater)element$iv;
                    boolean bl = false;
                    NotebookCellLines.Interval interval = cellPointer.get();
                    Intrinsics.checkNotNull((Object)interval);
                    it.executionStopped(editor, interval.getOrdinal(), jupyterStatus, endTime);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void executionStatusReset(NotebookIntervalPointer cellPointer, BackedNotebookVirtualFile notebook) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
                Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
                Iterable iterable = RemoteCellExecutionUpdater.Companion.getEP_NAME().getExtensionList();
                Editor editor = this.$editor;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    RemoteCellExecutionUpdater it = (RemoteCellExecutionUpdater)element$iv;
                    boolean bl = false;
                    NotebookCellLines.Interval interval = cellPointer.get();
                    Intrinsics.checkNotNull((Object)interval);
                    it.executionStatusReset(editor, interval.getOrdinal());
                }
            }
        });
    }
}

