/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.diff;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.swagger.core.diff.SwDiffResult;
import com.intellij.swagger.core.diff.model.SwModifiedElement;
import com.intellij.swagger.core.diff.model.SwModifiedSpecification;
import com.intellij.swagger.core.model.specification.SwSpecificationFile;
import com.intellij.swagger.core.model.specification.SwaggerFileHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a\u0093\u0001\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\b\b\u0000\u0010\b*\u00020\t\"\b\b\u0001\u0010\u0007*\u00020\t2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\f\u00a2\u0006\u0002\b\r2:\u0010\u000e\u001a6\u0012\u0013\u0012\u0011H\u0007\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u0011H\u0007\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0013\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u000fH\u0000\u001a\u0086\u0001\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\b\b\u0000\u0010\b*\u00020\t\"\b\b\u0001\u0010\u0007*\u00020\t2\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\u00070\u00152\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\u00070\u00152:\u0010\u000e\u001a6\u0012\u0013\u0012\u0011H\u0007\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u0011H\u0007\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0013\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u000fH\u0002\u001aC\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\u00070\u0015\"\u0004\b\u0000\u0010\u0007\"\u0004\b\u0001\u0010\b*\b\u0012\u0004\u0012\u0002H\u00070\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\f\u00a2\u0006\u0002\b\rH\u0002\u00a8\u0006\u0017"}, d2={"computeSwaggerDiff", "Lcom/intellij/swagger/core/diff/model/SwModifiedSpecification;", "original", "Lcom/intellij/psi/PsiFile;", "modified", "calculateDiffBetween", "Lcom/intellij/swagger/core/diff/SwDiffResult;", "Element", "Identifier", "", "", "identifyingFunction", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "wrappingFunction", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "elementBefore", "elementAfter", "Lcom/intellij/swagger/core/diff/model/SwModifiedElement;", "", "mapIdentifierToSelf", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwDiffUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwDiffUtils.kt\ncom/intellij/swagger/core/diff/SwDiffUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1#2:72\n1#2:103\n1#2:116\n1#2:129\n3193#3,10:73\n3193#3,10:83\n1611#3,9:93\n1863#3:102\n1864#3:104\n1620#3:105\n1611#3,9:106\n1863#3:115\n1864#3:117\n1620#3:118\n1611#3,9:119\n1863#3:128\n1864#3:130\n1620#3:131\n1557#3:132\n1628#3,3:133\n*S KotlinDebug\n*F\n+ 1 SwDiffUtils.kt\ncom/intellij/swagger/core/diff/SwDiffUtilsKt\n*L\n55#1:103\n61#1:116\n62#1:129\n48#1:73,10\n49#1:83,10\n55#1:93,9\n55#1:102\n55#1:104\n55#1:105\n61#1:106,9\n61#1:115\n61#1:117\n61#1:118\n62#1:119,9\n62#1:128\n62#1:130\n62#1:131\n71#1:132\n71#1:133,3\n*E\n"})
public final class SwDiffUtilsKt {
    @Nullable
    public static final SwModifiedSpecification computeSwaggerDiff(@NotNull PsiFile original, @NotNull PsiFile modified) {
        SwModifiedSpecification swModifiedSpecification;
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)modified, (String)"modified");
        VirtualFile virtualFile = original.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        Project project = original.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        SwSpecificationFile swSpecificationFile = SwaggerFileHelper.createSpecificationFile$default(SwaggerFileHelper.INSTANCE, original, virtualFile, project, false, false, 16, null);
        if (swSpecificationFile == null) {
            return null;
        }
        SwSpecificationFile originalSpecification = swSpecificationFile;
        VirtualFile virtualFile2 = modified.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        Project project2 = modified.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        SwSpecificationFile swSpecificationFile2 = SwaggerFileHelper.createSpecificationFile$default(SwaggerFileHelper.INSTANCE, modified, virtualFile2, project2, false, false, 16, null);
        if (swSpecificationFile2 == null) {
            return null;
        }
        SwSpecificationFile modifiedSpecification = swSpecificationFile2;
        SwModifiedSpecification it = swModifiedSpecification = new SwModifiedSpecification(originalSpecification, modifiedSpecification);
        boolean bl = false;
        it.getModificationType();
        return swModifiedSpecification;
    }

    @NotNull
    public static final <Identifier, Element> SwDiffResult<Element> calculateDiffBetween(@NotNull Collection<? extends Element> original, @NotNull Collection<? extends Element> modified, @NotNull Function1<? super Element, ? extends Identifier> identifyingFunction, @NotNull Function2<? super Element, ? super Element, ? extends SwModifiedElement<?>> wrappingFunction) {
        Intrinsics.checkNotNullParameter(original, (String)"original");
        Intrinsics.checkNotNullParameter(modified, (String)"modified");
        Intrinsics.checkNotNullParameter(identifyingFunction, (String)"identifyingFunction");
        Intrinsics.checkNotNullParameter(wrappingFunction, (String)"wrappingFunction");
        return SwDiffUtilsKt.calculateDiffBetween(SwDiffUtilsKt.mapIdentifierToSelf(original, identifyingFunction), SwDiffUtilsKt.mapIdentifierToSelf(modified, identifyingFunction), wrappingFunction);
    }

    /*
     * WARNING - void declaration
     */
    private static final <Identifier, Element> SwDiffResult<Element> calculateDiffBetween(Map<Identifier, ? extends Element> original, Map<Identifier, ? extends Element> modified, Function2<? super Element, ? super Element, ? extends SwModifiedElement<?>> wrappingFunction) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        boolean bl;
        Object element$iv$iv$iv2;
        void $this$mapNotNullTo$iv$iv3;
        Object element$iv;
        Iterable $this$partition$iv = original.keySet();
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        Iterator iterator = $this$partition$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv2;
            Object it = element$iv2 = iterator.next();
            boolean bl2 = false;
            if (modified.get(it) != null) {
                first$iv.add(element$iv2);
                continue;
            }
            second$iv.add(element$iv2);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List preservedIdentifiersBefore = (List)pair.component1();
        List removedIdentifiers = (List)pair.component2();
        Iterable $this$partition$iv2 = modified.keySet();
        boolean $i$f$partition2 = false;
        ArrayList first$iv2 = new ArrayList();
        ArrayList second$iv2 = new ArrayList();
        Iterator bl2 = $this$partition$iv2.iterator();
        while (bl2.hasNext()) {
            Object it = element$iv = bl2.next();
            boolean bl3 = false;
            if (original.get(it) != null) {
                first$iv2.add(element$iv);
                continue;
            }
            second$iv2.add(element$iv);
        }
        Pair pair2 = new Pair(first$iv2, second$iv2);
        List preservedIdentifiersAfter = (List)pair2.component1();
        List createdIdentifiers = (List)pair2.component2();
        boolean bl4 = first$iv2 = preservedIdentifiersBefore.size() == preservedIdentifiersAfter.size();
        if (_Assertions.ENABLED && !first$iv2) {
            boolean $i$a$-assert-SwDiffUtilsKt$calculateDiffBetween$42 = false;
            String $i$a$-assert-SwDiffUtilsKt$calculateDiffBetween$42 = "Different number of preserved items found: " + preservedIdentifiersBefore.size() + " from original and " + preservedIdentifiersAfter.size() + " from modified";
            throw new AssertionError((Object)$i$a$-assert-SwDiffUtilsKt$calculateDiffBetween$42);
        }
        Iterable $this$mapNotNull$iv = preservedIdentifiersBefore;
        boolean $i$f$mapNotNull = false;
        element$iv = $this$mapNotNull$iv;
        Iterable<SwModifiedElement> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv3;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
            SwModifiedElement it$iv$iv;
            Element itemAfter;
            Element itemBefore;
            Object element$iv$iv = element$iv$iv$iv2;
            boolean bl5 = false;
            Object it = element$iv$iv;
            boolean bl6 = false;
            if ((original.get(it) == null ? null : (modified.get(it) == null ? null : (SwModifiedElement)wrappingFunction.invoke(itemBefore, itemAfter))) == null) continue;
            it$iv$iv = it$iv$iv;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List preservedItems = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv2 = createdIdentifiers;
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv = $this$mapNotNull$iv2;
        Iterable<Element> destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach2 = false;
        element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv$iv2.hasNext()) {
            Element it$iv$iv;
            Object element$iv$iv$iv3;
            Object element$iv$iv = element$iv$iv$iv3 = element$iv$iv$iv2.next();
            boolean bl7 = false;
            Object it = element$iv$iv;
            boolean bl8 = false;
            if (modified.get(it) == null) continue;
            boolean bl9 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List createdItems = (List)destination$iv$iv2;
        Iterable $this$mapNotNull$iv3 = removedIdentifiers;
        boolean $i$f$mapNotNull3 = false;
        destination$iv$iv2 = $this$mapNotNull$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo3 = false;
        void $this$forEach$iv$iv$iv3 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach3 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv3.iterator();
        while (iterator2.hasNext()) {
            Element it$iv$iv;
            Object element$iv$iv$iv4;
            Object element$iv$iv = element$iv$iv$iv4 = iterator2.next();
            boolean bl10 = false;
            Object it = element$iv$iv;
            boolean bl11 = false;
            if (original.get(it) == null) continue;
            bl = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        List removedItems = (List)destination$iv$iv3;
        return new SwDiffResult(createdItems, removedItems, preservedItems);
    }

    /*
     * WARNING - void declaration
     */
    private static final <Element, Identifier> Map<Identifier, Element> mapIdentifierToSelf(Collection<? extends Element> $this$mapIdentifierToSelf, Function1<? super Element, ? extends Identifier> identifyingFunction) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$mapIdentifierToSelf;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)identifyingFunction.invoke((Object)it), (Object)it));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }
}

