/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.PosixFilePermissionsUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.util.Enumeration;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Decompressor {
    private static final Logger LOG = Logger.getInstance(Decompressor.class);
    @Nullable
    private Predicate<? super Entry> myFilter = null;
    @NotNull
    private BiFunction<? super Entry, ? super IOException, ErrorHandlerChoice> myErrorHandler = (__, ___) -> ErrorHandlerChoice.BAIL_OUT;
    private boolean myIgnoreIOExceptions = false;
    @Nullable
    private List<String> myPathPrefix = null;
    private boolean myOverwrite = true;
    private EscapingSymlinkPolicy myEscapingSymlinkPolicy = EscapingSymlinkPolicy.ALLOW;
    private BiConsumer<? super Entry, ? super Path> myPostProcessor;

    public Decompressor filter(@Nullable Predicate<? super String> filter2) {
        this.myFilter = filter2 != null ? e -> filter2.test(e.type == Entry.Type.DIR ? e.name + '/' : e.name) : null;
        return this;
    }

    public Decompressor entryFilter(@Nullable Predicate<? super Entry> filter2) {
        this.myFilter = filter2;
        return this;
    }

    public Decompressor errorHandler(@NotNull BiFunction<? super Entry, ? super IOException, ErrorHandlerChoice> errorHandler) {
        if (errorHandler == null) {
            Decompressor.$$$reportNull$$$0(0);
        }
        this.myErrorHandler = errorHandler;
        return this;
    }

    public Decompressor overwrite(boolean overwrite) {
        this.myOverwrite = overwrite;
        return this;
    }

    public Decompressor escapingSymlinkPolicy(@NotNull EscapingSymlinkPolicy policy) {
        if (policy == null) {
            Decompressor.$$$reportNull$$$0(1);
        }
        this.myEscapingSymlinkPolicy = policy;
        return this;
    }

    public Decompressor postProcessor(@Nullable Consumer<? super Path> consumer2) {
        this.myPostProcessor = consumer2 != null ? (entry, path) -> consumer2.accept((Path)path) : null;
        return this;
    }

    public Decompressor postProcessor(@Nullable BiConsumer<? super Entry, ? super Path> consumer2) {
        this.myPostProcessor = consumer2;
        return this;
    }

    public Decompressor removePrefixPath(@Nullable String prefix) throws IOException {
        this.myPathPrefix = prefix != null ? Decompressor.normalizePathAndSplit(prefix) : null;
        return this;
    }

    @ApiStatus.Obsolete
    public final void extract(@NotNull File outputDir) throws IOException {
        if (outputDir == null) {
            Decompressor.$$$reportNull$$$0(2);
        }
        this.extract(outputDir.toPath());
    }

    /*
     * Exception decompiling
     */
    public final void extract(@NotNull Path outputDir) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Path processEntry(@NotNull Path outputDir, Entry entry) throws IOException {
        if (outputDir == null) {
            Decompressor.$$$reportNull$$$0(4);
        }
        if (this.myPathPrefix != null && (entry = Decompressor.mapPathPrefix(entry, this.myPathPrefix)) == null) {
            return null;
        }
        Path outputFile = Decompressor.entryFile(outputDir, entry.name);
        switch (entry.type) {
            case DIR: {
                NioFiles.createDirectories(outputFile);
                break;
            }
            case FILE: {
                if (!this.myOverwrite && Files.exists(outputFile, new LinkOption[0])) break;
                InputStream inputStream = this.openEntryStream(entry);
                try {
                    NioFiles.createDirectories(outputFile.getParent());
                    try (OutputStream outputStream = Files.newOutputStream(outputFile, new OpenOption[0]);){
                        StreamUtil.copy(inputStream, outputStream);
                    }
                    if (entry.mode == 0) break;
                    Decompressor.setAttributes(entry.mode, outputFile);
                    break;
                }
                finally {
                    this.closeEntryStream(inputStream);
                }
            }
            case SYMLINK: {
                if (entry.linkTarget == null || entry.linkTarget.isEmpty()) {
                    throw new IOException("Invalid symlink entry: " + entry.name + " (empty target)");
                }
                String target = entry.linkTarget;
                switch (this.myEscapingSymlinkPolicy) {
                    case DISALLOW: {
                        Decompressor.verifySymlinkTarget(entry.name, entry.linkTarget, outputDir, outputFile);
                        break;
                    }
                    case RELATIVIZE_ABSOLUTE: {
                        if (!OSAgnosticPathUtil.isAbsolute(target)) break;
                        target = FileUtil.join(outputDir.toString(), entry.linkTarget.substring(1));
                    }
                }
                if (!this.myOverwrite && Files.exists(outputFile, LinkOption.NOFOLLOW_LINKS)) break;
                try {
                    Path outputTarget = Paths.get(target, new String[0]);
                    NioFiles.createDirectories(outputFile.getParent());
                    Files.deleteIfExists(outputFile);
                    Files.createSymbolicLink(outputFile, outputTarget, new FileAttribute[0]);
                    break;
                }
                catch (InvalidPathException e) {
                    throw new IOException("Invalid symlink entry: " + entry.name + " -> " + target, e);
                }
            }
        }
        if (this.myPostProcessor != null) {
            this.myPostProcessor.accept(entry, outputFile);
        }
        return outputFile;
    }

    private static void verifySymlinkTarget(String entryName, String linkTarget, Path outputDir, Path outputFile) throws IOException {
        try {
            Path outputTarget = Paths.get(linkTarget, new String[0]);
            if (outputTarget.isAbsolute()) {
                throw new IOException("Invalid symlink (absolute path): " + entryName + " -> " + linkTarget);
            }
            Path linkTargetNormalized = outputFile.getParent().resolve(outputTarget).normalize();
            if (!linkTargetNormalized.startsWith(outputDir.normalize())) {
                throw new IOException("Invalid symlink (points outside of output directory): " + entryName + " -> " + linkTarget);
            }
        }
        catch (InvalidPathException e) {
            throw new IOException("Failed to verify symlink entry scope: " + entryName + " -> " + linkTarget, e);
        }
    }

    @Nullable
    private static Entry mapPathPrefix(Entry e, List<String> prefix) throws IOException {
        List<String> ourPathSplit = Decompressor.normalizePathAndSplit(e.name);
        if (prefix.size() >= ourPathSplit.size() || !ourPathSplit.subList(0, prefix.size()).equals(prefix)) {
            return null;
        }
        String newName = String.join((CharSequence)"/", ourPathSplit.subList(prefix.size(), ourPathSplit.size()));
        return new Entry(newName, e.type, e.mode, e.linkTarget, e.size);
    }

    private static List<String> normalizePathAndSplit(String path) throws IOException {
        Decompressor.ensureValidPath(path);
        String canonicalPath = FileUtilRt.toCanonicalPath((String)path, (char)'/', (boolean)true);
        return FileUtilRt.splitPath((String)StringUtil.trimLeading(canonicalPath, '/'), (char)'/');
    }

    private static void setAttributes(int mode, Path outputFile) throws IOException {
        if (SystemInfo.isWindows) {
            DosFileAttributeView attrs = Files.getFileAttributeView(outputFile, DosFileAttributeView.class, new LinkOption[0]);
            if (attrs != null) {
                if ((mode & 1) != 0) {
                    attrs.setReadOnly(true);
                }
                if ((mode & 2) != 0) {
                    attrs.setHidden(true);
                }
            }
        } else {
            PosixFileAttributeView attrs = Files.getFileAttributeView(outputFile, PosixFileAttributeView.class, new LinkOption[0]);
            if (attrs != null) {
                attrs.setPermissions(PosixFilePermissionsUtil.fromUnixMode(mode));
            }
        }
    }

    protected Decompressor() {
    }

    protected abstract void openStream() throws IOException;

    @Nullable
    protected abstract Entry nextEntry() throws IOException;

    protected abstract InputStream openEntryStream(Entry var1) throws IOException;

    protected abstract void closeEntryStream(InputStream var1) throws IOException;

    protected abstract void closeStream() throws IOException;

    private static void ensureValidPath(String entryName) throws IOException {
        if (entryName.contains("..") && ArrayUtil.contains("..", entryName.split("[/\\\\]"))) {
            throw new IOException("Invalid entry name: " + entryName);
        }
    }

    @NotNull
    public static Path entryFile(@NotNull Path outputDir, @NotNull String entryName) throws IOException {
        if (outputDir == null) {
            Decompressor.$$$reportNull$$$0(5);
        }
        if (entryName == null) {
            Decompressor.$$$reportNull$$$0(6);
        }
        Decompressor.ensureValidPath(entryName);
        Path path = outputDir.resolve(StringUtil.trimLeading(entryName, '/'));
        if (path == null) {
            Decompressor.$$$reportNull$$$0(7);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/Decompressor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/Decompressor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "entryFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "errorHandler";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "escapingSymlinkPolicy";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processEntry";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "entryFile";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum EscapingSymlinkPolicy {
        ALLOW,
        DISALLOW,
        RELATIVIZE_ABSOLUTE;

    }

    public static final class Entry {
        public static final int DOS_READ_ONLY = 1;
        public static final int DOS_HIDDEN = 2;
        public final String name;
        public final Type type;
        public final int mode;
        public final long size;
        @Nullable
        public final String linkTarget;

        Entry(String name, boolean isDirectory, long size) {
            this(name, isDirectory ? Type.DIR : Type.FILE, 0, null, size);
        }

        Entry(String name, Type type, int mode, @Nullable String linkTarget, long size) {
            int s;
            name = name.trim().replace('\\', '/');
            int e = name.length() - 1;
            for (s = 0; s < e && name.charAt(s) == '/'; ++s) {
            }
            while (e >= s && name.charAt(e) == '/') {
                --e;
            }
            this.name = name.substring(s, e + 1);
            this.type = type;
            this.mode = mode;
            this.linkTarget = linkTarget;
            this.size = size;
        }

        public static enum Type {
            FILE,
            DIR,
            SYMLINK;

        }
    }

    public static enum ErrorHandlerChoice {
        ABORT,
        BAIL_OUT,
        RETRY,
        SKIP,
        SKIP_ALL;

    }

    public static final class Zip
    extends Decompressor {
        private final Path mySource;
        private java.util.zip.ZipFile myZip;
        private Enumeration<? extends ZipEntry> myEntries;
        private ZipEntry myEntry;

        public Zip(@NotNull Path file) {
            if (file == null) {
                Zip.$$$reportNull$$$0(0);
            }
            this.mySource = file;
        }

        @ApiStatus.Obsolete
        public Zip(@NotNull File file) {
            if (file == null) {
                Zip.$$$reportNull$$$0(1);
            }
            this.mySource = file.toPath();
        }

        @NotNull
        public Decompressor withZipExtensions() {
            return new ExtZip(this.mySource);
        }

        @Override
        protected void openStream() throws IOException {
            this.myZip = new java.util.zip.ZipFile(this.mySource.toFile());
            this.myEntries = this.myZip.entries();
        }

        @Override
        protected Entry nextEntry() {
            this.myEntry = this.myEntries.hasMoreElements() ? this.myEntries.nextElement() : null;
            return this.myEntry == null ? null : new Entry(this.myEntry.getName(), this.myEntry.isDirectory(), this.myEntry.getSize());
        }

        @Override
        protected InputStream openEntryStream(Entry entry) throws IOException {
            return this.myZip.getInputStream(this.myEntry);
        }

        @Override
        protected void closeEntryStream(InputStream stream) throws IOException {
            stream.close();
        }

        @Override
        protected void closeStream() throws IOException {
            this.myZip.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/Decompressor$Zip", "<init>"));
        }

        private static final class ExtZip
        extends Decompressor {
            private final Path mySource;
            private ZipFile myZip;
            private Enumeration<? extends ZipArchiveEntry> myEntries;
            private ZipArchiveEntry myEntry;

            ExtZip(Path file) {
                this.mySource = file;
            }

            @Override
            protected void openStream() throws IOException {
                this.myZip = new ZipFile(Files.newByteChannel(this.mySource, new OpenOption[0]));
                this.myEntries = this.myZip.getEntries();
            }

            @Override
            protected Entry nextEntry() throws IOException {
                ZipArchiveEntry zipArchiveEntry = this.myEntry = this.myEntries.hasMoreElements() ? this.myEntries.nextElement() : null;
                if (this.myEntry == null) {
                    return null;
                }
                int platform = this.myEntry.getPlatform();
                if (SystemInfo.isWindows) {
                    if (platform == 3) {
                        return new Entry(this.myEntry.getName(), ExtZip.type(this.myEntry), 0, this.myZip.getUnixSymlink(this.myEntry), this.myEntry.getSize());
                    }
                    if (platform == 0) {
                        return new Entry(this.myEntry.getName(), ExtZip.type(this.myEntry), (int)this.myEntry.getExternalAttributes(), null, this.myEntry.getSize());
                    }
                } else {
                    if (platform == 3) {
                        return new Entry(this.myEntry.getName(), ExtZip.type(this.myEntry), this.myEntry.getUnixMode(), this.myZip.getUnixSymlink(this.myEntry), this.myEntry.getSize());
                    }
                    if (platform == 0) {
                        long attributes = this.myEntry.getExternalAttributes();
                        int unixMode = (attributes & 1L) != 0L ? 292 : 420;
                        return new Entry(this.myEntry.getName(), ExtZip.type(this.myEntry), unixMode, this.myZip.getUnixSymlink(this.myEntry), this.myEntry.getSize());
                    }
                }
                return new Entry(this.myEntry.getName(), this.myEntry.isDirectory(), this.myEntry.getSize());
            }

            private static Entry.Type type(ZipArchiveEntry e) {
                return e.isUnixSymlink() ? Entry.Type.SYMLINK : (e.isDirectory() ? Entry.Type.DIR : Entry.Type.FILE);
            }

            @Override
            protected InputStream openEntryStream(Entry entry) throws IOException {
                return this.myZip.getInputStream(this.myEntry);
            }

            @Override
            protected void closeEntryStream(InputStream stream) throws IOException {
                stream.close();
            }

            @Override
            protected void closeStream() throws IOException {
                this.myZip.close();
            }
        }
    }

    public static final class Tar
    extends Decompressor {
        private final Object mySource;
        private TarArchiveInputStream myStream;

        public Tar(@NotNull Path file) {
            if (file == null) {
                Tar.$$$reportNull$$$0(0);
            }
            this.mySource = file;
        }

        @ApiStatus.Obsolete
        public Tar(@NotNull File file) {
            if (file == null) {
                Tar.$$$reportNull$$$0(1);
            }
            this.mySource = file.toPath();
        }

        public Tar(@NotNull InputStream stream) {
            if (stream == null) {
                Tar.$$$reportNull$$$0(2);
            }
            this.mySource = stream;
        }

        @Override
        protected void openStream() throws IOException {
            BufferedInputStream input;
            block2: {
                input = new BufferedInputStream(this.mySource instanceof Path ? Files.newInputStream((Path)this.mySource, new OpenOption[0]) : (InputStream)this.mySource);
                try {
                    input = new CompressorStreamFactory().createCompressorInputStream((InputStream)input);
                }
                catch (CompressorException e) {
                    Throwable cause = e.getCause();
                    if (!(cause instanceof IOException)) break block2;
                    throw (IOException)cause;
                }
            }
            this.myStream = new TarArchiveInputStream((InputStream)input);
        }

        @Override
        protected Entry nextEntry() throws IOException {
            TarArchiveEntry te;
            while (!((te = this.myStream.getNextEntry()) == null || te.isFile() && !te.isLink() || te.isDirectory() || te.isSymbolicLink())) {
            }
            if (te == null) {
                return null;
            }
            if (!SystemInfo.isWindows) {
                return new Entry(te.getName(), Tar.type(te), te.getMode(), te.getLinkName(), te.getSize());
            }
            if (te.isSymbolicLink()) {
                return new Entry(te.getName(), Entry.Type.SYMLINK, 0, te.getLinkName(), te.getSize());
            }
            return new Entry(te.getName(), te.isDirectory(), te.getSize());
        }

        private static Entry.Type type(TarArchiveEntry te) {
            return te.isSymbolicLink() ? Entry.Type.SYMLINK : (te.isDirectory() ? Entry.Type.DIR : Entry.Type.FILE);
        }

        @Override
        protected InputStream openEntryStream(Entry entry) {
            return this.myStream;
        }

        @Override
        protected void closeEntryStream(InputStream stream) {
        }

        @Override
        protected void closeStream() throws IOException {
            if (this.mySource instanceof Path) {
                this.myStream.close();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stream";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/io/Decompressor$Tar";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

