/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogNavigationUtil;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcsUtil.VcsUtil;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ShowCommitInLogAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(ShowCommitInLogAction.class);

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            ShowCommitInLogAction.$$$reportNull$$$0(0);
        }
        if ((project = (Project)event.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        VcsRevisionNumber revision = this.getRevisionNumber(event);
        if (revision == null) {
            return;
        }
        ShowCommitInLogAction.jumpToRevision(project, HashImpl.build(revision.asString()));
    }

    @Nullable
    protected VcsRevisionNumber getRevisionNumber(@NotNull AnActionEvent event) {
        VcsFileRevision fileRevision;
        VcsRevisionNumber revision;
        if (event == null) {
            ShowCommitInLogAction.$$$reportNull$$$0(1);
        }
        if ((revision = (VcsRevisionNumber)event.getData(VcsDataKeys.VCS_REVISION_NUMBER)) == null && (fileRevision = (VcsFileRevision)event.getData(VcsDataKeys.VCS_FILE_REVISION)) != null) {
            revision = fileRevision.getRevisionNumber();
        }
        return revision;
    }

    @Nullable
    protected VcsKey getVcsKey(@NotNull AnActionEvent event) {
        if (event == null) {
            ShowCommitInLogAction.$$$reportNull$$$0(2);
        }
        return (VcsKey)event.getData(VcsDataKeys.VCS);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowCommitInLogAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowCommitInLogAction.$$$reportNull$$$0(4);
        }
        Project project = e.getProject();
        VcsKey vcsKey = this.getVcsKey(e);
        e.getPresentation().setEnabled(project != null && this.getRevisionNumber(e) != null && vcsKey != null && VcsProjectLog.getSupportedVcs(project).contains(vcsKey));
        e.getPresentation().setText(ShowCommitInLogAction.getActionText(project, vcsKey));
    }

    @NlsActions.ActionText
    @NotNull
    private static String getActionText(@Nullable Project project, @Nullable VcsKey vcsKey) {
        AbstractVcs vcs;
        if (project != null && vcsKey != null && (vcs = VcsUtil.findVcsByKey((Project)project, (VcsKey)vcsKey)) != null) {
            String string = VcsLogBundle.message("action.Vcs.Log.SelectInLog.text.template", vcs.getDisplayName());
            if (string == null) {
                ShowCommitInLogAction.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = VcsLogBundle.message("action.Vcs.Log.SelectInLog.text", new Object[0]);
        if (string == null) {
            ShowCommitInLogAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    @ApiStatus.Internal
    public static void jumpToRevision(@NotNull Project project, @NotNull Hash hash) {
        if (project == null) {
            ShowCommitInLogAction.$$$reportNull$$$0(7);
        }
        if (hash == null) {
            ShowCommitInLogAction.$$$reportNull$$$0(8);
        }
        VcsLogContentUtil.runInMainLog(project, (Consumer<? super MainVcsLogUi>)((Consumer)logUi -> ShowCommitInLogAction.jumpToRevisionUnderProgress(project, logUi, hash)));
    }

    private static void jumpToRevisionUnderProgress(@NotNull Project project, @NotNull VcsLogUiEx logUi, @NotNull Hash hash) {
        ListenableFuture<Boolean> future;
        if (project == null) {
            ShowCommitInLogAction.$$$reportNull$$$0(9);
        }
        if (logUi == null) {
            ShowCommitInLogAction.$$$reportNull$$$0(10);
        }
        if (hash == null) {
            ShowCommitInLogAction.$$$reportNull$$$0(11);
        }
        if (!(future = VcsLogNavigationUtil.jumpToHash(logUi, hash.asString(), false, true)).isDone()) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, VcsLogBundle.message("vcs.log.show.commit.in.log.process", hash.toShortString()), false, PerformInBackgroundOption.ALWAYS_BACKGROUND, (Future)future){
                final /* synthetic */ Future val$future;
                {
                    this.val$future = future;
                    super(arg0, arg1, arg2, arg3);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        this.val$future.get();
                    }
                    catch (InterruptedException | CancellationException exception) {
                    }
                    catch (ExecutionException e) {
                        LOG.error((Throwable)e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/ui/actions/ShowCommitInLogAction$1", "run"));
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/actions/ShowCommitInLogAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logUi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/actions/ShowCommitInLogAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionNumber";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVcsKey";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "jumpToRevision";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "jumpToRevisionUnderProgress";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

