/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.intentions.extractComponent;

import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.inspections.CssUnusedSymbolUtils;
import com.intellij.psi.css.inspections.RemoveUnusedSymbolIntentionAction;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.editor.VueComponentSourceEdit;
import org.jetbrains.vuejs.index.VueFileVisitor;
import org.jetbrains.vuejs.index.VueFrameworkHandlerKt;
import org.jetbrains.vuejs.intentions.extractComponent.VueExtractComponentDataBuilder;
import org.jetbrains.vuejs.intentions.extractComponent.VueExtractComponentDataBuilder$processVueComponent$;
import org.jetbrains.vuejs.lang.expr.VueExprLanguagesKt;
import org.jetbrains.vuejs.lang.html.VueFile;
import org.jetbrains.vuejs.model.VueModelManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000f\u0018\u00002\u00020\u0001:\u0001CB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u0003H\u0002J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u00032\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#H\u0002J\u0016\u0010$\u001a\u00020\r2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0&H\u0002J\n\u0010'\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\rJ\u0010\u0010+\u001a\u00020\r2\u0006\u0010*\u001a\u00020\rH\u0002J$\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020\r2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001a0/H\u0002J\b\u00100\u001a\u00020\rH\u0002J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u00102\u001a\u00020\bH\u0002J\u0010\u00103\u001a\u00020\u001a2\u0006\u00102\u001a\u00020\bH\u0002J\u0010\u00104\u001a\u0002052\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0012\u00106\u001a\u00020\r2\b\u00107\u001a\u0004\u0018\u00010\rH\u0002J\b\u00108\u001a\u00020\rH\u0002J\u0016\u00109\u001a\u00020\r2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0&H\u0002J\u001e\u0010:\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\r2\u0006\u0010;\u001a\u00020\b2\u0006\u0010<\u001a\u00020\bJ\u000e\u0010=\u001a\u00020 2\u0006\u0010>\u001a\u00020\rJ\u0010\u0010?\u001a\u00020\u001a2\u0006\u00102\u001a\u00020\bH\u0002J\b\u0010@\u001a\u00020\rH\u0002J\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00170\u00032\u0006\u0010B\u001a\u000205H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/jetbrains/vuejs/intentions/extractComponent/VueExtractComponentDataBuilder;", "", "list", "", "Lcom/intellij/psi/xml/XmlTag;", "<init>", "(Ljava/util/List;)V", "containingFile", "Lcom/intellij/psi/PsiFile;", "kotlin.jvm.PlatformType", "Lcom/intellij/psi/PsiFile;", "scriptTag", "scriptLanguage", "", "templateLanguage", "styleTags", "unusedStylesInExistingComponent", "Lcom/intellij/psi/css/CssSelectorSuffix;", "importsToCopy", "", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportDeclaration;", "refDataMap", "", "Lorg/jetbrains/vuejs/intentions/extractComponent/VueExtractComponentDataBuilder$RefData;", "calculateProps", "processVueComponent", "", "ref", "Lcom/intellij/psi/impl/source/xml/TagNameReference;", "gatherReferences", "addElementReferences", "element", "Lcom/intellij/psi/PsiElement;", "tag", "offset", "", "generateNewTemplateContents", "mapHasDirectUsage", "", "findTemplate", "createNewComponent", "Lcom/intellij/openapi/vfs/VirtualFile;", "newComponentName", "generateNewComponentText", "psiOperationOnText", "text", "operation", "Lkotlin/Function1;", "copyStyles", "findStyles", "file", "optimizeAndRemoveEmptyStyles", "hasMeaningfulChildren", "", "langAttribute", "lang", "generateImports", "generateDescriptorMembers", "modifyCurrentComponent", "currentFile", "newPsiFile", "replaceWithNewTag", "replaceName", "optimizeUnusedComponentsAndImports", "generateProps", "sortedProps", "distinct", "RefData", "intellij.vuejs"})
@SourceDebugExtension(value={"SMAP\nVueExtractComponentDataBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueExtractComponentDataBuilder.kt\norg/jetbrains/vuejs/intentions/extractComponent/VueExtractComponentDataBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,310:1\n1863#2,2:311\n1863#2:317\n1863#2:318\n1863#2,2:319\n1864#2:321\n1864#2:322\n1557#2:326\n1628#2,3:327\n1755#2,3:331\n1557#2:338\n1628#2,3:339\n1863#2,2:342\n774#2:344\n865#2,2:345\n1863#2,2:347\n1863#2,2:349\n1863#2,2:359\n1663#2,8:361\n1053#2:369\n1611#2,9:370\n1863#2:379\n1864#2:381\n1620#2:382\n1062#2:383\n1863#2,2:384\n477#3:313\n183#3:314\n184#3:316\n1#4:315\n1#4:380\n3829#5:323\n4344#5,2:324\n3829#5:335\n4344#5,2:336\n11165#5:352\n11500#5,3:353\n3829#5:356\n4344#5,2:357\n216#6:330\n217#6:334\n19#7:351\n*S KotlinDebug\n*F\n+ 1 VueExtractComponentDataBuilder.kt\norg/jetbrains/vuejs/intentions/extractComponent/VueExtractComponentDataBuilder\n*L\n53#1:311,2\n92#1:317\n99#1:318\n100#1:319,2\n99#1:321\n92#1:322\n113#1:326\n113#1:327,3\n148#1:331,3\n196#1:338\n196#1:339,3\n202#1:342,2\n203#1:344\n203#1:345,2\n207#1:347,2\n254#1:349,2\n271#1:359,2\n285#1:361,8\n285#1:369\n123#1:370,9\n123#1:379\n123#1:381\n123#1:382\n127#1:383\n128#1:384,2\n79#1:313\n80#1:314\n80#1:316\n123#1:380\n113#1:323\n113#1:324,2\n196#1:335\n196#1:336,2\n262#1:352\n262#1:353,3\n271#1:356\n271#1:357,2\n147#1:330\n147#1:334\n260#1:351\n*E\n"})
public final class VueExtractComponentDataBuilder {
    @NotNull
    private final List<XmlTag> list;
    private final PsiFile containingFile;
    @Nullable
    private final XmlTag scriptTag;
    @Nullable
    private final String scriptLanguage;
    @Nullable
    private final String templateLanguage;
    @NotNull
    private final List<XmlTag> styleTags;
    @NotNull
    private List<? extends CssSelectorSuffix> unusedStylesInExistingComponent;
    @NotNull
    private final Map<String, ES6ImportDeclaration> importsToCopy;
    @NotNull
    private final Map<XmlTag, List<RefData>> refDataMap;

    public VueExtractComponentDataBuilder(@NotNull List<? extends XmlTag> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        this.list = list;
        this.containingFile = this.list.get(0).getContainingFile();
        this.scriptTag = this.containingFile instanceof XmlFile ? VueFrameworkHandlerKt.findScriptTag((XmlFile)this.containingFile, false) : null;
        this.scriptLanguage = VueUtilKt.detectLanguage(this.scriptTag);
        this.templateLanguage = VueUtilKt.detectLanguage(this.findTemplate());
        PsiFile psiFile = this.containingFile;
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"containingFile");
        this.styleTags = this.findStyles(psiFile);
        this.unusedStylesInExistingComponent = CollectionsKt.emptyList();
        this.importsToCopy = new LinkedHashMap();
        this.refDataMap = this.calculateProps();
    }

    private final Map<XmlTag, List<RefData>> calculateProps() {
        List<RefData> refList = this.gatherReferences();
        Map map = new LinkedHashMap();
        Iterable $this$forEach$iv = refList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiLanguageInjectionHost host;
            PsiElement resolved;
            RefData refData = (RefData)element$iv;
            boolean bl = false;
            if (refData.getRef() instanceof TagNameReference) {
                this.processVueComponent((TagNameReference)refData.getRef());
                continue;
            }
            if (refData.resolve() == null) continue;
            XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)resolved, XmlTag.class);
            if (parentTag == null && VueExprLanguagesKt.isVueExprMetaLanguage(resolved.getLanguage()) && (host = InjectedLanguageManager.getInstance((Project)this.list.get(0).getProject()).getInjectionHost(resolved)) != null) {
                parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)host), XmlTag.class);
            }
            if ((this.scriptTag == null || !Intrinsics.areEqual((Object)parentTag, (Object)this.scriptTag)) && !PsiTreeUtil.isAncestor((PsiElement)((PsiElement)parentTag), (PsiElement)((PsiElement)refData.getTag()), (boolean)true)) continue;
            map.putIfAbsent(refData.getTag(), (List)new ArrayList());
            Object v = map.get(refData.getTag());
            Intrinsics.checkNotNull(v);
            ((List)v).add(refData);
        }
        return map;
    }

    /*
     * Unable to fully structure code
     */
    private final void processVueComponent(TagNameReference ref) {
        block6: {
            v0 = ref.getNameElement().getText();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getText(...)");
            name = VueUtilKt.fromAsset$default(v0, false, 2, null);
            var5_3 = new JSExecutionScope[]{VueFrameworkHandlerKt.findModule((PsiElement)this.scriptTag, false), VueFrameworkHandlerKt.findModule((PsiElement)this.scriptTag, true)};
            var5_3 = SequencesKt.flatMap((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])var5_3)), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, processVueComponent$lambda$1(com.intellij.lang.javascript.psi.JSExecutionScope ), (Lcom/intellij/lang/javascript/psi/JSExecutionScope;)Lkotlin/sequences/Sequence;)());
            $i$f$filterIsInstance = false;
            v1 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)processVueComponent$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            $this$filterIsInstance$iv = v1;
            $i$f$firstOrNull = false;
            for (E element$iv : $this$firstOrNull$iv) {
                block5: {
                    importDeclaration = (ES6ImportDeclaration)element$iv;
                    $i$a$-firstOrNull-VueExtractComponentDataBuilder$processVueComponent$foundImport$2 = false;
                    v2 = importDeclaration.getImportedBindings();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getImportedBindings(...)");
                    for (Object var14_12 : (Object[])v2) {
                        binding = (ES6ImportedBinding)var14_12;
                        $i$a$-find-VueExtractComponentDataBuilder$processVueComponent$foundImport$2$1 = false;
                        if (binding.isNamespaceImport()) ** GOTO lbl-1000
                        it = binding.getName();
                        $i$a$-let-VueExtractComponentDataBuilder$processVueComponent$foundImport$2$1$1 = false;
                        v3 = it != null && Intrinsics.areEqual((Object)name, (Object)VueUtilKt.fromAsset$default(it, false, 2, null));
                        if (v3) {
                            v4 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v4 = false;
                        }
                        if (!v4) continue;
                        v5 = var14_12;
                        break block5;
                    }
                    v5 = null;
                }
                v6 = v5 != null;
                if (!v6) continue;
                v7 = element$iv;
                break block6;
            }
            v7 = null;
        }
        v8 = v7;
        if (v8 == null) {
            return;
        }
        foundImport = v8;
        var4_18 = this.importsToCopy;
        v9 = ref.getNameElement().getText();
        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getText(...)");
        var4_18.put(VueUtilKt.toAsset(v9, true), foundImport);
    }

    private final List<RefData> gatherReferences() {
        List refs = new ArrayList();
        InjectedLanguageManager injManager = InjectedLanguageManager.getInstance((Project)this.list.get(0).getProject());
        Iterable $this$forEach$iv = this.list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection hosts;
            XmlTag tag = (XmlTag)element$iv;
            boolean bl = false;
            PsiTreeUtil.processElements((PsiElement)((PsiElement)tag), (PsiElementProcessor)new PsiElementProcessor(refs, this, tag){
                final /* synthetic */ List<RefData> $refs;
                final /* synthetic */ VueExtractComponentDataBuilder this$0;
                final /* synthetic */ XmlTag $tag;
                {
                    this.$refs = $refs;
                    this.this$0 = $receiver;
                    this.$tag = $tag;
                }

                public final boolean execute(PsiElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$refs.addAll(VueExtractComponentDataBuilder.access$addElementReferences(this.this$0, it, this.$tag, 0));
                    return true;
                }
            });
            int tagOffset = tag.getTextRange().getStartOffset();
            Intrinsics.checkNotNullExpressionValue((Object)PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)tag), PsiLanguageInjectionHost.class), (String)"findChildrenOfType(...)");
            Iterable $this$forEach$iv2 = hosts;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)element$iv2;
                boolean bl2 = false;
                List list = injManager.getInjectedPsiFiles((PsiElement)host);
                if (list == null) continue;
                Iterable $this$forEach$iv3 = list;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    Pair pair = (Pair)element$iv3;
                    boolean bl3 = false;
                    PsiTreeUtil.processElements((PsiElement)((PsiElement)pair.first), (PsiElementProcessor)new PsiElementProcessor(host, tagOffset, refs, this, tag, (Pair<PsiElement, TextRange>)pair){
                        final /* synthetic */ PsiLanguageInjectionHost $host;
                        final /* synthetic */ int $tagOffset;
                        final /* synthetic */ List<RefData> $refs;
                        final /* synthetic */ VueExtractComponentDataBuilder this$0;
                        final /* synthetic */ XmlTag $tag;
                        final /* synthetic */ Pair<PsiElement, TextRange> $pair;
                        {
                            this.$host = $host;
                            this.$tagOffset = $tagOffset;
                            this.$refs = $refs;
                            this.this$0 = $receiver;
                            this.$tag = $tag;
                            this.$pair = $pair;
                        }

                        public final boolean execute(PsiElement element) {
                            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                            int offset = this.$host.getTextRange().getStartOffset() - this.$tagOffset;
                            this.$refs.addAll(VueExtractComponentDataBuilder.access$addElementReferences(this.this$0, element, this.$tag, offset + ((TextRange)this.$pair.second).getStartOffset()));
                            return true;
                        }
                    });
                }
            }
        }
        return refs;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final List<RefData> addElementReferences(PsiElement element, XmlTag tag, int offset) {
        v0 = element.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getReferences(...)");
        $this$filter$iv /* !! */  = v0;
        $i$f$filter = false;
        var6_6 = $this$filter$iv /* !! */ ;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (PsiReference element$iv$iv : $this$filterTo$iv$iv) {
            it = element$iv$iv;
            $i$a$-filter-VueExtractComponentDataBuilder$addElementReferences$1 = false;
            if (it == null) ** GOTO lbl-1000
            v1 = it instanceof PsiElement != false ? (PsiElement)it : null;
            if (!((v1 != null ? v1.getParent() : null) instanceof PsiReference)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv /* !! */  = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            element$iv$iv = (PsiReference)item$iv$iv;
            var14_17 = destination$iv$iv;
            $i$a$-map-VueExtractComponentDataBuilder$addElementReferences$2 = false;
            Intrinsics.checkNotNull((Object)it);
            var14_17.add(new RefData((PsiReference)it, tag, offset));
        }
        return (List)destination$iv$iv;
    }

    private final String generateNewTemplateContents(Set<String> mapHasDirectUsage) {
        return CollectionsKt.joinToString$default((Iterable)this.list, (CharSequence)"", null, null, (int)0, null, arg_0 -> VueExtractComponentDataBuilder.generateNewTemplateContents$lambda$13(this, mapHasDirectUsage, arg_0), (int)30, null);
    }

    private final XmlTag findTemplate() {
        PsiElement psiElement = PsiTreeUtil.findFirstParent((PsiElement)((PsiElement)this.list.get(0)), arg_0 -> VueExtractComponentDataBuilder.findTemplate$lambda$15(VueExtractComponentDataBuilder::findTemplate$lambda$14, arg_0));
        return psiElement instanceof XmlTag ? (XmlTag)psiElement : null;
    }

    @Nullable
    public final VirtualFile createNewComponent(@NotNull String newComponentName) {
        Intrinsics.checkNotNullParameter((Object)newComponentName, (String)"newComponentName");
        String newText = this.generateNewComponentText(newComponentName);
        PsiDirectory psiDirectory = this.containingFile.getParent();
        if (psiDirectory == null) {
            return null;
        }
        PsiDirectory folder = psiDirectory;
        VirtualFile virtualFile = folder.getVirtualFile().createChildData((Object)this, VueUtilKt.toAsset(newComponentName, true) + ".vue");
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"createChildData(...)");
        VirtualFile virtualFile2 = virtualFile;
        VfsUtil.saveText((VirtualFile)virtualFile2, (String)newText);
        return virtualFile2;
    }

    private final String generateNewComponentText(String newComponentName) {
        Set hasDirectUsageSet = new LinkedHashSet();
        Map hasReplaceMap = new LinkedHashMap();
        Map<XmlTag, List<RefData>> $this$forEach$iv = this.refDataMap;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<XmlTag, List<RefData>>> iterator = $this$forEach$iv.entrySet().iterator();
        block0: while (iterator.hasNext()) {
            Map.Entry<XmlTag, List<RefData>> element$iv;
            Map.Entry<XmlTag, List<RefData>> pair = element$iv = iterator.next();
            boolean bl = false;
            Iterable $this$any$iv = pair.getValue();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) continue;
            for (Object element$iv2 : $this$any$iv) {
                boolean bl2;
                RefData it = (RefData)element$iv2;
                boolean bl3 = false;
                boolean state2 = it.getReplaceRange() == null;
                String refName = it.getRefName();
                Boolean existing = (Boolean)hasReplaceMap.get(refName);
                if (existing != null && !Intrinsics.areEqual((Object)state2, (Object)existing)) {
                    hasDirectUsageSet.add(refName);
                    bl2 = true;
                } else {
                    Boolean bl4 = state2;
                    hasReplaceMap.put(refName, bl4);
                    bl2 = false;
                }
                if (!bl2) continue;
                continue block0;
            }
        }
        Object newText = "<template" + this.langAttribute(this.templateLanguage) + ">\n" + this.generateNewTemplateContents(hasDirectUsageSet) + "\n</template>\n<script" + this.langAttribute(this.scriptLanguage) + ">" + this.generateImports() + "\nexport default {\n  name: '" + newComponentName + "'" + this.generateDescriptorMembers(hasDirectUsageSet) + "\n}\n</script>" + this.copyStyles();
        newText = this.psiOperationOnText((String)newText, (Function1<? super PsiFile, Unit>)((Function1)arg_0 -> VueExtractComponentDataBuilder.generateNewComponentText$lambda$18(this, arg_0)));
        newText = this.psiOperationOnText((String)newText, (Function1<? super PsiFile, Unit>)((Function1)arg_0 -> VueExtractComponentDataBuilder.generateNewComponentText$lambda$19(this, arg_0)));
        return newText;
    }

    private final String psiOperationOnText(String text, Function1<? super PsiFile, Unit> operation) {
        Project project = this.containingFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VueFile dummyFile = VueUtilKt.createVueFileFromText(project, text);
        operation.invoke((Object)dummyFile);
        String string = dummyFile.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private final String copyStyles() {
        if (this.styleTags.isEmpty()) {
            return "";
        }
        return "\n" + CollectionsKt.joinToString$default((Iterable)this.styleTags, (CharSequence)"\n", null, null, (int)0, null, VueExtractComponentDataBuilder::copyStyles$lambda$20, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<XmlTag> findStyles(PsiFile file) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        XmlFile xmlFile = file instanceof XmlFile ? (XmlFile)file : null;
        if (xmlFile == null) {
            return CollectionsKt.emptyList();
        }
        XmlFile xmlFile2 = xmlFile;
        XmlDocument xmlDocument = xmlFile2.getDocument();
        if (xmlDocument == null) {
            return CollectionsKt.emptyList();
        }
        XmlDocument document = xmlDocument;
        PsiElement[] psiElementArray = document.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        Object $this$filter$iv = psiElementArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (PsiElement element$iv$iv : $this$filterTo$iv$iv) {
            PsiElement it = element$iv$iv;
            boolean bl = false;
            XmlTag xmlTag = it instanceof XmlTag ? (XmlTag)it : null;
            if (!Intrinsics.areEqual((Object)"style", (Object)(xmlTag != null ? xmlTag.getName() : null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiElement element$iv$iv;
            element$iv$iv = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlTag");
            collection.add((XmlTag)it);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void optimizeAndRemoveEmptyStyles(PsiFile file) {
        void $this$filterTo$iv$iv;
        Object element$iv2;
        List currentlyUnused = CssUnusedSymbolUtils.getUnusedStyles((PsiFile)file);
        currentlyUnused.removeAll((Collection)this.unusedStylesInExistingComponent);
        Intrinsics.checkNotNull((Object)currentlyUnused);
        Iterable $this$forEach$iv = currentlyUnused;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            CssSelectorSuffix suffix = (CssSelectorSuffix)element$iv2;
            boolean bl = false;
            RemoveUnusedSymbolIntentionAction.removeUnused((PsiElement)((PsiElement)suffix));
        }
        Iterable $this$filter$iv = this.findStyles(file);
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            XmlTag styleTag = (XmlTag)element$iv$iv;
            boolean bl = false;
            if (!(styleTag.isValid() && PsiTreeUtil.processElements((PsiElement)((PsiElement)styleTag), (PsiElementProcessor)new PsiElementProcessor(this){
                final /* synthetic */ VueExtractComponentDataBuilder this$0;
                {
                    this.this$0 = $receiver;
                }

                public final boolean execute(PsiElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !Intrinsics.areEqual((Object)CssElementTypes.CSS_RULESET_LIST, (Object)it.getNode().getElementType()) || !VueExtractComponentDataBuilder.access$hasMeaningfulChildren(this.this$0, it);
                }
            }))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toDelete2 = (List)destination$iv$iv;
        Iterable $this$forEach$iv2 = toDelete2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            XmlTag styleTag = (XmlTag)element$iv3;
            boolean bl = false;
            styleTag.delete();
        }
    }

    private final boolean hasMeaningfulChildren(PsiElement element) {
        PsiElement[] psiElementArray = element.getChildren();
        return !PsiTreeUtil.processElements((PsiElementProcessor)hasMeaningfulChildren.1.INSTANCE, (PsiElement[])Arrays.copyOf(psiElementArray, psiElementArray.length));
    }

    private final String langAttribute(String lang) {
        String string = lang;
        return string == null ? "" : " lang=\"" + string + "\"";
    }

    private final String generateImports() {
        if (this.importsToCopy.isEmpty()) {
            return "";
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)this.importsToCopy.keySet()), (CharSequence)"\n", (CharSequence)"\n", null, (int)0, null, arg_0 -> VueExtractComponentDataBuilder.generateImports$lambda$26(this, arg_0), (int)28, null);
    }

    private final String generateDescriptorMembers(Set<String> mapHasDirectUsage) {
        List members = new ArrayList();
        if (!this.importsToCopy.isEmpty()) {
            members.add(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)this.importsToCopy.keySet()), (CharSequence)", ", (CharSequence)",\ncomponents: {", (CharSequence)"}", (int)0, null, null, (int)56, null));
        }
        if (!this.refDataMap.isEmpty()) {
            members.add(CollectionsKt.joinToString$default((Iterable)this.sortedProps(true), (CharSequence)",\n", (CharSequence)",\nprops: {\n", (CharSequence)"\n}", (int)0, null, arg_0 -> VueExtractComponentDataBuilder.generateDescriptorMembers$lambda$27(mapHasDirectUsage, arg_0), (int)24, null));
        }
        return CollectionsKt.joinToString$default((Iterable)members, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    public final void modifyCurrentComponent(@NotNull String newComponentName, @NotNull PsiFile currentFile, @NotNull PsiFile newPsiFile) {
        Intrinsics.checkNotNullParameter((Object)newComponentName, (String)"newComponentName");
        Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
        Intrinsics.checkNotNullParameter((Object)newPsiFile, (String)"newPsiFile");
        VueComponentSourceEdit vueComponentSourceEdit = VueComponentSourceEdit.Companion.create(VueModelManager.Companion.findEnclosingContainer((PsiElement)currentFile));
        if (vueComponentSourceEdit != null) {
            vueComponentSourceEdit.insertComponentImport(newComponentName, (PsiElement)newPsiFile);
        }
        this.optimizeUnusedComponentsAndImports(currentFile);
    }

    @NotNull
    public final PsiElement replaceWithNewTag(@NotNull String replaceName) {
        Intrinsics.checkNotNullParameter((Object)replaceName, (String)"replaceName");
        this.unusedStylesInExistingComponent = CssUnusedSymbolUtils.getUnusedStyles((PsiFile)this.containingFile);
        XmlTag leader = this.list.get(0);
        String newTagName = VueUtilKt.toAsset(replaceName, true);
        Object[] objectArray = new String[]{"pug", "jade"};
        String replaceText = CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])objectArray), (Object)this.templateLanguage) ? "<template lang=\"pug\">\n" + newTagName + "(" + this.generateProps() + ")\n</template>" : "<template><" + newTagName + " " + this.generateProps() + "/></template>";
        Project project = leader.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VueFile dummyFile = VueUtilKt.createVueFileFromText(project2, replaceText);
        PsiElement psiElement = PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)dummyFile), XmlTag.class);
        Intrinsics.checkNotNull((Object)psiElement);
        XmlTag template = (XmlTag)psiElement;
        PsiElement psiElement2 = PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)template), XmlTag.class);
        Intrinsics.checkNotNull((Object)psiElement2);
        XmlTag newTag = (XmlTag)psiElement2;
        PsiElement newlyAdded = leader.replace((PsiElement)newTag);
        Iterable $this$forEach$iv = this.list.subList(1, this.list.size());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XmlTag it = (XmlTag)element$iv;
            boolean bl = false;
            it.delete();
        }
        Intrinsics.checkNotNull((Object)newlyAdded);
        return newlyAdded;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void optimizeUnusedComponentsAndImports(PsiFile file) {
        block9: {
            var3_2 = VueUtilKt.objectLiteralFor(VueUtilKt.findDefaultExport((PsiElement)VueFrameworkHandlerKt.findModule((PsiElement)file, false)));
            if (var3_2 == null || (var4_3 = var3_2.findProperty("components")) == null || (var5_4 = var4_3.getValue()) == null) ** GOTO lbl-1000
            var7_6 = var5_4;
            $i$f$asSafely = false;
            v0 = $this$asSafely$iv;
            if (!(v0 instanceof JSObjectLiteralExpression)) {
                v0 = null;
            }
            if ((var6_9 = (JSProperty[])v0) != null) {
                v1 = var6_9.getProperties();
            } else lbl-1000:
            // 2 sources

            {
                v1 = null;
            }
            componentsInitializer = v1;
            var3_2 = componentsInitializer;
            if (var3_2 == null || ((JSObjectLiteralExpression)var3_2).length == 0 != false) break block9;
            $this$map$iv = componentsInitializer;
            $i$f$map = false;
            var6_9 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>($this$map$iv.length);
            $i$f$mapTo = false;
            var10_12 = $this$mapTo$iv$iv.length;
            for (var9_11 = 0; var9_11 < var10_12; ++var9_11) {
                var12_14 = item$iv$iv = $this$mapTo$iv$iv[var9_11];
                var14_16 = destination$iv$iv;
                $i$a$-map-VueExtractComponentDataBuilder$optimizeUnusedComponentsAndImports$names$1 = false;
                v2 = it.getName();
                if (v2 == null) {
                    v2 = "";
                }
                var14_16.add(VueUtilKt.toAsset(v2, true));
            }
            names = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
            Intrinsics.checkNotNull((Object)file, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
            ((XmlFile)file).accept((PsiElementVisitor)new VueFileVisitor(names, this){
                final /* synthetic */ Set<String> $names;
                final /* synthetic */ VueExtractComponentDataBuilder this$0;
                {
                    this.$names = $names;
                    this.this$0 = $receiver;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (element instanceof XmlTag) {
                        String string = ((XmlTag)element).getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        this.$names.remove(VueUtilKt.toAsset(string, true));
                    }
                    if (!Intrinsics.areEqual((Object)VueExtractComponentDataBuilder.access$getScriptTag$p(this.this$0), (Object)element)) {
                        this.recursion(element);
                    }
                }
            });
            $this$filter$iv /* !! */  = componentsInitializer;
            $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv /* !! */ ;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            var10_12 = ((void)$this$filterTo$iv$iv).length;
            for (var9_11 = 0; var9_11 < var10_12; ++var9_11) {
                it = element$iv$iv = $this$filterTo$iv$iv[var9_11];
                $i$a$-filter-VueExtractComponentDataBuilder$optimizeUnusedComponentsAndImports$2 = false;
                if (it.getName() == null) ** GOTO lbl-1000
                v3 = it.getName();
                Intrinsics.checkNotNull((Object)v3);
                if (names.contains(VueUtilKt.toAsset(v3, true))) {
                    v4 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = false;
                }
                if (!v4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv /* !! */  = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (E element$iv : $this$forEach$iv) {
                it = (JSProperty)element$iv;
                $i$a$-forEach-VueExtractComponentDataBuilder$optimizeUnusedComponentsAndImports$3 = false;
                it.delete();
            }
        }
        ES6CreateImportUtil.optimizeImports((PsiElement)((PsiElement)file));
        this.optimizeAndRemoveEmptyStyles(file);
    }

    private final String generateProps() {
        return CollectionsKt.joinToString$default((Iterable)this.sortedProps(true), (CharSequence)" ", null, null, (int)0, null, VueExtractComponentDataBuilder::generateProps$lambda$32, (int)30, null);
    }

    private final List<RefData> sortedProps(boolean distinct) {
        List list;
        List flatten = CollectionsKt.flatten((Iterable)this.refDataMap.values());
        if (distinct) {
            Iterable $this$distinctBy$iv = flatten;
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                RefData it = (RefData)e$iv;
                boolean bl = false;
                String key$iv = it.getRefName();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            list = list$iv;
        } else {
            list = flatten;
        }
        Iterable $this$sortedBy$iv = list;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                RefData it = (RefData)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getRefName());
                it = (RefData)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getRefName())));
            }
        });
    }

    private static final Sequence processVueComponent$lambda$1(JSExecutionScope it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiElement[] psiElementArray = JSResolveUtil.getStubbedChildren((PsiElement)((PsiElement)it), (TokenSet)ES6ImportPsiUtil.ES6_IMPORT_DECLARATION);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getStubbedChildren(...)");
        return ArraysKt.asSequence((Object[])psiElementArray);
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence generateNewTemplateContents$lambda$13(VueExtractComponentDataBuilder this$0, Set $mapHasDirectUsage, XmlTag tag) {
        List replaces;
        List list;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        StringBuilder sb = new StringBuilder(tag.getText());
        int tagStart = tag.getTextRange().getStartOffset();
        List<RefData> list2 = this$0.refDataMap.get(tag);
        if (list2 != null) {
            void $this$sortedByDescending$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = list2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Trinity it$iv$iv;
                TextRange absRange;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                RefData it = (RefData)element$iv$iv;
                boolean bl2 = false;
                if (($mapHasDirectUsage.contains(it.getRefName()) ? null : (it.getReplaceRange() == null ? null : new Trinity((Object)(absRange.getStartOffset() - tagStart), (Object)(absRange.getEndOffset() - tagStart), (Object)it.getRefName()))) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$sortedByDescending = false;
            list = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Trinity it = (Trinity)b;
                    boolean bl = false;
                    it = (Trinity)a;
                    Comparable comparable = (Integer)it.first;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Integer)it.first));
                }
            });
        } else {
            list = null;
        }
        List list3 = replaces = list;
        if (list3 != null) {
            Iterable $this$forEach$iv = list3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Trinity it = (Trinity)element$iv;
                boolean bl = false;
                Object object = it.first;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
                int n = ((Number)object).intValue();
                Object object2 = it.second;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"second");
                sb.replace(n, ((Number)object2).intValue(), (String)it.third);
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final boolean findTemplate$lambda$14(PsiElement it) {
        XmlTag xmlTag = it instanceof XmlTag ? (XmlTag)it : null;
        return Intrinsics.areEqual((Object)"template", (Object)(xmlTag != null ? xmlTag.getName() : null));
    }

    private static final boolean findTemplate$lambda$15(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit generateNewComponentText$lambda$18(VueExtractComponentDataBuilder this$0, PsiFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.optimizeAndRemoveEmptyStyles(it);
        return Unit.INSTANCE;
    }

    private static final Unit generateNewComponentText$lambda$19(VueExtractComponentDataBuilder this$0, PsiFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CodeStyleManager.getInstance((Project)this$0.containingFile.getProject()).reformatText(it, 0, it.getTextRange().getEndOffset());
        return Unit.INSTANCE;
    }

    private static final CharSequence copyStyles$lambda$20(XmlTag it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final CharSequence generateImports$lambda$26(VueExtractComponentDataBuilder this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ES6ImportDeclaration eS6ImportDeclaration = this$0.importsToCopy.get(it);
        Intrinsics.checkNotNull((Object)eS6ImportDeclaration);
        Object object = eS6ImportDeclaration.getFromClause();
        if (object == null || (object = object.getReferenceText()) == null) {
            object = "''";
        }
        return "import " + it + " from " + (String)object;
    }

    private static final CharSequence generateDescriptorMembers$lambda$27(Set $mapHasDirectUsage, RefData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getRefName() + ": " + ($mapHasDirectUsage.contains(it.getRefName()) ? "{ type: Function }" : "{}");
    }

    private static final CharSequence generateProps$lambda$32(RefData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ":" + VueUtilKt.fromAsset$default(it.getRefName(), false, 2, null) + "=\"" + it.getExpressionText() + "\"";
    }

    public static final /* synthetic */ XmlTag access$getScriptTag$p(VueExtractComponentDataBuilder $this) {
        return $this.scriptTag;
    }

    public static final /* synthetic */ List access$addElementReferences(VueExtractComponentDataBuilder $this, PsiElement element, XmlTag tag, int offset) {
        return $this.addElementReferences(element, tag, offset);
    }

    public static final /* synthetic */ boolean access$hasMeaningfulChildren(VueExtractComponentDataBuilder $this, PsiElement element) {
        return $this.hasMeaningfulChildren(element);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0006\u0010\u0016\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/vuejs/intentions/extractComponent/VueExtractComponentDataBuilder$RefData;", "", "ref", "Lcom/intellij/psi/PsiReference;", "tag", "Lcom/intellij/psi/xml/XmlTag;", "offset", "", "<init>", "(Lcom/intellij/psi/PsiReference;Lcom/intellij/psi/xml/XmlTag;I)V", "getRef", "()Lcom/intellij/psi/PsiReference;", "getTag", "()Lcom/intellij/psi/xml/XmlTag;", "getOffset", "()I", "getRefName", "", "resolve", "Lcom/intellij/psi/PsiElement;", "getReplaceRange", "Lcom/intellij/openapi/util/TextRange;", "getExpressionText", "intellij.vuejs"})
    @SourceDebugExtension(value={"SMAP\nVueExtractComponentDataBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueExtractComponentDataBuilder.kt\norg/jetbrains/vuejs/intentions/extractComponent/VueExtractComponentDataBuilder$RefData\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,310:1\n19#2:311\n19#2:312\n*S KotlinDebug\n*F\n+ 1 VueExtractComponentDataBuilder.kt\norg/jetbrains/vuejs/intentions/extractComponent/VueExtractComponentDataBuilder$RefData\n*L\n291#1:311\n296#1:312\n*E\n"})
    private static final class RefData {
        @NotNull
        private final PsiReference ref;
        @NotNull
        private final XmlTag tag;
        private final int offset;

        public RefData(@NotNull PsiReference ref, @NotNull XmlTag tag, int offset) {
            Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            this.ref = ref;
            this.tag = tag;
            this.offset = offset;
        }

        @NotNull
        public final PsiReference getRef() {
            return this.ref;
        }

        @NotNull
        public final XmlTag getTag() {
            return this.tag;
        }

        public final int getOffset() {
            return this.offset;
        }

        @NotNull
        public final String getRefName() {
            Object object;
            PsiReference psiReference = this.ref;
            JSReferenceExpression jSReferenceExpression = psiReference instanceof JSReferenceExpression ? (JSReferenceExpression)psiReference : null;
            if (jSReferenceExpression == null) {
                String string = this.ref.getCanonicalText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
                return string;
            }
            JSReferenceExpression jsRef = jSReferenceExpression;
            JSExpression $this$asSafely$iv = JSResolveUtil.getLeftmostQualifier((JSExpression)((JSExpression)jsRef));
            boolean $i$f$asSafely = false;
            JSExpression jSExpression = $this$asSafely$iv;
            if (!(jSExpression instanceof JSReferenceExpression)) {
                jSExpression = null;
            }
            if ((object = (JSReferenceExpression)jSExpression) == null || (object = object.getReferenceName()) == null) {
                String string = ((JSReferenceExpression)this.ref).getCanonicalText();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
            }
            return object;
        }

        @Nullable
        public final PsiElement resolve() {
            PsiReference psiReference = this.ref;
            JSReferenceExpression jSReferenceExpression = psiReference instanceof JSReferenceExpression ? (JSReferenceExpression)psiReference : null;
            if (jSReferenceExpression == null) {
                return this.ref.resolve();
            }
            JSReferenceExpression jsRef = jSReferenceExpression;
            JSExpression $this$asSafely$iv = JSResolveUtil.getLeftmostQualifier((JSExpression)((JSExpression)jsRef));
            boolean $i$f$asSafely = false;
            JSExpression jSExpression = $this$asSafely$iv;
            if (!(jSExpression instanceof JSReferenceExpression)) {
                jSExpression = null;
            }
            JSReferenceExpression jSReferenceExpression2 = (JSReferenceExpression)jSExpression;
            return jSReferenceExpression2 != null ? jSReferenceExpression2.resolve() : null;
        }

        @Nullable
        public final TextRange getReplaceRange() {
            PsiReference psiReference = this.ref;
            PsiElement psiElement = psiReference instanceof PsiElement ? (PsiElement)psiReference : null;
            PsiElement psiElement2 = psiElement != null ? psiElement.getParent() : null;
            JSCallExpression jSCallExpression = psiElement2 instanceof JSCallExpression ? (JSCallExpression)psiElement2 : null;
            if (jSCallExpression == null) {
                return null;
            }
            JSCallExpression call = jSCallExpression;
            TextRange range = call.getTextRange();
            return new TextRange(this.offset + range.getStartOffset(), this.offset + range.getEndOffset());
        }

        @NotNull
        public final String getExpressionText() {
            PsiReference psiReference = this.ref;
            PsiElement psiElement = psiReference instanceof PsiElement ? (PsiElement)psiReference : null;
            Object object = psiElement != null ? psiElement.getParent() : null;
            Object object2 = object instanceof JSCallExpression ? (JSCallExpression)object : null;
            if (object2 == null || (object2 = object2.getText()) == null) {
                return this.getRefName();
            }
            return object2;
        }
    }
}

