/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JavaScriptInspection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ConfusingFloatingPointLiteralJSInspection
extends JavaScriptInspection {
    @NonNls
    private static final Pattern pickyFloatingPointPattern = Pattern.compile("[0-9]+\\.[0-9]+((e|E)(-)?[0-9]+)?(f|F|d|D)?");

    @Override
    @NotNull
    @InspectionMessage
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("confusing.floating.point.literal.problem.descriptor", new Object[0]);
        if (string == null) {
            ConfusingFloatingPointLiteralJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return new ConfusingFloatingPointLiteralFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConfusingFloatingPointLiteralVisitor();
    }

    private static boolean isConfusing(String text) {
        Matcher matcher = pickyFloatingPointPattern.matcher(text);
        return !matcher.matches();
    }

    private static boolean isFloatingPoint(JSLiteralExpression literal) {
        if (!literal.isNumericLiteral()) {
            return false;
        }
        String text = literal.getText();
        if (text == null) {
            return false;
        }
        char firstChar = text.charAt(0);
        if (firstChar != '.' && !Character.isDigit(firstChar)) {
            return false;
        }
        if (text.startsWith("0x")) {
            return false;
        }
        return text.contains(".") || text.contains("e") || text.contains("E");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/confusing/ConfusingFloatingPointLiteralJSInspection", "buildErrorString"));
    }

    private static class ConfusingFloatingPointLiteralFix
    extends InspectionJSFix {
        private ConfusingFloatingPointLiteralFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("confusing.floating.point.literal.change.quickfix", new Object[0]);
            if (string == null) {
                ConfusingFloatingPointLiteralFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            JSExpression literalExpression = (JSExpression)descriptor.getPsiElement();
            String text = literalExpression.getText();
            String newText = ConfusingFloatingPointLiteralFix.getCanonicalForm(text);
            ConfusingFloatingPointLiteralFix.replaceExpression(literalExpression, newText);
        }

        private static String getCanonicalForm(String text) {
            String prefix;
            String suffix;
            if (text.indexOf(101) > 0) {
                breakPoint = text.indexOf(101);
                suffix = text.substring(breakPoint);
                prefix = text.substring(0, breakPoint);
            } else if (text.indexOf(69) > 0) {
                breakPoint = text.indexOf(69);
                suffix = text.substring(breakPoint);
                prefix = text.substring(0, breakPoint);
            } else if (text.indexOf(102) > 0) {
                breakPoint = text.indexOf(102);
                suffix = text.substring(breakPoint);
                prefix = text.substring(0, breakPoint);
            } else if (text.indexOf(70) > 0) {
                breakPoint = text.indexOf(70);
                suffix = text.substring(breakPoint);
                prefix = text.substring(0, breakPoint);
            } else if (text.indexOf(100) > 0) {
                breakPoint = text.indexOf(100);
                suffix = text.substring(breakPoint);
                prefix = text.substring(0, breakPoint);
            } else if (text.indexOf(68) > 0) {
                breakPoint = text.indexOf(68);
                suffix = text.substring(breakPoint);
                prefix = text.substring(0, breakPoint);
            } else {
                suffix = "";
                prefix = text;
            }
            int indexPoint = prefix.indexOf(46);
            if (indexPoint < 0) {
                return prefix + ".0" + suffix;
            }
            if (indexPoint == 0) {
                return "0" + prefix + suffix;
            }
            return prefix + "0" + suffix;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/confusing/ConfusingFloatingPointLiteralJSInspection$ConfusingFloatingPointLiteralFix", "getFamilyName"));
        }
    }

    private static class ConfusingFloatingPointLiteralVisitor
    extends BaseInspectionVisitor {
        private ConfusingFloatingPointLiteralVisitor() {
        }

        @Override
        public void visitJSLiteralExpression(@NotNull JSLiteralExpression literal) {
            if (literal == null) {
                ConfusingFloatingPointLiteralVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSLiteralExpression(literal);
            if (!ConfusingFloatingPointLiteralJSInspection.isFloatingPoint(literal)) {
                return;
            }
            String text = literal.getText();
            if (!ConfusingFloatingPointLiteralJSInspection.isConfusing(text)) {
                return;
            }
            this.registerError((PsiElement)literal);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/sixrr/inspectjs/confusing/ConfusingFloatingPointLiteralJSInspection$ConfusingFloatingPointLiteralVisitor", "visitJSLiteralExpression"));
        }
    }
}

