/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.config.JSImportsValues;
import com.intellij.lang.javascript.config.JSModuleResolution;
import com.intellij.lang.javascript.config.JSModuleTarget;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathMappings;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigBase;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigCustomizer;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigFileReferenceSet;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigParsingUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.checkers.TypeScriptConfigIncludeBase;
import com.intellij.lang.typescript.tsconfig.checkers.TypeScriptConfigPatternInclude;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TypeScriptConfigImpl
extends TypeScriptConfigBase {
    private static final String CONFIG_DIR_TEMPLATE = "${configDir}";
    private final NullableLazyValue<VirtualFile> myRootDirValue;
    @NotNull
    private final VirtualFile myConfigFile;
    @NotNull
    private final Map<String, Object> myOptions;
    @NotNull
    private final VirtualFile myConfigDirectory;
    @NotNull
    private final VirtualFile myConfigDirTemplateValue;
    @NotNull
    private final NotNullLazyValue<Collection<VirtualFile>> myFilesList;
    private final NotNullLazyValue<Collection<VirtualFile>> myReferencesList;
    @NotNull
    private final Collection<String> myExcludePatterns;
    @NotNull
    private final Collection<String> myIncludedPatterns;
    @NotNull
    private final Collection<String> myModuleSuffixes;
    private final boolean myAllowJs;
    private final boolean myCheckJs;
    private final boolean mySuppressExcessPropertyChecks;
    @NotNull
    private final TypeScriptConfig.LanguageTarget myLanguageTarget;
    private final boolean myHasFilesList;
    private final boolean myHasIncludeList;
    private final boolean myHasExcludeList;
    private final boolean myHasReferences;
    @NotNull
    private final Collection<String> myRootDirs;
    @NotNull
    private final JSModulePathMappings<JSModulePathSubstitution> myPaths;
    @Nullable
    private final String myBaseUrl;
    private final boolean myInlineSourceMap;
    private final boolean mySourceMap;
    @NotNull
    private final List<VirtualFile> myExtendsPaths;
    @NotNull
    private final Project myProject;
    private final boolean myHasErrors;
    private final boolean myDirectoryBased;
    @Nullable
    private final String myModuleResolution;
    @Nullable
    private final String myModule;
    @NotNull
    private final List<String> myPlugins;
    private final boolean myHasExplicitCompileOnSave;
    private final boolean myCompileOnSave;
    private final boolean myNoImplicitAny;
    private final boolean myNoImplicitThis;
    private final boolean myStrictNullChecks;
    private final boolean myStrictBindCallApply;
    private final boolean myStrict;
    private final boolean myNoLib;
    private final boolean myPreserveSymlinks;
    private final boolean myKeyofStringsOnly;
    private final boolean myVerbatimModuleSyntax;
    private final boolean myExperimentalDecorators;
    private final boolean myComposite;
    private final boolean myAllowImportingTsExtensions;
    @Nullable
    private final String myJsx;
    @NotNull
    private final Collection<String> myTypeRoots;
    private final Collection<String> myLibs;
    @NotNull
    private final Collection<String> myTypes;
    private final NotNullLazyValue<Collection<VirtualFile>> myTypeRootFiles;
    private final NullableLazyValue<VirtualFile> myBaseUrlFile;
    private final NotNullLazyValue<Collection<PsiFileSystemItem>> myRootDirPsiElements;
    private final NotNullLazyValue<Collection<VirtualFile>> myRootDirFiles;
    @NotNull
    private final Map<Key<?>, Object> myCustomData;

    @Nullable
    @RequiresReadLock
    static TypeScriptConfigImpl getSimpleConfigImpl(@NotNull PsiFile rawFile, @Nullable VirtualFile configDirTemplateValue) {
        VirtualFile configDirectory;
        if (rawFile == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(0);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (configDirTemplateValue == null) {
            return null;
        }
        if (!(rawFile instanceof JsonFile)) {
            return null;
        }
        JsonFile file = (JsonFile)rawFile;
        VirtualFile configVirtualFile = file.getVirtualFile();
        VirtualFile virtualFile = configDirectory = configVirtualFile != null ? configVirtualFile.getParent() : null;
        if (configDirectory == null) {
            return null;
        }
        Map dirTemplateToConfigCache = (Map)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create((Object)ContainerUtil.createConcurrentWeakMap(), (Object[])new Object[]{file}));
        return dirTemplateToConfigCache.computeIfAbsent(configDirTemplateValue, dirTemplate -> {
            Pair result2 = (Pair)AstLoadingFilter.forceAllowTreeLoading((PsiFile)file, () -> Pair.pair((Object)((JsonObject)PsiTreeUtil.getChildOfType((PsiElement)file, JsonObject.class)), (Object)PsiTreeUtil.hasErrorElements((PsiElement)file)));
            JsonObject jsonObject = (JsonObject)result2.first;
            boolean hasErrors = (Boolean)result2.second;
            Project project = file.getProject();
            return jsonObject == null ? new TypeScriptConfigImpl(project, configVirtualFile, configDirectory, (VirtualFile)dirTemplate, hasErrors) : new TypeScriptConfigImpl(project, configVirtualFile, configDirectory, (VirtualFile)dirTemplate, jsonObject, hasErrors);
        });
    }

    @NotNull
    List<VirtualFile> getExtendsParents() {
        List<VirtualFile> list = this.myExtendsPaths;
        if (list == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    private static Collection<VirtualFile> getReferences(@Nullable JsonProperty references) {
        if (references == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(2);
            }
            return list;
        }
        JsonValue value = references.getValue();
        if (!(value instanceof JsonArray)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(3);
            }
            return list;
        }
        JsonArray arrayWithFiles = (JsonArray)value;
        LinkedHashSet<VirtualFile> files = new LinkedHashSet<VirtualFile>();
        for (JsonValue jsonValue : arrayWithFiles.getValueList()) {
            VirtualFile configCandidate;
            JsonValue pathValue;
            JsonProperty path2;
            if (!(jsonValue instanceof JsonObject) || (path2 = ((JsonObject)jsonValue).findProperty("path")) == null || !((pathValue = path2.getValue()) instanceof JsonStringLiteral) || (configCandidate = TypeScriptConfigImpl.resolveConfigFile((JsonStringLiteral)pathValue)) == null) continue;
            files.add(configCandidate);
        }
        LinkedHashSet<VirtualFile> linkedHashSet = files;
        if (linkedHashSet == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(4);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Collection<VirtualFile> getFiles(@Nullable JsonProperty filesProperty, @NotNull VirtualFile configDirTemplateValue) {
        if (configDirTemplateValue == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(5);
        }
        if (filesProperty == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(6);
            }
            return list;
        }
        JsonValue value = filesProperty.getValue();
        if (!(value instanceof JsonArray)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(7);
            }
            return list;
        }
        JsonArray arrayWithFiles = (JsonArray)value;
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)filesProperty);
        if (file == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(8);
            }
            return list;
        }
        VirtualFile parentDirectory = file.getParent();
        if (parentDirectory == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(9);
            }
            return list;
        }
        for (JsonValue jsonValue : arrayWithFiles.getValueList()) {
            String substitutedValue;
            VirtualFile path2;
            if (!(jsonValue instanceof JsonStringLiteral)) continue;
            ProgressManager.checkCanceled();
            String stringValue = ((JsonStringLiteral)jsonValue).getValue();
            if (StringUtil.isEmptyOrSpaces((String)stringValue) || (path2 = TypeScriptUtil.getFileByRelativePath(substitutedValue, (substitutedValue = TypeScriptConfigImpl.substituteConfigDirTemplate(stringValue, configDirTemplateValue)).startsWith("/") ? null : parentDirectory, parentDirectory.getFileSystem())) == null) continue;
            files.add(path2);
        }
        HashSet<VirtualFile> hashSet = files;
        if (hashSet == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    @NotNull
    private static Map<String, Object> getCompilerOptions(@Nullable JsonValue value) {
        HashMap<String, Object> result2 = new HashMap<String, Object>();
        if (!(value instanceof JsonObject)) {
            HashMap<String, Object> hashMap = result2;
            if (hashMap == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(11);
            }
            return hashMap;
        }
        JsonObject jsonObject = (JsonObject)value;
        for (JsonProperty property : jsonObject.getPropertyList()) {
            Object optionText;
            String optionName = property.getName();
            JsonValue optionValue = property.getValue();
            if (optionValue == null || (optionText = TypeScriptConfigImpl.extractValue(optionValue)) == null) continue;
            result2.put(StringUtil.unquoteString((String)optionName), optionText);
        }
        HashMap<String, Object> hashMap = result2;
        if (hashMap == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(12);
        }
        return hashMap;
    }

    @Nullable
    private static Object extractValue(@NotNull JsonValue optionValue) {
        if (optionValue == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(13);
        }
        if (optionValue instanceof JsonStringLiteral) {
            return ((JsonStringLiteral)optionValue).getValue();
        }
        if (optionValue instanceof JsonBooleanLiteral) {
            return ((JsonBooleanLiteral)optionValue).getValue();
        }
        if (optionValue instanceof JsonNumberLiteral) {
            double value = ((JsonNumberLiteral)optionValue).getValue();
            return Double.valueOf(value).intValue();
        }
        if (optionValue instanceof JsonArray) {
            return ContainerUtil.mapNotNull((Collection)((JsonArray)optionValue).getValueList(), TypeScriptConfigImpl::extractValue);
        }
        if (optionValue instanceof JsonObject) {
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            for (JsonProperty property : ((JsonObject)optionValue).getPropertyList()) {
                JsonValue value = property.getValue();
                String name = property.getName();
                Object extractedValue = value == null ? null : TypeScriptConfigImpl.extractValue(value);
                map2.put(name, extractedValue);
            }
            return map2;
        }
        return null;
    }

    private TypeScriptConfigImpl(@NotNull Project project, @NotNull VirtualFile configFile, @NotNull VirtualFile configDirectory, @NotNull VirtualFile configDirTemplateValue, boolean hasErrors) {
        NotNullLazyValue empty2;
        if (project == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(14);
        }
        if (configFile == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(15);
        }
        if (configDirectory == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(16);
        }
        if (configDirTemplateValue == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(17);
        }
        this.myRootDirValue = NullableLazyValue.lazyNullable(() -> {
            String dir = this.getRootDir();
            if (dir == null) {
                return null;
            }
            return JSPathMappingsUtil.getRelativeOrAbsoluteFilePath(this.substituteConfigDirTemplate(dir), this.getConfigDirectory());
        });
        this.myPlugins = new ArrayList<String>();
        this.myRootDirPsiElements = NotNullLazyValue.lazy((Supplier)new Supplier<Collection<PsiFileSystemItem>>(){

            @Override
            public Collection<PsiFileSystemItem> get() {
                if (TypeScriptConfigImpl.this.myRootDirs.isEmpty()) {
                    return ContainerUtil.emptyList();
                }
                return ContainerUtil.mapNotNull(TypeScriptConfigImpl.this.myRootDirs, filePath -> {
                    VirtualFile path2 = JSPathMappingsUtil.getRelativeOrAbsoluteFilePath(TypeScriptConfigImpl.this.substituteConfigDirTemplate((String)filePath), TypeScriptConfigImpl.this.getConfigDirectory());
                    if (path2 != null) {
                        return PsiManager.getInstance((Project)TypeScriptConfigImpl.this.myProject).findDirectory(path2);
                    }
                    return null;
                });
            }
        });
        this.myRootDirFiles = NotNullLazyValue.lazy(() -> {
            Collection dirs = (Collection)this.myRootDirPsiElements.getValue();
            return ContainerUtil.map((Collection)dirs, PsiFileSystemItem::getVirtualFile);
        });
        this.myConfigFile = configFile;
        this.myConfigDirectory = configDirectory;
        this.myConfigDirTemplateValue = configDirTemplateValue;
        this.myOptions = new HashMap<String, Object>();
        this.myFilesList = empty2 = NotNullLazyValue.createConstantValue((Object)ContainerUtil.emptyList());
        this.myReferencesList = empty2;
        this.myIncludedPatterns = ContainerUtil.emptyList();
        this.myExcludePatterns = DEFAULT_EXCLUDE_VALUES;
        this.myLanguageTarget = DEFAULT_LANGUAGE_TARGET;
        this.myRootDirs = ContainerUtil.emptyList();
        this.myPaths = JSModulePathMappings.empty();
        this.myBaseUrl = null;
        this.myProject = project;
        this.myHasErrors = hasErrors;
        this.myDirectoryBased = true;
        this.myInlineSourceMap = false;
        this.mySourceMap = false;
        this.myLibs = ContainerUtil.emptyList();
        this.myModuleResolution = null;
        this.myModule = null;
        this.myVerbatimModuleSyntax = false;
        this.myAllowImportingTsExtensions = false;
        this.myTypeRoots = ContainerUtil.emptyList();
        this.myTypes = ContainerUtil.emptyList();
        this.myModuleSuffixes = ContainerUtil.emptyList();
        this.myExtendsPaths = ContainerUtil.emptyList();
        this.myHasFilesList = false;
        this.myHasIncludeList = false;
        this.myHasExcludeList = false;
        this.myHasReferences = false;
        this.myAllowJs = false;
        this.myCheckJs = false;
        this.mySuppressExcessPropertyChecks = false;
        this.myHasExplicitCompileOnSave = false;
        this.myNoImplicitAny = false;
        this.myNoImplicitThis = false;
        this.myStrictNullChecks = false;
        this.myStrictBindCallApply = false;
        this.myStrict = false;
        this.myNoLib = false;
        this.myPreserveSymlinks = false;
        this.myKeyofStringsOnly = false;
        this.myExperimentalDecorators = false;
        this.myJsx = null;
        this.myComposite = false;
        this.myTypeRootFiles = NotNullLazyValue.lazy(() -> {
            if (this.myTypeRoots.isEmpty()) {
                VirtualFile defaultTypesDirectory = TypeScriptConfigUtil.finDefaultTypesDirectory(this.getConfigFile());
                return ContainerUtil.createMaybeSingletonList((Object)defaultTypesDirectory);
            }
            ArrayList<VirtualFile> results = new ArrayList<VirtualFile>();
            for (String root : this.myTypeRoots) {
                VirtualFile path2;
                if (StringUtil.isEmpty((String)root) || (path2 = JSPathMappingsUtil.getRelativeOrAbsoluteFilePath(this.substituteConfigDirTemplate(root), this.getConfigDirectory())) == null) continue;
                results.add(path2);
            }
            return results;
        });
        this.myBaseUrlFile = NullableLazyValue.lazyNullable(() -> null);
        this.myCustomData = Map.of();
        this.myCompileOnSave = false;
    }

    @NotNull
    private String substituteConfigDirTemplate(@NotNull String path2) {
        if (path2 == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(18);
        }
        return TypeScriptConfigImpl.substituteConfigDirTemplate(path2, this.myConfigDirTemplateValue);
    }

    @NotNull
    private static String substituteConfigDirTemplate(@NotNull String path2, @NotNull VirtualFile configDirTemplateValue) {
        if (path2 == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(19);
        }
        if (configDirTemplateValue == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(20);
        }
        if (path2.startsWith(CONFIG_DIR_TEMPLATE)) {
            String string = configDirTemplateValue.getPath() + path2.substring(CONFIG_DIR_TEMPLATE.length());
            if (string == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(21);
            }
            return string;
        }
        String string = path2;
        if (string == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Override
    public boolean hasExcludeList() {
        return this.myHasExcludeList;
    }

    private TypeScriptConfigImpl(@NotNull Project project, @NotNull VirtualFile configFile, @NotNull VirtualFile configDirectory, @NotNull VirtualFile configDirTemplateValue, @NotNull JsonObject jsonObject, boolean hasErrors) {
        if (project == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(23);
        }
        if (configFile == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(24);
        }
        if (configDirectory == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(25);
        }
        if (configDirTemplateValue == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(26);
        }
        if (jsonObject == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(27);
        }
        this.myRootDirValue = NullableLazyValue.lazyNullable(() -> {
            String dir = this.getRootDir();
            if (dir == null) {
                return null;
            }
            return JSPathMappingsUtil.getRelativeOrAbsoluteFilePath(this.substituteConfigDirTemplate(dir), this.getConfigDirectory());
        });
        this.myPlugins = new ArrayList<String>();
        this.myRootDirPsiElements = NotNullLazyValue.lazy((Supplier)new /* invalid duplicate definition of identical inner class */);
        this.myRootDirFiles = NotNullLazyValue.lazy(() -> {
            Collection dirs = (Collection)this.myRootDirPsiElements.getValue();
            return ContainerUtil.map((Collection)dirs, PsiFileSystemItem::getVirtualFile);
        });
        JsonObject compilerOptionsValue = TypeScriptConfigParsingUtil.getObjectOfProperty(jsonObject, "compilerOptions");
        Map<String, Object> options = TypeScriptConfigImpl.getCompilerOptions((JsonValue)compilerOptionsValue);
        JsonProperty filesProperty = jsonObject.findProperty("files");
        JsonProperty includeProperty = jsonObject.findProperty("include");
        JsonProperty excludeProperty = jsonObject.findProperty("exclude");
        JsonProperty referencesProperty = jsonObject.findProperty("references");
        this.myHasExcludeList = excludeProperty != null;
        this.myHasIncludeList = includeProperty != null;
        this.myHasFilesList = filesProperty != null;
        this.myHasReferences = referencesProperty != null;
        this.myConfigFile = configFile;
        this.myConfigDirectory = configDirectory;
        this.myConfigDirTemplateValue = configDirTemplateValue;
        this.myProject = project;
        this.myOptions = options;
        this.myFilesList = NotNullLazyValue.createValue(() -> TypeScriptConfigImpl.getFiles(filesProperty, configDirTemplateValue));
        this.myReferencesList = NotNullLazyValue.createValue(() -> TypeScriptConfigImpl.getReferences(referencesProperty));
        this.myDirectoryBased = filesProperty == null && includeProperty == null;
        String outDir = TypeScriptConfigParsingUtil.getStringOption((JsonElement)compilerOptionsValue, "outDir");
        this.myExcludePatterns = excludeProperty != null ? TypeScriptConfigImpl.readValues(excludeProperty.getValue(), configDirTemplateValue) : TypeScriptConfigImpl.unionDefaultExcludeWithOutDir(outDir);
        this.myIncludedPatterns = includeProperty != null ? TypeScriptConfigImpl.readValues(includeProperty.getValue(), configDirTemplateValue) : ContainerUtil.emptyList();
        this.myModuleSuffixes = TypeScriptConfigImpl.getPropertyList((JsonValue)compilerOptionsValue, "moduleSuffixes");
        this.myRootDirs = TypeScriptConfigImpl.getRootDirs((JsonValue)compilerOptionsValue);
        this.myPaths = TypeScriptConfigImpl.getPaths((JsonValue)compilerOptionsValue, configDirTemplateValue);
        this.myBaseUrl = TypeScriptConfigImpl.getBaseUrl((JsonValue)compilerOptionsValue);
        boolean allowJsDefault = this.myConfigFile.getName().equalsIgnoreCase("jsconfig.json");
        this.myAllowJs = TypeScriptConfigParsingUtil.getBooleanValue(compilerOptionsValue, "allowJs", allowJsDefault);
        this.myCheckJs = TypeScriptConfigParsingUtil.getBooleanValue(compilerOptionsValue, "checkJs", false);
        this.myStrictNullChecks = TypeScriptConfigParsingUtil.getBooleanValue(compilerOptionsValue, "strictNullChecks", false);
        this.myStrictBindCallApply = TypeScriptConfigParsingUtil.getBooleanValue(compilerOptionsValue, "strictBindCallApply", false);
        this.myStrict = TypeScriptConfigParsingUtil.getBooleanValue(compilerOptionsValue, "strict", false);
        this.mySuppressExcessPropertyChecks = TypeScriptConfigParsingUtil.getBooleanValue(compilerOptionsValue, "suppressExcessPropertyErrors", false);
        this.myNoImplicitAny = TypeScriptConfigParsingUtil.getBooleanValue(compilerOptionsValue, "noImplicitAny", false);
        this.myNoImplicitThis = TypeScriptConfigParsingUtil.getBooleanValue(compilerOptionsValue, "noImplicitThis", false);
        this.myNoLib = TypeScriptConfigParsingUtil.getBooleanValue(compilerOptionsValue, "noLib", false);
        this.myPreserveSymlinks = TypeScriptConfigParsingUtil.getBooleanValue(compilerOptionsValue, "preserveSymlinks", false);
        this.myKeyofStringsOnly = TypeScriptConfigParsingUtil.getBooleanValue(compilerOptionsValue, "keyofStringsOnly", false);
        this.myVerbatimModuleSyntax = TypeScriptConfigParsingUtil.getBooleanValue(compilerOptionsValue, "verbatimModuleSyntax", false);
        this.myAllowImportingTsExtensions = TypeScriptConfigParsingUtil.getBooleanValue(compilerOptionsValue, "allowImportingTsExtensions", false);
        this.myExperimentalDecorators = TypeScriptConfigParsingUtil.getBooleanValue(compilerOptionsValue, "experimentalDecorators", false);
        this.myJsx = TypeScriptConfigParsingUtil.getStringOption((JsonElement)compilerOptionsValue, "jsx");
        this.myComposite = TypeScriptConfigParsingUtil.getBooleanValue(compilerOptionsValue, "composite", false);
        this.myTypeRoots = TypeScriptConfigImpl.getTypeRoots((JsonValue)compilerOptionsValue);
        this.myTypes = TypeScriptConfigImpl.getTypes((JsonValue)compilerOptionsValue);
        this.myLibs = ContainerUtil.map(TypeScriptConfigImpl.getLibs((JsonValue)compilerOptionsValue), el -> TypeScriptConfigUtil.toLibraryName(el));
        this.myModuleResolution = TypeScriptConfigImpl.getModuleResolution((JsonValue)compilerOptionsValue);
        this.myModule = TypeScriptConfigImpl.getModule((JsonValue)compilerOptionsValue);
        this.myHasErrors = hasErrors;
        this.myHasExplicitCompileOnSave = jsonObject.findProperty("compileOnSave") != null;
        this.myCompileOnSave = TypeScriptConfigParsingUtil.getBooleanValue(jsonObject, "compileOnSave", false);
        JsonProperty extendsProperty = jsonObject.findProperty("extends");
        this.myExtendsPaths = TypeScriptConfigImpl.resolveConfigFiles(extendsProperty != null ? extendsProperty.getValue() : null);
        this.myInlineSourceMap = Boolean.TRUE.equals(this.myOptions.get("inlineSourceMap"));
        this.mySourceMap = Boolean.TRUE.equals(this.myOptions.get("sourceMap"));
        String optionValue = (String)ObjectUtils.tryCast((Object)this.myOptions.get("target"), String.class);
        this.myLanguageTarget = StringUtil.isEmpty((String)optionValue) ? DEFAULT_LANGUAGE_TARGET : TypeScriptConfigImpl.parseTarget(optionValue);
        this.myPlugins.addAll(TypeScriptConfigImpl.getPluginNames((JsonValue)compilerOptionsValue));
        this.myTypeRootFiles = NotNullLazyValue.lazy(() -> {
            if (this.myTypeRoots.isEmpty()) {
                VirtualFile defaultTypesDirectory = TypeScriptConfigUtil.finDefaultTypesDirectory(this.getConfigFile());
                return ContainerUtil.createMaybeSingletonList((Object)defaultTypesDirectory);
            }
            ArrayList<VirtualFile> results = new ArrayList<VirtualFile>();
            for (String root : this.myTypeRoots) {
                VirtualFile path2;
                if (StringUtil.isEmpty((String)root) || (path2 = JSPathMappingsUtil.getRelativeOrAbsoluteFilePath(this.substituteConfigDirTemplate(root), this.getConfigDirectory())) == null) continue;
                results.add(path2);
            }
            return results;
        });
        this.myBaseUrlFile = NullableLazyValue.lazyNullable(() -> {
            if (this.myBaseUrl == null) {
                return null;
            }
            return JSPathMappingsUtil.getRelativeOrAbsoluteFilePath(this.substituteConfigDirTemplate(this.myBaseUrl), this.getConfigDirectory());
        });
        this.myCustomData = TypeScriptConfigCustomizer.getCustomData(jsonObject);
    }

    @NotNull
    private static List<String> getPluginNames(@Nullable JsonValue compilerOptions) {
        JsonArray pluginsArray;
        JsonProperty pluginsProp;
        if (compilerOptions instanceof JsonObject && (pluginsProp = ((JsonObject)compilerOptions).findProperty("plugins")) != null && (pluginsArray = (JsonArray)ObjectUtils.tryCast((Object)pluginsProp.getValue(), JsonArray.class)) != null) {
            List list = ContainerUtil.mapNotNull((Collection)pluginsArray.getValueList(), plugin -> TypeScriptConfigParsingUtil.getStringOption((JsonElement)plugin, "name"));
            if (list == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(28);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(29);
        }
        return list;
    }

    private static List<VirtualFile> resolveConfigFiles(@Nullable JsonValue jsonValue) {
        return TypeScriptConfigFileReferenceSet.getFileReferences(jsonValue).stream().map(TypeScriptConfigImpl::resolveRefToConfigFile).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private static VirtualFile resolveConfigFile(@NotNull JsonStringLiteral jsonStringLiteral) {
        if (jsonStringLiteral == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(30);
        }
        return TypeScriptConfigImpl.resolveRefToConfigFile(TypeScriptConfigFileReferenceSet.getFileReferenceFromString(jsonStringLiteral));
    }

    @Nullable
    private static VirtualFile resolveRefToConfigFile(@Nullable FileReference fileReference) {
        if (fileReference == null) {
            return null;
        }
        PsiFileSystemItem resolved = fileReference.resolve();
        if (resolved instanceof JsonFile) {
            return resolved.getVirtualFile();
        }
        return null;
    }

    @NotNull
    private static Collection<String> unionDefaultExcludeWithOutDir(@Nullable String outDir) {
        if (outDir != null) {
            ArrayList<String> result2 = new ArrayList<String>(DEFAULT_EXCLUDE_VALUES);
            result2.add(outDir);
            ArrayList<String> arrayList = result2;
            if (arrayList == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(31);
            }
            return arrayList;
        }
        Collection collection = DEFAULT_EXCLUDE_VALUES;
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(32);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getRootDirsFiles() {
        Collection collection = (Collection)this.myRootDirFiles.getValue();
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(33);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<String> getExcludePatterns() {
        Collection<String> collection = this.myExcludePatterns;
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(34);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<String> getModuleSuffixes() {
        Collection<String> collection = this.myModuleSuffixes;
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(35);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<String> getIncludePatterns() {
        Collection<String> collection = this.myIncludedPatterns;
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(36);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getFileList() {
        Collection collection = (Collection)this.myFilesList.getValue();
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(37);
        }
        return collection;
    }

    @Override
    public boolean hasFilesList() {
        return this.myHasFilesList;
    }

    @Override
    public boolean hasIncludesList() {
        return this.myHasIncludeList;
    }

    @Override
    public boolean isFromFileList(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(38);
        }
        TypeScriptConfigIncludeBase checker = this.getInclude();
        return checker.isFromFilesList(file);
    }

    @Override
    @Nullable
    public String getRawCompilerOption(@NotNull String name) {
        Object value;
        if (name == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(39);
        }
        return (value = this.myOptions.get(name)) != null ? value.toString() : null;
    }

    @Override
    @NotNull
    public Map<String, Object> getRawCompilerOptions() {
        Map<String, Object> map2 = this.myOptions;
        if (map2 == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(40);
        }
        return map2;
    }

    @Override
    public boolean hasExplicitCompileOnSave() {
        return this.myHasExplicitCompileOnSave;
    }

    @Override
    public boolean compileOnSave() {
        return this.myCompileOnSave;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getDependencies() {
        List list = ContainerUtil.createMaybeSingletonList((Object)this.myConfigFile);
        if (list == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(41);
        }
        return list;
    }

    @Override
    public boolean allowJs() {
        return this.myAllowJs;
    }

    @Override
    public boolean suppressExcessPropertyChecks() {
        return this.mySuppressExcessPropertyChecks;
    }

    @Override
    public boolean checkJs() {
        return this.myCheckJs;
    }

    @Override
    public boolean noImplicitAny() {
        return this.myNoImplicitAny;
    }

    @Override
    public boolean noImplicitThis() {
        return this.myNoImplicitThis || this.myStrict && !this.hasCompilerOption("noImplicitThis");
    }

    @Override
    public boolean allowImportingTsExtensions() {
        return this.myAllowImportingTsExtensions;
    }

    @Override
    public boolean strictNullChecks() {
        return this.myStrictNullChecks || this.myStrict && !this.hasCompilerOption("strictNullChecks");
    }

    @Override
    public boolean strictBindCallApply() {
        return this.myStrictBindCallApply || this.myStrict && !this.hasCompilerOption("strictBindCallApply");
    }

    @Override
    public boolean noLib() {
        return this.myNoLib;
    }

    @Override
    public boolean preserveSymlinks() {
        return this.myPreserveSymlinks;
    }

    @Override
    @Nullable
    public String jsxFactory() {
        return this.hasCompilerOption("jsxFactory") ? this.getRawCompilerOption("jsxFactory") : null;
    }

    @Override
    @Nullable
    public String jsxFragmentFactory() {
        return this.hasCompilerOption("jsxFragmentFactory") ? this.getRawCompilerOption("jsxFragmentFactory") : null;
    }

    @Override
    @Nullable
    public String jsxImportSource() {
        return this.hasCompilerOption("jsxImportSource") ? this.getRawCompilerOption("jsxImportSource") : null;
    }

    @Override
    @NotNull
    public List<String> getPlugins() {
        List<String> list = this.myPlugins;
        if (list == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(42);
        }
        return list;
    }

    @Override
    public boolean isIncludedFile(@NotNull VirtualFile file, boolean checkExclude) {
        TypeScriptConfigIncludeBase checker;
        if (file == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(43);
        }
        if ((checker = this.getInclude()) instanceof TypeScriptConfigPatternInclude) {
            return ((TypeScriptConfigPatternInclude)checker).isIncludedFile(file, checkExclude);
        }
        return false;
    }

    @Nullable
    private static String getBaseUrl(@Nullable JsonValue compilerOptions) {
        return TypeScriptConfigParsingUtil.getStringOption((JsonElement)compilerOptions, "baseUrl");
    }

    private static String getModuleResolution(@Nullable JsonValue compilerOptions) {
        return TypeScriptConfigParsingUtil.getStringOption((JsonElement)compilerOptions, "moduleResolution");
    }

    private static String getModule(@Nullable JsonValue compilerOptions) {
        return TypeScriptConfigParsingUtil.getStringOption((JsonElement)compilerOptions, "module");
    }

    @NotNull
    private static Collection<String> getRootDirs(@Nullable JsonValue compilerOptions) {
        return TypeScriptConfigImpl.getPropertyList(compilerOptions, "rootDirs");
    }

    @NotNull
    private static Collection<String> getTypes(@Nullable JsonValue compilerOptions) {
        return TypeScriptConfigImpl.getPropertyList(compilerOptions, "types");
    }

    @NotNull
    private static Collection<String> getLibs(@Nullable JsonValue compilerOptions) {
        return TypeScriptConfigImpl.getPropertyList(compilerOptions, "lib");
    }

    @NotNull
    private static Collection<String> getTypeRoots(@Nullable JsonValue compilerOptions) {
        return TypeScriptConfigImpl.getPropertyList(compilerOptions, "typeRoots");
    }

    @NotNull
    private static Collection<String> getPropertyList(@Nullable JsonValue compilerOptions, String name) {
        if (!(compilerOptions instanceof JsonObject)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(44);
            }
            return list;
        }
        JsonObject jsonObject = (JsonObject)compilerOptions;
        JsonProperty property = jsonObject.findProperty(name);
        if (property == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(45);
            }
            return list;
        }
        JsonValue value = property.getValue();
        return TypeScriptConfigImpl.readValues(value, null);
    }

    @NotNull
    private static Collection<String> readValues(JsonValue value, @Nullable VirtualFile configDirTemplateValue) {
        if (!(value instanceof JsonArray)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(46);
            }
            return list;
        }
        JsonArray jsonArray = (JsonArray)value;
        ArrayList<String> resultList = new ArrayList<String>();
        for (JsonValue jsonValue : jsonArray.getValueList()) {
            if (!(jsonValue instanceof JsonStringLiteral)) continue;
            String stringValue = ((JsonStringLiteral)jsonValue).getValue();
            resultList.add(configDirTemplateValue != null ? TypeScriptConfigImpl.substituteConfigDirTemplate(stringValue, configDirTemplateValue) : stringValue);
        }
        ArrayList<String> arrayList = resultList;
        if (arrayList == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(47);
        }
        return arrayList;
    }

    private static JSModulePathMappings<JSModulePathSubstitution> getPaths(@Nullable JsonValue compilerOptions, @NotNull VirtualFile configDirTemplateValue) {
        if (configDirTemplateValue == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(48);
        }
        if (!(compilerOptions instanceof JsonObject)) {
            return JSModulePathMappings.empty();
        }
        JsonObject jsonObject = (JsonObject)compilerOptions;
        JsonProperty property = jsonObject.findProperty("paths");
        if (property == null) {
            return JSModulePathMappings.empty();
        }
        JsonValue propertyValue = property.getValue();
        if (!(propertyValue instanceof JsonObject)) {
            return JSModulePathMappings.empty();
        }
        JsonObject paths = (JsonObject)propertyValue;
        ArrayList<TypeScriptConfigPathSubstitution> result2 = new ArrayList<TypeScriptConfigPathSubstitution>();
        for (JsonProperty jsonProperty : paths.getPropertyList()) {
            String name = jsonProperty.getName();
            JsonValue value = jsonProperty.getValue();
            ArrayList<String> substitutions = new ArrayList<String>();
            if (value instanceof JsonStringLiteral) {
                substitutions.add(TypeScriptConfigImpl.substituteConfigDirTemplate(((JsonStringLiteral)value).getValue(), configDirTemplateValue));
            } else if (value instanceof JsonArray) {
                for (JsonValue jsonValue : ((JsonArray)value).getValueList()) {
                    if (!(jsonValue instanceof JsonStringLiteral)) continue;
                    substitutions.add(TypeScriptConfigImpl.substituteConfigDirTemplate(((JsonStringLiteral)jsonValue).getValue(), configDirTemplateValue));
                }
            }
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)compilerOptions.getProject());
            SmartPsiElementPointer pointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)jsonProperty);
            result2.add(new TypeScriptConfigPathSubstitution(substitutions, name, pointer));
        }
        return JSModulePathMappings.build(result2);
    }

    @Override
    public boolean isDirectoryBased() {
        return this.myDirectoryBased;
    }

    @Override
    @NotNull
    public VirtualFile getConfigFile() {
        VirtualFile virtualFile = this.myConfigFile;
        if (virtualFile == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(49);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile getConfigDirectory() {
        VirtualFile virtualFile = this.myConfigDirectory;
        if (virtualFile == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(50);
        }
        return virtualFile;
    }

    @Override
    public boolean hasErrors() {
        return this.myHasErrors;
    }

    @Override
    @NotNull
    public JSModulePathMappings<JSModulePathSubstitution> getPathMappings() {
        JSModulePathMappings<JSModulePathSubstitution> jSModulePathMappings = this.myPaths;
        if (jSModulePathMappings == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(51);
        }
        return jSModulePathMappings;
    }

    @Override
    @NotNull
    public VirtualFile getMappingRoot() {
        if (this.getBaseUrl() != null) {
            VirtualFile virtualFile = this.getBaseUrl();
            if (virtualFile == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(52);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = this.getConfigDirectory();
        if (virtualFile == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(53);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getRootDirs() {
        Collection collection = (Collection)this.myRootDirPsiElements.getValue();
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(54);
        }
        return collection;
    }

    @Override
    @NotNull
    public TypeScriptConfig.LanguageTarget getLanguageTarget() {
        TypeScriptConfig.LanguageTarget languageTarget = this.myLanguageTarget;
        if (languageTarget == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(55);
        }
        return languageTarget;
    }

    @Override
    @NotNull
    public Collection<String> getLibNames() {
        Collection<String> collection = this.myLibs;
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(56);
        }
        return collection;
    }

    @Override
    @Nullable
    public VirtualFile getBaseUrl() {
        return (VirtualFile)this.myBaseUrlFile.getValue();
    }

    @Override
    @Nullable
    public String getOutDirectory() {
        VirtualFile baseDirectory = this.getConfigDirectory();
        String directoryPath = this.getRawCompilerOption("outDir");
        return TypeScriptConfigUtil.getOutDirectory(baseDirectory, directoryPath != null ? this.substituteConfigDirTemplate(directoryPath) : null);
    }

    @Override
    @NotNull
    public VirtualFile getEffectiveOutDirectory() {
        String directoryPath = this.getRawCompilerOption("outDir");
        VirtualFile baseDirectory = this.getConfigDirectory();
        VirtualFile virtualFile = (VirtualFile)ObjectUtils.coalesce((Object)TypeScriptConfigUtil.getOutDirectoryFile(baseDirectory, directoryPath), (Object)this.getConfigDirectory());
        if (virtualFile == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(57);
        }
        return virtualFile;
    }

    @Override
    @Nullable
    public String getDeclarationDir() {
        String directoryPath = this.getRawCompilerOption("declarationDir");
        return directoryPath != null ? this.substituteConfigDirTemplate(directoryPath) : null;
    }

    @Override
    @NotNull
    public VirtualFile getEffectiveDeclarationDirectory() {
        String directoryPath = this.getRawCompilerOption("declarationDir");
        VirtualFile baseDirectory = this.getConfigDirectory();
        VirtualFile virtualFile = (VirtualFile)ObjectUtils.coalesce((Object)TypeScriptConfigUtil.getOutDirectoryFile(baseDirectory, directoryPath), (Object)this.getEffectiveOutDirectory());
        if (virtualFile == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(58);
        }
        return virtualFile;
    }

    public String toString() {
        return "TypeScriptConfigImpl{myConfigFile=" + this.myConfigFile + ", myOptions=" + this.myOptions + ", myConfigDirectory=" + this.myConfigDirectory + ", myFilesList=" + this.myFilesList + "}";
    }

    public static TypeScriptConfig.LanguageTarget parseTarget(String value) {
        String lowerCaseValue;
        return switch (lowerCaseValue = StringUtil.toLowerCase((String)value.trim())) {
            case "es3" -> TypeScriptConfig.LanguageTarget.ES3;
            case "es5" -> TypeScriptConfig.LanguageTarget.ES5;
            case "es6", "es2015" -> TypeScriptConfig.LanguageTarget.ES6;
            case "esnext" -> TypeScriptConfig.LanguageTarget.NEXT;
            default -> lowerCaseValue.startsWith("es") ? new TypeScriptConfig.LanguageTarget(lowerCaseValue + ".full", lowerCaseValue, 3) : DEFAULT_LANGUAGE_TARGET;
        };
    }

    @Override
    public boolean isInlineSourceMap() {
        return this.myInlineSourceMap;
    }

    @Override
    public boolean verbatimModuleSyntax() {
        return this.myVerbatimModuleSyntax;
    }

    @Override
    public boolean isSourceMap() {
        return this.mySourceMap;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getTypeRoots() {
        Collection collection = (Collection)this.myTypeRootFiles.getValue();
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(59);
        }
        return collection;
    }

    @Override
    @NotNull
    public JSModuleResolution getResolution() {
        if (StringUtil.isEmpty((String)this.myModuleResolution)) {
            JSModuleResolution jSModuleResolution = JSModuleResolution.UNKNOWN;
            if (jSModuleResolution == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(60);
            }
            return jSModuleResolution;
        }
        if ("node".equalsIgnoreCase(this.myModuleResolution)) {
            JSModuleResolution jSModuleResolution = JSModuleResolution.NODE;
            if (jSModuleResolution == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(61);
            }
            return jSModuleResolution;
        }
        if (StringUtil.startsWithIgnoreCase((String)this.myModuleResolution, (String)"node")) {
            JSModuleResolution jSModuleResolution = JSModuleResolution.NODENEXT;
            if (jSModuleResolution == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(62);
            }
            return jSModuleResolution;
        }
        if ("bundler".equalsIgnoreCase(this.myModuleResolution)) {
            JSModuleResolution jSModuleResolution = JSModuleResolution.BUNDLER;
            if (jSModuleResolution == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(63);
            }
            return jSModuleResolution;
        }
        if ("classic".equalsIgnoreCase(this.myModuleResolution)) {
            JSModuleResolution jSModuleResolution = JSModuleResolution.CLASSIC;
            if (jSModuleResolution == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(64);
            }
            return jSModuleResolution;
        }
        JSModuleResolution jSModuleResolution = JSModuleResolution.UNKNOWN;
        if (jSModuleResolution == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(65);
        }
        return jSModuleResolution;
    }

    @Override
    @NotNull
    public JSModuleTarget getModule() {
        JSModuleTarget jSModuleTarget = JSModuleTarget.resolveRawValue(this.myModule);
        if (jSModuleTarget == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(66);
        }
        return jSModuleTarget;
    }

    @Override
    @NotNull
    public Collection<String> getTypes() {
        Collection<String> collection = this.myTypes;
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(67);
        }
        return collection;
    }

    @Override
    public boolean hasCompilerOption(@NotNull String name) {
        if (name == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(68);
        }
        return this.myOptions.containsKey(name);
    }

    @Override
    @Nullable
    public VirtualFile getRootDirFile() {
        return (VirtualFile)this.myRootDirValue.getValue();
    }

    @Nullable
    private String getRootDir() {
        return this.getRawCompilerOption("rootDir");
    }

    @Override
    public boolean keyofStringsOnly() {
        return this.myKeyofStringsOnly;
    }

    @Override
    public boolean experimentalDecorators() {
        return this.myExperimentalDecorators;
    }

    @Override
    @Nullable
    public String jsx() {
        return this.myJsx;
    }

    @Override
    protected boolean declaredAllowSyntheticDefaultImports() {
        return Boolean.parseBoolean(this.getRawCompilerOption("allowSyntheticDefaultImports"));
    }

    @Override
    public boolean esModuleInterop() {
        return Boolean.parseBoolean(this.getRawCompilerOption("esModuleInterop"));
    }

    @Override
    public boolean resolveJsonModule() {
        return Boolean.parseBoolean(this.getRawCompilerOption("resolveJsonModule"));
    }

    @Override
    @NotNull
    public JSImportsValues importsNotUsedAsValues() {
        String value = this.getRawCompilerOption("importsNotUsedAsValues");
        if (value == null || value.equals("remove")) {
            JSImportsValues jSImportsValues = JSImportsValues.REMOVE;
            if (jSImportsValues == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(69);
            }
            return jSImportsValues;
        }
        if (value.equals("error")) {
            JSImportsValues jSImportsValues = JSImportsValues.ERROR;
            if (jSImportsValues == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(70);
            }
            return jSImportsValues;
        }
        if (value.equals("preserve")) {
            JSImportsValues jSImportsValues = JSImportsValues.PRESERVE;
            if (jSImportsValues == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(71);
            }
            return jSImportsValues;
        }
        JSImportsValues jSImportsValues = JSImportsValues.REMOVE;
        if (jSImportsValues == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(72);
        }
        return jSImportsValues;
    }

    @Override
    @NotNull
    protected Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(73);
        }
        return project;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getReferences() {
        Collection collection = (Collection)this.myReferencesList.getValue();
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(74);
        }
        return collection;
    }

    @Override
    public boolean isolatedModules() {
        return Boolean.parseBoolean(this.getRawCompilerOption("isolatedModules"));
    }

    @Override
    public boolean hasReferences() {
        return this.myHasReferences;
    }

    @Override
    public boolean isComposite() {
        return this.myComposite;
    }

    @Override
    public boolean noImplicitOverride() {
        return Boolean.parseBoolean(this.getRawCompilerOption("noImplicitOverride"));
    }

    @Override
    public boolean hasCustomOption(@NotNull Key<?> key) {
        if (key == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(75);
        }
        return this.myCustomData.containsKey(key);
    }

    @Override
    public <T> T getCustomOption(@NotNull Key<T> key) {
        if (key == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(76);
        }
        return (T)this.myCustomData.get(key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 21, 22, 28, 29, 31, 32, 33, 34, 35, 36, 37, 40, 41, 42, 44, 45, 46, 47, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 69, 70, 71, 72, 73, 74 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl";
                break;
            }
            case 5: 
            case 17: 
            case 20: 
            case 26: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDirTemplateValue";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionValue";
                break;
            }
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDirectory";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonObject";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonStringLiteral";
                break;
            }
            case 38: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 39: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 75: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendsParents";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerOptions";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteConfigDirTemplate";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginNames";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "unionDefaultExcludeWithOutDir";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootDirsFiles";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludePatterns";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleSuffixes";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludePatterns";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileList";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawCompilerOptions";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyList";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "readValues";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFile";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigDirectory";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMappings";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingRoot";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootDirs";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageTarget";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibNames";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveOutDirectory";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveDeclarationDirectory";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeRoots";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolution";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "importsNotUsedAsValues";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleConfigImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractValue";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "substituteConfigDirTemplate";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "resolveConfigFile";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isFromFileList";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getRawCompilerOption";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isIncludedFile";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getPaths";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "hasCompilerOption";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "hasCustomOption";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getCustomOption";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 21, 22, 28, 29, 31, 32, 33, 34, 35, 36, 37, 40, 41, 42, 44, 45, 46, 47, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 69, 70, 71, 72, 73, 74 -> new IllegalStateException(string);
        };
    }

    private static class TypeScriptConfigPathSubstitution
    implements JSModulePathSubstitution {
        @NotNull
        private final Collection<String> mySubstitutions;
        private final String myName;
        private final SmartPsiElementPointer<?> myPointer;

        TypeScriptConfigPathSubstitution(@NotNull Collection<String> substitutions, @NotNull String name, @NotNull SmartPsiElementPointer<?> pointer) {
            if (substitutions == null) {
                TypeScriptConfigPathSubstitution.$$$reportNull$$$0(0);
            }
            if (name == null) {
                TypeScriptConfigPathSubstitution.$$$reportNull$$$0(1);
            }
            if (pointer == null) {
                TypeScriptConfigPathSubstitution.$$$reportNull$$$0(2);
            }
            this.mySubstitutions = substitutions;
            this.myName = name;
            this.myPointer = pointer;
        }

        @Override
        @NotNull
        public Collection<String> getMappings() {
            Collection<String> collection = this.mySubstitutions;
            if (collection == null) {
                TypeScriptConfigPathSubstitution.$$$reportNull$$$0(3);
            }
            return collection;
        }

        @Override
        @NotNull
        public String getPattern() {
            String string = this.myName;
            if (string == null) {
                TypeScriptConfigPathSubstitution.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        public boolean canStartWith() {
            return false;
        }

        @Override
        public PsiElement getElement() {
            return this.myPointer.getElement();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeScriptConfigPathSubstitution that = (TypeScriptConfigPathSubstitution)o;
            if (!this.mySubstitutions.equals(that.mySubstitutions)) {
                return false;
            }
            return this.myName.equals(that.myName);
        }

        public int hashCode() {
            int result2 = this.mySubstitutions.hashCode();
            result2 = 31 * result2 + this.myName.hashCode();
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substitutions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pointer";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$TypeScriptConfigPathSubstitution";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$TypeScriptConfigPathSubstitution";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMappings";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

