/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard.operations;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeFacts;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.guard.operations.JSApplyTypeOperationContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSConditionalTypeOperationBase;
import com.intellij.lang.javascript.psi.types.guard.operations.JSInferDecoratorsContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSTypeOperation;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class JSNarrowTypeByEqualityOperation
extends JSConditionalTypeOperationBase {
    @NotNull
    final JSType myExpressionType;
    @NotNull
    private final Set<JSDecoratedType.TypeDecoration> myDecorations;
    final boolean myDoubleEquals;

    public JSNarrowTypeByEqualityOperation(@NotNull JSTypeOperation prev, @NotNull IElementType sign, @NotNull JSExpression expression, boolean assumeTrue) {
        if (prev == null) {
            JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(0);
        }
        if (sign == null) {
            JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(1);
        }
        if (expression == null) {
            JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(2);
        }
        super(prev, assumeTrue);
        this.myExpressionType = JSTypeGuardUtil.getOperationType(expression);
        this.myDoubleEquals = sign == JSTokenTypes.EQEQ || sign == JSTokenTypes.NE;
        this.myDecorations = JSTypeGuardChecker.getDecoratorsForNullOrUndefinedExpression(this.myDoubleEquals, expression, this.myAssumeTrue);
    }

    @Override
    @NotNull
    protected JSType applyForPrevType(@NotNull JSApplyTypeOperationContext context2, @NotNull JSType type) {
        JSType valueType;
        if (context2 == null) {
            JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(3);
        }
        if (type == null) {
            JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(4);
        }
        if ((valueType = JSTypeGuardChecker.collapseBooleanLiterals(context2.expandOperationType(this.myExpressionType))) == null) {
            JSType jSType = type;
            if (jSType == null) {
                JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(5);
            }
            return jSType;
        }
        if (type instanceof JSUnknownType && this.myAssumeTrue && !this.myDoubleEquals) {
            if (TypeScriptTypeRelations.isPrimitiveType(valueType)) {
                JSType jSType = valueType;
                if (jSType == null) {
                    JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(6);
                }
                return jSType;
            }
            if (TypeScriptTypeRelations.isObjectType(valueType)) {
                return JSNarrowTypeByEqualityOperation.createObjectType(context2);
            }
            JSType jSType = type;
            if (jSType == null) {
                JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(7);
            }
            return jSType;
        }
        if (JSTypeUtils.isNullOrUndefinedType(valueType)) {
            boolean valueIsNull = valueType instanceof JSNullType;
            JSTypeFacts.SimpleFact facts = this.myDoubleEquals ? (this.myAssumeTrue ? JSTypeFacts.SimpleFact.EQUndefinedOrNull : JSTypeFacts.SimpleFact.NEUndefinedOrNull) : (valueIsNull ? (this.myAssumeTrue ? JSTypeFacts.SimpleFact.EQNull : JSTypeFacts.SimpleFact.NENull) : (this.myAssumeTrue ? JSTypeFacts.SimpleFact.EQUndefined : JSTypeFacts.SimpleFact.NEUndefined));
            JSType jSType = type instanceof JSAnyType ? type : JSTypeFacts.TYPE_FACTS.getTypeWithFact(type, facts, context2.getContextElement(), context2.strictNullChecks());
            if (jSType == null) {
                JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(8);
            }
            return jSType;
        }
        if (this.myAssumeTrue) {
            JSType narrowType = TypeScriptTypeRelations.filterType(type, el -> this.myDoubleEquals ? TypeScriptTypeRelations.isCoercibleUnderDoubleEquals(el, valueType) || TypeScriptTypeRelations.areTypesComparable(el, valueType, context2.getProcessingContext()) : TypeScriptTypeRelations.areTypesComparable(el, valueType, context2.getProcessingContext()), context2.getContextElement());
            JSType jSType = narrowType instanceof TypeScriptNeverType ? type : JSTypeGuardUtil.replacePrimitivesWithLiterals(narrowType, valueType, context2.getContextElement());
            if (jSType == null) {
                JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(9);
            }
            return jSType;
        }
        if (JSTypeGuardUtil.isUnitType(valueType)) {
            JSType regularType = TypeScriptTypeRelations.getRegularTypeOfLiteralType(valueType);
            ProcessingContext processing = new ProcessingContext();
            processing.put(JSTypeBaseImpl.EQ_SKIP_SCOPE, (Object)true);
            JSType resultType = TypeScriptTypeRelations.filterType(type, el -> {
                JSType literalType = TypeScriptTypeRelations.getRegularTypeOfLiteralType(el);
                return literalType != null && !literalType.isEquivalentTo(regularType, processing, true);
            }, context2.getContextElement());
            JSType jSType = context2.processNeverType(type, resultType);
            if (jSType == null) {
                JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(10);
            }
            return jSType;
        }
        JSType jSType = type;
        if (jSType == null) {
            JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(11);
        }
        return jSType;
    }

    @NotNull
    private static JSType createObjectType(@NotNull JSApplyTypeOperationContext context2) {
        if (context2 == null) {
            JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(12);
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource(context2.getContextElement(), true);
        JSType jSType = JSNamedTypeFactory.createType("object", source, JSTypeContext.fromJSContext(JSContext.INSTANCE), false);
        if (jSType == null) {
            JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(13);
        }
        return jSType;
    }

    @Override
    @NotNull
    public Set<JSDecoratedType.TypeDecoration> inferTypeDecoratorsImpl(@NotNull JSInferDecoratorsContext context2) {
        if (context2 == null) {
            JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(14);
        }
        Set<JSDecoratedType.TypeDecoration> set = this.mergeSimilarDecorators(this.myDecorations, super.inferTypeDecoratorsImpl(context2));
        if (set == null) {
            JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(15);
        }
        return set;
    }

    @Override
    protected boolean checkOwnEquality(@NotNull JSTypeOperation sameTypeOperation) {
        if (sameTypeOperation == null) {
            JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(16);
        }
        JSNarrowTypeByEqualityOperation operation = (JSNarrowTypeByEqualityOperation)sameTypeOperation;
        return this.myExpressionType.isEquivalentTo(operation.myExpressionType, null, false) && this.myDoubleEquals == operation.myDoubleEquals;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 9, 10, 11, 13, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/operations/JSNarrowTypeByEqualityOperation";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sameTypeOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/operations/JSNarrowTypeByEqualityOperation";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "applyForPrevType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createObjectType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeDecoratorsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyForPrevType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createObjectType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeDecoratorsImpl";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkOwnEquality";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 9, 10, 11, 13, 15 -> new IllegalStateException(string);
        };
    }
}

