/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.prompt;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.terminal.TerminalColorPalette;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.output.EmptyTextAttributesProvider;
import org.jetbrains.plugins.terminal.block.output.TerminalTextHighlighterKt;
import org.jetbrains.plugins.terminal.block.output.TextAttributesProvider;
import org.jetbrains.plugins.terminal.block.output.TextWithAttributes;
import org.jetbrains.plugins.terminal.block.output.TextWithHighlightings;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptRenderer;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptRenderingInfo;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptState;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0015\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/BuiltInPromptRenderer;", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptRenderer;", "colorPalette", "Lcom/intellij/terminal/TerminalColorPalette;", "isSingleLine", "", "<init>", "(Lcom/intellij/terminal/TerminalColorPalette;Z)V", "calculateRenderingInfo", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptRenderingInfo;", "state", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptState;", "getPromptComponents", "", "Lorg/jetbrains/plugins/terminal/block/output/TextWithAttributes;", "calculateDirectoryText", "", "Lcom/intellij/openapi/util/NlsSafe;", "directory", "plainAttributes", "Lorg/jetbrains/plugins/terminal/block/output/TextAttributesProvider;", "colorIndex", "", "intellij.terminal"})
public final class BuiltInPromptRenderer
implements TerminalPromptRenderer {
    @NotNull
    private final TerminalColorPalette colorPalette;
    private final boolean isSingleLine;

    public BuiltInPromptRenderer(@NotNull TerminalColorPalette colorPalette, boolean isSingleLine) {
        Intrinsics.checkNotNullParameter((Object)colorPalette, (String)"colorPalette");
        this.colorPalette = colorPalette;
        this.isSingleLine = isSingleLine;
    }

    @Override
    @NotNull
    public TerminalPromptRenderingInfo calculateRenderingInfo(@NotNull TerminalPromptState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        TextWithHighlightings content = TerminalTextHighlighterKt.toTextWithHighlightings(this.getPromptComponents(state));
        return new TerminalPromptRenderingInfo(content.getText(), content.getHighlightings(), null, null, 12, null);
    }

    private final List<TextWithAttributes> getPromptComponents(TerminalPromptState state) {
        CharSequence venvName;
        List result = new ArrayList();
        TextAttributesProvider greenAttributes = this.plainAttributes(2);
        TextAttributesProvider yellowAttributes = this.plainAttributes(3);
        EmptyTextAttributesProvider defaultAttributes = EmptyTextAttributesProvider.INSTANCE;
        CharSequence charSequence = state.getVirtualEnv();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String string = PathUtil.getFileName((String)state.getVirtualEnv());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
            venvName = string;
            BuiltInPromptRenderer.getPromptComponents$addComponent(result, "(" + (String)venvName + ")", greenAttributes);
        }
        if (!((venvName = (CharSequence)state.getCondaEnv()) == null || StringsKt.isBlank((CharSequence)venvName))) {
            BuiltInPromptRenderer.getPromptComponents$addComponent(result, "(" + state.getCondaEnv() + ")", greenAttributes);
        }
        if (!((Collection)result).isEmpty()) {
            BuiltInPromptRenderer.getPromptComponents$addComponent(result, " ", defaultAttributes);
        }
        BuiltInPromptRenderer.getPromptComponents$addComponent(result, this.calculateDirectoryText(state.getCurrentDirectory()), defaultAttributes);
        venvName = state.getGitBranch();
        if (!(venvName == null || StringsKt.isBlank((CharSequence)venvName))) {
            BuiltInPromptRenderer.getPromptComponents$addComponent(result, " ", defaultAttributes);
            BuiltInPromptRenderer.getPromptComponents$addComponent(result, "git:", yellowAttributes);
            BuiltInPromptRenderer.getPromptComponents$addComponent(result, "[" + state.getGitBranch() + "]", greenAttributes);
        }
        String promptInputSeparator = this.isSingleLine ? " " : "\n";
        BuiltInPromptRenderer.getPromptComponents$addComponent(result, promptInputSeparator, defaultAttributes);
        return result;
    }

    private final String calculateDirectoryText(String directory) {
        String string;
        if (!Intrinsics.areEqual((Object)directory, (Object)SystemProperties.getUserHome())) {
            String string2 = FileUtil.getLocationRelativeToUserHome((String)directory, (boolean)false);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            string = "~";
        }
        return string;
    }

    private final TextAttributesProvider plainAttributes(int colorIndex) {
        return TerminalUiUtils.INSTANCE.plainAttributesProvider(colorIndex, this.colorPalette);
    }

    private static final void getPromptComponents$addComponent(List<TextWithAttributes> result, String text, TextAttributesProvider attributesProvider) {
        result.add(new TextWithAttributes(text, attributesProvider));
    }
}

