/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.anim.dom;

import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.relocated.apache.batik.anim.dom.AbstractElement;
import org.jetbrains.relocated.apache.batik.anim.dom.AbstractSVGAnimatedValue;
import org.jetbrains.relocated.apache.batik.anim.dom.AnimationTarget;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMElement;
import org.jetbrains.relocated.apache.batik.anim.values.AnimatableTransformListValue;
import org.jetbrains.relocated.apache.batik.anim.values.AnimatableValue;
import org.jetbrains.relocated.apache.batik.dom.svg.AbstractSVGTransformList;
import org.jetbrains.relocated.apache.batik.dom.svg.ListBuilder;
import org.jetbrains.relocated.apache.batik.dom.svg.LiveAttributeException;
import org.jetbrains.relocated.apache.batik.dom.svg.SVGItem;
import org.jetbrains.relocated.apache.batik.parser.ParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGAnimatedTransformList;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGTransform;
import org.w3c.dom.svg.SVGTransformList;

public class SVGOMAnimatedTransformList
extends AbstractSVGAnimatedValue
implements SVGAnimatedTransformList {
    protected BaseSVGTransformList baseVal;
    protected AnimSVGTransformList animVal;
    protected boolean changing;
    protected String defaultValue;

    public SVGOMAnimatedTransformList(AbstractElement elt, String ns, String ln, String defaultValue) {
        super(elt, ns, ln);
        this.defaultValue = defaultValue;
    }

    public SVGTransformList getBaseVal() {
        if (this.baseVal == null) {
            this.baseVal = new BaseSVGTransformList();
        }
        return this.baseVal;
    }

    public SVGTransformList getAnimVal() {
        if (this.animVal == null) {
            this.animVal = new AnimSVGTransformList();
        }
        return this.animVal;
    }

    public void check() {
        if (!this.hasAnimVal) {
            if (this.baseVal == null) {
                this.baseVal = new BaseSVGTransformList();
            }
            this.baseVal.revalidate();
            if (this.baseVal.missing) {
                throw new LiveAttributeException(this.element, this.localName, 0, null);
            }
            if (this.baseVal.malformed) {
                throw new LiveAttributeException(this.element, this.localName, 1, this.baseVal.getValueAsString());
            }
        }
    }

    @Override
    public AnimatableValue getUnderlyingValue(AnimationTarget target) {
        SVGTransformList tl = this.getBaseVal();
        int n = tl.getNumberOfItems();
        ArrayList<SVGTransform> v = new ArrayList<SVGTransform>(n);
        for (int i = 0; i < n; ++i) {
            v.add(tl.getItem(i));
        }
        return new AnimatableTransformListValue(target, v);
    }

    @Override
    protected void updateAnimatedValue(AnimatableValue val) {
        if (val == null) {
            this.hasAnimVal = false;
        } else {
            this.hasAnimVal = true;
            AnimatableTransformListValue aval = (AnimatableTransformListValue)val;
            if (this.animVal == null) {
                this.animVal = new AnimSVGTransformList();
            }
            this.animVal.setAnimatedValue(aval.getTransforms());
        }
        this.fireAnimatedAttributeListeners();
    }

    @Override
    public void attrAdded(Attr node, String newv) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    @Override
    public void attrModified(Attr node, String oldv, String newv) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    @Override
    public void attrRemoved(Attr node, String oldv) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    protected class AnimSVGTransformList
    extends AbstractSVGTransformList {
        public AnimSVGTransformList() {
            this.itemList = new ArrayList(1);
        }

        @Override
        protected DOMException createDOMException(short type, String key, Object[] args) {
            return SVGOMAnimatedTransformList.this.element.createDOMException(type, key, args);
        }

        @Override
        protected SVGException createSVGException(short type, String key, Object[] args) {
            return ((SVGOMElement)SVGOMAnimatedTransformList.this.element).createSVGException(type, key, args);
        }

        @Override
        public int getNumberOfItems() {
            if (SVGOMAnimatedTransformList.this.hasAnimVal) {
                return super.getNumberOfItems();
            }
            return SVGOMAnimatedTransformList.this.getBaseVal().getNumberOfItems();
        }

        @Override
        public SVGTransform getItem(int index) throws DOMException {
            if (SVGOMAnimatedTransformList.this.hasAnimVal) {
                return super.getItem(index);
            }
            return SVGOMAnimatedTransformList.this.getBaseVal().getItem(index);
        }

        @Override
        protected String getValueAsString() {
            if (this.itemList.size() == 0) {
                return "";
            }
            StringBuffer sb = new StringBuffer(this.itemList.size() * 8);
            Iterator i = this.itemList.iterator();
            if (i.hasNext()) {
                sb.append(((SVGItem)i.next()).getValueAsString());
            }
            while (i.hasNext()) {
                sb.append(this.getItemSeparator());
                sb.append(((SVGItem)i.next()).getValueAsString());
            }
            return sb.toString();
        }

        @Override
        protected void setAttributeValue(String value2) {
        }

        @Override
        public void clear() throws DOMException {
            throw SVGOMAnimatedTransformList.this.element.createDOMException((short)7, "readonly.transform.list", null);
        }

        @Override
        public SVGTransform initialize(SVGTransform newItem) throws DOMException, SVGException {
            throw SVGOMAnimatedTransformList.this.element.createDOMException((short)7, "readonly.transform.list", null);
        }

        @Override
        public SVGTransform insertItemBefore(SVGTransform newItem, int index) throws DOMException, SVGException {
            throw SVGOMAnimatedTransformList.this.element.createDOMException((short)7, "readonly.transform.list", null);
        }

        @Override
        public SVGTransform replaceItem(SVGTransform newItem, int index) throws DOMException, SVGException {
            throw SVGOMAnimatedTransformList.this.element.createDOMException((short)7, "readonly.transform.list", null);
        }

        @Override
        public SVGTransform removeItem(int index) throws DOMException {
            throw SVGOMAnimatedTransformList.this.element.createDOMException((short)7, "readonly.transform.list", null);
        }

        @Override
        public SVGTransform appendItem(SVGTransform newItem) throws DOMException {
            throw SVGOMAnimatedTransformList.this.element.createDOMException((short)7, "readonly.transform.list", null);
        }

        @Override
        public SVGTransform consolidate() {
            throw SVGOMAnimatedTransformList.this.element.createDOMException((short)7, "readonly.transform.list", null);
        }

        protected void setAnimatedValue(Iterator it) {
            int i;
            int size2 = this.itemList.size();
            for (i = 0; i < size2 && it.hasNext(); ++i) {
                AbstractSVGTransformList.SVGTransformItem t = (AbstractSVGTransformList.SVGTransformItem)this.itemList.get(i);
                t.assign((SVGTransform)it.next());
            }
            while (it.hasNext()) {
                this.appendItemImpl(new AbstractSVGTransformList.SVGTransformItem((SVGTransform)it.next()));
                ++i;
            }
            while (size2 > i) {
                this.removeItemImpl(--size2);
            }
        }

        protected void setAnimatedValue(SVGTransform transform2) {
            int size2 = this.itemList.size();
            while (size2 > 1) {
                this.removeItemImpl(--size2);
            }
            if (size2 == 0) {
                this.appendItemImpl(new AbstractSVGTransformList.SVGTransformItem(transform2));
            } else {
                AbstractSVGTransformList.SVGTransformItem t = (AbstractSVGTransformList.SVGTransformItem)this.itemList.get(0);
                t.assign(transform2);
            }
        }

        @Override
        protected void resetAttribute() {
        }

        @Override
        protected void resetAttribute(SVGItem item) {
        }

        @Override
        protected void revalidate() {
            this.valid = true;
        }
    }

    public class BaseSVGTransformList
    extends AbstractSVGTransformList {
        protected boolean missing;
        protected boolean malformed;

        @Override
        protected DOMException createDOMException(short type, String key, Object[] args) {
            return SVGOMAnimatedTransformList.this.element.createDOMException(type, key, args);
        }

        @Override
        protected SVGException createSVGException(short type, String key, Object[] args) {
            return ((SVGOMElement)SVGOMAnimatedTransformList.this.element).createSVGException(type, key, args);
        }

        @Override
        protected String getValueAsString() {
            Attr attr = SVGOMAnimatedTransformList.this.element.getAttributeNodeNS(SVGOMAnimatedTransformList.this.namespaceURI, SVGOMAnimatedTransformList.this.localName);
            if (attr == null) {
                return SVGOMAnimatedTransformList.this.defaultValue;
            }
            return attr.getValue();
        }

        @Override
        protected void setAttributeValue(String value2) {
            try {
                SVGOMAnimatedTransformList.this.changing = true;
                SVGOMAnimatedTransformList.this.element.setAttributeNS(SVGOMAnimatedTransformList.this.namespaceURI, SVGOMAnimatedTransformList.this.localName, value2);
            }
            finally {
                SVGOMAnimatedTransformList.this.changing = false;
            }
        }

        @Override
        protected void resetAttribute() {
            super.resetAttribute();
            this.missing = false;
            this.malformed = false;
        }

        @Override
        protected void resetAttribute(SVGItem item) {
            super.resetAttribute(item);
            this.missing = false;
            this.malformed = false;
        }

        @Override
        protected void revalidate() {
            if (this.valid) {
                return;
            }
            this.valid = true;
            this.missing = false;
            this.malformed = false;
            String s = this.getValueAsString();
            if (s == null) {
                this.missing = true;
                return;
            }
            try {
                ListBuilder builder = new ListBuilder(this);
                this.doParse(s, builder);
                if (builder.getList() != null) {
                    this.clear(this.itemList);
                }
                this.itemList = builder.getList();
            }
            catch (ParseException e) {
                this.itemList = new ArrayList(1);
                this.malformed = true;
            }
        }
    }
}

