/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.commons.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.core.commons.enums.EnumInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\tH\u0016J\u0019\u0010\u0012\u001a\u0004\u0018\u00018\u00002\b\u0010\u0011\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\u0013J\u001f\u0010\u0012\u001a\u00028\u00002\b\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0015\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u0013R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/core/commons/enums/EnumInfoImpl;", "EnumT", "", "Lorg/jetbrains/letsPlot/core/commons/enums/EnumInfo;", "enumConstants", "", "([Ljava/lang/Enum;)V", "myNormalizedValueMap", "", "", "myOriginalNames", "", "originalNames", "getOriginalNames", "()Ljava/util/List;", "hasValue", "", "name", "safeValueOf", "(Ljava/lang/String;)Ljava/lang/Enum;", "defaultValue", "(Ljava/lang/String;Ljava/lang/Enum;)Ljava/lang/Enum;", "toNormalizedName", "unsafeValueOf", "plot-base"})
public final class EnumInfoImpl<EnumT extends Enum<EnumT>>
implements EnumInfo<EnumT> {
    @NotNull
    private final Map<String, EnumT> myNormalizedValueMap;
    @NotNull
    private final List<String> myOriginalNames;

    public EnumInfoImpl(@NotNull EnumT[] enumConstants) {
        Intrinsics.checkNotNullParameter(enumConstants, (String)"enumConstants");
        int numConstants = enumConstants.length;
        HashMap<String, EnumT> valueMap = new HashMap<String, EnumT>(numConstants);
        ArrayList<String> originalNames = new ArrayList<String>(numConstants);
        for (EnumT value2 : enumConstants) {
            String originalName = ((Enum)value2).toString();
            originalNames.add(originalName);
            String normalizedName = this.toNormalizedName(originalName);
            Enum oldValue = (Enum)valueMap.put(normalizedName, value2);
            if (oldValue == null) continue;
            throw new IllegalArgumentException("duplicate values: '" + value2 + "', '" + oldValue + '\'');
        }
        this.myOriginalNames = originalNames;
        this.myNormalizedValueMap = valueMap;
    }

    @Override
    @NotNull
    public List<String> getOriginalNames() {
        return this.myOriginalNames;
    }

    private final String toNormalizedName(String name) {
        String string = name.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return string;
    }

    @Override
    @NotNull
    public EnumT safeValueOf(@Nullable String name, @NotNull EnumT defaultValue) {
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        EnumT value2 = this.safeValueOf(name);
        EnumT EnumT = value2;
        if (EnumT == null) {
            EnumT = defaultValue;
        }
        return EnumT;
    }

    @Override
    @Nullable
    public EnumT safeValueOf(@Nullable String name) {
        Enum result2 = null;
        if (this.hasValue(name)) {
            String string = name;
            Intrinsics.checkNotNull((Object)string);
            result2 = (Enum)this.myNormalizedValueMap.get(this.toNormalizedName(string));
        } else {
            result2 = null;
        }
        return (EnumT)result2;
    }

    @Override
    public boolean hasValue(@Nullable String name) {
        return name != null && this.myNormalizedValueMap.containsKey(this.toNormalizedName(name));
    }

    @Override
    @NotNull
    public EnumT unsafeValueOf(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        EnumT EnumT = this.safeValueOf(name);
        if (EnumT == null) {
            throw new IllegalArgumentException("name not found: '" + name + '\'');
        }
        return EnumT;
    }
}

