/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.panel.datawrangler;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.scientific.py.tables.panel.datawrangler.DWTransformationsStorage;
import com.intellij.scientific.py.tables.panel.datawrangler.DataWranglerMainPanel;
import com.intellij.scientific.py.tables.panel.datawrangler.NewStepPanel;
import com.intellij.scientific.py.tables.panel.datawrangler.OperationCard;
import com.intellij.scientific.py.tables.panel.datawrangler.operations.OperationDescription;
import com.intellij.scientific.tables.DSTableBundle;
import com.intellij.scientific.tables.api.DSTableCommandExecutor;
import com.intellij.scientific.tables.panel.DSTableWithStatistics;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 &2\u00020\u0001:\u0002%&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001H\u0002J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001aJ\u0014\u0010 \u001a\u00020\u001a2\n\u0010!\u001a\u00060\u000fj\u0002`\u0010H\u0002J\b\u0010\"\u001a\u00020\u0001H\u0002J\u0014\u0010#\u001a\u00020\u001a2\n\u0010$\u001a\u00060\u000fj\u0002`\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006'"}, d2={"Lcom/intellij/scientific/py/tables/panel/datawrangler/TransformationsMultiPanel;", "Ljavax/swing/JPanel;", "table", "Lcom/intellij/scientific/tables/panel/DSTableWithStatistics;", "<init>", "(Lcom/intellij/scientific/tables/panel/DSTableWithStatistics;)V", "getTable", "()Lcom/intellij/scientific/tables/panel/DSTableWithStatistics;", "cardLayout", "Ljava/awt/CardLayout;", "cardPanels", "allStepsCenterPanel", "newStepPanel", "Lcom/intellij/scientific/py/tables/panel/datawrangler/NewStepPanel;", "currentStepNumber", "", "Lcom/intellij/scientific/py/tables/panel/datawrangler/StepNumber;", "myTransformationsStorage", "Lcom/intellij/scientific/py/tables/panel/datawrangler/DWTransformationsStorage;", "source", "Lcom/intellij/database/datagrid/GridRequestSource;", "getSource", "()Lcom/intellij/database/datagrid/GridRequestSource;", "stackBackToAllStepsButtonAndPanel", "panel", "saveNewTransformationStep", "", "transformationCode", "", "textToDisplay", "Lcom/intellij/scientific/py/tables/panel/datawrangler/operations/OperationDescription;", "navigateToAllStepsCard", "openOperationStep", "stepNumber", "createAllStepsPanel", "deleteStep", "stepNumberToDelete", "AddNewTransformationStep", "Companion", "intellij.scientific.py.tables"})
public final class TransformationsMultiPanel
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DSTableWithStatistics table;
    @NotNull
    private final CardLayout cardLayout;
    @NotNull
    private final JPanel cardPanels;
    @NotNull
    private final JPanel allStepsCenterPanel;
    @NotNull
    private final NewStepPanel newStepPanel;
    private int currentStepNumber;
    private DWTransformationsStorage myTransformationsStorage;
    @NotNull
    private final GridRequestSource source;
    public static final int ALL_STEPS = -2;
    public static final int NEW_STEP = -1;

    public TransformationsMultiPanel(@NotNull DSTableWithStatistics table) {
        JBScrollPane jBScrollPane;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        super(new BorderLayout());
        this.table = table;
        this.cardLayout = new CardLayout();
        this.cardPanels = new JPanel(this.cardLayout);
        this.allStepsCenterPanel = new JPanel((LayoutManager)new VerticalLayout(10));
        this.newStepPanel = new NewStepPanel(this, this.table);
        this.source = new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)this.table.getGrid()));
        this.cardPanels.add((Component)this.createAllStepsPanel(), "-2");
        this.cardPanels.add((Component)this.stackBackToAllStepsButtonAndPanel(this.newStepPanel), "-1");
        JBScrollPane $this$_init__u24lambda_u240 = jBScrollPane = new JBScrollPane(20, 31);
        boolean bl = false;
        $this$_init__u24lambda_u240.setBorder((Border)JBUI.Borders.empty());
        $this$_init__u24lambda_u240.setViewportView((Component)this.cardPanels);
        JBScrollPane scrollPane = jBScrollPane;
        this.add((Component)scrollPane);
    }

    @NotNull
    public final DSTableWithStatistics getTable() {
        return this.table;
    }

    @NotNull
    public final GridRequestSource getSource() {
        return this.source;
    }

    private final JPanel stackBackToAllStepsButtonAndPanel(JPanel panel) {
        JButton newBackToAllStepPanelButton = new JButton(DSTableBundle.message((String)"ds.DataWrangler.newStepPanel.backToAllTransformations.button", (Object[])new Object[0]));
        newBackToAllStepPanelButton.setIcon(AllIcons.Actions.Back);
        newBackToAllStepPanelButton.addActionListener(arg_0 -> TransformationsMultiPanel.stackBackToAllStepsButtonAndPanel$lambda$1(this, arg_0));
        return (JPanel)BuilderKt.panel(arg_0 -> TransformationsMultiPanel.stackBackToAllStepsButtonAndPanel$lambda$4(newBackToAllStepPanelButton, panel, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public final void saveNewTransformationStep(@NotNull String transformationCode, @NotNull JPanel panel, @NotNull OperationDescription textToDisplay) {
        void it;
        OperationCard operationCard;
        Intrinsics.checkNotNullParameter((Object)transformationCode, (String)"transformationCode");
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)textToDisplay, (String)"textToDisplay");
        if (this.myTransformationsStorage == null) {
            DSTableCommandExecutor dSTableCommandExecutor = this.table.getDSTableCommandExecutor();
            Intrinsics.checkNotNull((Object)dSTableCommandExecutor);
            this.myTransformationsStorage = new DWTransformationsStorage(dSTableCommandExecutor);
            DWTransformationsStorage dWTransformationsStorage = this.myTransformationsStorage;
            if (dWTransformationsStorage == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myTransformationsStorage");
                dWTransformationsStorage = null;
            }
            dWTransformationsStorage.initialStep(this.table);
        }
        ++this.currentStepNumber;
        this.cardPanels.add((Component)this.stackBackToAllStepsButtonAndPanel(panel), String.valueOf(this.currentStepNumber));
        OperationCard operationCard2 = operationCard = new OperationCard(this.currentStepNumber, textToDisplay);
        JPanel jPanel = this.allStepsCenterPanel;
        boolean bl = false;
        it.onCardClicked((Function0<Unit>)((Function0)() -> TransformationsMultiPanel.saveNewTransformationStep$lambda$7$lambda$5(this, (OperationCard)it)));
        it.onDeleteCardClicked((Function1<? super Integer, Unit>)((Function1)arg_0 -> TransformationsMultiPanel.saveNewTransformationStep$lambda$7$lambda$6(this, arg_0)));
        jPanel.add((Component)((Object)operationCard));
        DWTransformationsStorage dWTransformationsStorage = this.myTransformationsStorage;
        if (dWTransformationsStorage == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTransformationsStorage");
            dWTransformationsStorage = null;
        }
        dWTransformationsStorage.addNewStep(transformationCode, this.table);
        this.table.getLoader().loadAndSetColumns(this.source);
        this.newStepPanel.updateNewStepPanelAfterTransformation(this.table);
        this.navigateToAllStepsCard();
    }

    public final void navigateToAllStepsCard() {
        this.cardLayout.show(this.cardPanels, "-2");
    }

    private final void openOperationStep(int stepNumber) {
        this.cardLayout.show(this.cardPanels, String.valueOf(stepNumber));
    }

    private final JPanel createAllStepsPanel() {
        JBScrollPane jBScrollPane;
        String allStepsToolbar = "allStepsToolbar";
        JPanel topPanel = DataWranglerMainPanel.Companion.createSummaryTransformationsTopPanel(DSTableBundle.message((String)"ds.DataWrangler.transformations.panel.name", (Object[])new Object[0]), allStepsToolbar, (ActionGroup)new DefaultActionGroup(CollectionsKt.listOf((Object)((Object)new AddNewTransformationStep()))), 0);
        this.allStepsCenterPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.allStepsCenterPanel.setOpaque(true);
        this.allStepsCenterPanel.add(topPanel);
        JBScrollPane $this$createAllStepsPanel_u24lambda_u248 = jBScrollPane = new JBScrollPane(20, 31);
        boolean bl = false;
        $this$createAllStepsPanel_u24lambda_u248.setBorder((Border)JBUI.Borders.empty());
        $this$createAllStepsPanel_u24lambda_u248.setViewportView((Component)this.allStepsCenterPanel);
        JBScrollPane scrollPane = jBScrollPane;
        JPanel fff = new JPanel(new BorderLayout());
        fff.add((Component)scrollPane);
        return fff;
    }

    private final void deleteStep(int stepNumberToDelete) {
        DWTransformationsStorage dWTransformationsStorage;
        int step2;
        if (stepNumberToDelete <= this.currentStepNumber && stepNumberToDelete <= (step2 = this.currentStepNumber)) {
            while (true) {
                this.allStepsCenterPanel.remove(step2);
                this.cardPanels.remove(step2 + 1);
                if (step2 == stepNumberToDelete) break;
                --step2;
            }
        }
        if ((dWTransformationsStorage = this.myTransformationsStorage) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTransformationsStorage");
            dWTransformationsStorage = null;
        }
        dWTransformationsStorage.revert(stepNumberToDelete - 1, this.table, this.source);
        this.currentStepNumber = stepNumberToDelete - 1;
    }

    private static final void stackBackToAllStepsButtonAndPanel$lambda$1(TransformationsMultiPanel this$0, ActionEvent it) {
        this$0.navigateToAllStepsCard();
    }

    private static final Unit stackBackToAllStepsButtonAndPanel$lambda$4$lambda$2(JButton $newBackToAllStepPanelButton, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$newBackToAllStepPanelButton);
        return Unit.INSTANCE;
    }

    private static final Unit stackBackToAllStepsButtonAndPanel$lambda$4$lambda$3(JPanel $panel, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$panel).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit stackBackToAllStepsButtonAndPanel$lambda$4(JButton $newBackToAllStepPanelButton, JPanel $panel, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TransformationsMultiPanel.stackBackToAllStepsButtonAndPanel$lambda$4$lambda$2($newBackToAllStepPanelButton, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TransformationsMultiPanel.stackBackToAllStepsButtonAndPanel$lambda$4$lambda$3($panel, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit saveNewTransformationStep$lambda$7$lambda$5(TransformationsMultiPanel this$0, OperationCard $it) {
        this$0.openOperationStep($it.getStepNumber());
        return Unit.INSTANCE;
    }

    private static final Unit saveNewTransformationStep$lambda$7$lambda$6(TransformationsMultiPanel this$0, int stepNumber) {
        this$0.deleteStep(stepNumber);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/scientific/py/tables/panel/datawrangler/TransformationsMultiPanel$AddNewTransformationStep;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(Lcom/intellij/scientific/py/tables/panel/datawrangler/TransformationsMultiPanel;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.scientific.py.tables"})
    public final class AddNewTransformationStep
    extends AnAction {
        public AddNewTransformationStep() {
            super(AddNewTransformationStep::_init_$lambda$0, AllIcons.General.Add);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            TransformationsMultiPanel.this.cardLayout.show(TransformationsMultiPanel.this.cardPanels, "-1");
        }

        private static final String _init_$lambda$0() {
            return "Add new Transformation Step";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/scientific/py/tables/panel/datawrangler/TransformationsMultiPanel$Companion;", "", "<init>", "()V", "ALL_STEPS", "", "Lcom/intellij/scientific/py/tables/panel/datawrangler/StepNumber;", "NEW_STEP", "intellij.scientific.py.tables"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

