/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pyramid.annotator;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.daemon.DefaultGutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.QualifiedName;
import com.intellij.python.pyramid.project.PyramidUtils;
import com.intellij.template.lang.core.templateLanguages.TemplatesService;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PyramidViewLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    private static final @NlsContexts.Tooltip String GOTO_TEMPLATE_TOOLTIP = PythonProBundle.message((String)"pyramid.goto.template.tooltip");
    private static final @NlsContexts.Label String VIEWS_GROUP = PythonProBundle.message((String)"pyramid.views.group");

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2) {
        if (element == null) {
            PyramidViewLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            PyramidViewLineMarkerProvider.$$$reportNull$$$0(1);
        }
        PyramidViewLineMarkerProvider.collectLineMarkersForElement(result2, element);
    }

    public static void collectLineMarkersForElement(Collection<? super RelatedItemLineMarkerInfo<?>> result2, PsiElement element) {
        if (!(element instanceof PyFunction)) {
            return;
        }
        PyFunction function = (PyFunction)element;
        if (!PyramidUtils.isPyramidProject(element)) {
            return;
        }
        PyDecoratorList decoratorList = function.getDecoratorList();
        if (decoratorList == null) {
            return;
        }
        for (PyDecorator decorator : decoratorList.getDecorators()) {
            QualifiedName qualifiedName = decorator.getQualifiedName();
            if (qualifiedName == null || !qualifiedName.matches(new String[]{"view_config"}) && !qualifiedName.matches(new String[]{"view", "view_config"})) continue;
            PyStringLiteralExpression argument = (PyStringLiteralExpression)decorator.getArgument(1, "renderer", PyStringLiteralExpression.class);
            if (argument == null) {
                return;
            }
            Project project = element.getProject();
            String filePath2 = argument.getStringValue();
            VirtualFile virtualFile = project.getBaseDir().findFileByRelativePath(project.getName() + File.separator + filePath2);
            if (virtualFile == null) {
                VirtualFile folder;
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                List<VirtualFile> folders = TemplatesService.getInstance(module).getTemplateFolders();
                Iterator<VirtualFile> iterator2 = folders.iterator();
                while (iterator2.hasNext() && (virtualFile = (folder = iterator2.next()).findFileByRelativePath(filePath2)) == null) {
                }
            }
            if (virtualFile == null) {
                return;
            }
            PsiFile file = PsiManager.getInstance((Project)project).findFile(virtualFile);
            if (file == null) {
                return;
            }
            PsiElement identifier = function.getNameIdentifier();
            if (identifier == null) continue;
            RelatedItemLineMarkerInfo info = new RelatedItemLineMarkerInfo(identifier, identifier.getTextRange(), AllIcons.FileTypes.Html, (Function)new ConstantFunction((Object)GOTO_TEMPLATE_TOOLTIP), (GutterIconNavigationHandler)new DefaultGutterIconNavigationHandler((Collection)Lists.newArrayList((Object[])new PsiFile[]{file}), GOTO_TEMPLATE_TOOLTIP), GutterIconRenderer.Alignment.RIGHT, () -> GotoRelatedItem.createItems((Collection)Lists.newArrayList((Object[])new PsiFile[]{file}), (String)VIEWS_GROUP));
            result2.add(info);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/python/pyramid/annotator/PyramidViewLineMarkerProvider";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

