/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.cython;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.QualifiedName;
import com.intellij.python.pro.cython.CythonNames;
import com.intellij.python.pro.cython.psi.CythonFile;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CythonResolveUtil {
    @NonNls
    private static final String SS_PATH_FILE = "%s/%s";
    @NonNls
    private static final String S_PYX = "%s.pyx";
    @NonNls
    private static final String S_PXD = "%s.pxd";
    @NonNls
    private static final String S_PXI = "%s.pxi";
    @NonNls
    private static final String CYTHON_QNAME = "cython";
    @NonNls
    private static final String VIEW_QNAME = "view";
    @NonNls
    private static final String PARALLEL_QNAME = "parallel";
    @NonNls
    private static final String CYTHON_DOT_PARALLEL = "CythonDotParallel";
    @NonNls
    private static final String INCLUDES_FILE = "Includes";
    @NonNls
    public static final String CAPITAL_CYTHON_QNAME = "Cython";

    private CythonResolveUtil() {
    }

    @Nullable
    public static PsiElement getImportedElement(@Nullable QualifiedName containingQName, @NotNull QualifiedName importedQName, @NotNull PsiElement foothold, EnumSet<CythonFileType> fileTypes, boolean withRoots) {
        boolean resolveToContainingModule;
        if (importedQName == null) {
            CythonResolveUtil.$$$reportNull$$$0(0);
        }
        if (foothold == null) {
            CythonResolveUtil.$$$reportNull$$$0(1);
        }
        boolean bl = resolveToContainingModule = containingQName == null;
        if (resolveToContainingModule) {
            containingQName = importedQName.getComponentCount() > 0 ? QualifiedName.fromComponents((String[])new String[]{(String)importedQName.getComponents().get(0)}) : importedQName;
        }
        if (containingQName.matchesPrefix(QualifiedName.fromComponents((String[])new String[]{CYTHON_QNAME}))) {
            return CythonResolveUtil.getCythonPackageElement(containingQName, importedQName, foothold, resolveToContainingModule);
        }
        VirtualFile importedFile = CythonResolveUtil.findCythonFile(CythonResolveUtil.getIncludePath(foothold, withRoots), containingQName, fileTypes);
        if (importedFile != null) {
            VirtualFile importedDir;
            VirtualFile submodule;
            if (CythonResolveUtil.isPackageInit(importedFile) && (submodule = CythonResolveUtil.findCythonFile(Collections.singletonList(importedDir = importedFile.getParent()), importedQName, fileTypes)) != null) {
                if (CythonResolveUtil.isPythonPackageInit(submodule)) {
                    return null;
                }
                return foothold.getManager().findFile(submodule);
            }
            if (CythonResolveUtil.isPythonPackageInit(importedFile)) {
                return null;
            }
            PsiFile psi = foothold.getManager().findFile(importedFile);
            if (resolveToContainingModule) {
                return psi;
            }
            if (psi instanceof PyFile) {
                return ((PyFile)psi).getElementNamed(importedQName.toString());
            }
        }
        return null;
    }

    @Nullable
    public static VirtualFile findFile(List<? extends VirtualFile> path2, String filename) {
        for (VirtualFile virtualFile : path2) {
            VirtualFile result2 = virtualFile.findFileByRelativePath(filename);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    public static List<VirtualFile> getIncludePath(@NotNull PsiElement foothold, boolean withRoots) {
        if (foothold == null) {
            CythonResolveUtil.$$$reportNull$$$0(2);
        }
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        PsiDirectory curDir = foothold.getContainingFile().getParent();
        if (curDir != null) {
            result2.add(curDir.getVirtualFile());
        }
        if (withRoots) {
            result2.addAll(PyUtil.getSourceRoots((PsiElement)foothold));
            VirtualFile includes = CythonResolveUtil.getStandardIncludePath(foothold);
            if (includes != null) {
                result2.add(includes);
            }
        }
        return result2;
    }

    @Nullable
    public static VirtualFile findCythonFile(List<? extends VirtualFile> path2, QualifiedName qname, EnumSet<CythonFileType> fileTypes) {
        String qnamePath = StringUtil.join((Collection)qname.getComponents(), (String)"/");
        ArrayList<String> names2 = new ArrayList<String>();
        names2.add(String.format(SS_PATH_FILE, qnamePath, CythonNames.DEFINITION_PACKAGE_INIT));
        names2.add(String.format(SS_PATH_FILE, qnamePath, "__init__.py"));
        if (fileTypes.contains((Object)CythonFileType.REGULAR)) {
            names2.add(String.format(S_PYX, qnamePath));
        }
        if (fileTypes.contains((Object)CythonFileType.DEFINITION)) {
            names2.add(String.format(S_PXD, qnamePath));
        }
        if (fileTypes.contains((Object)CythonFileType.INCLUDE)) {
            names2.add(String.format(S_PXI, qnamePath));
        }
        for (String name : names2) {
            VirtualFile module = CythonResolveUtil.findFile(path2, name);
            if (module == null) continue;
            return module;
        }
        return null;
    }

    @Nullable
    public static CythonFile findImplicitDefinitionFile(PsiElement foothold) {
        String ext;
        PsiFile file = foothold.getContainingFile();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null && "pyx".equals(ext = virtualFile.getExtension())) {
            VirtualFile pxd;
            QualifiedName importedQName = QualifiedName.fromComponents((String[])new String[]{virtualFile.getNameWithoutExtension()});
            VirtualFile curDir = virtualFile.getParent();
            if (curDir != null && (pxd = CythonResolveUtil.findCythonFile(Collections.singletonList(curDir), importedQName, EnumSet.of(CythonFileType.DEFINITION))) != null) {
                return CythonResolveUtil.toCythonFile(foothold.getProject(), pxd);
            }
        }
        return null;
    }

    public static boolean isPackageInit(VirtualFile file) {
        return file.getName().equals(CythonNames.DEFINITION_PACKAGE_INIT) || CythonResolveUtil.isPythonPackageInit(file);
    }

    private static boolean isPythonPackageInit(@NotNull VirtualFile file) {
        if (file == null) {
            CythonResolveUtil.$$$reportNull$$$0(3);
        }
        return file.getName().equals("__init__.py");
    }

    @Nullable
    public static CythonFile toCythonFile(Project project, VirtualFile file) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile instanceof CythonFile) {
            return (CythonFile)psiFile;
        }
        return null;
    }

    @Nullable
    private static VirtualFile getStandardIncludePath(@NotNull PsiElement foothold) {
        VirtualFile cythonIncludes;
        VirtualFile cythonDir;
        if (foothold == null) {
            CythonResolveUtil.$$$reportNull$$$0(4);
        }
        if ((cythonDir = CythonResolveUtil.getCythonPackageDirectory(foothold)) != null && (cythonIncludes = cythonDir.findChild(INCLUDES_FILE)) != null) {
            return cythonIncludes;
        }
        return null;
    }

    @Nullable
    private static VirtualFile getCythonPackageDirectory(@NotNull PsiElement foothold) {
        PsiElement cythonPackage;
        if (foothold == null) {
            CythonResolveUtil.$$$reportNull$$$0(5);
        }
        if ((cythonPackage = CythonResolveUtil.resolveCythonPackageWithoutForeign(foothold)) instanceof PsiDirectory) {
            return ((PsiDirectory)cythonPackage).getVirtualFile();
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveCythonPackageWithoutForeign(@NotNull PsiElement foothold) {
        if (foothold == null) {
            CythonResolveUtil.$$$reportNull$$$0(6);
        }
        PyQualifiedNameResolveContext context = PyResolveImportUtil.fromFoothold((PsiElement)foothold).copyWithoutForeign();
        List packages = PyResolveImportUtil.resolveQualifiedName((QualifiedName)QualifiedName.fromDottedString((String)CAPITAL_CYTHON_QNAME), (PyQualifiedNameResolveContext)context);
        return !packages.isEmpty() ? (PsiElement)packages.get(0) : null;
    }

    private static PsiElement getCythonPackageElement(@Nullable QualifiedName containingQName, @NotNull QualifiedName importedQName, @NotNull PsiElement foothold, boolean resolveToContainingModule) {
        PsiElement cythonPackage;
        if (importedQName == null) {
            CythonResolveUtil.$$$reportNull$$$0(7);
        }
        if (foothold == null) {
            CythonResolveUtil.$$$reportNull$$$0(8);
        }
        if ((cythonPackage = CythonResolveUtil.resolveCythonPackageWithoutForeign(foothold)) instanceof PsiDirectory) {
            cythonPackage = PyUtil.getPackageElement((PsiDirectory)((PsiDirectory)cythonPackage), (PsiElement)foothold);
        }
        if (cythonPackage instanceof PyFile) {
            PyFile packageFile = (PyFile)cythonPackage;
            PsiElement parallel = packageFile.getElementNamed(CYTHON_DOT_PARALLEL);
            if (VIEW_QNAME.equals(importedQName.toString())) {
                return cythonPackage;
            }
            if (containingQName != null && containingQName.matches(new String[]{CYTHON_QNAME, PARALLEL_QNAME})) {
                if (parallel instanceof PyClass) {
                    return ((PyClass)parallel).findMethodByName(importedQName.toString(), true, null);
                }
                return null;
            }
            if (PARALLEL_QNAME.equals(importedQName.toString())) {
                return parallel;
            }
            if (resolveToContainingModule) {
                return cythonPackage;
            }
            return packageFile.getElementNamed(importedQName.toString());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedQName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foothold";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/pro/cython/CythonResolveUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getImportedElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getIncludePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isPythonPackageInit";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getStandardIncludePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getCythonPackageDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveCythonPackageWithoutForeign";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getCythonPackageElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum CythonFileType {
        REGULAR,
        DEFINITION,
        INCLUDE;

    }
}

