/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.ift.lesson.essensial;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereUI;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.idea.ActionsBundle;
import com.intellij.jupyter.core.core.impl.actions.run.NotebookRunAllBelowAction;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.py.debugger.JupyterDebugAction;
import com.intellij.jupyter.py.ift.DsIftUtilsKt;
import com.intellij.jupyter.py.ift.DsLessonsBundle;
import com.intellij.jupyter.py.ift.lesson.essensial.JupyterOnboardingTourLessonKt;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorMode;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorModeKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebooksVisualizationIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.platform.AttachProjectAction;
import com.intellij.python.featuresTrainer.ift.PythonLessonsBundle;
import com.intellij.python.featuresTrainer.ift.PythonLessonsUtil;
import com.intellij.scientific.tables.editor.DSTableVirtualFile;
import com.intellij.toolWindow.StripeButton;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.sdk.PySdkExtKt;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.intellij.images.ui.ImageComponent;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.HighlightTriggerParametersContext;
import training.dsl.HighlightingTriggerMethods;
import training.dsl.LearningBalloonConfig;
import training.dsl.LessonContext;
import training.dsl.LessonSample;
import training.dsl.LessonSampleKt;
import training.dsl.LessonUtil;
import training.dsl.LessonUtilKt;
import training.dsl.TaskContext;
import training.dsl.TaskRuntimeContext;
import training.lang.LangSupport;
import training.learn.course.KLesson;
import training.learn.course.LessonProperties;
import training.learn.lesson.general.run.CommonDebugLessonKt;
import training.project.ProjectUtils;
import training.ui.LearningUiHighlightingManager;
import training.ui.OnboardingFeedbackFormKt;
import training.util.LessonEndInfo;
import training.util.UtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000b0'H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020)2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010-\u001a\u00020)2\u0006\u0010$\u001a\u00020%H\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010$\u001a\u00020%H\u0002J\f\u00108\u001a\u00020)*\u000204H\u0002J\f\u00109\u001a\u00020)*\u000204H\u0002J\f\u0010:\u001a\u00020)*\u000204H\u0002J\f\u0010;\u001a\u00020)*\u00020<H\u0002J\f\u0010=\u001a\u00020)*\u000204H\u0002J\f\u0010>\u001a\u00020)*\u000204H\u0002J\u001e\u0010?\u001a\u00020)*\u0002042\u0006\u0010@\u001a\u00020\u000b2\b\b\u0001\u0010A\u001a\u00020\u000bH\u0002J\f\u0010B\u001a\u00020)*\u000204H\u0002J\f\u0010C\u001a\u00020)*\u000204H\u0002J\f\u0010D\u001a\u00020)*\u000204H\u0002J\f\u0010E\u001a\u00020)*\u000204H\u0002J\f\u0010F\u001a\u00020)*\u000204H\u0002J\u0014\u0010G\u001a\u00020)*\u00020H2\u0006\u0010I\u001a\u00020\u000bH\u0002J\u0018\u0010J\u001a\u00020)2\u0006\u0010$\u001a\u00020%2\u0006\u0010K\u001a\u00020LH\u0016J\u0010\u0010M\u001a\u00020)2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010N\u001a\u00020)2\u0006\u0010O\u001a\u00020/2\u0006\u0010$\u001a\u00020%H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R%\u00102\u001a\u0013\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020)03\u00a2\u0006\u0002\b5X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107\u00a8\u0006P"}, d2={"Lcom/intellij/jupyter/py/ift/lesson/essensial/JupyterOnboardingTourLesson;", "Ltraining/learn/course/KLesson;", "<init>", "()V", "properties", "Ltraining/learn/course/LessonProperties;", "getProperties", "()Ltraining/learn/course/LessonProperties;", "backupPopupLocation", "Ljava/awt/Point;", "attachDirectoryName", "", "oneCellCode", "languageSupport", "Ltraining/lang/LangSupport;", "getLanguageSupport", "()Ltraining/lang/LangSupport;", "learningContentRoot", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getLearningContentRoot", "()Ljava/nio/file/Path;", "skipStartForDebug", "", "getSkipStartForDebug", "()Z", "installPandasTasksRequired", "installMatplotlibTasksRequired", "usedInterpreterAtStart", "uiSettings", "Lcom/intellij/ide/ui/UISettings;", "getUiSettings", "()Lcom/intellij/ide/ui/UISettings;", "hideToolStripesPreference", "showMainToolbarPreference", "packageIsNotInstalled", "project", "Lcom/intellij/openapi/project/Project;", "packageNames", "", "beforeCaretApplied", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "prepare", "detachLearningModule", "getLearningModule", "Lcom/intellij/openapi/module/Module;", "notebookDefaultName", "notebookName", "lessonContent", "Lkotlin/Function1;", "Ltraining/dsl/LessonContext;", "Lkotlin/ExtensionFunctionType;", "getLessonContent", "()Lkotlin/jvm/functions/Function1;", "checkUiSettings", "addFinishInformers", "workspaceTasks", "detectDirectoryUi", "Ltraining/dsl/TaskContext;", "firstCellTasks", "installPandasTasks", "installPackageTasks", "packageName", "installDescriptionMessage", "secondCellTasks", "installMatplotlibTasks", "thirdCellTasks", "debugAndFixTasks", "waitUntilInstallIsDone", "jupyterCaret", "Ltraining/dsl/TaskRuntimeContext;", "text", "onLessonEnd", "lessonEndInfo", "Ltraining/util/LessonEndInfo;", "showNotificationAboutLearningDirectoryDetach", "disableEditorsModificationOnLessonEnd", "learningModule", "intellij.jupyter.py.ift"})
@SourceDebugExtension(value={"SMAP\nJupyterOnboardingTourLesson.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterOnboardingTourLesson.kt\ncom/intellij/jupyter/py/ift/lesson/essensial/JupyterOnboardingTourLesson\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 HighlightingTriggerMethods.kt\ntraining/dsl/HighlightingTriggerMethods\n*L\n1#1,782:1\n24#2:783\n24#2:799\n24#2:806\n1734#3,3:784\n1971#3,14:829\n1#4:787\n3170#5,11:788\n20#6,2:800\n20#6,2:802\n20#6,2:804\n20#6,2:807\n20#6,2:809\n20#6,2:811\n20#6,2:813\n20#6,2:815\n20#6,2:817\n25#6,2:819\n20#6,2:821\n25#6,2:823\n20#6,2:825\n20#6,2:827\n20#6,2:843\n*S KotlinDebug\n*F\n+ 1 JupyterOnboardingTourLesson.kt\ncom/intellij/jupyter/py/ift/lesson/essensial/JupyterOnboardingTourLesson\n*L\n131#1:783\n726#1:799\n271#1:806\n135#1:784,3\n673#1:829,14\n174#1:788,11\n244#1:800,2\n249#1:802,2\n261#1:804,2\n295#1:807,2\n302#1:809,2\n309#1:811,2\n356#1:813,2\n372#1:815,2\n429#1:817,2\n495#1:819,2\n512#1:821,2\n548#1:823,2\n561#1:825,2\n578#1:827,2\n702#1:843,2\n*E\n"})
public final class JupyterOnboardingTourLesson
extends KLesson {
    @NotNull
    private final LessonProperties properties;
    @Nullable
    private Point backupPopupLocation;
    @NotNull
    private final String attachDirectoryName;
    @NotNull
    private final String oneCellCode;
    private boolean installPandasTasksRequired;
    private boolean installMatplotlibTasksRequired;
    @NotNull
    private String usedInterpreterAtStart;
    private boolean hideToolStripesPreference;
    private boolean showMainToolbarPreference;
    @NotNull
    private final String notebookDefaultName;
    @NotNull
    private String notebookName;
    @NotNull
    private final Function1<LessonContext, Unit> lessonContent;

    public JupyterOnboardingTourLesson() {
        Object[] objectArray = new Object[]{LessonUtil.INSTANCE.getProductName()};
        super("jupyter.onboarding", DsLessonsBundle.INSTANCE.message("jupyter.onboarding.lesson.name", objectArray));
        this.properties = new LessonProperties(true, false, null, 4, null);
        this.attachDirectoryName = "dataspell_demo";
        this.oneCellCode = "#%%\nimport pandas as pd\n\nkernel_stats = pd.read_csv('data/libraries_by_python_version.csv')\nkernel_stats";
        this.installPandasTasksRequired = true;
        this.installMatplotlibTasksRequired = true;
        this.usedInterpreterAtStart = "undefined";
        this.showMainToolbarPreference = true;
        this.notebookName = this.notebookDefaultName = "my_notebook";
        this.lessonContent = arg_0 -> JupyterOnboardingTourLesson.lessonContent$lambda$7(this, arg_0);
    }

    @NotNull
    public LessonProperties getProperties() {
        return this.properties;
    }

    private final LangSupport getLanguageSupport() {
        LangSupport langSupport = this.getModule().getPrimaryLanguage();
        if (langSupport == null) {
            throw new IllegalStateException("No language specified for the module of onboarding tour".toString());
        }
        return langSupport;
    }

    private final Path getLearningContentRoot() {
        return ProjectUtils.INSTANCE.getLearningProjectsPath().resolve(this.getLanguageSupport().getContentRootDirectoryName());
    }

    private final boolean getSkipStartForDebug() {
        return false;
    }

    private final UISettings getUiSettings() {
        return UISettings.Companion.getInstance();
    }

    private final boolean packageIsNotInstalled(Project project, List<String> packageNames) {
        boolean bl;
        block4: {
            Sdk sdk = PySdkExtKt.getPythonSdk((Project)project);
            if (sdk == null) {
                JupyterOnboardingTourLesson $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger2 = Logger.getInstance(JupyterOnboardingTourLesson.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                logger2.error("Python SDK is not configured");
                return true;
            }
            PyPackageManager manager = PyPackageManager.getInstance((Sdk)sdk);
            boolean bl2 = false;
            Iterable $this$all$iv = packageNames;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)manager);
                    if (JupyterOnboardingTourLessonKt.access$noPackage(manager, it)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    public void beforeCaretApplied(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        NotebookEditorModeKt.setMode((Editor)editor, (NotebookEditorMode)NotebookEditorMode.EDIT);
    }

    public void prepare(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Sdk sdk = PySdkExtKt.getPythonSdk((Project)project);
        if (sdk != null) {
            Sdk it = sdk;
            boolean bl = false;
            PyPackageManager.getInstance((Sdk)it).refreshAndGetPackages(false);
        }
        ActionsKt.invokeAndWaitIfNeeded$default(null, () -> JupyterOnboardingTourLesson.prepare$lambda$3(this, project), (int)1, null);
        Path learningDataPath = this.getLearningContentRoot();
        Intrinsics.checkNotNull((Object)learningDataPath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(learningDataPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            PathKt.delete((Path)learningDataPath, (boolean)true);
        }
        PathKt.createDirectories((Path)learningDataPath);
        LangSupport langSupport = this.getLanguageSupport();
        File file = learningDataPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        LangSupport.copyLearningProjectFiles$default((LangSupport)langSupport, (File)file, null, (int)2, null);
    }

    private final void detachLearningModule(Project project) {
        Module module = this.getLearningModule(project);
        if (module == null) {
            return;
        }
        Module learningModule = module;
        ActionsKt.runWriteAction(() -> JupyterOnboardingTourLesson.detachLearningModule$lambda$4(project, learningModule));
    }

    private final Module getLearningModule(Project project) {
        Module module;
        block4: {
            Module[] modules = ModuleManager.Companion.getInstance(project).getModules();
            Path learningModulePath = DsIftUtilsKt.getLearningModulePath(this.getLanguageSupport());
            Module[] $this$singleOrNull$iv = modules;
            boolean $i$f$singleOrNull = false;
            Module single$iv = null;
            boolean found$iv = false;
            int n = $this$singleOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                Path path2;
                Module element$iv;
                Module it = element$iv = $this$singleOrNull$iv[i];
                boolean bl = false;
                try {
                    VirtualFile virtualFile = ProjectUtil.guessModuleDir((Module)it);
                    path2 = virtualFile != null ? virtualFile.toNioPath() : null;
                }
                catch (UnsupportedOperationException e) {
                    path2 = null;
                }
                if (!Intrinsics.areEqual(path2, (Object)learningModulePath)) continue;
                if (found$iv) {
                    module = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            module = !found$iv ? null : single$iv;
        }
        return module;
    }

    @NotNull
    protected Function1<LessonContext, Unit> getLessonContent() {
        return this.lessonContent;
    }

    private final void checkUiSettings(LessonContext $this$checkUiSettings) {
        LessonUtilKt.showInvalidDebugLayoutWarning((LessonContext)$this$checkUiSettings);
        if (!this.getUiSettings().getHideToolStripes() && this.getUiSettings().getShowNewMainToolbar()) {
            $this$checkUiSettings.task(JupyterOnboardingTourLesson::checkUiSettings$lambda$8);
            $this$checkUiSettings.task(JupyterOnboardingTourLesson::checkUiSettings$lambda$9);
            return;
        }
        $this$checkUiSettings.task(JupyterOnboardingTourLesson::checkUiSettings$lambda$10);
        LessonContext.prepareRuntimeTask$default((LessonContext)$this$checkUiSettings, null, arg_0 -> JupyterOnboardingTourLesson.checkUiSettings$lambda$11(this, arg_0), (int)1, null);
    }

    private final void addFinishInformers(LessonContext $this$addFinishInformers) {
        $this$addFinishInformers.text(DsLessonsBundle.INSTANCE.message("jupyter.onboarding.congratulations", new Object[0]));
        Object[] objectArray = new Object[]{$this$addFinishInformers.code(this.attachDirectoryName)};
        $this$addFinishInformers.text(DsLessonsBundle.INSTANCE.message("jupyter.onboarding.cleaunup.informer", objectArray));
    }

    private final void workspaceTasks(LessonContext $this$workspaceTasks) {
        $this$workspaceTasks.task(JupyterOnboardingTourLesson::workspaceTasks$lambda$15);
        $this$workspaceTasks.task(JupyterOnboardingTourLesson::workspaceTasks$lambda$17);
        $this$workspaceTasks.task(arg_0 -> JupyterOnboardingTourLesson.workspaceTasks$lambda$19(this, arg_0));
        $this$workspaceTasks.task(arg_0 -> JupyterOnboardingTourLesson.workspaceTasks$lambda$20(this, arg_0));
        String string = ActionsBundle.message((String)"group.WeighingNewGroup.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String newGroupName = LessonUtilKt.dropMnemonic((String)string);
        String jupyterNotebookItemName = JupyterBundle.message((String)"action.JupyterCreateFileAction.text", (Object[])new Object[0]);
        $this$workspaceTasks.task(arg_0 -> JupyterOnboardingTourLesson.workspaceTasks$lambda$23(this, newGroupName, jupyterNotebookItemName, arg_0));
        $this$workspaceTasks.task(arg_0 -> JupyterOnboardingTourLesson.workspaceTasks$lambda$26(jupyterNotebookItemName, arg_0));
        $this$workspaceTasks.task(arg_0 -> JupyterOnboardingTourLesson.workspaceTasks$lambda$28(this, arg_0));
        $this$workspaceTasks.task(arg_0 -> JupyterOnboardingTourLesson.workspaceTasks$lambda$31(this, arg_0));
        LessonContext.prepareRuntimeTask$default((LessonContext)$this$workspaceTasks, null, arg_0 -> JupyterOnboardingTourLesson.workspaceTasks$lambda$32(this, arg_0), (int)1, null);
    }

    private final void detectDirectoryUi(TaskContext $this$detectDirectoryUi) {
        TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$detectDirectoryUi, null, (int)1, null).treeItem((arg_0, arg_1, arg_2) -> JupyterOnboardingTourLesson.detectDirectoryUi$lambda$33(this, arg_0, arg_1, arg_2));
    }

    private final void firstCellTasks(LessonContext $this$firstCellTasks) {
        $this$firstCellTasks.waitBeforeContinue(500);
        LessonSample sampleOne = LessonSampleKt.parseLessonSample((String)this.oneCellCode);
        LessonContext.prepareRuntimeTask$default((LessonContext)$this$firstCellTasks, null, arg_0 -> JupyterOnboardingTourLesson.firstCellTasks$lambda$35(sampleOne, arg_0), (int)1, null);
        this.installPandasTasks($this$firstCellTasks);
        $this$firstCellTasks.task(arg_0 -> JupyterOnboardingTourLesson.firstCellTasks$lambda$37(sampleOne, arg_0));
        $this$firstCellTasks.task(arg_0 -> JupyterOnboardingTourLesson.firstCellTasks$lambda$39(sampleOne, arg_0));
        $this$firstCellTasks.task(arg_0 -> JupyterOnboardingTourLesson.firstCellTasks$lambda$41(this, arg_0));
        $this$firstCellTasks.task(arg_0 -> JupyterOnboardingTourLesson.firstCellTasks$lambda$43(this, arg_0));
        LessonUtilKt.highlightButtonById$default((LessonContext)$this$firstCellTasks, (String)"JupyterToolbar.AddActionsPopup", (boolean)false, (boolean)false, (boolean)false, null, (int)30, null);
        $this$firstCellTasks.task(arg_0 -> JupyterOnboardingTourLesson.firstCellTasks$lambda$45(sampleOne, arg_0));
        LessonContext.prepareRuntimeTask$default((LessonContext)$this$firstCellTasks, null, JupyterOnboardingTourLesson::firstCellTasks$lambda$46, (int)1, null);
    }

    private final void installPandasTasks(LessonContext $this$installPandasTasks) {
        if (!this.installPandasTasksRequired) {
            return;
        }
        LessonContext.prepareRuntimeTask$default((LessonContext)$this$installPandasTasks, null, arg_0 -> JupyterOnboardingTourLesson.installPandasTasks$lambda$47(this, arg_0), (int)1, null);
        Object[] objectArray = new Object[]{$this$installPandasTasks.strong("pandas"), $this$installPandasTasks.code("pandas"), $this$installPandasTasks.action("ShowIntentionActions")};
        this.installPackageTasks($this$installPandasTasks, "pandas", DsLessonsBundle.INSTANCE.message("jupyter.onboarding.install.pandas", objectArray));
    }

    private final void installPackageTasks(LessonContext $this$installPackageTasks, String packageName, @Language(value="HTML") @Nls String installDescriptionMessage) {
        $this$installPackageTasks.task(arg_0 -> JupyterOnboardingTourLesson.installPackageTasks$lambda$49(installDescriptionMessage, packageName, arg_0));
        $this$installPackageTasks.task(arg_0 -> JupyterOnboardingTourLesson.installPackageTasks$lambda$51(packageName, arg_0));
        $this$installPackageTasks.task(arg_0 -> JupyterOnboardingTourLesson.installPackageTasks$lambda$53(this, packageName, arg_0));
        this.waitUntilInstallIsDone($this$installPackageTasks);
    }

    private final void secondCellTasks(LessonContext $this$secondCellTasks) {
        $this$secondCellTasks.waitBeforeContinue(1000);
        $this$secondCellTasks.task(JupyterOnboardingTourLesson::secondCellTasks$lambda$54);
        this.installMatplotlibTasks($this$secondCellTasks);
        LessonContext.prepareRuntimeTask$default((LessonContext)$this$secondCellTasks, null, arg_0 -> JupyterOnboardingTourLesson.secondCellTasks$lambda$55(this, arg_0), (int)1, null);
        $this$secondCellTasks.task(JupyterOnboardingTourLesson::secondCellTasks$lambda$57);
        $this$secondCellTasks.task(JupyterOnboardingTourLesson::secondCellTasks$lambda$59);
        $this$secondCellTasks.task(JupyterOnboardingTourLesson::secondCellTasks$lambda$63);
        LessonUtilKt.highlightButtonById$default((LessonContext)$this$secondCellTasks, (String)"NotebookRunCellSelectBelowAction", (boolean)false, (boolean)false, (boolean)false, null, (int)30, null);
        String runAndInsertText = LessonUtilKt.dropMnemonic((String)JupyterBundle.message((String)"action.NotebookRunCellSelectBelowAction.text", (Object[])new Object[0]));
        $this$secondCellTasks.actionTask("NotebookRunCellSelectBelowAction", (arg_0, arg_1) -> JupyterOnboardingTourLesson.secondCellTasks$lambda$64(runAndInsertText, arg_0, arg_1));
        $this$secondCellTasks.task(JupyterOnboardingTourLesson::secondCellTasks$lambda$66);
    }

    private final void installMatplotlibTasks(LessonContext $this$installMatplotlibTasks) {
        if (!this.installMatplotlibTasksRequired) {
            return;
        }
        LessonContext.prepareRuntimeTask$default((LessonContext)$this$installMatplotlibTasks, null, arg_0 -> JupyterOnboardingTourLesson.installMatplotlibTasks$lambda$67(this, arg_0), (int)1, null);
        Object[] objectArray = new Object[]{$this$installMatplotlibTasks.strong("matplotlib"), $this$installMatplotlibTasks.action("ShowIntentionActions")};
        this.installPackageTasks($this$installMatplotlibTasks, "matplotlib", DsLessonsBundle.INSTANCE.message("jupyter.onboarding.install.matplotlib", objectArray));
    }

    private final void thirdCellTasks(LessonContext $this$thirdCellTasks) {
        $this$thirdCellTasks.task(JupyterOnboardingTourLesson::thirdCellTasks$lambda$68);
        $this$thirdCellTasks.task(JupyterOnboardingTourLesson::thirdCellTasks$lambda$71);
        String splitItemText = LessonUtilKt.dropMnemonic((String)JupyterBundle.message((String)"action.NotebookSplitCellAction.text", (Object[])new Object[0]));
        $this$thirdCellTasks.task(arg_0 -> JupyterOnboardingTourLesson.thirdCellTasks$lambda$75(splitItemText, this, arg_0));
        $this$thirdCellTasks.actionTask("NotebookSplitCellAction", (arg_0, arg_1) -> JupyterOnboardingTourLesson.thirdCellTasks$lambda$76(splitItemText, arg_0, arg_1));
        $this$thirdCellTasks.task(arg_0 -> JupyterOnboardingTourLesson.thirdCellTasks$lambda$79(this, arg_0));
        $this$thirdCellTasks.task(arg_0 -> JupyterOnboardingTourLesson.thirdCellTasks$lambda$82(this, arg_0));
        $this$thirdCellTasks.actionTask("NotebookRunAllBelowAction", JupyterOnboardingTourLesson::thirdCellTasks$lambda$83);
    }

    private final void debugAndFixTasks(LessonContext $this$debugAndFixTasks) {
        $this$debugAndFixTasks.task(JupyterOnboardingTourLesson::debugAndFixTasks$lambda$84);
        Ref.ObjectRef logicalPosition = new Ref.ObjectRef();
        logicalPosition.element = new LogicalPosition(0, 0);
        LessonContext.prepareRuntimeTask$default((LessonContext)$this$debugAndFixTasks, null, arg_0 -> JupyterOnboardingTourLesson.debugAndFixTasks$lambda$85(logicalPosition, arg_0), (int)1, null);
        Function1 xRange = JupyterOnboardingTourLesson::debugAndFixTasks$lambda$86;
        String debugActionId = JupyterDebugAction.class.getSimpleName();
        CommonDebugLessonKt.toggleBreakpointTask$default((LessonContext)$this$debugAndFixTasks, null, () -> JupyterOnboardingTourLesson.debugAndFixTasks$lambda$87(logicalPosition), (boolean)false, (Function1)xRange, (boolean)false, JupyterOnboardingTourLesson::debugAndFixTasks$lambda$88, (int)16, null);
        Intrinsics.checkNotNull((Object)debugActionId);
        LessonUtilKt.highlightButtonById$default((LessonContext)$this$debugAndFixTasks, (String)debugActionId, (boolean)false, (boolean)false, (boolean)false, null, (int)30, null);
        LessonContext.prepareRuntimeTask$default((LessonContext)$this$debugAndFixTasks, null, arg_0 -> JupyterOnboardingTourLesson.debugAndFixTasks$lambda$89(this, arg_0), (int)1, null);
        $this$debugAndFixTasks.text(DsLessonsBundle.INSTANCE.message("jupyter.onboarding.debugging.workflow.description", new Object[0]));
        $this$debugAndFixTasks.actionTask(debugActionId, JupyterOnboardingTourLesson::debugAndFixTasks$lambda$90);
        LessonUtilKt.highlightButtonById$default((LessonContext)$this$debugAndFixTasks, (String)debugActionId, (boolean)false, (boolean)false, (boolean)false, null, (int)30, null);
        LessonContext.prepareRuntimeTask$default((LessonContext)$this$debugAndFixTasks, null, arg_0 -> JupyterOnboardingTourLesson.debugAndFixTasks$lambda$91(this, arg_0), (int)1, null);
        $this$debugAndFixTasks.text(DsLessonsBundle.INSTANCE.message("jupyter.onboarding.start.to.debug.call", new Object[0]));
        $this$debugAndFixTasks.actionTask(debugActionId, JupyterOnboardingTourLesson::debugAndFixTasks$lambda$92);
        LessonUtilKt.highlightOldDebugActionsToolbar$default((LessonContext)$this$debugAndFixTasks, (boolean)false, (boolean)false, (int)3, null);
        $this$debugAndFixTasks.task(JupyterOnboardingTourLesson::debugAndFixTasks$lambda$93);
        LessonUtilKt.highlightButtonById$default((LessonContext)$this$debugAndFixTasks, (String)"Stop", (boolean)false, (boolean)false, (boolean)false, null, (int)30, null);
        $this$debugAndFixTasks.task(JupyterOnboardingTourLesson::debugAndFixTasks$lambda$97);
        $this$debugAndFixTasks.task(arg_0 -> JupyterOnboardingTourLesson.debugAndFixTasks$lambda$100(this, arg_0));
        LessonUtilKt.highlightButtonById$default((LessonContext)$this$debugAndFixTasks, (String)"NotebookRunAllAction", (boolean)false, (boolean)false, (boolean)false, null, (int)30, null);
        $this$debugAndFixTasks.actionTask("NotebookRunAllAction", JupyterOnboardingTourLesson::debugAndFixTasks$lambda$101);
    }

    private final void waitUntilInstallIsDone(LessonContext $this$waitUntilInstallIsDone) {
        $this$waitUntilInstallIsDone.waitBeforeContinue(1000);
        $this$waitUntilInstallIsDone.task(JupyterOnboardingTourLesson::waitUntilInstallIsDone$lambda$103);
        $this$waitUntilInstallIsDone.task(JupyterOnboardingTourLesson::waitUntilInstallIsDone$lambda$104);
        LessonContext.prepareRuntimeTask$default((LessonContext)$this$waitUntilInstallIsDone, null, JupyterOnboardingTourLesson::waitUntilInstallIsDone$lambda$105, (int)1, null);
    }

    private final void jupyterCaret(TaskRuntimeContext $this$jupyterCaret, String text2) {
        NotebookEditorModeKt.setMode((Editor)$this$jupyterCaret.getEditor(), (NotebookEditorMode)NotebookEditorMode.EDIT);
        TaskRuntimeContext.caret$default((TaskRuntimeContext)$this$jupyterCaret, (String)text2, (boolean)false, (int)2, null);
        $this$jupyterCaret.getEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER);
    }

    public void onLessonEnd(@NotNull Project project, @NotNull LessonEndInfo lessonEndInfo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lessonEndInfo, (String)"lessonEndInfo");
        LangSupport primaryLanguage = this.getModule().getPrimaryLanguage();
        if (primaryLanguage == null) {
            JupyterOnboardingTourLesson $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(JupyterOnboardingTourLesson.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.error("Onboarding lesson has no language support for some magical reason");
            return;
        }
        PythonLessonsUtil.INSTANCE.prepareFeedbackDataForOnboardingLesson(project, OnboardingFeedbackFormKt.getFeedbackProposedPropertyName((LangSupport)primaryLanguage), "DataSpell Onboarding Tour Feedback", "dataspell_onboarding_tour", primaryLanguage, lessonEndInfo, this.usedInterpreterAtStart);
        this.getUiSettings().setHideToolStripes(this.hideToolStripesPreference);
        this.getUiSettings().setShowNewMainToolbar(this.showMainToolbarPreference);
        this.getUiSettings().fireUISettingsChanged();
        ActionsKt.invokeLater$default(null, () -> JupyterOnboardingTourLesson.onLessonEnd$lambda$106(project, this), (int)1, null);
    }

    private final void showNotificationAboutLearningDirectoryDetach(Project project) {
        Notification notification = UtilsKt.getIftNotificationGroup().createNotification(DsLessonsBundle.INSTANCE.message("jupyter.onboarding.cleanup.notification.title", new Object[0]), DsLessonsBundle.INSTANCE.message("jupyter.onboarding.cleanup.notification.description", new Object[0]), NotificationType.INFORMATION);
        Object[] objectArray = new Object[]{StringsKt.replace$default((String)this.attachDirectoryName, (String)"_", (String)"__", (boolean)false, (int)4, null)};
        String linkText = DsLessonsBundle.INSTANCE.message("jupyter.onboarding.cleanup.notification.action", objectArray);
        notification.addAction((AnAction)new NotificationAction(linkText, this, project){
            final /* synthetic */ JupyterOnboardingTourLesson this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super($linkText);
            }

            public void actionPerformed(AnActionEvent e, Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                JupyterOnboardingTourLesson.access$detachLearningModule(this.this$0, this.$project);
                notification.expire();
            }
        });
        notification.notify(project);
    }

    private final void disableEditorsModificationOnLessonEnd(Module learningModule, Project project) {
        VirtualFile virtualFile = ProjectUtil.guessModuleDir((Module)learningModule);
        if (virtualFile == null) {
            return;
        }
        VirtualFile moduleDir = virtualFile;
        for (FileEditor editor : FileEditorManager.getInstance((Project)project).getAllEditors()) {
            VirtualFile file = null;
            VirtualFile virtualFile2 = editor.getFile();
            if (virtualFile2 == null) continue;
            file = virtualFile2;
            if (BackedNotebookVirtualFile.Companion.takeIfBacked(file) != null) {
                BackedNotebookVirtualFile it;
                boolean bl = false;
                file = it.getOriginFile();
            }
            if (!VfsUtilCore.isAncestor((VirtualFile)moduleDir, (VirtualFile)file, (boolean)false)) continue;
            Intrinsics.checkNotNull((Object)editor);
            DsIftUtilsKt.setEditorWithLearningFileAsRO(editor);
        }
    }

    private static final Unit prepare$lambda$3(JupyterOnboardingTourLesson this$0, Project $project) {
        this$0.installPandasTasksRequired = this$0.packageIsNotInstalled($project, CollectionsKt.listOf((Object)"pandas"));
        this$0.installMatplotlibTasksRequired = this$0.packageIsNotInstalled($project, CollectionsKt.listOf((Object)"matplotlib"));
        if (!this$0.getSkipStartForDebug()) {
            this$0.detachLearningModule($project);
        }
        return Unit.INSTANCE;
    }

    private static final Unit detachLearningModule$lambda$4(Project $project, Module $learningModule) {
        Module[] moduleArray = new Module[]{$learningModule};
        ModuleDeleteProvider.detachModules((Project)$project, (Module[])moduleArray);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$7$lambda$6(JupyterOnboardingTourLesson this$0, TaskRuntimeContext $this$prepareRuntimeTask) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
        Object object = PySdkExtKt.getPythonSdk((Project)$this$prepareRuntimeTask.getProject());
        if (object == null || (object = object.getVersionString()) == null) {
            object = "none";
        }
        this$0.usedInterpreterAtStart = object;
        LessonUtil.INSTANCE.hideStandardToolwindows($this$prepareRuntimeTask.getProject());
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$7(JupyterOnboardingTourLesson this$0, LessonContext lessonContext) {
        Intrinsics.checkNotNullParameter((Object)lessonContext, (String)"<this>");
        LessonContext.prepareRuntimeTask$default((LessonContext)lessonContext, null, arg_0 -> JupyterOnboardingTourLesson.lessonContent$lambda$7$lambda$6(this$0, arg_0), (int)1, null);
        CommonDebugLessonKt.clearBreakpoints((LessonContext)lessonContext);
        this$0.checkUiSettings(lessonContext);
        this$0.workspaceTasks(lessonContext);
        this$0.firstCellTasks(lessonContext);
        this$0.secondCellTasks(lessonContext);
        this$0.thirdCellTasks(lessonContext);
        this$0.debugAndFixTasks(lessonContext);
        this$0.addFinishInformers(lessonContext);
        return Unit.INSTANCE;
    }

    private static final Unit checkUiSettings$lambda$8(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        return Unit.INSTANCE;
    }

    private static final Unit checkUiSettings$lambda$9(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        return Unit.INSTANCE;
    }

    private static final Unit checkUiSettings$lambda$10(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        TaskContext.text$default((TaskContext)$this$task, (String)DsLessonsBundle.INSTANCE.message("jupyter.onboarding.change.ui.settings", new Object[0]), null, (int)2, null);
        LessonUtilKt.proceedLink$default((TaskContext)$this$task, (int)0, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit checkUiSettings$lambda$11(JupyterOnboardingTourLesson this$0, TaskRuntimeContext $this$prepareRuntimeTask) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
        this$0.hideToolStripesPreference = this$0.getUiSettings().getHideToolStripes();
        this$0.showMainToolbarPreference = this$0.getUiSettings().getShowNewMainToolbar();
        this$0.getUiSettings().setHideToolStripes(false);
        this$0.getUiSettings().setShowNewMainToolbar(true);
        this$0.getUiSettings().fireUISettingsChanged();
        return Unit.INSTANCE;
    }

    private static final Unit workspaceTasks$lambda$15$lambda$13(HighlightTriggerParametersContext $this$triggerAndFullHighlight) {
        Intrinsics.checkNotNullParameter((Object)$this$triggerAndFullHighlight, (String)"$this$triggerAndFullHighlight");
        $this$triggerAndFullHighlight.setUsePulsation(true);
        return Unit.INSTANCE;
    }

    private static final Unit workspaceTasks$lambda$15(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        if (ExperimentalUI.Companion.isNewUI()) {
            HighlightingTriggerMethods this_$iv = TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$task, null, (int)1, null);
            boolean $i$f$component = false;
            this_$iv.explicitComponentDetection(ActionButton.class, null, (Function2)new Function2<TaskRuntimeContext, ActionButton, Boolean>(){

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                    void stripe;
                    Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ActionButton actionButton = (ActionButton)it;
                    TaskRuntimeContext $this$workspaceTasks_u24lambda_u2415_u24lambda_u2412 = $this$explicitComponentDetection;
                    boolean bl = false;
                    return Intrinsics.areEqual((Object)stripe.getAction().getTemplateText(), (Object)IdeUICustomization.getInstance().getProjectViewTitle($this$workspaceTasks_u24lambda_u2415_u24lambda_u2412.getProject()));
                }
            });
        } else {
            HighlightingTriggerMethods this_$iv = $this$task.triggerAndFullHighlight(JupyterOnboardingTourLesson::workspaceTasks$lambda$15$lambda$13);
            boolean $i$f$component = false;
            this_$iv.explicitComponentDetection(StripeButton.class, null, (Function2)new Function2<TaskRuntimeContext, StripeButton, Boolean>(){

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                    void stripe;
                    Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    StripeButton stripeButton = (StripeButton)it;
                    TaskRuntimeContext $this$workspaceTasks_u24lambda_u2415_u24lambda_u2414 = $this$explicitComponentDetection;
                    boolean bl = false;
                    return Intrinsics.areEqual((Object)stripe.getWindowInfo().getId(), (Object)"Project");
                }
            });
        }
        return Unit.INSTANCE;
    }

    private static final Unit workspaceTasks$lambda$17(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        String projectViewTitle = IdeUICustomization.getInstance().getProjectViewTitle($this$task.getProject());
        TaskContext.text$default((TaskContext)$this$task, (String)DsLessonsBundle.INSTANCE.message("jupyter.onboarding.intro", new Object[0]), null, (int)2, null);
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNull((Object)projectViewTitle);
        objectArray[0] = $this$task.strong(projectViewTitle);
        $this$task.text(DsLessonsBundle.INSTANCE.message("jupyter.onboarding.balloon.workspace.view", objectArray), new LearningBalloonConfig(Balloon.Position.atRight, 0, false, null, 0, 0, 0, null, null, 508, null));
        AnAction attachDirectoryAction = ActionManager.getInstance().getAction("AddDirectory");
        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndFullHighlight$default((TaskContext)$this$task, null, (int)1, null);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(ActionButton.class, null, (Function2)new Function2<TaskRuntimeContext, ActionButton, Boolean>(attachDirectoryAction){
            final /* synthetic */ AnAction $attachDirectoryAction$inlined;
            {
                this.$attachDirectoryAction$inlined = anAction;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void button;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ActionButton actionButton = (ActionButton)it;
                TaskRuntimeContext $this$workspaceTasks_u24lambda_u2417_u24lambda_u2416 = $this$explicitComponentDetection;
                boolean bl = false;
                return Intrinsics.areEqual((Object)button.getAction(), (Object)this.$attachDirectoryAction$inlined);
            }
        });
        TaskContext.restoreByUi$default((TaskContext)$this$task, null, (int)0, null, (int)7, null);
        return Unit.INSTANCE;
    }

    private static final Unit workspaceTasks$lambda$19$lambda$18(JupyterOnboardingTourLesson this$0, TaskRuntimeContext $this$before) {
        Intrinsics.checkNotNullParameter((Object)$this$before, (String)"$this$before");
        Path path2 = this$0.getLearningContentRoot().resolve(this$0.attachDirectoryName);
        Intrinsics.checkNotNull((Object)path2);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            TaskRuntimeContext $this$thisLogger$iv = $this$before;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(TaskRuntimeContext.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.error("No " + this$0.attachDirectoryName + " directory found in " + path2);
        } else {
            $this$before.getProject().putUserData(AttachProjectAction.Companion.getTO_SELECT_KEY(), (Object)path2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit workspaceTasks$lambda$19(JupyterOnboardingTourLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        $this$task.before(arg_0 -> JupyterOnboardingTourLesson.workspaceTasks$lambda$19$lambda$18(this$0, arg_0));
        Object[] objectArray = new Object[]{$this$task.strong(this$0.attachDirectoryName)};
        String string = DsLessonsBundle.INSTANCE.message("jupyter.onboarding.balloon.attach.button", objectArray);
        objectArray = Balloon.Position.below;
        $this$task.text(string, new LearningBalloonConfig((Balloon.Position)objectArray, 0, true, null, 200, 0, 0, null, null, 488, null));
        this$0.detectDirectoryUi($this$task);
        TaskContext.restoreByUi$default((TaskContext)$this$task, null, (int)0, null, (int)7, null);
        return Unit.INSTANCE;
    }

    private static final Unit workspaceTasks$lambda$20(JupyterOnboardingTourLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        this$0.detectDirectoryUi($this$task);
        return Unit.INSTANCE;
    }

    private static final Unit workspaceTasks$lambda$23$lambda$21(HighlightTriggerParametersContext $this$triggerAndFullHighlight) {
        Intrinsics.checkNotNullParameter((Object)$this$triggerAndFullHighlight, (String)"$this$triggerAndFullHighlight");
        $this$triggerAndFullHighlight.setUsePulsation(true);
        return Unit.INSTANCE;
    }

    private static final Unit workspaceTasks$lambda$23(JupyterOnboardingTourLesson this$0, String $newGroupName, String $jupyterNotebookItemName, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[]{$this$task.strong(this$0.attachDirectoryName), $this$task.strong($newGroupName + " | " + $jupyterNotebookItemName)};
        String string = DsLessonsBundle.INSTANCE.message("jupyter.onboarding.balloon.add.notebook", objectArray);
        objectArray = Balloon.Position.atRight;
        $this$task.text(string, new LearningBalloonConfig((Balloon.Position)objectArray, 0, true, null, 0, 0, 0, null, null, 504, null));
        HighlightingTriggerMethods this_$iv = $this$task.triggerAndFullHighlight(JupyterOnboardingTourLesson::workspaceTasks$lambda$23$lambda$21);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(ActionMenu.class, null, (Function2)new Function2<TaskRuntimeContext, ActionMenu, Boolean>($newGroupName){
            final /* synthetic */ String $newGroupName$inlined;
            {
                this.$newGroupName$inlined = string;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void ui;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ActionMenu actionMenu = (ActionMenu)it;
                TaskRuntimeContext $this$workspaceTasks_u24lambda_u2423_u24lambda_u2422 = $this$explicitComponentDetection;
                boolean bl = false;
                String string = ui.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                return StringsKt.startsWith$default((String)string, (String)this.$newGroupName$inlined, (boolean)false, (int)2, null);
            }
        });
        TaskContext.restoreByUi$default((TaskContext)$this$task, null, (int)0, null, (int)7, null);
        return Unit.INSTANCE;
    }

    private static final Unit workspaceTasks$lambda$26$lambda$24(HighlightTriggerParametersContext $this$triggerAndFullHighlight) {
        Intrinsics.checkNotNullParameter((Object)$this$triggerAndFullHighlight, (String)"$this$triggerAndFullHighlight");
        $this$triggerAndFullHighlight.setUsePulsation(true);
        return Unit.INSTANCE;
    }

    private static final Unit workspaceTasks$lambda$26(String $jupyterNotebookItemName, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        HighlightingTriggerMethods this_$iv = $this$task.triggerAndFullHighlight(JupyterOnboardingTourLesson::workspaceTasks$lambda$26$lambda$24);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(ActionMenuItem.class, null, (Function2)new Function2<TaskRuntimeContext, ActionMenuItem, Boolean>($jupyterNotebookItemName){
            final /* synthetic */ String $jupyterNotebookItemName$inlined;
            {
                this.$jupyterNotebookItemName$inlined = string;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void ui;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ActionMenuItem actionMenuItem = (ActionMenuItem)it;
                TaskRuntimeContext $this$workspaceTasks_u24lambda_u2426_u24lambda_u2425 = $this$explicitComponentDetection;
                boolean bl = false;
                return Intrinsics.areEqual((Object)ui.getText(), (Object)this.$jupyterNotebookItemName$inlined);
            }
        });
        TaskContext.restoreByUi$default((TaskContext)$this$task, null, (int)0, null, (int)7, null);
        return Unit.INSTANCE;
    }

    private static final Unit workspaceTasks$lambda$28(JupyterOnboardingTourLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$task, null, (int)1, null);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(ExtendableTextField.class, null, (Function2)new Function2<TaskRuntimeContext, ExtendableTextField, Boolean>(this$0){
            final /* synthetic */ JupyterOnboardingTourLesson this$0;
            {
                this.this$0 = jupyterOnboardingTourLesson;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void ui;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ExtendableTextField extendableTextField = (ExtendableTextField)it;
                TaskRuntimeContext $this$workspaceTasks_u24lambda_u2428_u24lambda_u2427 = $this$explicitComponentDetection;
                boolean bl = false;
                ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>((ExtendableTextField)ui, this.this$0){
                    final /* synthetic */ ExtendableTextField $ui;
                    final /* synthetic */ JupyterOnboardingTourLesson this$0;
                    {
                        this.$ui = $ui;
                        this.this$0 = $receiver;
                    }

                    public final void invoke() {
                        this.$ui.setText(JupyterOnboardingTourLesson.access$getNotebookDefaultName$p(this.this$0));
                    }
                }), (int)1, null);
                return true;
            }
        });
        TaskContext.restoreByUi$default((TaskContext)$this$task, null, (int)LessonUtilKt.getDefaultRestoreDelay(), (Integer)100, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit workspaceTasks$lambda$31$lambda$29(TaskRuntimeContext $this$before) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$before, (String)"$this$before");
            ToolWindow toolWindow = UtilsKt.learningToolWindow((Project)$this$before.getProject());
            if (toolWindow == null) break block0;
            toolWindow.show();
        }
        return Unit.INSTANCE;
    }

    private static final boolean workspaceTasks$lambda$31$lambda$30(TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        return $this$stateCheck.getFocusOwner() instanceof EditorComponentImpl;
    }

    private static final Unit workspaceTasks$lambda$31(JupyterOnboardingTourLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        $this$task.before(JupyterOnboardingTourLesson::workspaceTasks$lambda$31$lambda$29);
        Object[] objectArray = new Object[]{$this$task.strong(this$0.notebookDefaultName), LessonUtil.INSTANCE.rawEnter()};
        TaskContext.text$default((TaskContext)$this$task, (String)DsLessonsBundle.INSTANCE.message("jupyter.onboarding.notebook.name", objectArray), null, (int)2, null);
        $this$task.stateCheck(JupyterOnboardingTourLesson::workspaceTasks$lambda$31$lambda$30);
        TaskContext.restoreByUi$default((TaskContext)$this$task, null, (int)LessonUtilKt.getDefaultRestoreDelay(), null, (int)5, null);
        return Unit.INSTANCE;
    }

    private static final Unit workspaceTasks$lambda$32(JupyterOnboardingTourLesson this$0, TaskRuntimeContext $this$prepareRuntimeTask) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
        this$0.notebookName = $this$prepareRuntimeTask.getVirtualFile().getName();
        return Unit.INSTANCE;
    }

    private static final boolean detectDirectoryUi$lambda$33(JupyterOnboardingTourLesson this$0, TaskRuntimeContext $this$treeItem, JTree jTree, TreePath path2) {
        Intrinsics.checkNotNullParameter((Object)$this$treeItem, (String)"$this$treeItem");
        Intrinsics.checkNotNullParameter((Object)jTree, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return path2.getPathCount() >= 2 && StringsKt.contains$default((CharSequence)path2.getPathComponent(1).toString(), (CharSequence)this$0.attachDirectoryName, (boolean)false, (int)2, null);
    }

    private static final Unit firstCellTasks$lambda$35$lambda$34(TaskRuntimeContext $this_prepareRuntimeTask) {
        TaskRuntimeContext.caret$default((TaskRuntimeContext)$this_prepareRuntimeTask, (String)"kernel_stats", (boolean)false, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit firstCellTasks$lambda$35(LessonSample $sampleOne, TaskRuntimeContext $this$prepareRuntimeTask) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
        $this$prepareRuntimeTask.setSample($sampleOne, false);
        $this$prepareRuntimeTask.taskInvokeLater(ModalityState.nonModal(), () -> JupyterOnboardingTourLesson.firstCellTasks$lambda$35$lambda$34($this$prepareRuntimeTask));
        return Unit.INSTANCE;
    }

    private static final Unit firstCellTasks$lambda$37(LessonSample $sampleOne, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[]{$this$task.action("NotebookRunCellAction")};
        TaskContext.text$default((TaskContext)$this$task, (String)DsLessonsBundle.INSTANCE.message("jupyter.onboarding.run.first.sample", objectArray), null, (int)2, null);
        AnAction needToFindButton = UtilsKt.getActionById((String)"DS.OpenResultInNewTab");
        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndFullHighlight$default((TaskContext)$this$task, null, (int)1, null);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(ActionButton.class, null, (Function2)new Function2<TaskRuntimeContext, ActionButton, Boolean>(needToFindButton){
            final /* synthetic */ AnAction $needToFindButton$inlined;
            {
                this.$needToFindButton$inlined = anAction;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void actionButton;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ActionButton actionButton2 = (ActionButton)it;
                TaskRuntimeContext $this$firstCellTasks_u24lambda_u2437_u24lambda_u2436 = $this$explicitComponentDetection;
                boolean bl = false;
                return Intrinsics.areEqual((Object)actionButton.getAction(), (Object)this.$needToFindButton$inlined);
            }
        });
        LessonUtil.INSTANCE.restoreIfModified($this$task, $sampleOne);
        return Unit.INSTANCE;
    }

    private static final boolean firstCellTasks$lambda$39$lambda$38(TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)$this$stateCheck.getProject()).getSelectedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSelectedFiles(...)");
        return ArraysKt.singleOrNull((Object[])virtualFileArray) instanceof DSTableVirtualFile;
    }

    private static final Unit firstCellTasks$lambda$39(LessonSample $sampleOne, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        $this$task.setRehighlightPreviousUi(Boolean.valueOf(true));
        Object[] objectArray = new Object[1];
        Icon icon = AllIcons.Ide.External_link_arrow;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"External_link_arrow");
        objectArray[0] = $this$task.icon(icon);
        TaskContext.text$default((TaskContext)$this$task, (String)DsLessonsBundle.INSTANCE.message("jupyter.onboarding.open.results.in.tab", objectArray), null, (int)2, null);
        $this$task.stateCheck(JupyterOnboardingTourLesson::firstCellTasks$lambda$39$lambda$38);
        LessonUtil.INSTANCE.restoreIfModified($this$task, $sampleOne);
        return Unit.INSTANCE;
    }

    private static final Unit firstCellTasks$lambda$41(JupyterOnboardingTourLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndFullHighlight$default((TaskContext)$this$task, null, (int)1, null);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(TabLabel.class, null, (Function2)new Function2<TaskRuntimeContext, TabLabel, Boolean>(this$0){
            final /* synthetic */ JupyterOnboardingTourLesson this$0;
            {
                this.this$0 = jupyterOnboardingTourLesson;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void tab;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                TabLabel tabLabel = (TabLabel)it;
                TaskRuntimeContext $this$firstCellTasks_u24lambda_u2441_u24lambda_u2440 = $this$explicitComponentDetection;
                boolean bl = false;
                return Intrinsics.areEqual((Object)tab.getInfo().getText(), (Object)JupyterOnboardingTourLesson.access$getNotebookName$p(this.this$0));
            }
        });
        return Unit.INSTANCE;
    }

    private static final boolean firstCellTasks$lambda$43$lambda$42(JupyterOnboardingTourLesson this$0, TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)$this$stateCheck.getProject()).getSelectedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSelectedFiles(...)");
        VirtualFile virtualFile = (VirtualFile)ArraysKt.singleOrNull((Object[])virtualFileArray);
        return Intrinsics.areEqual((Object)(virtualFile != null ? virtualFile.getName() : null), (Object)this$0.notebookName);
    }

    private static final Unit firstCellTasks$lambda$43(JupyterOnboardingTourLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        TaskContext.text$default((TaskContext)$this$task, (String)DsLessonsBundle.INSTANCE.message("jupyter.onboarding.return.to.editor", new Object[0]), null, (int)2, null);
        $this$task.stateCheck(arg_0 -> JupyterOnboardingTourLesson.firstCellTasks$lambda$43$lambda$42(this$0, arg_0));
        $this$task.setPropagateHighlighting(Boolean.valueOf(false));
        return Unit.INSTANCE;
    }

    private static final boolean firstCellTasks$lambda$45$lambda$44(TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        return NotebookCellLines.Companion.get($this$stateCheck.getEditor()).getIntervals().size() == 2;
    }

    private static final Unit firstCellTasks$lambda$45(LessonSample $sampleOne, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        LessonUtil.INSTANCE.restoreIfModified($this$task, $sampleOne);
        Object[] objectArray = new Object[3];
        objectArray[0] = $this$task.action("NotebookInsertCellBelowAction");
        Icon icon = AllIcons.General.Add;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Add");
        objectArray[1] = $this$task.icon(icon);
        objectArray[2] = LessonUtil.INSTANCE.actionName("JupyterAddCodeCellAction");
        TaskContext.text$default((TaskContext)$this$task, (String)DsLessonsBundle.INSTANCE.message("jupyter.onboarding.insert.second.cell", objectArray), null, (int)2, null);
        $this$task.stateCheck(JupyterOnboardingTourLesson::firstCellTasks$lambda$45$lambda$44);
        return Unit.INSTANCE;
    }

    private static final Unit firstCellTasks$lambda$46(TaskRuntimeContext $this$prepareRuntimeTask) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
        LearningUiHighlightingManager.INSTANCE.clearHighlights();
        return Unit.INSTANCE;
    }

    private static final Unit installPandasTasks$lambda$47(JupyterOnboardingTourLesson this$0, TaskRuntimeContext $this$prepareRuntimeTask) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
        this$0.jupyterCaret($this$prepareRuntimeTask, "ndas as pd");
        return Unit.INSTANCE;
    }

    private static final boolean installPackageTasks$lambda$49$lambda$48(String $installLinkName, TaskRuntimeContext $this$listItem, Object item) {
        Intrinsics.checkNotNullParameter((Object)$this$listItem, (String)"$this$listItem");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return StringsKt.contains$default((CharSequence)item.toString(), (CharSequence)$installLinkName, (boolean)false, (int)2, null);
    }

    private static final Unit installPackageTasks$lambda$49(String $installDescriptionMessage, String $packageName, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        TaskContext.text$default((TaskContext)$this$task, (String)$installDescriptionMessage, null, (int)2, null);
        Object[] objectArray = new Object[]{$packageName};
        String string = PyBundle.message((String)"python.unresolved.reference.inspection.install.package", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String installLinkName = string;
        TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$task, null, (int)1, null).listItem((arg_0, arg_1) -> JupyterOnboardingTourLesson.installPackageTasks$lambda$49$lambda$48(installLinkName, arg_0, arg_1));
        LessonUtil.restoreIfModifiedOrMovedIncorrectly$default((LessonUtil)LessonUtil.INSTANCE, (TaskContext)$this$task, (String)$packageName, null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit installPackageTasks$lambda$51(String $packageName, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[]{$packageName};
        String string = PyBundle.message((String)"python.packaging.progress.text.installing.specific.package", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String installingMessage = string;
        Object[] objectArray2 = new Object[]{LessonUtil.INSTANCE.rawEnter()};
        TaskContext.text$default((TaskContext)$this$task, (String)DsLessonsBundle.INSTANCE.message("jupyter.onboarding.confirm.package.installation", objectArray2), null, (int)2, null);
        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$task, null, (int)1, null);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(TextPanel.class, null, (Function2)new Function2<TaskRuntimeContext, TextPanel, Boolean>(installingMessage){
            final /* synthetic */ String $installingMessage$inlined;
            {
                this.$installingMessage$inlined = string;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void progressLabel;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                TextPanel textPanel = (TextPanel)it;
                TaskRuntimeContext $this$installPackageTasks_u24lambda_u2451_u24lambda_u2450 = $this$explicitComponentDetection;
                boolean bl = false;
                return Intrinsics.areEqual((Object)progressLabel.getText(), (Object)this.$installingMessage$inlined);
            }
        });
        TaskContext.restoreByUi$default((TaskContext)$this$task, null, (int)LessonUtilKt.getDefaultRestoreDelay(), null, (int)5, null);
        return Unit.INSTANCE;
    }

    private static final boolean installPackageTasks$lambda$53$lambda$52(JupyterOnboardingTourLesson this$0, String $packageName, TaskRuntimeContext $this$timerCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$timerCheck, (String)"$this$timerCheck");
        return !this$0.packageIsNotInstalled($this$timerCheck.getProject(), CollectionsKt.listOf((Object)$packageName));
    }

    private static final Unit installPackageTasks$lambda$53(JupyterOnboardingTourLesson this$0, String $packageName, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        TaskContext.text$default((TaskContext)$this$task, (String)DsLessonsBundle.INSTANCE.message("jupyter.onboarding.wait.pandas.installation", new Object[0]), null, (int)2, null);
        TaskContext.timerCheck$default((TaskContext)$this$task, (int)0, arg_0 -> JupyterOnboardingTourLesson.installPackageTasks$lambda$53$lambda$52(this$0, $packageName, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit secondCellTasks$lambda$54(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        $this$task.type("import matplotlib.pyplot as plt\n\nplt.pie(kernel_stats[''], labels=kernel_stats['library'])");
        return Unit.INSTANCE;
    }

    private static final Unit secondCellTasks$lambda$55(JupyterOnboardingTourLesson this$0, TaskRuntimeContext $this$prepareRuntimeTask) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
        LearningUiHighlightingManager.INSTANCE.clearHighlights();
        this$0.jupyterCaret($this$prepareRuntimeTask, "'], labels=");
        return Unit.INSTANCE;
    }

    private static final boolean secondCellTasks$lambda$57$lambda$56(TaskRuntimeContext $this$listItem, Object item) {
        Intrinsics.checkNotNullParameter((Object)$this$listItem, (String)"$this$listItem");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return StringsKt.contains$default((CharSequence)item.toString(), (CharSequence)"total_count", (boolean)false, (int)2, null);
    }

    private static final Unit secondCellTasks$lambda$57(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        TaskContext.text$default((TaskContext)$this$task, (String)DsLessonsBundle.INSTANCE.message("jupyter.onboarding.second.cell.intro", new Object[0]), null, (int)2, null);
        Object[] objectArray = new Object[]{$this$task.code("total_count"), $this$task.action("CodeCompletion")};
        TaskContext.text$default((TaskContext)$this$task, (String)DsLessonsBundle.INSTANCE.message("jupyter.onboarding.start.completion", objectArray), null, (int)2, null);
        TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$task, null, (int)1, null).listItem(JupyterOnboardingTourLesson::secondCellTasks$lambda$57$lambda$56);
        LessonUtilKt.proposeRestoreForInvalidText((TaskContext)$this$task, (String)"total_count");
        return Unit.INSTANCE;
    }

    private static final boolean secondCellTasks$lambda$59$lambda$58(TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        String string = $this$stateCheck.getEditor().getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"kernel_stats['total_count']", (boolean)false, (int)2, null);
    }

    private static final Unit secondCellTasks$lambda$59(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[]{$this$task.code("total_count"), $this$task.action("EditorChooseLookupItem")};
        TaskContext.text$default((TaskContext)$this$task, (String)DsLessonsBundle.INSTANCE.message("jupyter.onboarding.finish.completion", objectArray), null, (int)2, null);
        $this$task.stateCheck(JupyterOnboardingTourLesson::secondCellTasks$lambda$59$lambda$58);
        TaskContext.restoreByUi$default((TaskContext)$this$task, null, (int)0, null, (int)7, null);
        return Unit.INSTANCE;
    }

    private static final Unit secondCellTasks$lambda$63$lambda$61(Ref.ObjectRef $rectangle, TaskRuntimeContext $this$before) {
        Intrinsics.checkNotNullParameter((Object)$this$before, (String)"$this$before");
        CharSequence charSequence = $this$before.getEditor().getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence charsSequence = charSequence;
        int startOffset = StringsKt.indexOf$default((CharSequence)charsSequence, (String)"import matplotlib", (int)0, (boolean)false, (int)6, null);
        String it = "labels=kernel_stats['library'])";
        boolean bl = false;
        int endOffset = StringsKt.indexOf$default((CharSequence)charsSequence, (String)it, (int)0, (boolean)false, (int)6, null) + it.length();
        Point point2 = $this$before.getEditor().offsetToXY(startOffset);
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"offsetToXY(...)");
        Point startPoint = point2;
        Point point3 = $this$before.getEditor().offsetToXY(endOffset);
        Intrinsics.checkNotNullExpressionValue((Object)point3, (String)"offsetToXY(...)");
        Point endPoint = point3;
        $rectangle.element = new Rectangle(startPoint.x - 3, startPoint.y, endPoint.x - startPoint.x + 6, endPoint.y - startPoint.y + $this$before.getEditor().getLineHeight());
        return Unit.INSTANCE;
    }

    private static final Unit secondCellTasks$lambda$63(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Ref.ObjectRef rectangle = new Ref.ObjectRef();
        $this$task.before(arg_0 -> JupyterOnboardingTourLesson.secondCellTasks$lambda$63$lambda$61(rectangle, arg_0));
        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$task, null, (int)1, null);
        boolean $i$f$componentPart = false;
        this_$iv.explicitComponentPartDetection(EditorComponentImpl.class, (Function2)new Function2<TaskRuntimeContext, EditorComponentImpl, Rectangle>(rectangle){
            final /* synthetic */ Ref.ObjectRef $rectangle$inlined;
            {
                this.$rectangle$inlined = objectRef;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Rectangle invoke(TaskRuntimeContext $this$explicitComponentPartDetection, Component it) {
                Rectangle rectangle;
                void ui;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentPartDetection, (String)"$this$explicitComponentPartDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                EditorComponentImpl editorComponentImpl = (EditorComponentImpl)it;
                TaskRuntimeContext $this$secondCellTasks_u24lambda_u2463_u24lambda_u2462 = $this$explicitComponentPartDetection;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)ui.getEditor(), (Object)$this$secondCellTasks_u24lambda_u2463_u24lambda_u2462.getEditor())) {
                    rectangle = null;
                } else if (this.$rectangle$inlined.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"rectangle");
                    rectangle = null;
                } else {
                    rectangle = (Rectangle)this.$rectangle$inlined.element;
                }
                return rectangle;
            }
        });
        return Unit.INSTANCE;
    }

    private static final String secondCellTasks$lambda$64(String $runAndInsertText, TaskContext $this$actionTask, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$actionTask, (String)"$this$actionTask");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[3];
        objectArray[0] = $this$actionTask.strong($runAndInsertText);
        Icon icon = NotebooksVisualizationIcons.Actions.RunAndSelect;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"RunAndSelect");
        objectArray[1] = $this$actionTask.icon(icon);
        objectArray[2] = $this$actionTask.action(it);
        return DsLessonsBundle.INSTANCE.message("jupyter.onboarding.run.and.select.below", objectArray);
    }

    private static final Unit secondCellTasks$lambda$66(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$task, null, (int)1, null);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(ImageComponent.class, null, (Function2)new Function2<TaskRuntimeContext, ImageComponent, Boolean>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ImageComponent cfr_ignored_0 = (ImageComponent)it;
                TaskRuntimeContext $this$secondCellTasks_u24lambda_u2466_u24lambda_u2465 = $this$explicitComponentDetection;
                boolean bl = false;
                return true;
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit installMatplotlibTasks$lambda$67(JupyterOnboardingTourLesson this$0, TaskRuntimeContext $this$prepareRuntimeTask) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
        this$0.jupyterCaret($this$prepareRuntimeTask, "plotlib.pyplot as plt");
        return Unit.INSTANCE;
    }

    private static final Unit thirdCellTasks$lambda$68(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        $this$task.type("def average_for_34_and_35(r):\n  return (r['kernel-python 3.4'] + r['kernel_python 3.5']) / 2\n\nkernel_stats.apply(average_for_34_and_35, axis=1)");
        return Unit.INSTANCE;
    }

    private static final Unit thirdCellTasks$lambda$71$lambda$69(Ref.ObjectRef $startPoint, TaskRuntimeContext $this$before) {
        Intrinsics.checkNotNullParameter((Object)$this$before, (String)"$this$before");
        CharSequence charSequence = $this$before.getEditor().getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence charsSequence = charSequence;
        int startOffset = StringsKt.indexOf$default((CharSequence)charsSequence, (String)"kernel_stats.apply", (int)0, (boolean)false, (int)6, null) - 1;
        $startPoint.element = $this$before.getEditor().offsetToXY(startOffset);
        return Unit.INSTANCE;
    }

    private static final Unit thirdCellTasks$lambda$71(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Ref.ObjectRef startPoint = new Ref.ObjectRef();
        $this$task.before(arg_0 -> JupyterOnboardingTourLesson.thirdCellTasks$lambda$71$lambda$69(startPoint, arg_0));
        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$task, null, (int)1, null);
        boolean $i$f$componentPart = false;
        this_$iv.explicitComponentPartDetection(EditorComponentImpl.class, (Function2)new Function2<TaskRuntimeContext, EditorComponentImpl, Rectangle>(startPoint){
            final /* synthetic */ Ref.ObjectRef $startPoint$inlined;
            {
                this.$startPoint$inlined = objectRef;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Rectangle invoke(TaskRuntimeContext $this$explicitComponentPartDetection, Component it) {
                Rectangle rectangle;
                void ui;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentPartDetection, (String)"$this$explicitComponentPartDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                EditorComponentImpl editorComponentImpl = (EditorComponentImpl)it;
                TaskRuntimeContext $this$thirdCellTasks_u24lambda_u2471_u24lambda_u2470 = $this$explicitComponentPartDetection;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)ui.getEditor(), (Object)$this$thirdCellTasks_u24lambda_u2471_u24lambda_u2470.getEditor())) {
                    rectangle = null;
                } else {
                    Point point2;
                    Point point3;
                    Point point4;
                    if (this.$startPoint$inlined.element == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"startPoint");
                        point4 = null;
                    } else {
                        point4 = (Point)this.$startPoint$inlined.element;
                    }
                    int n = point4.x - 3;
                    if (this.$startPoint$inlined.element == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"startPoint");
                        point3 = null;
                    } else {
                        point3 = (Point)this.$startPoint$inlined.element;
                    }
                    int n2 = point3.y;
                    int n3 = ui.getSize().width;
                    if (this.$startPoint$inlined.element == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"startPoint");
                        point2 = null;
                    } else {
                        point2 = (Point)this.$startPoint$inlined.element;
                    }
                    rectangle = new Rectangle(n, n2, n3 - point2.x - 20, $this$thirdCellTasks_u24lambda_u2471_u24lambda_u2470.getEditor().getLineHeight());
                }
                return rectangle;
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit thirdCellTasks$lambda$75$lambda$72(JupyterOnboardingTourLesson this$0, TaskRuntimeContext $this$before) {
        Intrinsics.checkNotNullParameter((Object)$this$before, (String)"$this$before");
        this$0.jupyterCaret($this$before, "kernel_stats.apply");
        return Unit.INSTANCE;
    }

    private static final Unit thirdCellTasks$lambda$75$lambda$73(HighlightTriggerParametersContext $this$triggerAndFullHighlight) {
        Intrinsics.checkNotNullParameter((Object)$this$triggerAndFullHighlight, (String)"$this$triggerAndFullHighlight");
        $this$triggerAndFullHighlight.setUsePulsation(true);
        return Unit.INSTANCE;
    }

    private static final Unit thirdCellTasks$lambda$75(String $splitItemText, JupyterOnboardingTourLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        $this$task.before(arg_0 -> JupyterOnboardingTourLesson.thirdCellTasks$lambda$75$lambda$72(this$0, arg_0));
        TaskContext.text$default((TaskContext)$this$task, (String)DsLessonsBundle.INSTANCE.message("jupyter.onboarding.third.cell.intro", new Object[0]), null, (int)2, null);
        Object[] objectArray = new Object[]{$this$task.strong($splitItemText)};
        TaskContext.text$default((TaskContext)$this$task, (String)DsLessonsBundle.INSTANCE.message("jupyter.onboarding.right.click.for.split", objectArray), null, (int)2, null);
        HighlightingTriggerMethods this_$iv = $this$task.triggerAndFullHighlight(JupyterOnboardingTourLesson::thirdCellTasks$lambda$75$lambda$73);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(ActionMenuItem.class, null, (Function2)new Function2<TaskRuntimeContext, ActionMenuItem, Boolean>($splitItemText){
            final /* synthetic */ String $splitItemText$inlined;
            {
                this.$splitItemText$inlined = string;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void ui;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ActionMenuItem actionMenuItem = (ActionMenuItem)it;
                TaskRuntimeContext $this$thirdCellTasks_u24lambda_u2475_u24lambda_u2474 = $this$explicitComponentDetection;
                boolean bl = false;
                String string = ui.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                return StringsKt.startsWith$default((String)string, (String)LessonUtilKt.dropMnemonic((String)this.$splitItemText$inlined), (boolean)false, (int)2, null);
            }
        });
        return Unit.INSTANCE;
    }

    private static final String thirdCellTasks$lambda$76(String $splitItemText, TaskContext $this$actionTask, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$actionTask, (String)"$this$actionTask");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        TaskContext.restoreByUi$default((TaskContext)$this$actionTask, null, (int)0, null, (int)7, null);
        Object[] objectArray = new Object[]{$this$actionTask.strong($splitItemText)};
        return DsLessonsBundle.INSTANCE.message("jupyter.onboarding.apply.split", objectArray);
    }

    private static final Unit thirdCellTasks$lambda$79$lambda$77(JupyterOnboardingTourLesson this$0, TaskRuntimeContext $this$before) {
        Intrinsics.checkNotNullParameter((Object)$this$before, (String)"$this$before");
        this$0.jupyterCaret($this$before, "def average_for_34_and_35(r)");
        return Unit.INSTANCE;
    }

    private static final Unit thirdCellTasks$lambda$79(JupyterOnboardingTourLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        $this$task.before(arg_0 -> JupyterOnboardingTourLesson.thirdCellTasks$lambda$79$lambda$77(this$0, arg_0));
        Object[] objectArray = new Object[]{LessonUtil.INSTANCE.rawKeyStroke(16)};
        TaskContext.text$default((TaskContext)$this$task, (String)DsLessonsBundle.INSTANCE.message("jupyter.onboarding.invoke.search.everywhere", objectArray), null, (int)2, null);
        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$task, null, (int)1, null);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(ExtendableTextField.class, null, (Function2)new Function2<TaskRuntimeContext, ExtendableTextField, Boolean>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void ui;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ExtendableTextField extendableTextField = (ExtendableTextField)it;
                TaskRuntimeContext $this$thirdCellTasks_u24lambda_u2479_u24lambda_u2478 = $this$explicitComponentDetection;
                boolean bl = false;
                return UIUtil.getParentOfType(SearchEverywhereUI.class, (Component)((Component)ui)) != null;
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit thirdCellTasks$lambda$82$lambda$80(JupyterOnboardingTourLesson this$0, TaskRuntimeContext $this$before) {
        Intrinsics.checkNotNullParameter((Object)$this$before, (String)"$this$before");
        if (this$0.backupPopupLocation == null) {
            this$0.backupPopupLocation = LessonUtil.INSTANCE.adjustPopupPosition($this$before, "search.everywhere.popup");
        }
        return Unit.INSTANCE;
    }

    private static final boolean thirdCellTasks$lambda$82$lambda$81(TaskRuntimeContext $this$listItem, Object item) {
        Intrinsics.checkNotNullParameter((Object)$this$listItem, (String)"$this$listItem");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        GotoActionModel.MatchedValue matchedValue = item instanceof GotoActionModel.MatchedValue ? (GotoActionModel.MatchedValue)item : null;
        Object value2 = matchedValue != null ? matchedValue.value : null;
        GotoActionModel.ActionWrapper actionWrapper = value2 instanceof GotoActionModel.ActionWrapper ? (GotoActionModel.ActionWrapper)value2 : null;
        return (actionWrapper != null ? actionWrapper.getAction() : null) instanceof NotebookRunAllBelowAction;
    }

    private static final Unit thirdCellTasks$lambda$82(JupyterOnboardingTourLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        $this$task.before(arg_0 -> JupyterOnboardingTourLesson.thirdCellTasks$lambda$82$lambda$80(this$0, arg_0));
        Object[] objectArray = new Object[2];
        String string = IdeBundle.message((String)"searcheverywhere.accessible.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        objectArray[0] = $this$task.strong(string);
        objectArray[1] = $this$task.strong("run below");
        TaskContext.text$default((TaskContext)$this$task, (String)DsLessonsBundle.INSTANCE.message("jupyter.onboarding.start.typing.run.below", objectArray), null, (int)2, null);
        TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$task, null, (int)1, null).listItem(JupyterOnboardingTourLesson::thirdCellTasks$lambda$82$lambda$81);
        return Unit.INSTANCE;
    }

    private static final String thirdCellTasks$lambda$83(TaskContext $this$actionTask, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$actionTask, (String)"$this$actionTask");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{LessonUtil.INSTANCE.rawEnter(), $this$actionTask.strong("run"), $this$actionTask.strong("below")};
        return DsLessonsBundle.INSTANCE.message("jupyter.onboarding.press.run.below", objectArray);
    }

    private static final Unit debugAndFixTasks$lambda$84(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        TaskContext.text$default((TaskContext)$this$task, (String)DsLessonsBundle.INSTANCE.message("jupyter.onboarding.debug.introduction", new Object[0]), null, (int)2, null);
        LessonUtilKt.proceedLink$default((TaskContext)$this$task, (int)0, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit debugAndFixTasks$lambda$85(Ref.ObjectRef $logicalPosition, TaskRuntimeContext $this$prepareRuntimeTask) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
        String string = $this$prepareRuntimeTask.getEditor().getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        int offset2 = StringsKt.indexOf$default((CharSequence)string, (String)"return (r[", (int)0, (boolean)false, (int)6, null);
        $logicalPosition.element = $this$prepareRuntimeTask.getEditor().offsetToLogicalPosition(offset2);
        NotebookEditorModeKt.setMode((Editor)$this$prepareRuntimeTask.getEditor(), (NotebookEditorMode)NotebookEditorMode.EDIT);
        $this$prepareRuntimeTask.caret(offset2);
        return Unit.INSTANCE;
    }

    private static final IntRange debugAndFixTasks$lambda$86(int it) {
        return new IntRange(5, 28);
    }

    private static final LogicalPosition debugAndFixTasks$lambda$87(Ref.ObjectRef $logicalPosition) {
        return (LogicalPosition)$logicalPosition.element;
    }

    private static final Unit debugAndFixTasks$lambda$88(TaskContext $this$toggleBreakpointTask) {
        Intrinsics.checkNotNullParameter((Object)$this$toggleBreakpointTask, (String)"$this$toggleBreakpointTask");
        $this$toggleBreakpointTask.text(PythonLessonsBundle.INSTANCE.message("python.onboarding.balloon.click.here", new Object[0]), new LearningBalloonConfig(Balloon.Position.below, 0, false, null, 0, 0, 0, null, null, 504, null));
        TaskContext.text$default((TaskContext)$this$toggleBreakpointTask, (String)PythonLessonsBundle.INSTANCE.message("python.onboarding.toggle.breakpoint.2", new Object[0]), null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit debugAndFixTasks$lambda$89(JupyterOnboardingTourLesson this$0, TaskRuntimeContext $this$prepareRuntimeTask) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
        this$0.jupyterCaret($this$prepareRuntimeTask, "def average_for_34_and_35(r)");
        return Unit.INSTANCE;
    }

    private static final String debugAndFixTasks$lambda$90(TaskContext $this$actionTask, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$actionTask, (String)"$this$actionTask");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LessonUtilKt.showBalloonOnHighlightingComponent$default((TaskContext)$this$actionTask, (String)PythonLessonsBundle.INSTANCE.message("python.onboarding.balloon.start.debugging", new Object[0]), (Balloon.Position)Balloon.Position.below, (int)0, null, (int)12, null);
        Object[] objectArray = new Object[1];
        Icon icon = AllIcons.Actions.StartDebugger;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"StartDebugger");
        objectArray[0] = $this$actionTask.icon(icon);
        return PythonLessonsBundle.INSTANCE.message("python.onboarding.start.debugging", objectArray);
    }

    private static final Unit debugAndFixTasks$lambda$91(JupyterOnboardingTourLesson this$0, TaskRuntimeContext $this$prepareRuntimeTask) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
        this$0.jupyterCaret($this$prepareRuntimeTask, "kernel_stats.apply");
        return Unit.INSTANCE;
    }

    private static final String debugAndFixTasks$lambda$92(TaskContext $this$actionTask, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$actionTask, (String)"$this$actionTask");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LessonUtilKt.showBalloonOnHighlightingComponent$default((TaskContext)$this$actionTask, (String)PythonLessonsBundle.INSTANCE.message("python.onboarding.balloon.start.debugging", new Object[0]), (Balloon.Position)Balloon.Position.below, (int)0, null, (int)12, null);
        Object[] objectArray = new Object[1];
        Icon icon = AllIcons.Actions.StartDebugger;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"StartDebugger");
        objectArray[0] = $this$actionTask.icon(icon);
        return PythonLessonsBundle.INSTANCE.message("python.onboarding.start.debugging", objectArray);
    }

    private static final Unit debugAndFixTasks$lambda$93(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        $this$task.setRehighlightPreviousUi(Boolean.valueOf(true));
        Object[] objectArray = new Object[1];
        String string = UIBundle.message((String)"tool.window.name.debug", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        objectArray[0] = $this$task.strong(string);
        TaskContext.text$default((TaskContext)$this$task, (String)DsLessonsBundle.INSTANCE.message("jupyter.onboarding.balloon.about.debug.panel", objectArray), null, (int)2, null);
        LessonUtilKt.proceedLink$default((TaskContext)$this$task, (int)0, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final JComponent debugAndFixTasks$lambda$97$lambda$95(List list2) {
        Object v0;
        Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
        Iterable $this$maxByOrNull$iv = list2;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                JComponent it = (JComponent)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getLocationOnScreen().y;
                do {
                    Object e$iv = iterator$iv.next();
                    JComponent it2 = (JComponent)e$iv;
                    $i$a$-maxByOrNull-JupyterOnboardingTourLesson$debugAndFixTasks$10$1$1 = false;
                    int v$iv = it2.getLocationOnScreen().y;
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        return v0;
    }

    private static final boolean debugAndFixTasks$lambda$97$lambda$96(TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        return XDebuggerManager.getInstance((Project)$this$stateCheck.getProject()).getCurrentSession() == null;
    }

    private static final Unit debugAndFixTasks$lambda$97(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        LessonUtilKt.showBalloonOnHighlightingComponent$default((TaskContext)$this$task, (String)PythonLessonsBundle.INSTANCE.message("python.onboarding.balloon.stop.debugging", new Object[0]), (Balloon.Position)(ExperimentalUI.Companion.isNewUI() ? Balloon.Position.below : Balloon.Position.atRight), (int)0, JupyterOnboardingTourLesson::debugAndFixTasks$lambda$97$lambda$95, (int)4, null);
        Object[] objectArray = new Object[1];
        Icon icon = AllIcons.Actions.Suspend;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Suspend");
        objectArray[0] = $this$task.icon(icon);
        TaskContext.text$default((TaskContext)$this$task, (String)PythonLessonsBundle.INSTANCE.message("python.onboarding.stop.debugging", objectArray), null, (int)2, null);
        $this$task.stateCheck(JupyterOnboardingTourLesson::debugAndFixTasks$lambda$97$lambda$96);
        return Unit.INSTANCE;
    }

    private static final Unit debugAndFixTasks$lambda$100$lambda$98(JupyterOnboardingTourLesson this$0, TaskRuntimeContext $this$before) {
        Intrinsics.checkNotNullParameter((Object)$this$before, (String)"$this$before");
        LearningUiHighlightingManager.INSTANCE.clearHighlights();
        this$0.jupyterCaret($this$before, "-python 3.4");
        return Unit.INSTANCE;
    }

    private static final boolean debugAndFixTasks$lambda$100$lambda$99(TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        String string = $this$stateCheck.getEditor().getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"'kernel_python 3.4'", (boolean)false, (int)2, null);
    }

    private static final Unit debugAndFixTasks$lambda$100(JupyterOnboardingTourLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        $this$task.before(arg_0 -> JupyterOnboardingTourLesson.debugAndFixTasks$lambda$100$lambda$98(this$0, arg_0));
        Object[] objectArray = new Object[]{$this$task.code("'kernel-python 3.4'"), $this$task.code("'kernel_python 3.4'")};
        TaskContext.text$default((TaskContext)$this$task, (String)DsLessonsBundle.INSTANCE.message("jupyter.onboarding.fix.problem", objectArray), null, (int)2, null);
        $this$task.stateCheck(JupyterOnboardingTourLesson::debugAndFixTasks$lambda$100$lambda$99);
        return Unit.INSTANCE;
    }

    private static final String debugAndFixTasks$lambda$101(TaskContext $this$actionTask, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$actionTask, (String)"$this$actionTask");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[2];
        Icon icon = AllIcons.Actions.RunAll;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"RunAll");
        objectArray[0] = $this$actionTask.icon(icon);
        objectArray[1] = $this$actionTask.action(it);
        return DsLessonsBundle.INSTANCE.message("jupyter.onboarding.rerun.all", objectArray);
    }

    private static final Unit waitUntilInstallIsDone$lambda$103(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$task, null, (int)1, null);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(NonOpaquePanel.class, null, (Function2)new Function2<TaskRuntimeContext, NonOpaquePanel, Boolean>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void progress;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                NonOpaquePanel nonOpaquePanel = (NonOpaquePanel)it;
                TaskRuntimeContext $this$waitUntilInstallIsDone_u24lambda_u24103_u24lambda_u24102 = $this$explicitComponentDetection;
                boolean bl = false;
                String string = progress.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                return StringsKt.contains$default((CharSequence)string, (CharSequence)"InlineProgressPanel", (boolean)false, (int)2, null);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit waitUntilInstallIsDone$lambda$104(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        TaskContext.text$default((TaskContext)$this$task, (String)DsLessonsBundle.INSTANCE.message("jupyter.onboarding.wait.indexing", new Object[0]), null, (int)2, null);
        LessonUtilKt.waitSmartModeStep((TaskContext)$this$task);
        return Unit.INSTANCE;
    }

    private static final Unit waitUntilInstallIsDone$lambda$105(TaskRuntimeContext $this$prepareRuntimeTask) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
        LearningUiHighlightingManager.INSTANCE.clearHighlights();
        return Unit.INSTANCE;
    }

    private static final Unit onLessonEnd$lambda$106(Project $project, JupyterOnboardingTourLesson this$0) {
        $project.putUserData(AttachProjectAction.Companion.getTO_SELECT_KEY(), null);
        Module learningModule = this$0.getLearningModule($project);
        if (!$project.isDisposed() && learningModule != null) {
            this$0.disableEditorsModificationOnLessonEnd(learningModule, $project);
            this$0.showNotificationAboutLearningDirectoryDetach($project);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$detachLearningModule(JupyterOnboardingTourLesson $this, Project project) {
        $this.detachLearningModule(project);
    }

    public static final /* synthetic */ String access$getNotebookDefaultName$p(JupyterOnboardingTourLesson $this) {
        return $this.notebookDefaultName;
    }

    public static final /* synthetic */ String access$getNotebookName$p(JupyterOnboardingTourLesson $this) {
        return $this.notebookName;
    }
}

