/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0017B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\u0003J\u0011\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u0006H\u0016J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/sql/formatter/Change;", "", "from", "", "till", "replacement", "", "<init>", "(IILjava/lang/String;)V", "range", "Lcom/intellij/openapi/util/TextRange;", "delta", "compareTo", "other", "toString", "component1", "component2", "component3", "copy", "equals", "", "", "hashCode", "Companion", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nChange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Change.kt\ncom/intellij/sql/formatter/Change\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public final class Change
implements Comparable<Change> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    public final int from;
    @JvmField
    public final int till;
    @JvmField
    @NotNull
    public final String replacement;

    public Change(int from, int till, @NotNull String replacement) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        this.from = from;
        this.till = till;
        this.replacement = replacement;
        boolean bl2 = bl = this.from <= this.till;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "The change interval should be positive or zero but got negative: " + this.from + " .. " + this.till + " (in attempt to replace with: " + this.replacement + ")";
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public final TextRange range() {
        return new TextRange(this.from, this.till);
    }

    public final int delta() {
        return this.replacement.length() - (this.till - this.from);
    }

    @Override
    public int compareTo(@NotNull Change other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.from < other.from ? -1 : (this.from > other.from ? 1 : (this.till < other.till ? -1 : (this.till > other.till ? 1 : (this.replacement.compareTo(other.replacement) < 0 ? -1 : (this.replacement.compareTo(other.replacement) > 0 ? 1 : 0)))));
    }

    @NotNull
    public String toString() {
        int delta = this.delta();
        int sign = MathKt.getSign((int)delta);
        Object d = switch (sign) {
            case 0 -> "";
            case -1 -> "(" + delta + ")";
            case 1 -> "(+" + delta + ")";
            default -> "(sign = " + sign + ", delta = " + delta + ")";
        };
        return this.from + ":" + this.till + " " + (String)d + " <- " + this.replacement;
    }

    public final int component1() {
        return this.from;
    }

    public final int component2() {
        return this.till;
    }

    @NotNull
    public final String component3() {
        return this.replacement;
    }

    @NotNull
    public final Change copy(int from, int till, @NotNull String replacement) {
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        return new Change(from, till, replacement);
    }

    public static /* synthetic */ Change copy$default(Change change, int n, int n2, String string, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = change.from;
        }
        if ((n3 & 2) != 0) {
            n2 = change.till;
        }
        if ((n3 & 4) != 0) {
            string = change.replacement;
        }
        return change.copy(n, n2, string);
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.from);
        result2 = result2 * 31 + Integer.hashCode(this.till);
        result2 = result2 * 31 + this.replacement.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Change)) {
            return false;
        }
        Change change = (Change)other;
        if (this.from != change.from) {
            return false;
        }
        if (this.till != change.till) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.replacement, (Object)change.replacement);
    }

    @JvmStatic
    @NotNull
    public static final Change insert(int position, @NotNull String text) {
        return Companion.insert(position, text);
    }

    @JvmStatic
    @NotNull
    public static final Change insertBefore(@NotNull TextRange range, @NotNull String text) {
        return Companion.insertBefore(range, text);
    }

    @JvmStatic
    @NotNull
    public static final Change insertAfter(@NotNull TextRange range, @NotNull String text) {
        return Companion.insertAfter(range, text);
    }

    @JvmStatic
    @NotNull
    public static final Change replace(int from, int till, @NotNull String text) {
        return Companion.replace(from, till, text);
    }

    @JvmStatic
    @NotNull
    public static final Change replace(@NotNull TextRange range, @NotNull String text) {
        return Companion.replace(range, text);
    }

    @JvmStatic
    @NotNull
    public static final Change delete(int from, int till) {
        return Companion.delete(from, till);
    }

    @JvmStatic
    @NotNull
    public static final Change delete(@NotNull TextRange range) {
        return Companion.delete(range);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0007J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0007J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/formatter/Change$Companion;", "", "<init>", "()V", "insert", "Lcom/intellij/sql/formatter/Change;", "position", "", "text", "", "insertBefore", "range", "Lcom/intellij/openapi/util/TextRange;", "insertAfter", "replace", "from", "till", "delete", "intellij.database.sql.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Change insert(int position, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return new Change(position, position, text);
        }

        @JvmStatic
        @NotNull
        public final Change insertBefore(@NotNull TextRange range, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return this.insert(range.getStartOffset(), text);
        }

        @JvmStatic
        @NotNull
        public final Change insertAfter(@NotNull TextRange range, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return this.insert(range.getEndOffset(), text);
        }

        @JvmStatic
        @NotNull
        public final Change replace(int from, int till, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return new Change(from, till, text);
        }

        @JvmStatic
        @NotNull
        public final Change replace(@NotNull TextRange range, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return this.replace(range.getStartOffset(), range.getEndOffset(), text);
        }

        @JvmStatic
        @NotNull
        public final Change delete(int from, int till) {
            return new Change(from, till, "");
        }

        @JvmStatic
        @NotNull
        public final Change delete(@NotNull TextRange range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return this.delete(range.getStartOffset(), range.getEndOffset());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

