/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model.applier;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.references.BasicParentReference;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.applier.DbReferenceModelApplier;
import com.intellij.database.schemaEditor.model.state.DbIndirectReferenceModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbIndirectReferenceModelApplier<E extends BasicElement, T extends BasicElement, V, S extends DbIndirectReferenceModelState<T, V>>
extends DbReferenceModelApplier<E, T, S> {
    private final RefParser<V> myParser;
    public static final RefParser<String> TEXT_PARSER = new RefParser<String>(){

        @Override
        @Nullable
        public BasicReference toReference(@NotNull Dbms dbms, @Nullable String text) {
            if (dbms == null) {
                1.$$$reportNull$$$0(0);
            }
            if (StringUtil.isEmpty((String)text)) {
                return null;
            }
            NamingService ns = NamingServices.getNamingService(dbms);
            ParserDefinition definition = Objects.requireNonNull((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(DbSqlUtil.getLanguage(dbms)));
            return BasicParentReference.parseRef(text, ns, definition.createLexer(null));
        }

        @Override
        @Nullable
        public String fromReference(@NotNull Dbms dbms, @Nullable BasicReference ref2, @Nullable ElementIdentity<?> targetId) {
            if (dbms == null) {
                1.$$$reportNull$$$0(1);
            }
            return ref2 == null ? null : 1.getText(NamingServices.getNamingService(dbms), ref2);
        }

        private static String getText(@NotNull NamingService ns, @NotNull BasicReference ref2) {
            String name2;
            if (ns == null) {
                1.$$$reportNull$$$0(2);
            }
            if (ref2 == null) {
                1.$$$reportNull$$$0(3);
            }
            StringBuilder res2 = new StringBuilder();
            int i2 = 0;
            while ((name2 = ref2.getParentName(i2)) != null) {
                if (!res2.isEmpty()) {
                    res2.insert(0, ".");
                }
                res2.insert(0, ns.catToScript(name2, ObjectKind.NONE, i2 == 0 && ref2.isPlain()));
                ++i2;
            }
            return res2.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ns";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/model/applier/DbIndirectReferenceModelApplier$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fromReference";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public DbIndirectReferenceModelApplier(@NotNull BasicMetaReference<E, T> reference, @NotNull RefParser<V> parser2) {
        if (reference == null) {
            DbIndirectReferenceModelApplier.$$$reportNull$$$0(0);
        }
        if (parser2 == null) {
            DbIndirectReferenceModelApplier.$$$reportNull$$$0(1);
        }
        super(reference);
        this.myParser = parser2;
    }

    @Override
    public void copyState(@NotNull DbEditorModel<E, S> from, @NotNull DbEditorModel<E, S> to) {
        if (from == null) {
            DbIndirectReferenceModelApplier.$$$reportNull$$$0(2);
        }
        if (to == null) {
            DbIndirectReferenceModelApplier.$$$reportNull$$$0(3);
        }
        super.copyState(from, to);
        ElementIdentity targetId = ((DbIndirectReferenceModelState)from.getState()).getTargetId();
        DbModelRef srcSm = ((DbIndirectReferenceModelState)from.getState()).getTargetStructureRef();
        DbEditorModel sm = srcSm == null || targetId == null ? null : to.getController().createStructureNodeModel(targetId);
        ((DbIndirectReferenceModelState)to.getState()).setTargetId(targetId, DbModelRef.create(sm), ((DbIndirectReferenceModelState)from.getState()).getActualRef(), ((DbIndirectReferenceModelState)from.getState()).getValue());
    }

    @Override
    protected void resetImpl(@NotNull DbEditorModel<E, S> model, @NotNull ElementOwner owner, @NotNull E e) {
        if (model == null) {
            DbIndirectReferenceModelApplier.$$$reportNull$$$0(4);
        }
        if (owner == null) {
            DbIndirectReferenceModelApplier.$$$reportNull$$$0(5);
        }
        if (e == null) {
            DbIndirectReferenceModelApplier.$$$reportNull$$$0(6);
        }
        BasicMetaReference metaRef = this.getReference();
        this.setTargetId(model, owner, e, DbIndirectReferenceModelApplier.identifyTarget(owner, e, metaRef), (BasicReference)metaRef.get(e), false);
    }

    protected void setTargetId(@NotNull DbEditorModel<E, S> model, @NotNull ElementOwner owner, @NotNull E e, @Nullable ElementIdentity<T> targetId, @Nullable BasicReference ref2, boolean keepText) {
        if (model == null) {
            DbIndirectReferenceModelApplier.$$$reportNull$$$0(7);
        }
        if (owner == null) {
            DbIndirectReferenceModelApplier.$$$reportNull$$$0(8);
        }
        if (e == null) {
            DbIndirectReferenceModelApplier.$$$reportNull$$$0(9);
        }
        DbIndirectReferenceModelState state = (DbIndirectReferenceModelState)model.getState();
        BasicReference targetRef = this.asPortableRef(owner, e, targetId, this.getReference(), ref2);
        DbEditorModel<T, DbStructureObjectModelState<T>> tgtSm = targetId == null || owner.find(targetId) == null ? null : model.getController().getStructureNodeModel(targetId);
        state.setTargetId(targetId, DbModelRef.create(tgtSm), targetRef, keepText ? state.getValue() : this.fromReference(model.getDbms(), e, targetRef, targetId));
    }

    @Override
    public void resolveImpl(@NotNull DbEditorModel<E, S> model, @NotNull ElementOwner owner, @NotNull E e) {
        ElementIdentity targetId;
        if (model == null) {
            DbIndirectReferenceModelApplier.$$$reportNull$$$0(10);
        }
        if (owner == null) {
            DbIndirectReferenceModelApplier.$$$reportNull$$$0(11);
        }
        if (e == null) {
            DbIndirectReferenceModelApplier.$$$reportNull$$$0(12);
        }
        if ((targetId = ((DbIndirectReferenceModelState)model.getState()).getTargetId()) == null) {
            BasicMetaReference metaRef = this.getReference();
            this.setTargetId(model, owner, e, DbIndirectReferenceModelApplier.identifyTarget(owner, e, metaRef), (BasicReference)metaRef.get(e), true);
        } else {
            this.updateStoredRef(model, owner, e, targetId);
        }
    }

    protected void updateStoredRef(@NotNull DbEditorModel<E, S> model, @NotNull ElementOwner owner, @NotNull E e, @NotNull ElementIdentity<T> targetId) {
        T target2;
        BasicReference ref2;
        if (model == null) {
            DbIndirectReferenceModelApplier.$$$reportNull$$$0(13);
        }
        if (owner == null) {
            DbIndirectReferenceModelApplier.$$$reportNull$$$0(14);
        }
        if (e == null) {
            DbIndirectReferenceModelApplier.$$$reportNull$$$0(15);
        }
        if (targetId == null) {
            DbIndirectReferenceModelApplier.$$$reportNull$$$0(16);
        }
        if ((ref2 = DbIndirectReferenceModelApplier.asPortableRef(owner, e, target2 = owner.find(targetId), this.getReference())) != null) {
            ((DbIndirectReferenceModelState)model.getState()).updateRef(ref2, this.fromReference(model.getDbms(), e, ref2, targetId));
        }
    }

    @Nullable
    public BasicReference toReference(@NotNull Dbms dbms, @Nullable V value) {
        if (dbms == null) {
            DbIndirectReferenceModelApplier.$$$reportNull$$$0(17);
        }
        return this.myParser.toReference(dbms, value);
    }

    @Nullable
    public V fromReference(@NotNull Dbms dbms, E element, @Nullable BasicReference ref2, @Nullable ElementIdentity<T> targetId) {
        if (dbms == null) {
            DbIndirectReferenceModelApplier.$$$reportNull$$$0(18);
        }
        return this.myParser.fromReference(dbms, ref2, targetId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetId";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/schemaEditor/model/applier/DbIndirectReferenceModelApplier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "copyState";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "resetImpl";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "setTargetId";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveImpl";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "updateStoredRef";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "toReference";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "fromReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface RefParser<V> {
        @Nullable
        public BasicReference toReference(@NotNull Dbms var1, @Nullable V var2);

        @Nullable
        public V fromReference(@NotNull Dbms var1, @Nullable BasicReference var2, @Nullable ElementIdentity<?> var3);
    }
}

