/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class GridFilteringModelImpl
implements GridFilteringModel {
    private final EventDispatcher<GridFilteringModel.Listener> myEventDispatcher = EventDispatcher.create(GridFilteringModel.Listener.class);
    private final List<String> myHistory = new ArrayList<String>();
    private boolean ignoreCurrentText = false;
    private final Document myDocument = EditorFactory.getInstance().createDocument((CharSequence)"");

    public void applyCurrentText() {
        String text = this.getFilterText().trim();
        this.myHistory.remove(text);
        this.myHistory.add(0, text);
        this.trimFilterHistory();
    }

    public boolean isIgnoreCurrentText() {
        return this.ignoreCurrentText;
    }

    public void setIgnoreCurrentText(boolean ignore) {
        this.ignoreCurrentText = ignore;
    }

    @NotNull
    public String getAppliedText() {
        String item = (String)ContainerUtil.getFirstItem(this.getHistory());
        String string = item == null ? "" : item;
        if (string == null) {
            GridFilteringModelImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    private void trimFilterHistory() {
        DatabaseSettings settings = DatabaseSettings.getSettings();
        int historySize = Math.max(0, settings.getFiltersHistorySize());
        while (this.myHistory.size() > historySize) {
            this.myHistory.remove(this.myHistory.size() - 1);
        }
    }

    public void setHistory(@NotNull List<String> history) {
        if (history == null) {
            GridFilteringModelImpl.$$$reportNull$$$0(1);
        }
        this.myHistory.clear();
        this.myHistory.addAll(history);
        this.trimFilterHistory();
    }

    @NotNull
    public List<String> getHistory() {
        List<String> list = this.myHistory;
        if (list == null) {
            GridFilteringModelImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public String getFilterText() {
        String string = this.myDocument.getText();
        if (string == null) {
            GridFilteringModelImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setFilterText(@NotNull String filter) {
        boolean valueChanged;
        if (filter == null) {
            GridFilteringModelImpl.$$$reportNull$$$0(4);
        }
        String newFilter = filter.trim();
        String currentFilter = this.getFilterText();
        boolean bl = valueChanged = !Objects.equals(currentFilter, newFilter);
        if (!valueChanged) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> this.myDocument.setText((CharSequence)filter));
    }

    @NotNull
    public Document getFilterDocument() {
        Document document = this.myDocument;
        if (document == null) {
            GridFilteringModelImpl.$$$reportNull$$$0(5);
        }
        return document;
    }

    public void addListener(@NotNull GridFilteringModel.Listener l, @NotNull Disposable disposable) {
        if (l == null) {
            GridFilteringModelImpl.$$$reportNull$$$0(6);
        }
        if (disposable == null) {
            GridFilteringModelImpl.$$$reportNull$$$0(7);
        }
        this.myEventDispatcher.addListener((EventListener)l, disposable);
    }

    public void fireApplicableUpdated() {
        ((GridFilteringModel.Listener)this.myEventDispatcher.getMulticaster()).onApplicableUpdated();
    }

    public void firePrefixUpdated() {
        ((GridFilteringModel.Listener)this.myEventDispatcher.getMulticaster()).onPrefixUpdated();
    }

    public void firePSIUpdated() {
        ((GridFilteringModel.Listener)this.myEventDispatcher.getMulticaster()).onPsiUpdated();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/GridFilteringModelImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "history";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppliedText";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/GridFilteringModelImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterDocument";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setHistory";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setFilterText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

