/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import com.intellij.database.dataSource.url.template.JdbcTemplateLexer;
import com.intellij.database.dataSource.url.template.TemplateToken;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JdbcTemplateParser {
    private static final Set<IElementType> SEQUENCE_END = Set.of(TemplateToken.GROUP_END, TemplateToken.OPT_GROUP_END, TemplateToken.LIST_END, TemplateToken.SEPARATOR);
    private final EventProcessor myProcessor;
    private final JdbcTemplateLexer myLexer;
    private final StringBuffer myBuffer;

    public static boolean parse(@NotNull String text, EventProcessor processor2) {
        if (text == null) {
            JdbcTemplateParser.$$$reportNull$$$0(0);
        }
        return new JdbcTemplateParser(text, processor2).parse();
    }

    private JdbcTemplateParser(@NotNull String text, @Nullable EventProcessor processor2) {
        if (text == null) {
            JdbcTemplateParser.$$$reportNull$$$0(1);
        }
        this.myLexer = new JdbcTemplateLexer();
        this.myLexer.start(text);
        this.myProcessor = processor2;
        this.myBuffer = new StringBuffer();
    }

    private boolean parse() {
        if (!this.parseSequence()) {
            return false;
        }
        if (this.myLexer.getTokenType() != null) {
            return this.unexpectedToken("EOF");
        }
        return true;
    }

    private static IElementType group(boolean begin, boolean opt) {
        if (opt) {
            return begin ? TemplateToken.OPT_GROUP_BEGIN : TemplateToken.OPT_GROUP_END;
        }
        return begin ? TemplateToken.GROUP_BEGIN : TemplateToken.GROUP_END;
    }

    private boolean parseGroup(boolean opt) {
        if (!this.consumeToken(JdbcTemplateParser.group(true, opt), opt ? "[" : "(")) {
            return false;
        }
        if (this.myLexer.getTokenType() == JdbcTemplateParser.group(false, opt)) {
            this.myLexer.advance();
            return true;
        }
        if (this.myProcessor != null) {
            this.myProcessor.processGroupStart();
        }
        if (!this.parseSequence()) {
            return false;
        }
        if (!this.consumeToken(JdbcTemplateParser.group(false, opt), opt ? "]" : ")")) {
            return false;
        }
        if (this.myProcessor != null) {
            this.myProcessor.processGroupFinish();
            if (opt) {
                this.myProcessor.processOptionality();
            }
        }
        return true;
    }

    private boolean parseSequence() {
        IElementType elementType = this.myLexer.getTokenType();
        while (elementType != null && !SEQUENCE_END.contains(elementType)) {
            if (!this.parseSingle(true)) {
                return false;
            }
            elementType = this.myLexer.getTokenType();
        }
        return true;
    }

    private boolean parseSingle(boolean glueChars) {
        IElementType elementType = this.myLexer.getTokenType();
        if (elementType == TemplateToken.CHAR && glueChars) {
            if (!this.parseCharSequence()) {
                return false;
            }
        } else if (elementType == TemplateToken.CHAR) {
            if (!this.parseSingleChar()) {
                return false;
            }
        } else if (elementType == TemplateToken.NEGATION) {
            if (!this.parseNegation()) {
                return false;
            }
        } else if (elementType == TemplateToken.LIST_BEGIN) {
            if (!this.parseList()) {
                return false;
            }
        } else if (elementType == TemplateToken.GROUP_BEGIN) {
            if (!this.parseGroup(false)) {
                return false;
            }
        } else if (elementType == TemplateToken.OPT_GROUP_BEGIN) {
            if (!this.parseGroup(true)) {
                return false;
            }
        } else if (elementType == TemplateToken.PARAM_BEGIN) {
            if (!this.parseParameter()) {
                return false;
            }
        } else if (elementType == TemplateToken.OPTIONALITY) {
            if (!this.parseOptionality()) {
                return false;
            }
        } else {
            return this.unexpectedToken(null);
        }
        return true;
    }

    private boolean parseSingleChar() {
        if (!this.appendCharacter(false)) {
            return false;
        }
        this.processString();
        return true;
    }

    private boolean parseCharSequence() {
        this.myProcessor.processGroupStart();
        while (this.myLexer.getTokenType() == TemplateToken.CHAR) {
            if (this.appendCharacter(true)) continue;
            return false;
        }
        char last = this.myLexer.getTokenType() == TemplateToken.OPTIONALITY ? this.popLastChar() : (char)'\u0000';
        this.processString();
        this.myProcessor.processGroupFinish();
        if (last != '\u0000') {
            this.myBuffer.append(last);
            this.processString();
        }
        return true;
    }

    private char popLastChar() {
        char last;
        if (this.myBuffer.length() > 1) {
            int lastIdx = this.myBuffer.length() - 1;
            last = this.myBuffer.charAt(lastIdx);
            this.myBuffer.setLength(lastIdx);
        } else {
            last = '\u0000';
        }
        return last;
    }

    private boolean parseNegation() {
        if (!this.consumeToken(TemplateToken.NEGATION, "!")) {
            return false;
        }
        if (!this.parseSingle(false)) {
            return false;
        }
        if (this.myProcessor != null) {
            this.myProcessor.processNegation();
        }
        return true;
    }

    private boolean parseList() {
        if (!this.consumeToken(TemplateToken.LIST_BEGIN, "<")) {
            return false;
        }
        if (!this.parseListSeparator()) {
            return false;
        }
        if (!this.parseListBodies()) {
            return false;
        }
        if (this.myProcessor != null) {
            this.myProcessor.processListFinish();
        }
        return this.consumeToken(TemplateToken.LIST_END, ">");
    }

    private boolean parseListBodies() {
        while (this.myLexer.getTokenType() != TemplateToken.LIST_END) {
            if (!this.consumeToken(TemplateToken.SEPARATOR, ",")) {
                return false;
            }
            boolean mandatory = this.parseMandatoryMark();
            if (!this.parseSequence()) {
                return false;
            }
            if (this.myProcessor == null) continue;
            this.myProcessor.processListBranch(mandatory);
        }
        return true;
    }

    private boolean parseMandatoryMark() {
        boolean mandatory = StringUtil.startsWith((CharSequence)this.myLexer.getBufferSequence(), (int)this.myLexer.getTokenStart(), (CharSequence)"!!");
        if (mandatory) {
            this.myLexer.advance();
            this.myLexer.advance();
        }
        return mandatory;
    }

    private boolean parseListSeparator() {
        while (this.myLexer.getTokenType() == TemplateToken.CHAR) {
            if (this.appendCharacter(false)) continue;
            return false;
        }
        if (this.myBuffer.length() == 0) {
            return this.parsingError("Expected list separator as first item");
        }
        if (this.myProcessor != null) {
            this.myProcessor.processListStart(this.myBuffer.toString());
        }
        this.myBuffer.setLength(0);
        return true;
    }

    private boolean parseOptionality() {
        if (!this.consumeToken(TemplateToken.OPTIONALITY, "?")) {
            return false;
        }
        if (this.myProcessor != null) {
            if (this.myBuffer.length() != 0) {
                if (this.myBuffer.length() != 1) {
                    this.myProcessor.processString(this.myBuffer.substring(0, this.myBuffer.length() - 1));
                }
                this.myProcessor.processString(this.myBuffer.substring(this.myBuffer.length() - 1, this.myBuffer.length()));
                this.myBuffer.setLength(0);
            }
            this.myProcessor.processOptionality();
        }
        return true;
    }

    private boolean parseParameter() {
        if (!this.consumeToken(TemplateToken.PARAM_BEGIN, "{")) {
            return false;
        }
        String name2 = this.parseIdentifier();
        String type = null;
        if (this.consumeOptToken(TemplateToken.SEPARATOR)) {
            type = this.parseIdentifier();
            if (name2 == null && type == null) {
                return this.parsingError("Name or type should be specified");
            }
        } else if (name2 == null) {
            this.unexpectedToken("identifier or :");
            return false;
        }
        String defValue = null;
        if (this.consumeOptToken(TemplateToken.SEPARATOR)) {
            defValue = StringUtil.notNullize((String)this.parseIdentifier());
        }
        String configuration = null;
        if (this.consumeOptToken(TemplateToken.SEPARATOR)) {
            configuration = this.parseIdentifier();
        }
        String quote = null;
        if (this.consumeOptToken(TemplateToken.SEPARATOR)) {
            quote = this.parseIdentifier();
        }
        if (!this.consumeToken(TemplateToken.PARAM_END, "}")) {
            return false;
        }
        if (this.myProcessor != null) {
            this.myProcessor.processParameter(name2, type, defValue, configuration, quote);
        }
        return true;
    }

    private String parseIdentifier() {
        if (this.myLexer.getTokenType() != TemplateToken.IDENTIFIER) {
            return null;
        }
        String res2 = JdbcTemplateParser.unescape(this.myLexer.getTokenText());
        this.myLexer.advance();
        return res2;
    }

    @NotNull
    private static String unescape(@NotNull String text) {
        if (text == null) {
            JdbcTemplateParser.$$$reportNull$$$0(2);
        }
        String string = StringUtil.unescapeStringCharacters((String)text);
        if (string == null) {
            JdbcTemplateParser.$$$reportNull$$$0(3);
        }
        return string;
    }

    private boolean appendCharacter(boolean allowSubdivide) {
        int c2;
        String text = this.myLexer.getTokenText();
        if (text.length() == 1) {
            c2 = text.charAt(0);
        } else if (text.length() == 2 && text.charAt(0) == '\\') {
            c2 = text.charAt(1);
            if (c2 == 32) {
                c2 = 160;
            }
        } else {
            return this.parsingError("Invalid character token `" + text + "`");
        }
        if (this.myBuffer.length() != 0 && allowSubdivide) {
            boolean subdivide;
            boolean bl = subdivide = !JdbcTemplateParser.isAlphaNum((char)c2) || !JdbcTemplateParser.isAlphaNum(this.myBuffer.charAt(this.myBuffer.length() - 1));
            if (subdivide) {
                this.processString();
            }
        }
        this.myBuffer.append((char)c2);
        this.myLexer.advance();
        return true;
    }

    private static boolean isAlphaNum(char c2) {
        return Character.isAlphabetic(c2) || Character.isDigit(c2);
    }

    private void processString() {
        if (this.myBuffer.length() == 0) {
            return;
        }
        if (this.myProcessor != null) {
            this.myProcessor.processString(this.myBuffer.toString());
        }
        this.myBuffer.setLength(0);
    }

    private boolean consumeToken(@NotNull IElementType elementType, @NotNull String replacement) {
        if (elementType == null) {
            JdbcTemplateParser.$$$reportNull$$$0(4);
        }
        if (replacement == null) {
            JdbcTemplateParser.$$$reportNull$$$0(5);
        }
        if (!this.consumeOptToken(elementType)) {
            return this.unexpectedToken(replacement);
        }
        return true;
    }

    private boolean consumeOptToken(@NotNull IElementType elementType) {
        IElementType current;
        if (elementType == null) {
            JdbcTemplateParser.$$$reportNull$$$0(6);
        }
        if ((current = this.myLexer.getTokenType()) != elementType) {
            return false;
        }
        this.myLexer.advance();
        return true;
    }

    private boolean unexpectedToken(@Nullable String expected) {
        return this.parsingError("Unexpected token `" + this.myLexer.getTokenText() + (String)(expected == null ? "`" : "` expected `" + expected + "`"));
    }

    private boolean parsingError(@NotNull String error) {
        if (error == null) {
            JdbcTemplateParser.$$$reportNull$$$0(7);
        }
        if (this.myProcessor != null) {
            this.myProcessor.processError(error);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/template/JdbcTemplateParser";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/template/JdbcTemplateParser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "unescape";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unescape";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "consumeToken";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "consumeOptToken";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parsingError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static interface EventProcessor {
        public void processString(@NotNull String var1);

        public void processGroupStart();

        public void processGroupFinish();

        public void processOptionality();

        public void processNegation();

        @Contract(value="null,null,_,_,_->fail")
        public void processParameter(@Nullable String var1, @Nullable String var2, @Nullable String var3, @Nullable String var4, @Nullable String var5);

        public void processError(@NotNull String var1);

        public void processListBranch(boolean var1);

        public void processListStart(@NotNull String var1);

        public void processListFinish();
    }
}

