/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseSshTunnelEstablisher;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.remote.jdbc.RemoteDriver;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.messages.Topic;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JdbcDriverManager
extends SimpleModificationTracker {
    public static final Topic<Listener> TOPIC = Topic.create((String)JdbcDriverManager.class.getSimpleName(), Listener.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.TO_PARENT);

    public static JdbcDriverManager getDriverManager(Project project) {
        return (JdbcDriverManager)((Object)project.getService(JdbcDriverManager.class));
    }

    @Nullable
    public static JdbcDriverManager getDriverManagerIfCreated(Project project) {
        return (JdbcDriverManager)((Object)project.getServiceIfCreated(JdbcDriverManager.class));
    }

    public abstract Project getProject();

    public abstract ModificationTracker getModificationTracker();

    @NotNull
    public abstract ConsoleRunConfiguration getDefaultRunConfiguration(@NotNull LocalDataSource var1, @Nullable DatabaseCredentials var2);

    public abstract List<ConsoleRunConfiguration> getActiveConfigurations(@NotNull LocalDataSource var1);

    public abstract RemoteDriver getDriver(@NotNull LocalDataSource var1, @NotNull ConsoleRunConfiguration var2) throws Exception;

    public abstract Future<?> releaseDriver(@NotNull LocalDataSource var1, @Nullable ConsoleRunConfiguration var2);

    public abstract void addModificationTrackerListener(ModificationTrackerListener<JdbcDriverManager> var1, Disposable var2);

    @NotNull
    public abstract List<DatabaseSshTunnelEstablisher.SshTunnel> getTunnels(@NotNull LocalDataSource var1);

    public static interface Listener
    extends EventListener {
        default public void onStarted(@NotNull LocalDataSource dataSource, @NotNull ConsoleRunConfiguration configuration) {
            if (dataSource == null) {
                Listener.$$$reportNull$$$0(0);
            }
            if (configuration == null) {
                Listener.$$$reportNull$$$0(1);
            }
        }

        default public void onTerminated(@NotNull LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration) {
            if (dataSource == null) {
                Listener.$$$reportNull$$$0(2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcDriverManager$Listener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onStarted";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTerminated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

