/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.tables.dump;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DynamicNestedTable;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.HierarchicalColumnsDataGridModel;
import com.intellij.database.datagrid.NestedTable;
import com.intellij.database.datagrid.NestedTablesDataGridModel;
import com.intellij.scientific.tables.DSGridLoader;
import com.intellij.scientific.tables.DSTableRawData;
import com.intellij.scientific.tables.NestedTableDataRetrieverFromDataSource;
import com.intellij.scientific.tables.dump.DataProducerHelper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NestedTableAwareDataProducer
implements DataProducer {
    private final NestedTableDataRetrieverFromDataSource myTableDataRetrieverFromDataSource;

    public NestedTableAwareDataProducer(@NotNull NestedTableDataRetrieverFromDataSource tableDataRetrieverFromDataSource) {
        if (tableDataRetrieverFromDataSource == null) {
            NestedTableAwareDataProducer.$$$reportNull$$$0(0);
        }
        this.myTableDataRetrieverFromDataSource = tableDataRetrieverFromDataSource;
    }

    public void processRequest(@NotNull GridDataRequest request) {
        DataConsumer consumer;
        if (request == null) {
            NestedTableAwareDataProducer.$$$reportNull$$$0(1);
        }
        DataConsumer dataConsumer = consumer = request instanceof DataConsumer ? (DataConsumer)request : null;
        if (consumer == null) {
            request.getPromise().setError("GridDataRequest must implement DataConsumer. request: " + request);
            return;
        }
        NestedTableDataRetrieverFromDataSource tableDataRetriever = this.myTableDataRetrieverFromDataSource.asTopLevelTableDataRetrieverFromDataSource();
        NestedTableAwareDataProducer.increaseChunkSizeAndLoad(tableDataRetriever, consumer);
        request.getPromise().setResult(null);
    }

    private static void increaseChunkSizeAndLoad(@NotNull NestedTableDataRetrieverFromDataSource tableDataRetriever, @NotNull DataConsumer consumer) {
        if (tableDataRetriever == null) {
            NestedTableAwareDataProducer.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            NestedTableAwareDataProducer.$$$reportNull$$$0(3);
        }
        int chunkSize = tableDataRetriever.getChunkSize();
        int newChunkSize = tableDataRetriever.getNRows() / 100;
        if (newChunkSize > chunkSize) {
            tableDataRetriever.setChunkSize(newChunkSize);
        }
        DataProducerHelper.loadData(tableDataRetriever, consumer, new NestedTablesProcessing(tableDataRetriever));
        tableDataRetriever.setChunkSize(chunkSize);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableDataRetrieverFromDataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableDataRetriever";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/scientific/tables/dump/NestedTableAwareDataProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processRequest";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "increaseChunkSizeAndLoad";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class NestedTablesProcessing
    implements BiConsumer<List<GridRow>, List<GridColumn>> {
        private final NestedTableDataRetrieverFromDataSource myTableDataRetriever;

        private NestedTablesProcessing(NestedTableDataRetrieverFromDataSource tableDataRetriever) {
            this.myTableDataRetriever = tableDataRetriever;
        }

        @Override
        public void accept(@NotNull List<GridRow> rows, @NotNull List<GridColumn> columns) {
            if (rows == null) {
                NestedTablesProcessing.$$$reportNull$$$0(0);
            }
            if (columns == null) {
                NestedTablesProcessing.$$$reportNull$$$0(1);
            }
            for (GridRow row : rows) {
                for (GridColumn column : columns) {
                    DynamicNestedTable nestedTable;
                    Object cellValue = column.getValue(row);
                    if (!(cellValue instanceof DynamicNestedTable) || (nestedTable = (DynamicNestedTable)cellValue).getRowsNum() == nestedTable.getTotalRowsNum()) continue;
                    LoadNestedTableRowsTask task2 = new LoadNestedTableRowsTask(this.myTableDataRetriever);
                    task2.accept(List.of(new NestedTablesDataGridModel.NestedTableCellCoordinate(row, column)), (NestedTable)nestedTable);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rows";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "columns";
                    break;
                }
            }
            objectArray[1] = "com/intellij/scientific/tables/dump/NestedTableAwareDataProducer$NestedTablesProcessing";
            objectArray[2] = "accept";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class LoadNestedTableRowsTask
    implements BiConsumer<List<NestedTablesDataGridModel.NestedTableCellCoordinate>, NestedTable> {
        private final NestedTableDataRetrieverFromDataSource myTableDataRetriever;

        public LoadNestedTableRowsTask(@NotNull NestedTableDataRetrieverFromDataSource tableDataRetriever) {
            if (tableDataRetriever == null) {
                LoadNestedTableRowsTask.$$$reportNull$$$0(0);
            }
            this.myTableDataRetriever = tableDataRetriever;
        }

        @Override
        public void accept(@NotNull List<NestedTablesDataGridModel.NestedTableCellCoordinate> path, @NotNull NestedTable nestedTable) {
            if (path == null) {
                LoadNestedTableRowsTask.$$$reportNull$$$0(1);
            }
            if (nestedTable == null) {
                LoadNestedTableRowsTask.$$$reportNull$$$0(2);
            }
            HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode root = nestedTable.getColumnsHierarchy();
            List<DummyGridColumnImpl> nestedTableColumns = LoadNestedTableRowsTask.getLeafColumns(root);
            NestedTableDataRetrieverFromDataSource TableDataRetriever = this.myTableDataRetriever.enterNestedTable((NestedTablesDataGridModel.NestedTableCellCoordinate)ContainerUtil.getLastItem(path), nestedTable);
            int newChunkSize = TableDataRetriever.getNRows() / 10;
            if (newChunkSize > TableDataRetriever.getChunkSize()) {
                TableDataRetriever.setChunkSize(newChunkSize);
            }
            int[] rowsLoaded = new int[]{0};
            TableDataRetriever.loadInChunks(null, 0, TableDataRetriever.getNRows(), null, (Function2<? super DSTableRawData, ? super Boolean, Unit>)((Function2)(data, endOfTableReached) -> {
                if (data != null) {
                    List<GridRow> rows = DSGridLoader.Companion.createRows((DSTableRawData)data, rowsLoaded[0]);
                    for (GridRow row : rows) {
                        for (GridColumn column : nestedTableColumns) {
                            DynamicNestedTable nested;
                            Object value = column.getValue(row);
                            if (!(value instanceof DynamicNestedTable) || (nested = (DynamicNestedTable)value).getRowsNum() == nested.getTotalRowsNum()) continue;
                            this.accept(ContainerUtil.append((List)path, (Object[])new NestedTablesDataGridModel.NestedTableCellCoordinate[]{new NestedTablesDataGridModel.NestedTableCellCoordinate(row, column)}), (NestedTable)nested);
                        }
                    }
                    nestedTable.insertRows(rowsLoaded[0], rows);
                    rowsLoaded[0] = rowsLoaded[0] + rows.size();
                }
                return Unit.INSTANCE;
            }));
        }

        @NotNull
        private static List<DummyGridColumnImpl> getLeafColumns(@NotNull HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode root) {
            if (root == null) {
                LoadNestedTableRowsTask.$$$reportNull$$$0(3);
            }
            ArrayList<DummyGridColumnImpl> leafColumns = new ArrayList<DummyGridColumnImpl>();
            List children = root.getChildren();
            for (int idx = 0; idx < children.size(); ++idx) {
                LoadNestedTableRowsTask.constructLeafColumnsRecursively((HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode)children.get(idx), new int[]{idx}, leafColumns);
            }
            ArrayList<DummyGridColumnImpl> arrayList = leafColumns;
            if (arrayList == null) {
                LoadNestedTableRowsTask.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        private static void constructLeafColumnsRecursively(@NotNull HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode node, int[] path, @NotNull List<DummyGridColumnImpl> result) {
            if (node == null) {
                LoadNestedTableRowsTask.$$$reportNull$$$0(5);
            }
            if (result == null) {
                LoadNestedTableRowsTask.$$$reportNull$$$0(6);
            }
            if (node.getChildren().isEmpty()) {
                result.add(new DummyGridColumnImpl(path, node));
            }
            for (int i = 0; i < node.getChildren().size(); ++i) {
                HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode n = (HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode)node.getChildren().get(i);
                LoadNestedTableRowsTask.constructLeafColumnsRecursively(n, ArrayUtil.append((int[])path, (int)i), result);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableDataRetriever";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nestedTable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/scientific/tables/dump/NestedTableAwareDataProducer$LoadNestedTableRowsTask";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/scientific/tables/dump/NestedTableAwareDataProducer$LoadNestedTableRowsTask";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLeafColumns";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getLeafColumns";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "constructLeafColumnsRecursively";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }

        private static final class DummyGridColumnImpl
        implements GridColumn {
            private final int[] myHierarchicalIdx;
            private final HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode myNode;

            private DummyGridColumnImpl(int[] path, HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode node) {
                this.myHierarchicalIdx = path;
                this.myNode = node;
            }

            @Nullable
            public Object getValue(@NotNull GridRow row) {
                if (row == null) {
                    DummyGridColumnImpl.$$$reportNull$$$0(0);
                }
                return HierarchicalColumnsDataGridModel.extractValueByHierarchicalIndex((Object[])GridRow.getValues((GridRow)row), (int[])this.myHierarchicalIdx);
            }

            public int getColumnNumber() {
                return this.myHierarchicalIdx[this.myHierarchicalIdx.length - 1];
            }

            public int getType() {
                throw new IllegalStateException("Should not be called");
            }

            @NotNull
            public String getName() {
                String string = this.myNode.getName();
                if (string == null) {
                    DummyGridColumnImpl.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Nullable
            public String getTypeName() {
                throw new IllegalStateException("Should not be called");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "row";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/scientific/tables/dump/NestedTableAwareDataProducer$LoadNestedTableRowsTask$DummyGridColumnImpl";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/scientific/tables/dump/NestedTableAwareDataProducer$LoadNestedTableRowsTask$DummyGridColumnImpl";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getValue";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }
    }
}

