/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.notebooks.ui.visualization.NotebookBelowLastCellPanel;
import com.intellij.notebooks.visualization.EditorNotebookPostprocessor;
import com.intellij.notebooks.visualization.NotebookCellInlayController;
import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.notebooks.visualization.NotebookIntervalPointersEvent;
import com.intellij.notebooks.visualization.UpdateContext;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellEventListener;
import com.intellij.notebooks.visualization.ui.EditorCellView;
import com.intellij.notebooks.visualization.ui.EditorCellViewEventListener;
import com.intellij.notebooks.visualization.ui.EditorEmbeddedComponentContainer;
import com.intellij.notebooks.visualization.ui.EditorNotebook;
import com.intellij.notebooks.visualization.ui.JupyterCellSelectionNotifier;
import com.intellij.notebooks.visualization.ui.NotebookEditorUiUtilKt;
import com.intellij.notebooks.visualization.ui.UpdateManager;
import com.intellij.notebooks.visualization.ui.UpdateManagerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 g2\u00020\u00012\u00020\u0002:\u0001gB!\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ&\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020\u00062\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020&0)H\u0002J\b\u0010+\u001a\u00020&H\u0016J\u000e\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020.J\u0006\u0010/\u001a\u00020&J\b\u00100\u001a\u00020&H\u0002J\u0006\u00101\u001a\u00020&J\u0016\u0010%\u001a\u00020&2\f\u00102\u001a\b\u0012\u0004\u0012\u00020403H\u0002J\u000e\u0010%\u001a\u00020&2\u0006\u00105\u001a\u00020\u0012J\u000e\u0010%\u001a\u00020&2\u0006\u00106\u001a\u000204J \u00107\u001a\u00020&2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\b\b\u0002\u0010'\u001a\u00020\u0006H\u0002J\b\u00108\u001a\u00020&H\u0002J\b\u00109\u001a\u00020&H\u0002J\u0016\u0010:\u001a\u00020&2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020<0\u0011H\u0002J\u0018\u0010=\u001a\u00020&2\u0006\u00105\u001a\u00020\u00122\u0006\u0010>\u001a\u00020*H\u0002J\u0018\u0010?\u001a\u00020&2\u0006\u00105\u001a\u00020\u00122\u0006\u0010>\u001a\u00020*H\u0002J\u0010\u0010@\u001a\u00020&2\u0006\u00105\u001a\u00020\u0012H\u0002J\b\u0010A\u001a\u00020&H\u0002J\b\u0010B\u001a\u00020&H\u0002J\b\u0010C\u001a\u00020&H\u0002J\u0006\u0010D\u001a\u00020&J\b\u0010E\u001a\u00020&H\u0002J\u0016\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010G\u001a\u00020HH\u0002J\b\u0010I\u001a\u00020&H\u0002J\u0016\u0010J\u001a\u00020&2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0010\u0010K\u001a\u00020&2\u0006\u0010L\u001a\u00020MH\u0016J\b\u0010N\u001a\u00020&H\u0002J\u0018\u0010O\u001a\u00020&2\u0006\u0010P\u001a\u00020Q2\u0006\u0010>\u001a\u00020*H\u0002J\u0010\u0010R\u001a\u00020&2\u0006\u00106\u001a\u000204H\u0002J\u0010\u0010S\u001a\u00020&2\u0006\u0010T\u001a\u00020UH\u0002J\u0016\u0010V\u001a\u00020&2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020\u0001J\u0016\u0010Z\u001a\u00020&2\u0006\u0010[\u001a\u00020\u001e2\u0006\u0010Y\u001a\u00020\u0001J\u0015\u0010\\\u001a\u00020&2\u0006\u0010]\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b^J\u0015\u0010_\u001a\u00020&2\u0006\u0010]\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b`J\u000e\u0010a\u001a\u00020\u00122\u0006\u0010T\u001a\u00020UJ\u000e\u0010a\u001a\u00020\u00122\u0006\u0010-\u001a\u00020.J\u000e\u0010a\u001a\u00020\u00122\u0006\u00106\u001a\u000204J\u0006\u0010b\u001a\u00020&J\u0013\u0010c\u001a\b\u0012\u0004\u0012\u00020e0dH\u0000\u00a2\u0006\u0002\bfR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u001c\u001a\u0015\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u001e0\u001e0\u001d\u00a2\u0006\u0002\b X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006h"}, d2={"Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointerFactory$ChangeListener;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "shouldCheckInlayOffsets", "", "notebook", "Lcom/intellij/notebooks/visualization/ui/EditorNotebook;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;ZLcom/intellij/notebooks/visualization/ui/EditorNotebook;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "notebookCellLines", "Lcom/intellij/notebooks/visualization/NotebookCellLines;", "initialized", "cells", "", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "getCells", "()Ljava/util/List;", "views", "", "Lcom/intellij/notebooks/visualization/ui/EditorCellView;", "getViews", "()Ljava/util/Map;", "belowLastCellInlay", "Lcom/intellij/openapi/editor/Inlay;", "cellViewEventListeners", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/notebooks/visualization/ui/EditorCellViewEventListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "invalidationListeners", "", "Ljava/lang/Runnable;", "valid", "update", "", "force", "block", "Lkotlin/Function1;", "Lcom/intellij/notebooks/visualization/UpdateContext;", "dispose", "getCellForInterval", "interval", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "updateAllOutputs", "updateAll", "forceUpdateAll", "pointers", "", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "cell", "pointer", "updateCells", "addViewportChangeListener", "initialize", "updateUI", "events", "Lcom/intellij/notebooks/visualization/ui/EditorCellEventListener$EditorCellEvent;", "createCellViewIfNecessary", "ctx", "createCellView", "disposeCellView", "setupSelectionUI", "updateSelection", "addBelowLastCellInlay", "removeBelowLastCellInlay", "setupFoldingListener", "editorCells", "region", "Lcom/intellij/openapi/editor/FoldRegion;", "handleRefreshedDocument", "updateCellsFolding", "onUpdated", "event", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointersEvent;", "checkInlayOffsets", "fixInlaysOffsetsAfterNewCellInsert", "change", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointersEvent$OnInserted;", "addCell", "removeCell", "index", "", "addCellEventsListener", "editorCellEventListener", "Lcom/intellij/notebooks/visualization/ui/EditorCellEventListener;", "disposable", "addCellViewEventsListener", "editorCellViewEventListener", "fireCellViewCreated", "cellView", "fireCellViewCreated$intellij_notebooks_visualization", "fireCellViewRemoved", "fireCellViewRemoved$intellij_notebooks_visualization", "getCell", "invalidateCells", "getInputFactories", "Lkotlin/sequences/Sequence;", "Lcom/intellij/notebooks/visualization/NotebookCellInlayController$InputFactory;", "getInputFactories$intellij_notebooks_visualization", "Companion", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nNotebookCellInlayManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookCellInlayManager.kt\ncom/intellij/notebooks/visualization/NotebookCellInlayManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,513:1\n1557#2:514\n1628#2,3:515\n774#2:519\n865#2,2:520\n1557#2:523\n1628#2,3:524\n1863#2,2:527\n1863#2,2:529\n1611#2,9:531\n1863#2:540\n1864#2:542\n1620#2:543\n1557#2:544\n1628#2,3:545\n1863#2,2:548\n1863#2,2:550\n1863#2,2:552\n1863#2,2:554\n1863#2,2:556\n1863#2,2:558\n808#2,11:560\n1863#2,2:571\n1#3:518\n1#3:541\n24#4:522\n*S KotlinDebug\n*F\n+ 1 NotebookCellInlayManager.kt\ncom/intellij/notebooks/visualization/NotebookCellInlayManager\n*L\n211#1:514\n211#1:515,3\n278#1:519\n278#1:520,2\n396#1:523\n396#1:524,3\n449#1:527,2\n72#1:529,2\n91#1:531,9\n91#1:540\n91#1:542\n91#1:543\n91#1:544\n91#1:545,3\n104#1:548,2\n113#1:550,2\n290#1:552,2\n297#1:554,2\n352#1:556,2\n357#1:558,2\n373#1:560,11\n373#1:571,2\n91#1:541\n396#1:522\n*E\n"})
public final class NotebookCellInlayManager
implements Disposable,
NotebookIntervalPointerFactory.ChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    private final boolean shouldCheckInlayOffsets;
    @NotNull
    private final EditorNotebook notebook;
    @NotNull
    private final NotebookCellLines notebookCellLines;
    private boolean initialized;
    @NotNull
    private final Map<EditorCell, EditorCellView> views;
    @Nullable
    private Inlay<?> belowLastCellInlay;
    @NotNull
    private final EventDispatcher<EditorCellViewEventListener> cellViewEventListeners;
    @NotNull
    private final List<Runnable> invalidationListeners;
    private boolean valid;
    @NotNull
    private static final Key<Boolean> FOLDING_MARKER_KEY = new Key("jupyter.folding.paragraph");
    @NotNull
    private static final Key<NotebookCellInlayManager> CELL_INLAY_MANAGER_KEY;

    private NotebookCellInlayManager(EditorImpl editor, boolean shouldCheckInlayOffsets, EditorNotebook notebook) {
        this.editor = editor;
        this.shouldCheckInlayOffsets = shouldCheckInlayOffsets;
        this.notebook = notebook;
        this.notebookCellLines = NotebookCellLines.Companion.get((Editor)this.editor);
        this.views = new LinkedHashMap();
        EventDispatcher eventDispatcher = EventDispatcher.create(EditorCellViewEventListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.cellViewEventListeners = eventDispatcher;
        this.invalidationListeners = new ArrayList();
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @NotNull
    public final List<EditorCell> getCells() {
        return this.notebook.getCells();
    }

    @NotNull
    public final Map<EditorCell, EditorCellView> getViews() {
        return this.views;
    }

    private final void update(boolean force, Function1<? super UpdateContext, Unit> block) {
        UpdateManagerKt.getUpdateManager((Editor)this.editor).update(force, block);
    }

    static /* synthetic */ void update$default(NotebookCellInlayManager notebookCellInlayManager, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        notebookCellInlayManager.update(bl, (Function1<? super UpdateContext, Unit>)function1);
    }

    public void dispose() {
        RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)this.editor), CELL_INLAY_MANAGER_KEY);
    }

    @NotNull
    public final EditorCell getCellForInterval(@NotNull NotebookCellLines.Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return this.notebook.getCells().get(interval.getOrdinal());
    }

    public final void updateAllOutputs() {
        NotebookCellInlayManager.update$default(this, false, arg_0 -> NotebookCellInlayManager.updateAllOutputs$lambda$1(this, arg_0), 1, null);
    }

    private final void updateAll() {
        if (this.initialized) {
            this.updateCells(this.getCells(), false);
        }
    }

    public final void forceUpdateAll() {
        ActionsKt.runInEdt$default(null, () -> NotebookCellInlayManager.forceUpdateAll$lambda$2(this), (int)1, null);
    }

    private final void update(Collection<? extends NotebookIntervalPointer> pointers) {
        ActionsKt.runInEdt$default(null, () -> NotebookCellInlayManager.update$lambda$5(this, pointers), (int)1, null);
    }

    public final void update(@NotNull EditorCell cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        ActionsKt.runInEdt$default(null, () -> NotebookCellInlayManager.update$lambda$6(this, cell), (int)1, null);
    }

    public final void update(@NotNull NotebookIntervalPointer pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        ActionsKt.runInEdt$default(null, () -> NotebookCellInlayManager.update$lambda$7(this, pointer), (int)1, null);
    }

    private final void updateCells(List<EditorCell> cells, boolean force) {
        this.update(force, (Function1<? super UpdateContext, Unit>)((Function1)arg_0 -> NotebookCellInlayManager.updateCells$lambda$9(cells, this, arg_0)));
    }

    static /* synthetic */ void updateCells$default(NotebookCellInlayManager notebookCellInlayManager, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        notebookCellInlayManager.updateCells(list, bl);
    }

    private final void addViewportChangeListener() {
        this.editor.getScrollPane().getViewport().addChangeListener(arg_0 -> NotebookCellInlayManager.addViewportChangeListener$lambda$11(this, arg_0));
    }

    private final void initialize() {
        this.editor.putUserData(CELL_INLAY_MANAGER_KEY, (Object)this);
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Disposable disposable = this.editor.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        MessageBusConnection connection = messageBus.connect(disposable);
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, arg_0 -> NotebookCellInlayManager.initialize$lambda$12(this, arg_0));
        Topic topic2 = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        connection.subscribe(topic2, arg_0 -> NotebookCellInlayManager.initialize$lambda$13(this, arg_0));
        this.addViewportChangeListener();
        this.editor.getFoldingModel().addListener(new FoldingListener(this){
            final /* synthetic */ NotebookCellInlayManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void onFoldProcessingEnd() {
                this.this$0.invalidateCells();
            }
        }, this.editor.getDisposable());
        this.initialized = true;
        this.setupFoldingListener();
        this.setupSelectionUI();
        this.addBelowLastCellInlay();
        this.notebook.addCellEventsListener(this, new EditorCellEventListener(this){
            final /* synthetic */ NotebookCellInlayManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void onEditorCellEvents(List<? extends EditorCellEventListener.EditorCellEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                NotebookCellInlayManager.access$updateUI(this.this$0, events);
            }
        });
        this.handleRefreshedDocument();
    }

    private final void updateUI(List<? extends EditorCellEventListener.EditorCellEvent> events) {
        NotebookCellInlayManager.update$default(this, false, arg_0 -> NotebookCellInlayManager.updateUI$lambda$15(events, this, arg_0), 1, null);
    }

    private final void createCellViewIfNecessary(EditorCell cell, UpdateContext ctx) {
        if (this.views.get(cell) == null) {
            this.createCellView(cell, ctx);
        }
    }

    private final void createCellView(EditorCell cell, UpdateContext ctx) {
        EditorCellView view = new EditorCellView(this.editor, this.notebookCellLines, cell, this);
        Disposer.register((Disposable)cell, (Disposable)view);
        view.updateCellFolding(ctx);
        this.views.put(cell, view);
        this.fireCellViewCreated$intellij_notebooks_visualization(view);
    }

    private final void disposeCellView(EditorCell cell) {
        block0: {
            EditorCellView editorCellView = this.views.remove(cell);
            if (editorCellView == null) break block0;
            EditorCellView view = editorCellView;
            boolean bl = false;
            this.fireCellViewRemoved$intellij_notebooks_visualization(view);
            Disposer.dispose((Disposable)view);
        }
    }

    private final void setupSelectionUI() {
        this.editor.getCaretModel().addCaretListener(new CaretListener(this){
            final /* synthetic */ NotebookCellInlayManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void caretPositionChanged(CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                NotebookCellInlayManager.access$updateSelection(this.this$0);
            }
        }, (Disposable)this);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSelection() {
        void $this$mapTo$iv$iv;
        NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)this.editor);
        if (notebookCellSelectionModel == null) {
            throw new IllegalStateException("The selection model is supposed to be installed".toString());
        }
        NotebookCellSelectionModel selectionModel = notebookCellSelectionModel;
        Iterable $this$map$iv = selectionModel.getSelectedCells();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getOrdinal());
        }
        List selectedCells = (List)destination$iv$iv;
        for (EditorCell cell : this.getCells()) {
            NotebookCellLines.Interval interval = cell.getIntervalPointer().get();
            cell.getSelected().set(CollectionsKt.contains((Iterable)selectedCells, (Object)(interval != null ? Integer.valueOf(interval.getOrdinal()) : null)));
            if (!cell.getSelected().get().booleanValue()) continue;
            Object object = this.editor.getProject();
            if (object == null || (object = object.getMessageBus()) == null || (object = (JupyterCellSelectionNotifier)object.syncPublisher(JupyterCellSelectionNotifier.Companion.getTOPIC())) == null) continue;
            object.cellSelected(cell.getInterval(), (Editor)this.editor);
        }
    }

    private final void addBelowLastCellInlay() {
        this.belowLastCellInlay = NotebookEditorUiUtilKt.addComponentInlay$default((EditorEx)this.editor, new NotebookBelowLastCellPanel(this.editor), true, false, false, 0, this.editor.getDocument().getLineEndOffset(RangesKt.coerceAtLeast((int)(this.editor.getDocument().getLineCount() - 1), (int)0)), null, 72, null);
    }

    public final void removeBelowLastCellInlay() {
        Inlay<?> inlay = this.belowLastCellInlay;
        if (inlay != null) {
            Inlay<?> it = inlay;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
        this.belowLastCellInlay = null;
    }

    private final void setupFoldingListener() {
        FoldingModelImpl foldingModelImpl = this.editor.getFoldingModel();
        Intrinsics.checkNotNullExpressionValue((Object)foldingModelImpl, (String)"getFoldingModel(...)");
        FoldingModelImpl foldingModel = foldingModelImpl;
        foldingModel.addListener(new FoldingListener(this){
            private final LinkedHashSet<FoldRegion> changedRegions;
            private final LinkedHashSet<FoldRegion> removedRegions;
            final /* synthetic */ NotebookCellInlayManager this$0;
            {
                this.this$0 = $receiver;
                this.changedRegions = new LinkedHashSet<E>();
                this.removedRegions = new LinkedHashSet<E>();
            }

            public final LinkedHashSet<FoldRegion> getChangedRegions() {
                return this.changedRegions;
            }

            public final LinkedHashSet<FoldRegion> getRemovedRegions() {
                return this.removedRegions;
            }

            public void beforeFoldRegionDisposed(FoldRegion region) {
                Intrinsics.checkNotNullParameter((Object)region, (String)"region");
                this.removedRegions.add(region);
                this.changedRegions.remove(region);
            }

            public void beforeFoldRegionRemoved(FoldRegion region) {
                Intrinsics.checkNotNullParameter((Object)region, (String)"region");
                this.removedRegions.add(region);
                this.changedRegions.remove(region);
            }

            public void onFoldRegionStateChange(FoldRegion region) {
                Intrinsics.checkNotNullParameter((Object)region, (String)"region");
                this.changedRegions.add(region);
            }

            /*
             * WARNING - void declaration
             */
            public void onFoldProcessingEnd() {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                void $this$filterTo$iv$iv2;
                Iterable $this$filter$iv2 = this.changedRegions;
                boolean $i$f$filter22 = false;
                Object object = $this$filter$iv2;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo22 = false;
                for (T element$iv$iv : $this$filterTo$iv$iv2) {
                    FoldRegion it = (FoldRegion)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getUserData(NotebookCellInlayManager.Companion.getFOLDING_MARKER_KEY()), (Object)true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List changedRegions = (List)destination$iv$iv;
                this.changedRegions.clear();
                Iterable $i$f$filter22 = this.removedRegions;
                object = this.this$0;
                boolean $i$f$filter = false;
                void $i$f$filterTo22 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    FoldRegion it = (FoldRegion)element$iv$iv;
                    boolean bl = false;
                    if (!(((NotebookCellInlayManager)object).getEditor().getFoldingModel().getCollapsedRegionAtOffset(it.getStartOffset()) == null)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List removedRegions = (List)destination$iv$iv2;
                this.removedRegions.clear();
                NotebookCellInlayManager.update$default(this.this$0, false, arg_0 -> setupFoldingListener.1.onFoldProcessingEnd$lambda$6(changedRegions, removedRegions, this.this$0, arg_0), 1, null);
            }

            private static final Unit onFoldProcessingEnd$lambda$6(List $changedRegions, List $removedRegions, NotebookCellInlayManager this$0, UpdateContext ctx) {
                EditorCell it;
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                FoldRegion region;
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Iterable $this$forEach$iv2 = $changedRegions;
                boolean $i$f$forEach2 = false;
                for (T element$iv : $this$forEach$iv2) {
                    region = (FoldRegion)element$iv;
                    boolean bl = false;
                    $this$forEach$iv = NotebookCellInlayManager.access$editorCells(this$0, region);
                    $i$f$forEach = false;
                    for (T element$iv2 : $this$forEach$iv) {
                        it = (EditorCell)element$iv2;
                        boolean bl2 = false;
                        it.getVisible().set(region.isExpanded());
                    }
                }
                $this$forEach$iv2 = $removedRegions;
                $i$f$forEach2 = false;
                for (T element$iv : $this$forEach$iv2) {
                    region = (FoldRegion)element$iv;
                    boolean bl = false;
                    $this$forEach$iv = NotebookCellInlayManager.access$editorCells(this$0, region);
                    $i$f$forEach = false;
                    for (T element$iv2 : $this$forEach$iv) {
                        it = (EditorCell)element$iv2;
                        boolean bl3 = false;
                        it.getVisible().set(true);
                    }
                }
                return Unit.INSTANCE;
            }
        }, (Disposable)this);
    }

    /*
     * WARNING - void declaration
     */
    private final List<EditorCell> editorCells(FoldRegion region) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.notebook.getCells();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EditorCell cell = (EditorCell)element$iv$iv;
            boolean bl = false;
            DocumentEx documentEx = this.editor.getDocument();
            NotebookCellLines.Interval interval = cell.getIntervalPointer().get();
            Intrinsics.checkNotNull((Object)interval);
            int startOffset = documentEx.getLineStartOffset(interval.getLines().getFirst());
            DocumentEx documentEx2 = this.editor.getDocument();
            NotebookCellLines.Interval interval2 = cell.getIntervalPointer().get();
            Intrinsics.checkNotNull((Object)interval2);
            int endOffset = documentEx2.getLineEndOffset(interval2.getLines().getLast());
            if (!(startOffset >= region.getStartOffset() && endOffset <= region.getEndOffset())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void handleRefreshedDocument() {
        ThreadingAssertions.softAssertReadAccess();
        this.notebook.clear();
        NotebookIntervalPointerFactory pointerFactory = NotebookIntervalPointerFactory.Companion.get((Editor)this.editor);
        NotebookCellInlayManager.update$default(this, false, arg_0 -> NotebookCellInlayManager.handleRefreshedDocument$lambda$21(this, pointerFactory, arg_0), 1, null);
    }

    private final void updateCellsFolding(List<EditorCell> editorCells) {
        NotebookCellInlayManager.update$default(this, false, arg_0 -> NotebookCellInlayManager.updateCellsFolding$lambda$23(editorCells, arg_0), 1, null);
    }

    @Override
    public void onUpdated(@NotNull NotebookIntervalPointersEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        NotebookCellInlayManager.update$default(this, false, arg_0 -> NotebookCellInlayManager.onUpdated$lambda$27(event, this, arg_0), 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkInlayOffsets() {
        Set set;
        if (!this.shouldCheckInlayOffsets) {
            return;
        }
        Set $this$checkInlayOffsets_u24lambda_u2428 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        for (EditorCell cell : this.notebook.getCells()) {
            $this$checkInlayOffsets_u24lambda_u2428.add(this.editor.getDocument().getLineStartOffset(cell.getInterval().getLines().getFirst()));
            $this$checkInlayOffsets_u24lambda_u2428.add(this.editor.getDocument().getLineEndOffset(cell.getInterval().getLines().getLast()));
        }
        Set inlaysOffsets = SetsKt.build((Set)set);
        Set wronglyPlacedInlays = SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.notebook.getCells()), NotebookCellInlayManager::checkInlayOffsets$lambda$29), NotebookCellInlayManager::checkInlayOffsets$lambda$30), arg_0 -> NotebookCellInlayManager.checkInlayOffsets$lambda$31(inlaysOffsets, arg_0)));
        if (!((Collection)wronglyPlacedInlays).isEmpty()) {
            Collection<Integer> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(NotebookCellInlayManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            $this$thisLogger$iv = wronglyPlacedInlays;
            Set set2 = inlaysOffsets;
            Logger logger2 = logger;
            boolean $i$f$map = false;
            Iterator<EditorCell> iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Inlay inlay = (Inlay)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getOffset());
            }
            collection = (List)destination$iv$iv;
            VirtualFile virtualFile = this.editor.getVirtualFile();
            logger2.error("Expected offsets: " + set2 + ". Wrongly placed offsets: " + (List)collection + " of inlays " + wronglyPlacedInlays + ", for file = '" + (virtualFile != null ? virtualFile.getName() : null) + "'");
        }
    }

    private final void fixInlaysOffsetsAfterNewCellInsert(NotebookIntervalPointersEvent.OnInserted change, UpdateContext ctx) {
        int prevCellIndex = ((NotebookIntervalPointersEvent.PointerSnapshot)CollectionsKt.first(change.getSubsequentPointers())).getInterval().getOrdinal() - 1;
        if (prevCellIndex >= 0) {
            EditorCell prevCell = this.getCell(prevCellIndex);
            prevCell.update(ctx);
        }
    }

    private final void addCell(NotebookIntervalPointer pointer) {
        this.notebook.addCell(pointer);
        this.invalidateCells();
    }

    private final void removeCell(int index) {
        this.notebook.removeCell(index);
        this.invalidateCells();
    }

    public final void addCellEventsListener(@NotNull EditorCellEventListener editorCellEventListener, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)editorCellEventListener, (String)"editorCellEventListener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.notebook.addCellEventsListener(disposable, editorCellEventListener);
    }

    public final void addCellViewEventsListener(@NotNull EditorCellViewEventListener editorCellViewEventListener, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)editorCellViewEventListener, (String)"editorCellViewEventListener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.cellViewEventListeners.addListener((EventListener)editorCellViewEventListener, disposable);
    }

    public final void fireCellViewCreated$intellij_notebooks_visualization(@NotNull EditorCellView cellView) {
        Intrinsics.checkNotNullParameter((Object)cellView, (String)"cellView");
        ((EditorCellViewEventListener)this.cellViewEventListeners.getMulticaster()).onEditorCellViewEvents(CollectionsKt.listOf((Object)new EditorCellViewEventListener.CellViewCreated(cellView)));
    }

    public final void fireCellViewRemoved$intellij_notebooks_visualization(@NotNull EditorCellView cellView) {
        Intrinsics.checkNotNullParameter((Object)cellView, (String)"cellView");
        ((EditorCellViewEventListener)this.cellViewEventListeners.getMulticaster()).onEditorCellViewEvents(CollectionsKt.listOf((Object)new EditorCellViewEventListener.CellViewRemoved(cellView)));
    }

    @NotNull
    public final EditorCell getCell(int index) {
        return this.getCells().get(index);
    }

    @NotNull
    public final EditorCell getCell(@NotNull NotebookCellLines.Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return this.getCells().get(interval.getOrdinal());
    }

    @NotNull
    public final EditorCell getCell(@NotNull NotebookIntervalPointer pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        NotebookCellLines.Interval interval = pointer.get();
        Intrinsics.checkNotNull((Object)interval);
        return this.getCell(interval);
    }

    public final void invalidateCells() {
        if (this.valid) {
            this.valid = false;
            Iterable $this$forEach$iv = this.invalidationListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Runnable it = (Runnable)element$iv;
                boolean bl = false;
                it.run();
            }
        }
    }

    @NotNull
    public final Sequence<NotebookCellInlayController.InputFactory> getInputFactories$intellij_notebooks_visualization() {
        return CollectionsKt.asSequence((Iterable)NotebookCellInlayController.InputFactory.EP_NAME.getExtensionList());
    }

    private static final Unit updateAllOutputs$lambda$1(NotebookCellInlayManager this$0, UpdateContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$forEach$iv = this$0.notebook.getCells();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorCell it2 = (EditorCell)element$iv;
            boolean bl = false;
            it2.updateOutputs();
        }
        return Unit.INSTANCE;
    }

    private static final Unit forceUpdateAll$lambda$2(NotebookCellInlayManager this$0) {
        if (this$0.initialized) {
            this$0.updateCells(this$0.getCells(), true);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit update$lambda$5(NotebookCellInlayManager this$0, Collection $pointers) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Iterable iterable = $pointers;
        NotebookCellInlayManager notebookCellInlayManager = this$0;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            NotebookIntervalPointer it = (NotebookIntervalPointer)element$iv$iv;
            boolean bl2 = false;
            NotebookCellLines.Interval interval = it.get();
            if ((interval != null ? Integer.valueOf(interval.getOrdinal()) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this$0.getCells().get((int)it));
        }
        notebookCellInlayManager.updateCells((List)destination$iv$iv, false);
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$6(NotebookCellInlayManager this$0, EditorCell $cell) {
        this$0.update($cell.getIntervalPointer());
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$7(NotebookCellInlayManager this$0, NotebookIntervalPointer $pointer) {
        this$0.update((Collection)new SmartList((Object)$pointer));
        return Unit.INSTANCE;
    }

    private static final Unit updateCells$lambda$9(List $cells, NotebookCellInlayManager this$0, UpdateContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Iterable $this$forEach$iv = $cells;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorCell it = (EditorCell)element$iv;
            boolean bl = false;
            it.update(ctx);
        }
        this$0.updateCellsFolding($cells);
        return Unit.INSTANCE;
    }

    private static final void addViewportChangeListener$lambda$11(NotebookCellInlayManager this$0, ChangeEvent it) {
        Iterable $this$forEach$iv = this$0.notebook.getCells();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorCell it2 = (EditorCell)element$iv;
            boolean bl = false;
            it2.onViewportChange();
        }
    }

    private static final void initialize$lambda$12(NotebookCellInlayManager this$0, EditorColorsScheme it) {
        this$0.updateAll();
    }

    private static final void initialize$lambda$13(NotebookCellInlayManager this$0, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateAll();
    }

    private static final Unit updateUI$lambda$15$lambda$14(NotebookCellInlayManager this$0, EditorCell $cell, UpdateContext $ctx, boolean visible) {
        if (visible) {
            this$0.createCellViewIfNecessary($cell, $ctx);
        } else {
            this$0.disposeCellView($cell);
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateUI$lambda$15(List $events, NotebookCellInlayManager this$0, UpdateContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        for (EditorCellEventListener.EditorCellEvent event : $events) {
            EditorCellEventListener.EditorCellEvent editorCellEvent = event;
            if (editorCellEvent instanceof EditorCellEventListener.CellCreated) {
                EditorCell cell = ((EditorCellEventListener.CellCreated)event).getCell();
                cell.getVisible().afterChange(arg_0 -> NotebookCellInlayManager.updateUI$lambda$15$lambda$14(this$0, cell, ctx, arg_0));
                this$0.createCellViewIfNecessary(cell, ctx);
                continue;
            }
            if (editorCellEvent instanceof EditorCellEventListener.CellRemoved) {
                this$0.disposeCellView(((EditorCellEventListener.CellRemoved)event).getCell());
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    private static final Unit handleRefreshedDocument$lambda$21(NotebookCellInlayManager this$0, NotebookIntervalPointerFactory $pointerFactory, UpdateContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$forEach$iv = this$0.notebookCellLines.getIntervals();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)element$iv;
            boolean bl = false;
            this$0.notebook.addCell($pointerFactory.create(interval));
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateCellsFolding$lambda$23(List $editorCells, UpdateContext updateContext) {
        Intrinsics.checkNotNullParameter((Object)updateContext, (String)"updateContext");
        Iterable $this$forEach$iv = $editorCells;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorCell cell = (EditorCell)element$iv;
            boolean bl = false;
            EditorCellView editorCellView = cell.getView();
            if (editorCellView == null) continue;
            editorCellView.updateCellFolding(updateContext);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onUpdated$lambda$27(NotebookIntervalPointersEvent $event, NotebookCellInlayManager this$0, UpdateContext ctx) {
        void $this$filterIsInstanceTo$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        for (NotebookIntervalPointersEvent.Change change : $event.getChanges()) {
            NotebookIntervalPointersEvent.PointerSnapshot it;
            Iterable $this$forEach$iv;
            object = change;
            if (object instanceof NotebookIntervalPointersEvent.OnEdited) {
                EditorCell cell = this$0.notebook.getCells().get(((NotebookIntervalPointersEvent.OnEdited)change).getIntervalAfter().getOrdinal());
                cell.updateInput();
                continue;
            }
            if (object instanceof NotebookIntervalPointersEvent.OnInserted) {
                $this$forEach$iv = ((NotebookIntervalPointersEvent.OnInserted)change).getSubsequentPointers();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (NotebookIntervalPointersEvent.PointerSnapshot)element$iv;
                    boolean bl = false;
                    this$0.addCell(it.getPointer());
                }
                continue;
            }
            if (object instanceof NotebookIntervalPointersEvent.OnRemoved) {
                $this$forEach$iv = CollectionsKt.reversed((Iterable)((NotebookIntervalPointersEvent.OnRemoved)change).getSubsequentPointers());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (NotebookIntervalPointersEvent.PointerSnapshot)element$iv;
                    boolean bl = false;
                    int index = it.getInterval().getOrdinal();
                    this$0.removeCell(index);
                }
                continue;
            }
            if (object instanceof NotebookIntervalPointersEvent.OnSwapped) {
                EditorCell firstCell = this$0.notebook.getCells().get(((NotebookIntervalPointersEvent.OnSwapped)change).getFirstOrdinal());
                NotebookIntervalPointer first = firstCell.getIntervalPointer();
                EditorCell secondCell = this$0.notebook.getCells().get(((NotebookIntervalPointersEvent.OnSwapped)change).getSecondOrdinal());
                firstCell.setIntervalPointer(secondCell.getIntervalPointer());
                secondCell.setIntervalPointer(first);
                firstCell.update(ctx);
                secondCell.update(ctx);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        Iterable $this$filterIsInstance$iv = $event.getChanges();
        boolean $i$f$filterIsInstance = false;
        object = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof NotebookIntervalPointersEvent.OnInserted)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotebookIntervalPointersEvent.OnInserted change = (NotebookIntervalPointersEvent.OnInserted)element$iv;
            boolean bl = false;
            this$0.fixInlaysOffsetsAfterNewCellInsert(change, ctx);
        }
        this$0.checkInlayOffsets();
        return Unit.INSTANCE;
    }

    private static final EditorCellView checkInlayOffsets$lambda$29(EditorCell it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getView();
    }

    private static final Sequence checkInlayOffsets$lambda$30(EditorCellView it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getInlays();
    }

    private static final boolean checkInlayOffsets$lambda$31(Set $inlaysOffsets, Inlay it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$inlaysOffsets.contains(it.getOffset());
    }

    public static final /* synthetic */ void access$updateUI(NotebookCellInlayManager $this, List events) {
        $this.updateUI(events);
    }

    public static final /* synthetic */ void access$updateSelection(NotebookCellInlayManager $this) {
        $this.updateSelection();
    }

    public static final /* synthetic */ List access$editorCells(NotebookCellInlayManager $this, FoldRegion region) {
        return $this.editorCells(region);
    }

    public /* synthetic */ NotebookCellInlayManager(EditorImpl editor, boolean shouldCheckInlayOffsets, EditorNotebook notebook, DefaultConstructorMarker $constructor_marker) {
        this(editor, shouldCheckInlayOffsets, notebook);
    }

    static {
        Key key = Key.create((String)NotebookCellInlayManager.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        CELL_INLAY_MANAGER_KEY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R!\u0010\u0015\u001a\u0015\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00050\u00050\u0012\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/notebooks/visualization/NotebookCellInlayManager$Companion;", "", "<init>", "()V", "install", "Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "shouldCheckInlayOffsets", "", "editorNotebookPostprocessors", "", "Lcom/intellij/notebooks/visualization/EditorNotebookPostprocessor;", "createNotebook", "Lcom/intellij/notebooks/visualization/ui/EditorNotebook;", "get", "Lcom/intellij/openapi/editor/Editor;", "FOLDING_MARKER_KEY", "Lcom/intellij/openapi/util/Key;", "getFOLDING_MARKER_KEY", "()Lcom/intellij/openapi/util/Key;", "CELL_INLAY_MANAGER_KEY", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.notebooks.visualization"})
    @SourceDebugExtension(value={"SMAP\nNotebookCellInlayManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookCellInlayManager.kt\ncom/intellij/notebooks/visualization/NotebookCellInlayManager$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,513:1\n1#2:514\n1863#3,2:515\n*S KotlinDebug\n*F\n+ 1 NotebookCellInlayManager.kt\ncom/intellij/notebooks/visualization/NotebookCellInlayManager$Companion\n*L\n328#1:515,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NotebookCellInlayManager install(@NotNull EditorImpl editor, boolean shouldCheckInlayOffsets, @NotNull List<? extends EditorNotebookPostprocessor> editorNotebookPostprocessors) {
            NotebookCellInlayManager notebookCellInlayManager;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter(editorNotebookPostprocessors, (String)"editorNotebookPostprocessors");
            new EditorEmbeddedComponentContainer((EditorEx)editor);
            UpdateManager updateManager = new UpdateManager(editor);
            Disposer.register((Disposable)editor.getDisposable(), (Disposable)updateManager);
            EditorNotebook notebook = this.createNotebook(editor, editorNotebookPostprocessors);
            NotebookCellInlayManager it = notebookCellInlayManager = new NotebookCellInlayManager(editor, shouldCheckInlayOffsets, notebook, null);
            boolean bl = false;
            Disposer.register((Disposable)editor.getDisposable(), (Disposable)it);
            NotebookCellInlayManager notebookCellInlayManager2 = notebookCellInlayManager;
            editor.putUserData(com.intellij.notebooks.ui.NotebookEditorUiUtilKt.isFoldingEnabledKey(), (Object)Registry.Companion.is("jupyter.editor.folding.cells"));
            notebookCellInlayManager2.initialize();
            NotebookIntervalPointerFactory.Companion.get((Editor)editor).getChangeListeners().addListener((EventListener)notebookCellInlayManager2, (Disposable)notebookCellInlayManager2);
            return notebookCellInlayManager2;
        }

        public static /* synthetic */ NotebookCellInlayManager install$default(Companion companion, EditorImpl editorImpl, boolean bl, List list, int n, Object object) {
            if ((n & 4) != 0) {
                list = CollectionsKt.emptyList();
            }
            return companion.install(editorImpl, bl, list);
        }

        private final EditorNotebook createNotebook(EditorImpl editor, List<? extends EditorNotebookPostprocessor> editorNotebookPostprocessors) {
            EditorNotebook notebook = new EditorNotebook(editor);
            Iterable $this$forEach$iv = editorNotebookPostprocessors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EditorNotebookPostprocessor it = (EditorNotebookPostprocessor)element$iv;
                boolean bl = false;
                it.postprocess(notebook);
            }
            Disposer.register((Disposable)editor.getDisposable(), (Disposable)notebook);
            return notebook;
        }

        @Nullable
        public final NotebookCellInlayManager get(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return (NotebookCellInlayManager)CELL_INLAY_MANAGER_KEY.get((UserDataHolder)editor);
        }

        @NotNull
        public final Key<Boolean> getFOLDING_MARKER_KEY() {
            return FOLDING_MARKER_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

