/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.ui.visualization;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/notebooks/ui/visualization/NotebookCellTagLabel;", "Ljavax/swing/JLabel;", "tag", "", "cellIndex", "", "<init>", "(Ljava/lang/String;I)V", "getTag", "()Ljava/lang/String;", "getCellIndex", "()I", "paintComponent", "", "g", "Ljava/awt/Graphics;", "Companion", "intellij.notebooks.ui"})
public final class NotebookCellTagLabel
extends JLabel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tag;
    private final int cellIndex;
    private static final int TEXT_VERTICAL_PADDING = JBUI.scale((int)2);
    private static final int TEXT_HORIZONTAL_PADDING = JBUI.scale((int)8);
    private static final int ARC_SIZE = JBUI.scale((int)20);
    @NotNull
    private static JBColor backgroundColor;

    public NotebookCellTagLabel(@NlsSafe @NotNull String tag, int cellIndex) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super(tag);
        this.tag = tag;
        this.cellIndex = cellIndex;
        this.setFont((Font)JBFont.small());
        this.setForeground((Color)JBColor.BLACK);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(TEXT_VERTICAL_PADDING, TEXT_HORIZONTAL_PADDING, TEXT_VERTICAL_PADDING, TEXT_HORIZONTAL_PADDING));
        PopupHandler.installPopupMenu((JComponent)this, (String)"JupyterCellTagActionGroup", (String)"NotebookCellTagPopup");
    }

    @NotNull
    public final String getTag() {
        return this.tag;
    }

    public final int getCellIndex() {
        return this.cellIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor((Color)backgroundColor);
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), ARC_SIZE, ARC_SIZE);
        }
        finally {
            g2.dispose();
        }
        super.paintComponent(g);
    }

    static {
        JBColor jBColor = JBColor.namedColor((String)"Tag.background", (Color)((Color)Gray.xDF));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        backgroundColor = jBColor;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/notebooks/ui/visualization/NotebookCellTagLabel$Companion;", "", "<init>", "()V", "TEXT_VERTICAL_PADDING", "", "TEXT_HORIZONTAL_PADDING", "ARC_SIZE", "backgroundColor", "Lcom/intellij/ui/JBColor;", "Lorg/jetbrains/annotations/NotNull;", "intellij.notebooks.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

