/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.ui.visualization;

import com.intellij.notebooks.ui.visualization.NotebookEditorAppearance;
import com.intellij.notebooks.ui.visualization.NotebookEditorAppearanceUtils;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.ui.scale.JBUIScale;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00182\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0002J\b\u0010\u001c\u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/notebooks/ui/visualization/NotebookAboveCellDelimiterPanel;", "Ljavax/swing/JPanel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isCodeCell", "", "isFirstCell", "<init>", "(Lcom/intellij/openapi/editor/Editor;ZZ)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "()Z", "backgroundColor", "Ljava/awt/Color;", "cellRoofColor", "standardDelimiterHeight", "", "delimiterPanelHeight", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/Nullable;", "getProject", "()Lcom/intellij/openapi/project/Project;", "createRoofAndDelimiterPanels", "Lkotlin/Pair;", "listenForColorSchemeChanges", "", "refreshColorScheme", "updateComponentColors", "intellij.notebooks.ui"})
public final class NotebookAboveCellDelimiterPanel
extends JPanel {
    @NotNull
    private final Editor editor;
    private final boolean isCodeCell;
    @NotNull
    private Color backgroundColor;
    @Nullable
    private Color cellRoofColor;
    private final int standardDelimiterHeight;
    private final int delimiterPanelHeight;

    public NotebookAboveCellDelimiterPanel(@NotNull Editor editor, boolean isCodeCell, boolean isFirstCell) {
        int n;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(new BorderLayout());
        this.editor = editor;
        this.isCodeCell = isCodeCell;
        Color color = this.editor.getColorsScheme().getDefaultBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultBackground(...)");
        this.backgroundColor = color;
        this.standardDelimiterHeight = NotebookUtil.INSTANCE.getNotebookAppearance(this.editor).getCellBorderHeight() / 2;
        boolean bl = isFirstCell;
        if (bl) {
            n = NotebookUtil.INSTANCE.getNotebookAppearance(this.editor).getAboveFirstCellDelimiterHeight();
        } else if (!bl) {
            n = NotebookUtil.INSTANCE.getNotebookAppearance(this.editor).getDistanceBetweenCells();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.delimiterPanelHeight = n;
        EditorKind editorKind = this.editor.getEditorKind();
        Intrinsics.checkNotNullExpressionValue((Object)editorKind, (String)"getEditorKind(...)");
        if (!NotebookEditorAppearanceUtils.INSTANCE.isDiff(editorKind)) {
            this.refreshColorScheme();
            Pair<JPanel, JPanel> pair = this.createRoofAndDelimiterPanels(this.cellRoofColor);
            JPanel delimiterPanel = (JPanel)pair.component1();
            JPanel roofPanel = (JPanel)pair.component2();
            this.add((Component)delimiterPanel, "North");
            this.add((Component)roofPanel, "South");
            this.listenForColorSchemeChanges();
        }
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    public final boolean isCodeCell() {
        return this.isCodeCell;
    }

    @NotNull
    public final Project getProject() {
        Project project = this.editor.getProject();
        if (project == null) {
            Project project2 = ProjectManager.getInstance().getDefaultProject();
            project = project2;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getDefaultProject(...)");
        }
        return project;
    }

    private final Pair<JPanel, JPanel> createRoofAndDelimiterPanels(Color cellRoofColor) {
        JPanel delimiterPanel = new JPanel();
        delimiterPanel.setBackground(this.backgroundColor);
        delimiterPanel.setPreferredSize(new Dimension(JBUIScale.scale((int)1), this.delimiterPanelHeight));
        JPanel roofPanel = new JPanel();
        roofPanel.setBackground(cellRoofColor);
        roofPanel.setPreferredSize(new Dimension(JBUIScale.scale((int)1), this.standardDelimiterHeight));
        return new Pair((Object)delimiterPanel, (Object)roofPanel);
    }

    private final void listenForColorSchemeChanges() {
        this.addPropertyChangeListener("border", arg_0 -> NotebookAboveCellDelimiterPanel.listenForColorSchemeChanges$lambda$0(this, arg_0));
    }

    private final void refreshColorScheme() {
        Color color;
        this.backgroundColor = this.editor.getColorsScheme().getDefaultBackground();
        if (this.isCodeCell) {
            NotebookEditorAppearance notebookEditorAppearance = NotebookUtil.INSTANCE.getNotebookAppearance(this.editor);
            EditorColorsScheme editorColorsScheme = this.editor.getColorsScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
            color = notebookEditorAppearance.getCodeCellBackground(editorColorsScheme);
        } else {
            color = this.backgroundColor;
        }
        this.cellRoofColor = color;
    }

    private final void updateComponentColors() {
        block2: {
            this.refreshColorScheme();
            Component[] componentArray = this.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            if (!(!(((Object[])componentArray).length == 0))) break block2;
            Component component = this.getComponents()[0];
            JPanel delimiterPanel = component instanceof JPanel ? (JPanel)component : null;
            Component component2 = this.getComponents()[1];
            JPanel roofPanel = component2 instanceof JPanel ? (JPanel)component2 : null;
            JPanel jPanel = delimiterPanel;
            if (jPanel != null) {
                jPanel.setBackground(this.backgroundColor);
            }
            JPanel jPanel2 = roofPanel;
            if (jPanel2 != null) {
                jPanel2.setBackground(this.cellRoofColor);
            }
        }
    }

    private static final void listenForColorSchemeChanges$lambda$0(NotebookAboveCellDelimiterPanel this$0, PropertyChangeEvent it) {
        this$0.updateComponentColors();
    }
}

