/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.raster;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.jcef.HasViewport;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.NotebookGraphicsConfigurationManager;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.raster.CefMouseWheelEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefJSQuery;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.Charsets;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 32\u00020\u0001:\u000223B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020!H\u0002J\"\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\u00132\b\b\u0002\u0010$\u001a\u00020\t2\b\b\u0002\u0010%\u001a\u00020\tJ\u0010\u0010&\u001a\u00020'2\u0006\u0010#\u001a\u00020\u0013H\u0002J\u0018\u0010(\u001a\u00020 2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\tH\u0002J \u0010)\u001a\u00020 2\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\tH\u0002J0\u0010)\u001a\u00020 2\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\t2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0002J \u0010-\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u00132\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020+2\u0006\u00101\u001a\u00020+H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RP\u0010\f\u001aB\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00100\u0010 \u000f* \u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/MouseWheelForwarder;", "", "browser", "Lcom/intellij/ui/jcef/JBCefBrowserBase;", "graphicsConfigurationManager", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookGraphicsConfigurationManager;", "<init>", "(Lcom/intellij/ui/jcef/JBCefBrowserBase;Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookGraphicsConfigurationManager;)V", "wheelFactor", "", "id", "Ljava/util/concurrent/atomic/AtomicInteger;", "callbacks", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "kotlin.jvm.PlatformType", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/MouseWheelForwarder$OriginalMouseEventToCallback;", "Lcom/github/benmanes/caffeine/cache/Cache;", "_postponedVerticalScroll", "Ljava/awt/event/MouseWheelEvent;", "queryWheelEvent", "Lcom/intellij/ui/jcef/JBCefJSQuery;", "sendWheelEventToCef", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getUpdatedMouseWheelEvent", "data", "createCefMouseWheelEvent", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/CefMouseWheelEvent;", "eventJson", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "injectJs", "", "Lorg/cef/browser/CefBrowser;", "forwardMouseWheelEvent", "e", "shiftX", "shiftY", "canMergeEvent", "", "sendPostponedEvent", "sendEvent", "deltaX", "", "deltaY", "registerCallback", "component", "Ljava/awt/Component;", "getDelta", "preciseWheelRotation", "OriginalMouseEventToCallback", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nMouseWheelForwarder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MouseWheelForwarder.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/MouseWheelForwarder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,328:1\n1#2:329\n1310#3,2:330\n1310#3,2:332\n1310#3,2:334\n1310#3,2:336\n*S KotlinDebug\n*F\n+ 1 MouseWheelForwarder.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/MouseWheelForwarder\n*L\n301#1:330,2\n307#1:332,2\n313#1:334,2\n319#1:336,2\n*E\n"})
public final class MouseWheelForwarder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JBCefBrowserBase browser;
    @NotNull
    private final NotebookGraphicsConfigurationManager graphicsConfigurationManager;
    private final int wheelFactor;
    @NotNull
    private final AtomicInteger id;
    private final Cache<String, OriginalMouseEventToCallback> callbacks;
    @Nullable
    private MouseWheelEvent _postponedVerticalScroll;
    @NotNull
    private final JBCefJSQuery queryWheelEvent;
    @NotNull
    private final JBCefJSQuery sendWheelEventToCef;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private static final Lazy<Field> wheelRotationField$delegate = LazyKt.lazy(MouseWheelForwarder::wheelRotationField_delegate$lambda$14);
    @NotNull
    private static final Lazy<Field> preciseWheelRotationField$delegate = LazyKt.lazy(MouseWheelForwarder::preciseWheelRotationField_delegate$lambda$18);
    @NotNull
    private static final Lazy<Field> mouseEventXField$delegate = LazyKt.lazy(MouseWheelForwarder::mouseEventXField_delegate$lambda$22);
    @NotNull
    private static final Lazy<Field> mouseEventYField$delegate = LazyKt.lazy(MouseWheelForwarder::mouseEventYField_delegate$lambda$26);
    @NotNull
    private static final Lazy<String> processMouseWheelJs$delegate = LazyKt.lazy(MouseWheelForwarder::processMouseWheelJs_delegate$lambda$27);

    /*
     * WARNING - void declaration
     */
    public MouseWheelForwarder(@NotNull JBCefBrowserBase browser, @NotNull NotebookGraphicsConfigurationManager graphicsConfigurationManager) {
        void $this$sendWheelEventToCef_u24lambda_u241;
        JBCefJSQuery $this$queryWheelEvent_u24lambda_u240;
        JBCefJSQuery jBCefJSQuery;
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter((Object)graphicsConfigurationManager, (String)"graphicsConfigurationManager");
        this.browser = browser;
        this.graphicsConfigurationManager = graphicsConfigurationManager;
        this.wheelFactor = Registry.Companion.intValue("ide.browser.jcef.osr.wheelRotation.factor");
        this.id = new AtomicInteger(0);
        this.callbacks = Caffeine.newBuilder().expireAfterWrite(Duration.of(1L, ChronoUnit.SECONDS)).build();
        JBCefJSQuery jBCefJSQuery2 = JBCefJSQuery.create((JBCefBrowserBase)this.browser);
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery2, (String)"create(...)");
        JBCefJSQuery jBCefJSQuery3 = jBCefJSQuery = jBCefJSQuery2;
        MouseWheelForwarder mouseWheelForwarder = this;
        boolean bl = false;
        Disposer.register((Disposable)((Disposable)this.browser), (Disposable)((Disposable)$this$queryWheelEvent_u24lambda_u240));
        mouseWheelForwarder.queryWheelEvent = jBCefJSQuery;
        JBCefJSQuery jBCefJSQuery4 = JBCefJSQuery.create((JBCefBrowserBase)this.browser);
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery4, (String)"create(...)");
        $this$queryWheelEvent_u24lambda_u240 = jBCefJSQuery = jBCefJSQuery4;
        mouseWheelForwarder = this;
        boolean bl2 = false;
        Disposer.register((Disposable)((Disposable)this.browser), (Disposable)((Disposable)$this$sendWheelEventToCef_u24lambda_u241));
        mouseWheelForwarder.sendWheelEventToCef = jBCefJSQuery;
        this.objectMapper = new ObjectMapper();
        this.browser.getJBCefClient().addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                if (httpStatusCode != 200) {
                    return;
                }
                this.injectJs(browser);
            }
        }, this.browser.getCefBrowser());
        this.sendWheelEventToCef.addHandler(arg_0 -> MouseWheelForwarder._init_$lambda$4(arg_0 -> MouseWheelForwarder._init_$lambda$3(this, arg_0), arg_0));
        this.queryWheelEvent.addHandler(arg_0 -> MouseWheelForwarder._init_$lambda$6(arg_0 -> MouseWheelForwarder._init_$lambda$5(this, arg_0), arg_0));
    }

    private final MouseWheelEvent getUpdatedMouseWheelEvent(String data) {
        Object lastEvent;
        block4: {
            JsonNode jsonNode = this.objectMapper.readTree(data);
            Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
            ObjectNode eventJson = (ObjectNode)jsonNode;
            Object object = (OriginalMouseEventToCallback)this.callbacks.getIfPresent((Object)eventJson.get("id").asText());
            if (object == null || (object = ((OriginalMouseEventToCallback)object).getOriginalEvent()) == null) {
                return null;
            }
            lastEvent = object;
            double deltaY = eventJson.get("deltaY").asDouble() / (double)this.wheelFactor;
            double deltaX = eventJson.get("deltaX").asDouble() / (double)this.wheelFactor;
            int cefX = eventJson.get("x").asInt();
            int cefY = eventJson.get("y").asInt();
            double delta = !(deltaY == 0.0) ? deltaY : deltaX;
            double preciseWheelRotation = delta * (double)-25;
            int wheelRotation = (int)preciseWheelRotation;
            Field field = MouseWheelForwarder.Companion.getWheelRotationField();
            if (field != null) {
                field.set(lastEvent, wheelRotation);
            }
            Field field2 = MouseWheelForwarder.Companion.getPreciseWheelRotationField();
            if (field2 != null) {
                field2.set(lastEvent, preciseWheelRotation);
            }
            Field field3 = MouseWheelForwarder.Companion.getMouseEventXField();
            if (field3 != null) {
                field3.set(lastEvent, cefX);
            }
            Field field4 = MouseWheelForwarder.Companion.getMouseEventYField();
            if (field4 == null) break block4;
            field4.set(lastEvent, cefY);
        }
        return lastEvent;
    }

    private final CefMouseWheelEvent createCefMouseWheelEvent(ObjectNode eventJson) {
        boolean defaultPrevented = eventJson.get("defaultPrevented").asBoolean();
        int cefX = eventJson.get("x").asInt();
        int cefY = eventJson.get("y").asInt();
        double deltaY = eventJson.get("deltaY").asDouble() / (double)this.wheelFactor;
        double deltaX = eventJson.get("deltaX").asDouble() / (double)this.wheelFactor;
        long timestamp = eventJson.get("timeStamp").asLong();
        boolean altKey = eventJson.get("altKey").asBoolean();
        boolean ctrlKey = eventJson.get("ctrlKey").asBoolean();
        boolean shiftKey = eventJson.get("shiftKey").asBoolean();
        return new CefMouseWheelEvent(cefX, cefY, deltaX, deltaY, timestamp, altKey, ctrlKey, shiftKey, defaultPrevented);
    }

    private final void injectJs(CefBrowser browser) {
        browser.executeJavaScript("\n          " + Companion.getProcessMouseWheelJs() + "\n          window.__IntelliJTools.processWheelEvent = function(data) {\n                " + this.queryWheelEvent.inject("data") + " \n          };\n          window.__IntelliJTools.sendWheelEventToCef = function(data) {\n                " + this.sendWheelEventToCef.inject("data") + " \n          };          \n          ", browser.getURL(), 0);
    }

    public final void forwardMouseWheelEvent(@NotNull MouseWheelEvent e, int shiftX, int shiftY) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if ((e.getModifiersEx() & 0x40) == 0) {
            this.sendPostponedEvent(shiftX, shiftY);
            this._postponedVerticalScroll = e;
            SwingUtilities.invokeLater(() -> MouseWheelForwarder.forwardMouseWheelEvent$lambda$7(this, shiftX, shiftY));
        } else if (this.canMergeEvent(e)) {
            double deltaX = e.getPreciseWheelRotation();
            MouseWheelEvent mouseWheelEvent = this._postponedVerticalScroll;
            double deltaY = mouseWheelEvent != null ? mouseWheelEvent.getPreciseWheelRotation() : 0.0;
            this.sendEvent(e, shiftX, shiftY, deltaX, deltaY);
            this._postponedVerticalScroll = null;
        } else {
            this.sendPostponedEvent(shiftX, shiftY);
            this.sendEvent(e, shiftX, shiftY);
        }
    }

    public static /* synthetic */ void forwardMouseWheelEvent$default(MouseWheelForwarder mouseWheelForwarder, MouseWheelEvent mouseWheelEvent, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        mouseWheelForwarder.forwardMouseWheelEvent(mouseWheelEvent, n, n2);
    }

    private final boolean canMergeEvent(MouseWheelEvent e) {
        MouseWheelEvent postponedVerticalScroll = this._postponedVerticalScroll;
        return postponedVerticalScroll != null && (e.getModifiersEx() & 0x40) > 0 && postponedVerticalScroll.getX() == e.getX() && postponedVerticalScroll.getY() == e.getY() && Intrinsics.areEqual((Object)postponedVerticalScroll.getComponent(), (Object)e.getComponent()) && postponedVerticalScroll.getScrollType() == e.getScrollType();
    }

    private final void sendPostponedEvent(int shiftX, int shiftY) {
        MouseWheelEvent mouseWheelEvent = this._postponedVerticalScroll;
        if (mouseWheelEvent != null) {
            MouseWheelEvent it = mouseWheelEvent;
            boolean bl = false;
            this.sendEvent(it, shiftX, shiftY);
        }
        this._postponedVerticalScroll = null;
    }

    private final void sendEvent(MouseWheelEvent e, int shiftX, int shiftY) {
        Pair pair = (e.getModifiersEx() & 0x40) == 0 ? TuplesKt.to((Object)0.0, (Object)e.getPreciseWheelRotation()) : TuplesKt.to((Object)e.getPreciseWheelRotation(), (Object)0.0);
        double deltaX = ((Number)pair.component1()).doubleValue();
        double deltaY = ((Number)pair.component2()).doubleValue();
        this.sendEvent(e, shiftX, shiftY, deltaX, deltaY);
    }

    private final void sendEvent(MouseWheelEvent e, int shiftX, int shiftY, double deltaX, double deltaY) {
        float scale = this.graphicsConfigurationManager.getHiDpi() ? 1.0f : 1.0f / this.graphicsConfigurationManager.getScreenScale();
        Component component2 = e.getComponent();
        Point point = component2 instanceof HasViewport ? ((HasViewport)((Object)component2)).convertViewportPointToComponent(new Point(e.getX(), e.getY())) : new Point(e.getX(), e.getY());
        Pair pair = TuplesKt.to((Object)Float.valueOf((float)point.x * scale + (float)shiftX), (Object)Float.valueOf((float)point.y * scale + (float)shiftY));
        float x = ((Number)pair.component1()).floatValue();
        float y = ((Number)pair.component2()).floatValue();
        String id = "Callback_" + this.id.incrementAndGet();
        Component component3 = e.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)component3, (String)"getComponent(...)");
        this.registerCallback(id, e, component3);
        this.browser.getCefBrowser().executeJavaScript("\n        {\n          window.__IntelliJTools.sendMouseWheelEvent('" + id + "', " + x + ", " + y + ", " + this.getDelta(deltaX) + ", " + this.getDelta(deltaY) + ", " + e.getWhen() + ", " + e.isShiftDown() + ", " + e.isAltDown() + ", " + e.isControlDown() + ")\n        }\n      ", this.browser.getCefBrowser().getURL(), 0);
    }

    private final void registerCallback(String id, MouseWheelEvent e, Component component2) {
        this.callbacks.put((Object)id, (Object)new OriginalMouseEventToCallback(e, (Function1<? super CefMouseWheelEvent, Unit>)((Function1)arg_0 -> MouseWheelForwarder.registerCallback$lambda$10(component2, arg_0))));
    }

    private final double getDelta(double preciseWheelRotation) {
        return preciseWheelRotation * (double)this.wheelFactor;
    }

    private static final JBCefJSQuery.Response _init_$lambda$3(MouseWheelForwarder this$0, String data) {
        block0: {
            Intrinsics.checkNotNull((Object)data);
            MouseWheelEvent mouseWheelEvent = this$0.getUpdatedMouseWheelEvent(data);
            if (mouseWheelEvent == null) break block0;
            MouseWheelEvent it = mouseWheelEvent;
            boolean bl = false;
            this$0.browser.getCefBrowser().sendMouseWheelEvent(it);
        }
        return null;
    }

    private static final JBCefJSQuery.Response _init_$lambda$4(Function1 $tmp0, Object p0) {
        return (JBCefJSQuery.Response)$tmp0.invoke(p0);
    }

    private static final JBCefJSQuery.Response _init_$lambda$5(MouseWheelForwarder this$0, String data) {
        JsonNode jsonNode = this$0.objectMapper.readTree(data);
        Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        ObjectNode eventJson = (ObjectNode)jsonNode;
        String id = eventJson.get("id").asText();
        OriginalMouseEventToCallback callback2 = (OriginalMouseEventToCallback)this$0.callbacks.getIfPresent((Object)id);
        this$0.callbacks.invalidate((Object)id);
        if (callback2 != null) {
            callback2.getCallback().invoke((Object)this$0.createCefMouseWheelEvent(eventJson));
        }
        return null;
    }

    private static final JBCefJSQuery.Response _init_$lambda$6(Function1 $tmp0, Object p0) {
        return (JBCefJSQuery.Response)$tmp0.invoke(p0);
    }

    private static final void forwardMouseWheelEvent$lambda$7(MouseWheelForwarder this$0, int $shiftX, int $shiftY) {
        this$0.sendPostponedEvent($shiftX, $shiftY);
    }

    private static final Unit registerCallback$lambda$10$lambda$9(Component $component, CefMouseWheelEvent $event) {
        double delta;
        Pair pair;
        Container parent = $component.getParent();
        int modifiers = 0;
        modifiers = $event.getAltKey() ? 512 : 0;
        modifiers = $event.getCtrlKey() ? modifiers | 0x80 : modifiers;
        modifiers = $event.getShiftKey() ? modifiers | 0x40 : modifiers;
        boolean isShift = (modifiers & 0x40) != 0;
        Point point = $component.getLocationOnScreen();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocationOnScreen(...)");
        Point locationOnScreen = point;
        if ($component instanceof HasViewport) {
            Point point2 = ((HasViewport)((Object)$component)).convertComponentPointToViewport(new Point($event.getX(), $event.getY()));
            pair = TuplesKt.to((Object)point2.x, (Object)point2.y);
        } else {
            pair = TuplesKt.to((Object)$event.getX(), (Object)$event.getY());
        }
        Pair pair2 = pair;
        int x = ((Number)pair2.component1()).intValue();
        int y = ((Number)pair2.component2()).intValue();
        int absX = locationOnScreen.x + x;
        int absY = locationOnScreen.y + y;
        if (!isShift && !($event.getDeltaY() == 0.0)) {
            parent.dispatchEvent(new MouseWheelEvent($component, 507, $event.getTimestamp(), modifiers, x, y, absX, absY, 0, false, 0, 1, MathKt.roundToInt((double)$event.getDeltaY()), $event.getDeltaY()));
        }
        double d = delta = isShift && !($event.getDeltaY() == 0.0) ? $event.getDeltaY() : $event.getDeltaX();
        if (!(delta == 0.0)) {
            parent.dispatchEvent(new MouseWheelEvent($component, 507, $event.getTimestamp(), modifiers |= 0x40, x, y, absX, absY, 0, false, 0, 1, MathKt.roundToInt((double)delta), delta));
        }
        return Unit.INSTANCE;
    }

    private static final Unit registerCallback$lambda$10(Component $component, CefMouseWheelEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!event.getDefaultPrevented()) {
            ActionsKt.runInEdt$default(null, () -> MouseWheelForwarder.registerCallback$lambda$10$lambda$9($component, event), (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Field wheelRotationField_delegate$lambda$14() {
        Field field;
        Object object;
        block3: {
            Field[] fieldArray = MouseWheelEvent.class.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
            Object[] $this$firstOrNull$iv = fieldArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Field it = (Field)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"wheelRotation")) continue;
                object = element$iv;
                break block3;
            }
            object = null;
        }
        Field field2 = (Field)object;
        if (field2 != null) {
            Field field3;
            Field field4;
            Field $this$wheelRotationField_delegate_u24lambda_u2414_u24lambda_u2413 = field4 = field2;
            boolean bl = false;
            Field $this$wheelRotationField_delegate_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412 = field3 = $this$wheelRotationField_delegate_u24lambda_u2414_u24lambda_u2413;
            boolean bl2 = false;
            $this$wheelRotationField_delegate_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412.setAccessible(true);
            field = field4;
        } else {
            field = null;
        }
        return field;
    }

    private static final Field preciseWheelRotationField_delegate$lambda$18() {
        Field field;
        Object object;
        block3: {
            Field[] fieldArray = MouseWheelEvent.class.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
            Object[] $this$firstOrNull$iv = fieldArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Field it = (Field)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"preciseWheelRotation")) continue;
                object = element$iv;
                break block3;
            }
            object = null;
        }
        Field field2 = (Field)object;
        if (field2 != null) {
            Field field3;
            Field field4;
            Field $this$preciseWheelRotationField_delegate_u24lambda_u2418_u24lambda_u2417 = field4 = field2;
            boolean bl = false;
            Field $this$preciseWheelRotationField_delegate_u24lambda_u2418_u24lambda_u2417_u24lambda_u2416 = field3 = $this$preciseWheelRotationField_delegate_u24lambda_u2418_u24lambda_u2417;
            boolean bl2 = false;
            $this$preciseWheelRotationField_delegate_u24lambda_u2418_u24lambda_u2417_u24lambda_u2416.setAccessible(true);
            field = field4;
        } else {
            field = null;
        }
        return field;
    }

    private static final Field mouseEventXField_delegate$lambda$22() {
        Field field;
        Object object;
        block3: {
            Field[] fieldArray = MouseEvent.class.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
            Object[] $this$firstOrNull$iv = fieldArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Field it = (Field)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"x")) continue;
                object = element$iv;
                break block3;
            }
            object = null;
        }
        Field field2 = (Field)object;
        if (field2 != null) {
            Field field3;
            Field field4;
            Field $this$mouseEventXField_delegate_u24lambda_u2422_u24lambda_u2421 = field4 = field2;
            boolean bl = false;
            Field $this$mouseEventXField_delegate_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420 = field3 = $this$mouseEventXField_delegate_u24lambda_u2422_u24lambda_u2421;
            boolean bl2 = false;
            $this$mouseEventXField_delegate_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420.setAccessible(true);
            field = field4;
        } else {
            field = null;
        }
        return field;
    }

    private static final Field mouseEventYField_delegate$lambda$26() {
        Field field;
        Object object;
        block3: {
            Field[] fieldArray = MouseEvent.class.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
            Object[] $this$firstOrNull$iv = fieldArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Field it = (Field)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"y")) continue;
                object = element$iv;
                break block3;
            }
            object = null;
        }
        Field field2 = (Field)object;
        if (field2 != null) {
            Field field3;
            Field field4;
            Field $this$mouseEventYField_delegate_u24lambda_u2426_u24lambda_u2425 = field4 = field2;
            boolean bl = false;
            Field $this$mouseEventYField_delegate_u24lambda_u2426_u24lambda_u2425_u24lambda_u2424 = field3 = $this$mouseEventYField_delegate_u24lambda_u2426_u24lambda_u2425;
            boolean bl2 = false;
            $this$mouseEventYField_delegate_u24lambda_u2426_u24lambda_u2425_u24lambda_u2424.setAccessible(true);
            field = field4;
        } else {
            field = null;
        }
        return field;
    }

    private static final String processMouseWheelJs_delegate$lambda$27() {
        String string;
        InputStream inputStream = Companion.getClass().getResourceAsStream("processWheelEvent.js");
        if (inputStream != null) {
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            string = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
        } else {
            string = null;
        }
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u0004\u0018\u00010\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\n\u001a\u0004\u0018\u00010\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\t\u001a\u0004\b\u000b\u0010\u0007R\u001d\u0010\r\u001a\u0004\u0018\u00010\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\t\u001a\u0004\b\u000e\u0010\u0007R\u001d\u0010\u0010\u001a\u0004\u0018\u00010\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\t\u001a\u0004\b\u0011\u0010\u0007R\u001d\u0010\u0013\u001a\u0004\u0018\u00010\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\t\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/MouseWheelForwarder$Companion;", "", "<init>", "()V", "wheelRotationField", "Ljava/lang/reflect/Field;", "getWheelRotationField", "()Ljava/lang/reflect/Field;", "wheelRotationField$delegate", "Lkotlin/Lazy;", "preciseWheelRotationField", "getPreciseWheelRotationField", "preciseWheelRotationField$delegate", "mouseEventXField", "getMouseEventXField", "mouseEventXField$delegate", "mouseEventYField", "getMouseEventYField", "mouseEventYField$delegate", "processMouseWheelJs", "", "getProcessMouseWheelJs", "()Ljava/lang/String;", "processMouseWheelJs$delegate", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        private final Field getWheelRotationField() {
            Lazy lazy = wheelRotationField$delegate;
            return (Field)lazy.getValue();
        }

        private final Field getPreciseWheelRotationField() {
            Lazy lazy = preciseWheelRotationField$delegate;
            return (Field)lazy.getValue();
        }

        private final Field getMouseEventXField() {
            Lazy lazy = mouseEventXField$delegate;
            return (Field)lazy.getValue();
        }

        private final Field getMouseEventYField() {
            Lazy lazy = mouseEventYField$delegate;
            return (Field)lazy.getValue();
        }

        @Nullable
        public final String getProcessMouseWheelJs() {
            Lazy lazy = processMouseWheelJs$delegate;
            return (String)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/MouseWheelForwarder$OriginalMouseEventToCallback;", "", "originalEvent", "Ljava/awt/event/MouseWheelEvent;", "callback", "Lkotlin/Function1;", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/CefMouseWheelEvent;", "", "<init>", "(Ljava/awt/event/MouseWheelEvent;Lkotlin/jvm/functions/Function1;)V", "getOriginalEvent", "()Ljava/awt/event/MouseWheelEvent;", "getCallback", "()Lkotlin/jvm/functions/Function1;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.jupyter.core"})
    private static final class OriginalMouseEventToCallback {
        @NotNull
        private final MouseWheelEvent originalEvent;
        @NotNull
        private final Function1<CefMouseWheelEvent, Unit> callback;

        public OriginalMouseEventToCallback(@NotNull MouseWheelEvent originalEvent, @NotNull Function1<? super CefMouseWheelEvent, Unit> callback2) {
            Intrinsics.checkNotNullParameter((Object)originalEvent, (String)"originalEvent");
            Intrinsics.checkNotNullParameter(callback2, (String)"callback");
            this.originalEvent = originalEvent;
            this.callback = callback2;
        }

        @NotNull
        public final MouseWheelEvent getOriginalEvent() {
            return this.originalEvent;
        }

        @NotNull
        public final Function1<CefMouseWheelEvent, Unit> getCallback() {
            return this.callback;
        }

        @NotNull
        public final MouseWheelEvent component1() {
            return this.originalEvent;
        }

        @NotNull
        public final Function1<CefMouseWheelEvent, Unit> component2() {
            return this.callback;
        }

        @NotNull
        public final OriginalMouseEventToCallback copy(@NotNull MouseWheelEvent originalEvent, @NotNull Function1<? super CefMouseWheelEvent, Unit> callback2) {
            Intrinsics.checkNotNullParameter((Object)originalEvent, (String)"originalEvent");
            Intrinsics.checkNotNullParameter(callback2, (String)"callback");
            return new OriginalMouseEventToCallback(originalEvent, callback2);
        }

        public static /* synthetic */ OriginalMouseEventToCallback copy$default(OriginalMouseEventToCallback originalMouseEventToCallback, MouseWheelEvent mouseWheelEvent, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                mouseWheelEvent = originalMouseEventToCallback.originalEvent;
            }
            if ((n & 2) != 0) {
                function1 = originalMouseEventToCallback.callback;
            }
            return originalMouseEventToCallback.copy(mouseWheelEvent, function1);
        }

        @NotNull
        public String toString() {
            return "OriginalMouseEventToCallback(originalEvent=" + this.originalEvent + ", callback=" + this.callback + ")";
        }

        public int hashCode() {
            int result2 = this.originalEvent.hashCode();
            result2 = result2 * 31 + this.callback.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OriginalMouseEventToCallback)) {
                return false;
            }
            OriginalMouseEventToCallback originalMouseEventToCallback = (OriginalMouseEventToCallback)other;
            if (!Intrinsics.areEqual((Object)this.originalEvent, (Object)originalMouseEventToCallback.originalEvent)) {
                return false;
            }
            return Intrinsics.areEqual(this.callback, originalMouseEventToCallback.callback);
        }
    }
}

