/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.image;

import com.intellij.ui.components.JBPanel;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.ImageObserver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0000\u001a\u00020\u0001\"\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"paintPanelImage", "", "T", "Lcom/intellij/ui/components/JBPanel;", "g", "Ljava/awt/Graphics;", "image", "Ljava/awt/Image;", "intellij.jupyter.core"})
public final class ImagePanelKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T extends JBPanel<T>> void paintPanelImage(@NotNull JBPanel<T> $this$paintPanelImage, @NotNull Graphics g, @Nullable Image image) {
        Intrinsics.checkNotNullParameter($this$paintPanelImage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (image == null) {
            return;
        }
        Insets insets = $this$paintPanelImage.getInsets();
        Rectangle rect = new Rectangle(insets.left, insets.top, $this$paintPanelImage.getWidth() - insets.left - insets.right, $this$paintPanelImage.getHeight() - insets.bottom - insets.top);
        int imageWidth = image.getWidth((ImageObserver)$this$paintPanelImage);
        int imageHeight = image.getHeight((ImageObserver)$this$paintPanelImage);
        if (imageWidth > 0 && imageHeight > 0) {
            double scale = RangesKt.coerceAtMost((double)(rect.getWidth() / (double)imageWidth), (double)(rect.getHeight() / (double)imageHeight));
            int w = MathKt.roundToInt((double)((double)imageWidth * scale));
            int h = MathKt.roundToInt((double)((double)imageHeight * scale));
            int xOffset = 0;
            int yOffset = rect.y + (rect.height - h) / 2;
            Graphics graphics = g.create();
            Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D g2 = (Graphics2D)graphics;
            try {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                boolean bl = g2.drawImage(image, xOffset, yOffset, w, h, null);
            }
            finally {
                g2.dispose();
            }
        }
    }
}

