/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.actions;

import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellsContents;
import com.intellij.notebooks.visualization.NotebookCellLines;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0016J\u001a\u0010\u000f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0005H\u0002R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/actions/JupyterCellLinesEditHelper;", "Lcom/intellij/jupyter/core/core/api/actions/NotebookCellLinesEditHelper;", "<init>", "()V", "makeInsertedCells", "", "notebookCellsContents", "Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellsContents;", "targetOrdinal", "", "makeCell", "source", "cellType", "Lcom/intellij/notebooks/visualization/NotebookCellLines$CellType;", "customHeader", "makeHeader", "isChangingCellTypeAllowed", "", "()Z", "hasHeader", "intellij.jupyter.core"})
public final class JupyterCellLinesEditHelper
implements NotebookCellLinesEditHelper {
    @Override
    @NotNull
    public String makeInsertedCells(@NotNull NotebookCellsContents notebookCellsContents, int targetOrdinal) {
        String string;
        Intrinsics.checkNotNullParameter((Object)notebookCellsContents, (String)"notebookCellsContents");
        String source = notebookCellsContents.getRawText();
        NotebookCellLines.Interval interval = notebookCellsContents.getCopiedIntervals();
        boolean bl = interval != null && (interval = (NotebookCellLines.Interval)CollectionsKt.firstOrNull(interval)) != null && (interval = interval.getMarkers()) != null ? interval.getHasTopLine() : false;
        if (bl) {
            string = source;
        } else if (this.hasHeader(source)) {
            string = source;
        } else {
            NotebookCellLinesEditHelper notebookCellLinesEditHelper = this;
            NotebookCellLines.CellType cellType = notebookCellsContents.getCopiedIntervals();
            if (cellType == null || (cellType = (NotebookCellLines.Interval)CollectionsKt.firstOrNull(cellType)) == null || (cellType = cellType.getType()) == null) {
                cellType = NotebookCellLines.CellType.CODE;
            }
            string = NotebookCellLinesEditHelper.DefaultImpls.makeCell$default(notebookCellLinesEditHelper, source, cellType, null, 4, null);
        }
        return string;
    }

    @Override
    @NotNull
    public String makeCell(@NotNull String source, @NotNull NotebookCellLines.CellType cellType, @Nullable String customHeader) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)cellType, (String)"cellType");
        return this.makeHeader(cellType, customHeader) + "\n" + source;
    }

    private final String makeHeader(NotebookCellLines.CellType cellType, String customHeader) {
        if (customHeader != null) {
            return "#%% " + customHeader;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[cellType.ordinal()]) {
            case 1 -> "#%%";
            case 2 -> "#%% md";
            case 3 -> "#%% raw";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public boolean isChangingCellTypeAllowed() {
        return true;
    }

    private final boolean hasHeader(String source) {
        return StringsKt.startsWith$default((String)source, (String)"#%%", (boolean)false, (int)2, null);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotebookCellLines.CellType.values().length];
            try {
                nArray[NotebookCellLines.CellType.CODE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotebookCellLines.CellType.MARKDOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotebookCellLines.CellType.RAW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

