/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.filecontentsapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.ContentsApiModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.DirectoryModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.FileContentsApiKt;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.FileWriterOutputStream;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.LeafContentsApiModel;
import com.intellij.jupyter.core.jupyter.connections.http.HttpSession;
import com.intellij.jupyter.core.jupyter.connections.http.JupyterHttpSessionRestUtilsKt;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.util.io.Ksuid;
import java.io.IOException;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0015H\u0016J\b\u0010\u001c\u001a\u00020\u0017H\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0016J\u001a\u0010\u001e\u001a\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010\u00052\u0006\u0010 \u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/FileWriterOutputStreamImpl;", "Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/FileWriterOutputStream;", "httpSession", "Lcom/intellij/jupyter/core/jupyter/connections/http/HttpSession;", "finalPath", "", "<init>", "(Lcom/intellij/jupyter/core/jupyter/connections/http/HttpSession;Ljava/lang/String;)V", "closed", "", "intermediatePath", "value", "Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/LeafContentsApiModel;", "model", "getModel", "()Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/LeafContentsApiModel;", "rootNode", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "kotlin.jvm.PlatformType", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "chunk", "", "write", "", "b", "", "off", "len", "flush", "close", "doWrite", "content", "format", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nFileContentsApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileContentsApi.kt\ncom/intellij/jupyter/core/jupyter/connections/filecontentsapi/FileWriterOutputStreamImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 JupyterJson.kt\ncom/intellij/jupyter/core/JupyterJsonKt\n*L\n1#1,614:1\n1#2:615\n61#3,5:616\n46#4,6:621\n*S KotlinDebug\n*F\n+ 1 FileContentsApi.kt\ncom/intellij/jupyter/core/jupyter/connections/filecontentsapi/FileWriterOutputStreamImpl\n*L\n441#1:616,5\n447#1:621,6\n*E\n"})
public final class FileWriterOutputStreamImpl
extends FileWriterOutputStream {
    @NotNull
    private final HttpSession httpSession;
    @NotNull
    private final String finalPath;
    private boolean closed;
    @NotNull
    private final String intermediatePath;
    @Nullable
    private LeafContentsApiModel model;
    private final ObjectNode rootNode;
    private int chunk;

    /*
     * WARNING - void declaration
     */
    public FileWriterOutputStreamImpl(@NotNull HttpSession httpSession, @NotNull String finalPath) {
        void $this$rootNode_u24lambda_u241;
        ObjectNode objectNode;
        Intrinsics.checkNotNullParameter((Object)httpSession, (String)"httpSession");
        Intrinsics.checkNotNullParameter((Object)finalPath, (String)"finalPath");
        this.httpSession = httpSession;
        this.finalPath = finalPath;
        if (!(!StringsKt.endsWith$default((String)this.finalPath, (String)"/", (boolean)false, (int)2, null))) {
            boolean $i$a$-require-FileWriterOutputStreamImpl$22 = false;
            String $i$a$-require-FileWriterOutputStreamImpl$22 = "Path `" + this.finalPath + "` looks like a directory, but a file is expected";
            throw new IllegalArgumentException($i$a$-require-FileWriterOutputStreamImpl$22.toString());
        }
        this.intermediatePath = this.finalPath + "-upload-" + Ksuid.generate();
        ObjectNode $i$a$-require-FileWriterOutputStreamImpl$22 = objectNode = JupyterJsonKt.getJackson().createObjectNode();
        FileWriterOutputStreamImpl fileWriterOutputStreamImpl = this;
        boolean bl = false;
        $this$rootNode_u24lambda_u241.put("type", "file");
        fileWriterOutputStreamImpl.rootNode = objectNode;
        this.chunk = 1;
    }

    @Override
    @Nullable
    public LeafContentsApiModel getModel() {
        return this.model;
    }

    @Override
    public void write(int b) {
        throw new IllegalStateException("Should be never called".toString());
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (this.closed) {
            throw new IOException("Closed");
        }
        Pair pair = TuplesKt.to((Object)Base64.getMimeEncoder(Integer.MAX_VALUE, new byte[0]).encodeToString(ArraysKt.sliceArray((byte[])b, (IntRange)RangesKt.until((int)off, (int)(off + len)))), (Object)"base64");
        Object object = pair.component1();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component1(...)");
        String content = (String)object;
        String format = (String)pair.component2();
        this.doWrite(content, format);
    }

    @Override
    public void flush() {
        if (this.closed) {
            throw new IOException("Closed");
        }
        if (this.getModel() == null) {
            this.doWrite("", "base64");
        }
    }

    @Override
    public void close() {
        LeafContentsApiModel newModel;
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.chunk = -1;
        this.doWrite("", "base64");
        ContentsApiModel m = FileContentsApiKt.renameRemoteFile$default(this.httpSession, this.intermediatePath, this.finalPath, false, 8, null);
        if (m instanceof DirectoryModel) {
            throw new IllegalStateException(("Failure in renaming `" + this.intermediatePath + "` to `" + this.finalPath + "`. The final model is " + m).toString());
        }
        if (!(m instanceof LeafContentsApiModel)) {
            throw new NoWhenBranchMatchedException();
        }
        this.model = newModel = (LeafContentsApiModel)m;
        FileContentsApiKt.access$handleLastModified(this.httpSession, newModel, this.finalPath);
    }

    /*
     * WARNING - void declaration
     */
    private final void doWrite(String content, String format) {
        Object object;
        Object object2;
        Object $this$doWrite_u24lambda_u242 = this.rootNode;
        boolean bl = false;
        $this$doWrite_u24lambda_u242.put("chunk", this.chunk);
        $this$doWrite_u24lambda_u242.put("content", content);
        $this$doWrite_u24lambda_u242.put("format", format);
        $this$doWrite_u24lambda_u242 = new char[1];
        $this$doWrite_u24lambda_u242[0] = (ObjectNode)47;
        String endpoint = "/api/contents/" + StringsKt.trim((String)this.intermediatePath, (char[])$this$doWrite_u24lambda_u242);
        Logger $this$debug_u24default$iv = FileContentsApiKt.access$getLOG$p();
        ObjectMapper e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            object2 = $this$debug_u24default$iv;
            boolean bl2 = false;
            String string = content;
            object2.debug("Authority " + this.httpSession.getBaseURI().getAuthority() + ", path \"" + this.intermediatePath + "\", writing chunk " + this.chunk + " with length " + (string != null ? Integer.valueOf(string.length()) : null) + ", format " + format + ".", e$iv);
        }
        String string = JupyterJsonKt.getJackson().writeValueAsString((Object)this.rootNode);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        String response = JupyterHttpSessionRestUtilsKt.put$default(this.httpSession, endpoint, string, null, 4, null);
        ++this.chunk;
        e$iv = JupyterJsonKt.getJackson();
        object2 = this;
        boolean $i$f$readValueWrappingError = false;
        try {
            void $this$readValueWrappingError$iv;
            object = $this$readValueWrappingError$iv.readValue(response, LeafContentsApiModel.class);
        }
        catch (JsonProcessingException err$iv) {
            boolean bl3 = false;
            Attachment[] attachmentArray = new Attachment[]{new Attachment("response.json", response)};
            Attachment[] attachmentArray2 = attachmentArray;
            Throwable throwable = err$iv;
            String string2 = "PUT " + endpoint;
            throw new RuntimeExceptionWithAttachments(string2, throwable, attachmentArray2);
        }
        object2.model = (LeafContentsApiModel)object;
    }
}

