/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor.markdown;

import com.intellij.jupyter.core.editor.markdown.Heading;
import com.intellij.jupyter.core.editor.markdown.MarkdownEditorCellKt;
import com.intellij.jupyter.core.editor.markdown.MarkdownExtension;
import com.intellij.jupyter.core.editor.markdown.NotebookStructureElement;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.observables.DeduplicatedObservableProperty;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellExtension;
import com.intellij.notebooks.visualization.ui.EditorNotebook;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010\"\u001a\u00020\u001aH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lcom/intellij/jupyter/core/editor/markdown/MarkdownEditorCell;", "Lcom/intellij/notebooks/visualization/ui/EditorCellExtension;", "Lcom/intellij/openapi/Disposable;", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "parser", "Lorg/intellij/markdown/parser/MarkdownParser;", "<init>", "(Lcom/intellij/notebooks/visualization/ui/EditorCell;Lorg/intellij/markdown/parser/MarkdownParser;)V", "heading", "Lcom/intellij/notebooks/visualization/observables/DeduplicatedObservableProperty;", "Lcom/intellij/jupyter/core/editor/markdown/Heading;", "getHeading", "()Lcom/intellij/notebooks/visualization/observables/DeduplicatedObservableProperty;", "sectionFolded", "Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "getSectionFolded", "()Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "rendered", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "", "getRendered", "()Lcom/intellij/openapi/observable/properties/AtomicProperty;", "getSection", "Lcom/intellij/jupyter/core/editor/markdown/NotebookStructureElement$NotebookSection;", "onBeforeRemove", "", "source", "", "isHeading", "node", "Lorg/intellij/markdown/ast/ASTNode;", "getLevel", "", "dispose", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nMarkdownEditorCell.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownEditorCell.kt\ncom/intellij/jupyter/core/editor/markdown/MarkdownEditorCell\n+ 2 EditorNotebook.kt\ncom/intellij/notebooks/visualization/ui/EditorNotebookKt\n*L\n1#1,72:1\n78#2:73\n*S KotlinDebug\n*F\n+ 1 MarkdownEditorCell.kt\ncom/intellij/jupyter/core/editor/markdown/MarkdownEditorCell\n*L\n47#1:73\n*E\n"})
public final class MarkdownEditorCell
implements EditorCellExtension,
Disposable {
    @NotNull
    private final EditorCell cell;
    @NotNull
    private final MarkdownParser parser;
    @NotNull
    private final DeduplicatedObservableProperty<Heading> heading;
    @NotNull
    private final AtomicBooleanProperty sectionFolded;
    @NotNull
    private final AtomicProperty<Boolean> rendered;

    public MarkdownEditorCell(@NotNull EditorCell cell, @NotNull MarkdownParser parser) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        this.cell = cell;
        this.parser = parser;
        this.heading = new DeduplicatedObservableProperty(null);
        this.sectionFolded = new AtomicBooleanProperty(false);
        this.rendered = new AtomicProperty((Object)true);
        this.cell.getSource().afterChange(arg_0 -> MarkdownEditorCell._init_$lambda$0(this, arg_0));
        this.heading.set((Object)this.getHeading((String)this.cell.getSource().get()));
        Disposer.register((Disposable)((Disposable)this.cell), (Disposable)this);
    }

    @NotNull
    public final DeduplicatedObservableProperty<Heading> getHeading() {
        return this.heading;
    }

    @NotNull
    public final AtomicBooleanProperty getSectionFolded() {
        return this.sectionFolded;
    }

    @NotNull
    public final AtomicProperty<Boolean> getRendered() {
        return this.rendered;
    }

    @Nullable
    public final NotebookStructureElement.NotebookSection getSection() {
        EditorNotebook $this$getExtension$iv = this.cell.getNotebook();
        boolean $i$f$getExtension = false;
        Object object = (DeduplicatedObservableProperty<NotebookStructureElement.Notebook>)$this$getExtension$iv.getExtension(Reflection.getOrCreateKotlinClass(MarkdownExtension.class));
        NotebookStructureElement notebookStructureElement = object != null && (object = ((MarkdownExtension)object).getStructure()) != null && (object = (NotebookStructureElement.Notebook)object.get()) != null ? ((NotebookStructureElement.WithChildren)object).getElement(this.cell) : null;
        return notebookStructureElement instanceof NotebookStructureElement.NotebookSection ? (NotebookStructureElement.NotebookSection)notebookStructureElement : null;
    }

    public void onBeforeRemove() {
        block0: {
            NotebookStructureElement.NotebookSection notebookSection = this.getSection();
            if (notebookSection == null) break block0;
            notebookSection.unfold();
        }
    }

    private final Heading getHeading(String source) {
        if (this.cell.getType() != NotebookCellLines.CellType.MARKDOWN) {
            return null;
        }
        ASTNode parsedTree = MarkdownParser.parse$default((MarkdownParser)this.parser, (IElementType)new IElementType("ROOT"), (String)source, (boolean)false, (int)4, null);
        ASTNode firstNode = (ASTNode)CollectionsKt.firstOrNull((List)parsedTree.getChildren());
        return firstNode != null && this.isHeading(firstNode) ? new Heading(this.getLevel(firstNode), ((Object)ASTUtilKt.getTextInNode((ASTNode)firstNode, (CharSequence)source)).toString()) : null;
    }

    private final boolean isHeading(ASTNode node) {
        return MarkdownEditorCellKt.access$getHEADING_TYPES$p().containsKey(node.getType());
    }

    private final int getLevel(ASTNode node) {
        Integer n = (Integer)MarkdownEditorCellKt.access$getHEADING_TYPES$p().get(node.getType());
        if (n == null) {
            throw new IllegalStateException("Node is not a heading".toString());
        }
        return n;
    }

    public void dispose() {
    }

    private static final Unit _init_$lambda$0(MarkdownEditorCell this$0, String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this$0.heading.set((Object)this$0.getHeading(source));
        return Unit.INSTANCE;
    }
}

